/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-04-11 22:00:39 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=962 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=146303 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=2817 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=270 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_eg_grids` (
  `id` mediumint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `postparams` text NOT NULL,
  `params` text NOT NULL,
  `layers` mediumtext NOT NULL,
  `settings` text DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_eg_item_elements` (
  `id` mediumint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `settings` mediumtext NOT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_eg_item_skins` (
  `id` mediumint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `params` text NOT NULL,
  `layers` mediumtext NOT NULL,
  `settings` text DEFAULT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=107 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_eg_navigation_skins` (
  `id` mediumint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` mediumtext NOT NULL,
  `navversion` varchar(191) DEFAULT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_campaign_forms` (
  `campaign_id` int(10) unsigned NOT NULL,
  `form_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`campaign_id`,`form_id`),
  KEY `form_id` (`form_id`),
  KEY `campaign_id` (`campaign_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_campaigns` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `campaign_page_id` int(10) unsigned DEFAULT NULL,
  `form_id` int(11) NOT NULL,
  `campaign_type` varchar(12) NOT NULL DEFAULT '',
  `campaign_title` text NOT NULL,
  `campaign_url` text NOT NULL,
  `short_desc` text NOT NULL,
  `long_desc` text NOT NULL,
  `campaign_logo` text NOT NULL,
  `campaign_image` text NOT NULL,
  `primary_color` varchar(7) NOT NULL,
  `secondary_color` varchar(7) NOT NULL,
  `campaign_goal` int(10) unsigned NOT NULL,
  `goal_type` varchar(24) NOT NULL DEFAULT 'amount',
  `status` varchar(12) NOT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_commentmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `give_comment_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `give_comment_id` (`give_comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_comments` (
  `comment_ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `comment_content` longtext NOT NULL,
  `comment_parent` mediumtext NOT NULL,
  `comment_type` mediumtext NOT NULL,
  `comment_date` datetime NOT NULL,
  `comment_date_gmt` datetime NOT NULL,
  PRIMARY KEY (`comment_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_donationmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `donation_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `donation_id` (`donation_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3612 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_donormeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `donor_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `donor_id` (`donor_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_donors` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `email` varchar(255) NOT NULL,
  `name` mediumtext NOT NULL,
  `phone` varchar(50) NOT NULL DEFAULT '',
  `purchase_value` mediumtext NOT NULL,
  `purchase_count` bigint(20) NOT NULL,
  `payment_ids` longtext NOT NULL,
  `date_created` datetime NOT NULL,
  `token` varchar(255) NOT NULL,
  `verify_key` varchar(255) NOT NULL,
  `verify_throttle` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `user` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_give_formmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `form_id` (`form_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3481 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `log_type` varchar(16) NOT NULL,
  `data` text NOT NULL,
  `category` varchar(64) NOT NULL,
  `source` varchar(64) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `log_type` (`log_type`),
  KEY `category` (`category`),
  KEY `source` (`source`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_migrations` (
  `id` varchar(180) NOT NULL,
  `status` varchar(16) NOT NULL,
  `error` text DEFAULT NULL,
  `last_run` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_revenue` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `donation_id` bigint(20) unsigned NOT NULL,
  `form_id` bigint(20) unsigned NOT NULL,
  `amount` int(10) unsigned NOT NULL,
  `campaign_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `campaign_id` (`campaign_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_sequential_ordering` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `payment_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_key`),
  UNIQUE KEY `session_id` (`session_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_subscriptionmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `subscription_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `subscription_id` (`subscription_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_subscriptions` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `customer_id` bigint(20) NOT NULL,
  `period` varchar(20) NOT NULL,
  `frequency` bigint(20) NOT NULL DEFAULT 1,
  `initial_amount` decimal(18,10) NOT NULL,
  `recurring_amount` decimal(18,10) NOT NULL,
  `recurring_fee_amount` decimal(18,10) NOT NULL,
  `bill_times` bigint(20) NOT NULL,
  `transaction_id` varchar(60) NOT NULL,
  `parent_payment_id` bigint(20) NOT NULL,
  `payment_mode` varchar(20) NOT NULL DEFAULT '',
  `product_id` bigint(20) NOT NULL,
  `created` datetime NOT NULL,
  `expiration` datetime NOT NULL,
  `status` varchar(20) NOT NULL,
  `profile_id` varchar(60) NOT NULL,
  `notes` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `profile_id` (`profile_id`),
  KEY `customer` (`customer_id`),
  KEY `transaction` (`transaction_id`),
  KEY `customer_and_status` (`customer_id`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_litespeed_url` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url` varchar(500) NOT NULL,
  `cache_tags` varchar(1000) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `url` (`url`(191)),
  KEY `cache_tags` (`cache_tags`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_litespeed_url_file` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url_id` bigint(20) NOT NULL,
  `vary` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of final vary',
  `filename` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of file content',
  `type` tinyint(4) NOT NULL COMMENT 'css=1,js=2,ccss=3,ucss=4',
  `mobile` tinyint(4) NOT NULL COMMENT 'mobile=1',
  `webp` tinyint(4) NOT NULL COMMENT 'webp=1',
  `expired` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `filename` (`filename`),
  KEY `type` (`type`),
  KEY `url_id_2` (`url_id`,`vary`,`type`),
  KEY `filename_2` (`filename`,`expired`),
  KEY `url_id` (`url_id`,`expired`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=310340 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=54890 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=6959 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_sliders7` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_slides7` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(11) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  `static` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_tec_events` (
  `event_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL,
  `start_date` varchar(19) NOT NULL,
  `end_date` varchar(19) DEFAULT NULL,
  `timezone` varchar(30) NOT NULL DEFAULT 'UTC',
  `start_date_utc` varchar(19) NOT NULL,
  `end_date_utc` varchar(19) DEFAULT NULL,
  `duration` mediumint(30) DEFAULT 7200,
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `hash` varchar(40) NOT NULL,
  PRIMARY KEY (`event_id`),
  UNIQUE KEY `post_id` (`post_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_tec_occurrences` (
  `occurrence_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` bigint(20) unsigned NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `start_date` varchar(19) NOT NULL,
  `start_date_utc` varchar(19) NOT NULL,
  `end_date` varchar(19) NOT NULL,
  `end_date_utc` varchar(19) NOT NULL,
  `duration` mediumint(30) DEFAULT 7200,
  `hash` varchar(40) NOT NULL,
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`occurrence_id`),
  UNIQUE KEY `hash` (`hash`),
  KEY `event_id` (`event_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3126 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=160 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=27503 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=91 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `zone_id` (`zone_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("27", "action_scheduler/migration_hook", "failed", "2024-06-05 03:17:56", "2024-06-05 05:17:56", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1717557476;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1717557476;}", "2", "1", "2024-06-05 03:18:08", "2024-06-05 05:18:08", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("28", "woocommerce_install_assembler_fonts", "failed", "2024-06-05 03:18:12", "2024-06-05 05:18:12", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1717557492;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1717557492;}", "1", "1", "2024-06-05 03:19:53", "2024-06-05 05:19:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("120", "woocommerce_marketplace_fetch_promotions", "failed", "2024-07-05 04:03:13", "2024-07-05 06:03:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1720152193;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1720152193;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2024-07-05 04:05:38", "2024-07-05 06:05:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("853", "woocommerce_marketplace_fetch_promotions", "failed", "2025-03-08 03:34:33", "2025-03-08 04:34:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1741404873;s:18:\"\0*\0first_timestamp\";i:1721278807;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1741404873;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-08 03:52:50", "2025-03-08 04:52:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("866", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-12 06:59:40", "2025-03-12 07:59:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1741762780;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1741762780;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-12 07:09:40", "2025-03-12 08:09:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("867", "woocommerce_cleanup_draft_orders", "complete", "2025-03-12 21:38:22", "2025-03-12 22:38:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1741815502;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1741815502;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-03-12 22:03:01", "2025-03-12 23:03:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("868", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-12 19:09:40", "2025-03-12 20:09:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1741806580;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1741806580;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-12 20:19:55", "2025-03-12 21:19:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("869", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-13 08:19:55", "2025-03-13 09:19:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1741853995;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1741853995;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-13 08:38:53", "2025-03-13 09:38:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("870", "woocommerce_cleanup_draft_orders", "complete", "2025-03-13 22:03:01", "2025-03-13 23:03:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1741903381;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1741903381;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-03-13 22:18:00", "2025-03-13 23:18:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("871", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-13 20:38:53", "2025-03-13 21:38:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1741898333;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1741898333;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-13 20:43:25", "2025-03-13 21:43:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("872", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-14 08:43:25", "2025-03-14 09:43:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1741941805;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1741941805;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-14 09:16:26", "2025-03-14 10:16:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("873", "woocommerce_cleanup_draft_orders", "complete", "2025-03-14 22:18:00", "2025-03-14 23:18:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1741990680;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1741990680;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-03-14 22:42:45", "2025-03-14 23:42:45", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("874", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-14 21:16:26", "2025-03-14 22:16:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1741986986;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1741986986;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-14 21:16:54", "2025-03-14 22:16:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("875", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-15 09:16:54", "2025-03-15 10:16:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742030214;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742030214;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-15 09:29:24", "2025-03-15 10:29:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("876", "woocommerce_cleanup_draft_orders", "complete", "2025-03-15 22:42:45", "2025-03-15 23:42:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742078565;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742078565;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-03-15 22:55:14", "2025-03-15 23:55:14", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("877", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-15 21:29:24", "2025-03-15 22:29:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742074164;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742074164;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-15 21:54:54", "2025-03-15 22:54:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("878", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-16 09:54:54", "2025-03-16 10:54:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742118894;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742118894;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-16 10:15:42", "2025-03-16 11:15:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("879", "woocommerce_cleanup_draft_orders", "complete", "2025-03-16 22:55:14", "2025-03-16 23:55:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742165714;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742165714;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-03-16 22:58:28", "2025-03-16 23:58:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("880", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-16 22:15:42", "2025-03-16 23:15:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742163342;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742163342;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-16 22:40:56", "2025-03-16 23:40:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("881", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-17 10:40:56", "2025-03-17 11:40:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742208056;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742208056;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-17 10:53:40", "2025-03-17 11:53:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("882", "woocommerce_cleanup_draft_orders", "complete", "2025-03-17 22:58:28", "2025-03-17 23:58:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742252308;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742252308;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-03-17 23:27:00", "2025-03-18 00:27:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("883", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-17 22:53:40", "2025-03-17 23:53:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742252020;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742252020;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-17 23:27:00", "2025-03-18 00:27:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("884", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-18 11:27:00", "2025-03-18 12:27:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742297220;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742297220;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-18 11:50:53", "2025-03-18 12:50:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("885", "woocommerce_cleanup_draft_orders", "complete", "2025-03-18 23:27:00", "2025-03-19 00:27:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742340420;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742340420;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-03-19 00:38:35", "2025-03-19 01:38:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("886", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-18 23:50:53", "2025-03-19 00:50:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742341853;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742341853;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-19 00:38:35", "2025-03-19 01:38:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("887", "woocommerce_cleanup_draft_orders", "complete", "2025-03-20 00:38:35", "2025-03-20 01:38:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742431115;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742431115;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-03-20 01:09:45", "2025-03-20 02:09:45", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("888", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-19 12:38:35", "2025-03-19 13:38:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742387915;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742387915;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-19 12:59:51", "2025-03-19 13:59:51", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("889", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-20 00:59:51", "2025-03-20 01:59:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742432391;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742432391;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-20 01:09:45", "2025-03-20 02:09:45", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("890", "woocommerce_cleanup_draft_orders", "complete", "2025-03-21 01:09:45", "2025-03-21 02:09:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742519385;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742519385;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-03-21 02:06:48", "2025-03-21 03:06:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("891", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-20 13:09:45", "2025-03-20 14:09:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742476185;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742476185;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-20 14:13:37", "2025-03-20 15:13:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("892", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-21 02:13:37", "2025-03-21 03:13:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742523217;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742523217;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-21 02:37:54", "2025-03-21 03:37:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("893", "woocommerce_cleanup_draft_orders", "complete", "2025-03-22 02:06:48", "2025-03-22 03:06:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742609208;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742609208;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-03-22 02:48:57", "2025-03-22 03:48:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("894", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-21 14:37:54", "2025-03-21 15:37:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742567874;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742567874;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-21 14:59:28", "2025-03-21 15:59:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("895", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-22 02:59:28", "2025-03-22 03:59:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742612368;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742612368;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-22 03:24:37", "2025-03-22 04:24:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("896", "woocommerce_cleanup_draft_orders", "complete", "2025-03-23 02:48:57", "2025-03-23 03:48:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742698137;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742698137;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-03-23 02:52:48", "2025-03-23 03:52:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("897", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-22 15:24:37", "2025-03-22 16:24:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742657077;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742657077;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-22 15:34:05", "2025-03-22 16:34:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("898", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-23 03:34:05", "2025-03-23 04:34:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742700845;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742700845;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-23 04:17:31", "2025-03-23 05:17:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("899", "woocommerce_cleanup_draft_orders", "complete", "2025-03-24 02:52:48", "2025-03-24 03:52:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742784768;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742784768;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-03-24 03:16:13", "2025-03-24 04:16:13", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("900", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-23 16:17:31", "2025-03-23 17:17:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742746651;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742746651;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-23 16:23:32", "2025-03-23 17:23:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("901", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-24 04:23:32", "2025-03-24 05:23:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742790212;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742790212;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-24 04:58:30", "2025-03-24 05:58:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("902", "woocommerce_cleanup_draft_orders", "complete", "2025-03-25 03:16:13", "2025-03-25 04:16:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742872573;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742872573;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-03-25 03:27:41", "2025-03-25 04:27:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("903", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-24 16:58:30", "2025-03-24 17:58:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742835510;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742835510;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-24 17:18:38", "2025-03-24 18:18:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("904", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-25 05:18:38", "2025-03-25 06:18:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742879918;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742879918;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-25 06:01:22", "2025-03-25 07:01:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("905", "woocommerce_cleanup_draft_orders", "complete", "2025-03-26 03:27:41", "2025-03-26 04:27:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742959661;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742959661;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-03-26 04:25:35", "2025-03-26 05:25:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("906", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-25 18:01:22", "2025-03-25 19:01:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742925682;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742925682;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-25 18:03:17", "2025-03-25 19:03:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("907", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-26 06:03:17", "2025-03-26 07:03:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742968997;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742968997;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-26 06:04:07", "2025-03-26 07:04:07", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("908", "woocommerce_cleanup_draft_orders", "complete", "2025-03-27 04:25:35", "2025-03-27 05:25:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743049535;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743049535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-03-27 05:05:32", "2025-03-27 06:05:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("909", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-26 18:04:07", "2025-03-26 19:04:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743012247;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743012247;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-26 18:13:24", "2025-03-26 19:13:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("910", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-27 06:13:24", "2025-03-27 07:13:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743056004;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743056004;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-27 06:16:16", "2025-03-27 07:16:16", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("911", "woocommerce_cleanup_draft_orders", "complete", "2025-03-28 05:05:32", "2025-03-28 06:05:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743138332;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743138332;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-03-28 05:13:28", "2025-03-28 06:13:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("912", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-27 18:16:16", "2025-03-27 19:16:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743099376;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743099376;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-27 18:43:58", "2025-03-27 19:43:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("913", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-28 06:43:58", "2025-03-28 07:43:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743144238;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743144238;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-28 06:51:42", "2025-03-28 07:51:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("914", "woocommerce_cleanup_draft_orders", "complete", "2025-03-29 05:13:28", "2025-03-29 06:13:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743225208;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743225208;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-03-29 05:14:49", "2025-03-29 06:14:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("915", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-28 18:51:42", "2025-03-28 19:51:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743187902;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743187902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-28 19:49:40", "2025-03-28 20:49:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("916", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-29 07:49:40", "2025-03-29 08:49:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743234580;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743234580;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-29 08:29:32", "2025-03-29 09:29:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("917", "woocommerce_cleanup_draft_orders", "complete", "2025-03-30 05:14:49", "2025-03-30 07:14:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743311689;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743311689;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-03-30 05:22:41", "2025-03-30 07:22:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("918", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-29 20:29:32", "2025-03-29 21:29:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743280172;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743280172;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-29 21:00:22", "2025-03-29 22:00:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("919", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-30 09:00:22", "2025-03-30 11:00:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743325222;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743325222;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-30 09:11:12", "2025-03-30 11:11:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("920", "woocommerce_cleanup_draft_orders", "complete", "2025-03-31 05:22:41", "2025-03-31 07:22:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743398561;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743398561;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-03-31 05:36:47", "2025-03-31 07:36:47", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("921", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-30 21:11:12", "2025-03-30 23:11:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743369072;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743369072;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-30 21:13:59", "2025-03-30 23:13:59", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("922", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-31 09:13:59", "2025-03-31 11:13:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743412439;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743412439;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-31 09:17:38", "2025-03-31 11:17:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("923", "woocommerce_cleanup_draft_orders", "complete", "2025-04-01 05:36:47", "2025-04-01 07:36:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743485807;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743485807;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-04-01 05:59:34", "2025-04-01 07:59:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("924", "woocommerce_marketplace_fetch_promotions", "complete", "2025-03-31 21:17:38", "2025-03-31 23:17:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743455858;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743455858;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-03-31 21:21:07", "2025-03-31 23:21:07", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("925", "woocommerce_marketplace_fetch_promotions", "complete", "2025-04-01 09:21:07", "2025-04-01 11:21:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743499267;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743499267;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-04-01 09:46:21", "2025-04-01 11:46:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("926", "woocommerce_cleanup_draft_orders", "complete", "2025-04-02 05:59:34", "2025-04-02 07:59:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743573574;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743573574;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-04-02 06:05:47", "2025-04-02 08:05:47", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("927", "woocommerce_marketplace_fetch_promotions", "complete", "2025-04-01 21:46:21", "2025-04-01 23:46:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743543981;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743543981;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-04-01 21:46:25", "2025-04-01 23:46:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("928", "woocommerce_marketplace_fetch_promotions", "complete", "2025-04-02 09:46:25", "2025-04-02 11:46:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743587185;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743587185;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-04-02 09:51:43", "2025-04-02 11:51:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("929", "woocommerce_cleanup_draft_orders", "complete", "2025-04-03 06:05:47", "2025-04-03 08:05:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743660347;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743660347;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-04-03 06:17:10", "2025-04-03 08:17:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("930", "woocommerce_marketplace_fetch_promotions", "complete", "2025-04-02 21:51:43", "2025-04-02 23:51:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743630703;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743630703;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-04-02 21:56:12", "2025-04-02 23:56:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("931", "woocommerce_marketplace_fetch_promotions", "complete", "2025-04-03 09:56:12", "2025-04-03 11:56:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743674172;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743674172;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-04-03 09:59:14", "2025-04-03 11:59:14", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("932", "woocommerce_cleanup_draft_orders", "complete", "2025-04-04 06:17:10", "2025-04-04 08:17:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743747430;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743747430;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-04-04 06:18:52", "2025-04-04 08:18:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("933", "woocommerce_marketplace_fetch_promotions", "complete", "2025-04-03 21:59:14", "2025-04-03 23:59:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743717554;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743717554;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-04-03 21:59:45", "2025-04-03 23:59:45", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("934", "woocommerce_marketplace_fetch_promotions", "complete", "2025-04-04 09:59:45", "2025-04-04 11:59:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743760785;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743760785;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-04-04 10:45:53", "2025-04-04 12:45:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("935", "woocommerce_cleanup_draft_orders", "complete", "2025-04-05 06:18:52", "2025-04-05 08:18:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743833932;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743833932;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-04-05 06:21:11", "2025-04-05 08:21:11", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("936", "woocommerce_marketplace_fetch_promotions", "complete", "2025-04-04 22:45:53", "2025-04-05 00:45:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743806753;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743806753;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-04-04 22:46:30", "2025-04-05 00:46:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("937", "woocommerce_marketplace_fetch_promotions", "complete", "2025-04-05 10:46:30", "2025-04-05 12:46:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743849990;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743849990;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-04-05 11:29:55", "2025-04-05 13:29:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("938", "woocommerce_cleanup_draft_orders", "complete", "2025-04-06 06:21:11", "2025-04-06 08:21:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743920471;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743920471;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-04-06 06:26:59", "2025-04-06 08:26:59", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("939", "woocommerce_marketplace_fetch_promotions", "complete", "2025-04-05 23:29:55", "2025-04-06 01:29:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743895795;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743895795;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-04-06 00:00:19", "2025-04-06 02:00:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("940", "woocommerce_marketplace_fetch_promotions", "complete", "2025-04-06 12:00:19", "2025-04-06 14:00:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743940819;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743940819;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-04-06 12:43:11", "2025-04-06 14:43:11", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("941", "woocommerce_cleanup_draft_orders", "complete", "2025-04-07 06:26:59", "2025-04-07 08:26:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744007219;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744007219;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-04-07 06:41:39", "2025-04-07 08:41:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("942", "woocommerce_marketplace_fetch_promotions", "complete", "2025-04-07 00:43:11", "2025-04-07 02:43:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743986591;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743986591;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-04-07 01:08:52", "2025-04-07 03:08:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("943", "woocommerce_marketplace_fetch_promotions", "complete", "2025-04-07 13:08:52", "2025-04-07 15:08:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744031332;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744031332;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-04-07 13:15:50", "2025-04-07 15:15:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("944", "woocommerce_cleanup_draft_orders", "complete", "2025-04-08 06:41:39", "2025-04-08 08:41:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744094499;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744094499;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-04-08 06:50:34", "2025-04-08 08:50:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("945", "woocommerce_marketplace_fetch_promotions", "complete", "2025-04-08 01:15:50", "2025-04-08 03:15:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744074950;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744074950;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-04-08 01:28:09", "2025-04-08 03:28:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("946", "woocommerce_marketplace_fetch_promotions", "complete", "2025-04-08 13:28:09", "2025-04-08 15:28:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744118889;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744118889;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-04-08 13:33:21", "2025-04-08 15:33:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("947", "woocommerce_cleanup_draft_orders", "complete", "2025-04-09 06:50:34", "2025-04-09 08:50:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744181434;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744181434;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-04-09 06:54:23", "2025-04-09 08:54:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("948", "woocommerce_marketplace_fetch_promotions", "complete", "2025-04-09 01:33:21", "2025-04-09 03:33:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744162401;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744162401;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-04-09 01:44:41", "2025-04-09 03:44:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("949", "woocommerce_marketplace_fetch_promotions", "complete", "2025-04-09 13:44:41", "2025-04-09 15:44:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744206281;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744206281;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-04-09 13:47:59", "2025-04-09 15:47:59", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("950", "woocommerce_cleanup_draft_orders", "complete", "2025-04-10 06:54:23", "2025-04-10 08:54:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744268063;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744268063;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-04-10 07:12:26", "2025-04-10 09:12:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("951", "woocommerce_marketplace_fetch_promotions", "complete", "2025-04-10 01:47:59", "2025-04-10 03:47:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744249679;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744249679;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-04-10 01:48:03", "2025-04-10 03:48:03", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("952", "woocommerce_marketplace_fetch_promotions", "complete", "2025-04-10 13:48:03", "2025-04-10 15:48:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744292883;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744292883;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-04-10 14:08:49", "2025-04-10 16:08:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("953", "woocommerce_cleanup_draft_orders", "complete", "2025-04-11 07:12:26", "2025-04-11 09:12:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744355546;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744355546;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-04-11 07:18:16", "2025-04-11 09:18:16", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("954", "woocommerce_marketplace_fetch_promotions", "complete", "2025-04-11 02:08:49", "2025-04-11 04:08:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744337329;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744337329;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-04-11 03:18:47", "2025-04-11 05:18:47", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("955", "woocommerce_marketplace_fetch_promotions", "complete", "2025-04-11 15:18:47", "2025-04-11 17:18:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744384727;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744384727;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "1", "2025-04-11 15:19:20", "2025-04-11 17:19:20", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("956", "woocommerce_cleanup_draft_orders", "pending", "2025-04-12 07:18:16", "2025-04-12 09:18:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744442296;s:18:\"\0*\0first_timestamp\";i:1717557344;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744442296;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("957", "woocommerce_marketplace_fetch_promotions", "pending", "2025-04-12 03:19:20", "2025-04-12 05:19:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744427960;s:18:\"\0*\0first_timestamp\";i:1741407291;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744427960;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("960", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2025-04-11 21:57:12", "2025-04-11 23:57:12", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1744408632;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1744408632;}", "4", "1", "2025-04-11 21:57:43", "2025-04-11 23:57:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("961", "fetch_patterns", "complete", "2025-04-11 21:57:12", "2025-04-11 23:57:12", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1744408632;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1744408632;}", "1", "1", "2025-04-11 21:57:43", "2025-04-11 23:57:43", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_claims */
INSERT INTO `wp_actionscheduler_claims` VALUES("49283", "2024-07-18 04:58:38");
INSERT INTO `wp_actionscheduler_claims` VALUES("49284", "2024-07-18 04:59:39");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "woocommerce-remote-inbox-engine");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "add_campaign_id_to_donations");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("12", "27", "acción creada", "2024-06-05 03:16:56", "2024-06-05 05:16:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("13", "27", "acción empezada vía Async Request", "2024-06-05 03:18:08", "2024-06-05 05:18:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("14", "27", "acción fallida vía Async Request: La acción programada para action_scheduler/migration_hook no se ejecutará ya que no se han registrado llamadas.", "2024-06-05 03:18:08", "2024-06-05 05:18:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("15", "28", "acción creada", "2024-06-05 03:18:12", "2024-06-05 05:18:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("18", "28", "acción empezada vía Async Request", "2024-06-05 03:19:53", "2024-06-05 05:19:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("26", "28", "acción marcada como fallida después de 300 segundos. Se ha producido un error desconocido. Revisa los registros de errores del servidor, de PHP y de la base de datos para diagnosticar el motivo.", "2024-06-05 03:25:15", "2024-06-05 05:25:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("293", "120", "acción creada", "2024-07-04 16:03:13", "2024-07-04 18:03:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("297", "120", "acción empezada vía Async Request", "2024-07-05 04:05:38", "2024-07-05 06:05:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("298", "120", "acción marcada como fallida después de 300 segundos. Se ha producido un error desconocido. Revisa los registros de errores del servidor, de PHP y de la base de datos para diagnosticar el motivo.", "2024-07-05 04:11:39", "2024-07-05 06:11:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2492", "853", "acción creada", "2025-03-07 15:34:33", "2025-03-07 16:34:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("2496", "853", "acción empezada vía Async Request", "2025-03-08 03:52:50", "2025-03-08 04:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2497", "853", "acción marcada como fallida después de 300 segundos. Se ha producido un error desconocido. Revisa los registros de errores del servidor, de PHP y de la base de datos para diagnosticar el motivo.", "2025-03-08 03:58:28", "2025-03-08 04:58:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2531", "866", "acción creada", "2025-03-11 18:59:40", "2025-03-11 19:59:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2534", "867", "acción creada", "2025-03-11 21:38:22", "2025-03-11 22:38:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("2535", "866", "acción empezada vía WP Cron", "2025-03-12 07:09:40", "2025-03-12 08:09:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2536", "866", "acción completa vía WP Cron", "2025-03-12 07:09:40", "2025-03-12 08:09:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2537", "868", "acción creada", "2025-03-12 07:09:40", "2025-03-12 08:09:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2538", "868", "acción empezada vía WP Cron", "2025-03-12 20:19:55", "2025-03-12 21:19:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2539", "868", "acción completa vía WP Cron", "2025-03-12 20:19:55", "2025-03-12 21:19:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2540", "869", "acción creada", "2025-03-12 20:19:55", "2025-03-12 21:19:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2541", "867", "acción empezada vía WP Cron", "2025-03-12 22:03:01", "2025-03-12 23:03:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2542", "867", "acción completa vía WP Cron", "2025-03-12 22:03:01", "2025-03-12 23:03:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2543", "870", "acción creada", "2025-03-12 22:03:01", "2025-03-12 23:03:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2544", "869", "acción empezada vía WP Cron", "2025-03-13 08:38:53", "2025-03-13 09:38:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2545", "869", "acción completa vía WP Cron", "2025-03-13 08:38:53", "2025-03-13 09:38:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2546", "871", "acción creada", "2025-03-13 08:38:53", "2025-03-13 09:38:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2547", "871", "acción empezada vía WP Cron", "2025-03-13 20:43:25", "2025-03-13 21:43:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2548", "871", "acción completa vía WP Cron", "2025-03-13 20:43:25", "2025-03-13 21:43:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2549", "872", "acción creada", "2025-03-13 20:43:25", "2025-03-13 21:43:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2550", "870", "acción empezada vía WP Cron", "2025-03-13 22:18:00", "2025-03-13 23:18:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2551", "870", "acción completa vía WP Cron", "2025-03-13 22:18:00", "2025-03-13 23:18:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2552", "873", "acción creada", "2025-03-13 22:18:00", "2025-03-13 23:18:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2553", "872", "acción empezada vía WP Cron", "2025-03-14 09:16:26", "2025-03-14 10:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2554", "872", "acción completa vía WP Cron", "2025-03-14 09:16:26", "2025-03-14 10:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2555", "874", "acción creada", "2025-03-14 09:16:26", "2025-03-14 10:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2556", "874", "acción empezada vía WP Cron", "2025-03-14 21:16:53", "2025-03-14 22:16:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2557", "874", "acción completa vía WP Cron", "2025-03-14 21:16:54", "2025-03-14 22:16:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("2558", "875", "acción creada", "2025-03-14 21:16:54", "2025-03-14 22:16:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("2559", "873", "acción empezada vía WP Cron", "2025-03-14 22:42:45", "2025-03-14 23:42:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2560", "873", "acción completa vía WP Cron", "2025-03-14 22:42:45", "2025-03-14 23:42:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2561", "876", "acción creada", "2025-03-14 22:42:45", "2025-03-14 23:42:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2562", "875", "acción empezada vía WP Cron", "2025-03-15 09:29:24", "2025-03-15 10:29:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("2563", "875", "acción completa vía WP Cron", "2025-03-15 09:29:24", "2025-03-15 10:29:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("2564", "877", "acción creada", "2025-03-15 09:29:24", "2025-03-15 10:29:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("2565", "877", "acción empezada vía WP Cron", "2025-03-15 21:54:54", "2025-03-15 22:54:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("2566", "877", "acción completa vía WP Cron", "2025-03-15 21:54:54", "2025-03-15 22:54:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("2567", "878", "acción creada", "2025-03-15 21:54:54", "2025-03-15 22:54:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("2568", "876", "acción empezada vía WP Cron", "2025-03-15 22:55:14", "2025-03-15 23:55:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2569", "876", "acción completa vía WP Cron", "2025-03-15 22:55:14", "2025-03-15 23:55:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2570", "879", "acción creada", "2025-03-15 22:55:14", "2025-03-15 23:55:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2571", "878", "acción empezada vía WP Cron", "2025-03-16 10:15:41", "2025-03-16 11:15:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2572", "878", "acción completa vía WP Cron", "2025-03-16 10:15:42", "2025-03-16 11:15:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("2573", "880", "acción creada", "2025-03-16 10:15:42", "2025-03-16 11:15:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("2574", "880", "acción empezada vía WP Cron", "2025-03-16 22:40:56", "2025-03-16 23:40:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2575", "880", "acción completa vía WP Cron", "2025-03-16 22:40:56", "2025-03-16 23:40:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2576", "881", "acción creada", "2025-03-16 22:40:56", "2025-03-16 23:40:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2577", "879", "acción empezada vía WP Cron", "2025-03-16 22:58:28", "2025-03-16 23:58:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2578", "879", "acción completa vía WP Cron", "2025-03-16 22:58:28", "2025-03-16 23:58:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2579", "882", "acción creada", "2025-03-16 22:58:28", "2025-03-16 23:58:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2580", "881", "acción empezada vía WP Cron", "2025-03-17 10:53:39", "2025-03-17 11:53:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2581", "881", "acción completa vía WP Cron", "2025-03-17 10:53:40", "2025-03-17 11:53:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2582", "883", "acción creada", "2025-03-17 10:53:40", "2025-03-17 11:53:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2583", "883", "acción empezada vía WP Cron", "2025-03-17 23:26:59", "2025-03-18 00:26:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2584", "883", "acción completa vía WP Cron", "2025-03-17 23:27:00", "2025-03-18 00:27:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2585", "884", "acción creada", "2025-03-17 23:27:00", "2025-03-18 00:27:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2586", "882", "acción empezada vía WP Cron", "2025-03-17 23:27:00", "2025-03-18 00:27:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2587", "882", "acción completa vía WP Cron", "2025-03-17 23:27:00", "2025-03-18 00:27:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2588", "885", "acción creada", "2025-03-17 23:27:00", "2025-03-18 00:27:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2589", "884", "acción empezada vía WP Cron", "2025-03-18 11:50:53", "2025-03-18 12:50:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2590", "884", "acción completa vía WP Cron", "2025-03-18 11:50:53", "2025-03-18 12:50:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2591", "886", "acción creada", "2025-03-18 11:50:53", "2025-03-18 12:50:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2592", "885", "acción empezada vía WP Cron", "2025-03-19 00:38:35", "2025-03-19 01:38:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2593", "885", "acción completa vía WP Cron", "2025-03-19 00:38:35", "2025-03-19 01:38:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2594", "887", "acción creada", "2025-03-19 00:38:35", "2025-03-19 01:38:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2595", "886", "acción empezada vía WP Cron", "2025-03-19 00:38:35", "2025-03-19 01:38:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2596", "886", "acción completa vía WP Cron", "2025-03-19 00:38:35", "2025-03-19 01:38:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2597", "888", "acción creada", "2025-03-19 00:38:35", "2025-03-19 01:38:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2598", "888", "acción empezada vía WP Cron", "2025-03-19 12:59:50", "2025-03-19 13:59:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2599", "888", "acción completa vía WP Cron", "2025-03-19 12:59:51", "2025-03-19 13:59:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("2600", "889", "acción creada", "2025-03-19 12:59:51", "2025-03-19 13:59:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("2601", "887", "acción empezada vía WP Cron", "2025-03-20 01:09:45", "2025-03-20 02:09:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2602", "887", "acción completa vía WP Cron", "2025-03-20 01:09:45", "2025-03-20 02:09:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2603", "890", "acción creada", "2025-03-20 01:09:45", "2025-03-20 02:09:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2604", "889", "acción empezada vía WP Cron", "2025-03-20 01:09:45", "2025-03-20 02:09:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2605", "889", "acción completa vía WP Cron", "2025-03-20 01:09:45", "2025-03-20 02:09:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2606", "891", "acción creada", "2025-03-20 01:09:45", "2025-03-20 02:09:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2607", "891", "acción empezada vía WP Cron", "2025-03-20 14:13:37", "2025-03-20 15:13:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2608", "891", "acción completa vía WP Cron", "2025-03-20 14:13:37", "2025-03-20 15:13:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2609", "892", "acción creada", "2025-03-20 14:13:37", "2025-03-20 15:13:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2610", "890", "acción empezada vía WP Cron", "2025-03-21 02:06:48", "2025-03-21 03:06:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2611", "890", "acción completa vía WP Cron", "2025-03-21 02:06:48", "2025-03-21 03:06:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2612", "893", "acción creada", "2025-03-21 02:06:48", "2025-03-21 03:06:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2613", "892", "acción empezada vía WP Cron", "2025-03-21 02:37:53", "2025-03-21 03:37:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2614", "892", "acción completa vía WP Cron", "2025-03-21 02:37:54", "2025-03-21 03:37:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("2615", "894", "acción creada", "2025-03-21 02:37:54", "2025-03-21 03:37:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("2616", "894", "acción empezada vía WP Cron", "2025-03-21 14:59:28", "2025-03-21 15:59:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2617", "894", "acción completa vía WP Cron", "2025-03-21 14:59:28", "2025-03-21 15:59:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2618", "895", "acción creada", "2025-03-21 14:59:28", "2025-03-21 15:59:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2619", "893", "acción empezada vía WP Cron", "2025-03-22 02:48:57", "2025-03-22 03:48:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2620", "893", "acción completa vía WP Cron", "2025-03-22 02:48:57", "2025-03-22 03:48:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2621", "896", "acción creada", "2025-03-22 02:48:57", "2025-03-22 03:48:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2622", "895", "acción empezada vía WP Cron", "2025-03-22 03:24:37", "2025-03-22 04:24:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2623", "895", "acción completa vía WP Cron", "2025-03-22 03:24:37", "2025-03-22 04:24:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2624", "897", "acción creada", "2025-03-22 03:24:37", "2025-03-22 04:24:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2625", "897", "acción empezada vía WP Cron", "2025-03-22 15:34:04", "2025-03-22 16:34:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2626", "897", "acción completa vía WP Cron", "2025-03-22 15:34:05", "2025-03-22 16:34:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("2627", "898", "acción creada", "2025-03-22 15:34:05", "2025-03-22 16:34:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("2628", "896", "acción empezada vía WP Cron", "2025-03-23 02:52:48", "2025-03-23 03:52:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2629", "896", "acción completa vía WP Cron", "2025-03-23 02:52:48", "2025-03-23 03:52:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2630", "899", "acción creada", "2025-03-23 02:52:48", "2025-03-23 03:52:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2631", "898", "acción empezada vía WP Cron", "2025-03-23 04:17:31", "2025-03-23 05:17:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2632", "898", "acción completa vía WP Cron", "2025-03-23 04:17:31", "2025-03-23 05:17:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2633", "900", "acción creada", "2025-03-23 04:17:31", "2025-03-23 05:17:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2634", "900", "acción empezada vía WP Cron", "2025-03-23 16:23:32", "2025-03-23 17:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2635", "900", "acción completa vía WP Cron", "2025-03-23 16:23:32", "2025-03-23 17:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2636", "901", "acción creada", "2025-03-23 16:23:32", "2025-03-23 17:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2637", "899", "acción empezada vía Async Request", "2025-03-24 03:16:13", "2025-03-24 04:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("2638", "899", "acción completa vía Async Request", "2025-03-24 03:16:13", "2025-03-24 04:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("2639", "902", "acción creada", "2025-03-24 03:16:13", "2025-03-24 04:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("2640", "901", "acción empezada vía WP Cron", "2025-03-24 04:58:30", "2025-03-24 05:58:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2641", "901", "acción completa vía WP Cron", "2025-03-24 04:58:30", "2025-03-24 05:58:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2642", "903", "acción creada", "2025-03-24 04:58:30", "2025-03-24 05:58:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2643", "903", "acción empezada vía WP Cron", "2025-03-24 17:18:37", "2025-03-24 18:18:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2644", "903", "acción completa vía WP Cron", "2025-03-24 17:18:38", "2025-03-24 18:18:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("2645", "904", "acción creada", "2025-03-24 17:18:38", "2025-03-24 18:18:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("2646", "902", "acción empezada vía WP Cron", "2025-03-25 03:27:41", "2025-03-25 04:27:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2647", "902", "acción completa vía WP Cron", "2025-03-25 03:27:41", "2025-03-25 04:27:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2648", "905", "acción creada", "2025-03-25 03:27:41", "2025-03-25 04:27:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2649", "904", "acción empezada vía WP Cron", "2025-03-25 06:01:22", "2025-03-25 07:01:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("2650", "904", "acción completa vía WP Cron", "2025-03-25 06:01:22", "2025-03-25 07:01:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("2651", "906", "acción creada", "2025-03-25 06:01:22", "2025-03-25 07:01:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("2652", "906", "acción empezada vía WP Cron", "2025-03-25 18:03:17", "2025-03-25 19:03:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2653", "906", "acción completa vía WP Cron", "2025-03-25 18:03:17", "2025-03-25 19:03:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2654", "907", "acción creada", "2025-03-25 18:03:17", "2025-03-25 19:03:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2655", "905", "acción empezada vía WP Cron", "2025-03-26 04:25:35", "2025-03-26 05:25:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2656", "905", "acción completa vía WP Cron", "2025-03-26 04:25:35", "2025-03-26 05:25:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2657", "908", "acción creada", "2025-03-26 04:25:35", "2025-03-26 05:25:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2658", "907", "acción empezada vía WP Cron", "2025-03-26 06:04:07", "2025-03-26 07:04:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("2659", "907", "acción completa vía WP Cron", "2025-03-26 06:04:07", "2025-03-26 07:04:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("2660", "909", "acción creada", "2025-03-26 06:04:07", "2025-03-26 07:04:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("2661", "909", "acción empezada vía WP Cron", "2025-03-26 18:13:23", "2025-03-26 19:13:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("2662", "909", "acción completa vía WP Cron", "2025-03-26 18:13:24", "2025-03-26 19:13:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("2663", "910", "acción creada", "2025-03-26 18:13:24", "2025-03-26 19:13:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("2664", "908", "acción empezada vía WP Cron", "2025-03-27 05:05:32", "2025-03-27 06:05:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2665", "908", "acción completa vía WP Cron", "2025-03-27 05:05:32", "2025-03-27 06:05:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2666", "911", "acción creada", "2025-03-27 05:05:32", "2025-03-27 06:05:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2667", "910", "acción empezada vía WP Cron", "2025-03-27 06:16:15", "2025-03-27 07:16:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("2668", "910", "acción completa vía WP Cron", "2025-03-27 06:16:16", "2025-03-27 07:16:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("2669", "912", "acción creada", "2025-03-27 06:16:16", "2025-03-27 07:16:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("2670", "912", "acción empezada vía WP Cron", "2025-03-27 18:43:58", "2025-03-27 19:43:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2671", "912", "acción completa vía WP Cron", "2025-03-27 18:43:58", "2025-03-27 19:43:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2672", "913", "acción creada", "2025-03-27 18:43:58", "2025-03-27 19:43:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2673", "911", "acción empezada vía WP Cron", "2025-03-28 05:13:28", "2025-03-28 06:13:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2674", "911", "acción completa vía WP Cron", "2025-03-28 05:13:28", "2025-03-28 06:13:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2675", "914", "acción creada", "2025-03-28 05:13:28", "2025-03-28 06:13:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2676", "913", "acción empezada vía WP Cron", "2025-03-28 06:51:42", "2025-03-28 07:51:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("2677", "913", "acción completa vía WP Cron", "2025-03-28 06:51:42", "2025-03-28 07:51:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("2678", "915", "acción creada", "2025-03-28 06:51:42", "2025-03-28 07:51:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("2679", "915", "acción empezada vía WP Cron", "2025-03-28 19:49:39", "2025-03-28 20:49:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2680", "915", "acción completa vía WP Cron", "2025-03-28 19:49:40", "2025-03-28 20:49:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2681", "916", "acción creada", "2025-03-28 19:49:40", "2025-03-28 20:49:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2682", "914", "acción empezada vía Async Request", "2025-03-29 05:14:49", "2025-03-29 06:14:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("2683", "914", "acción completa vía Async Request", "2025-03-29 05:14:49", "2025-03-29 06:14:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("2684", "917", "acción creada", "2025-03-29 05:14:49", "2025-03-29 06:14:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("2685", "916", "acción empezada vía WP Cron", "2025-03-29 08:29:32", "2025-03-29 09:29:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2686", "916", "acción completa vía WP Cron", "2025-03-29 08:29:32", "2025-03-29 09:29:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2687", "918", "acción creada", "2025-03-29 08:29:32", "2025-03-29 09:29:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2688", "918", "acción empezada vía WP Cron", "2025-03-29 21:00:22", "2025-03-29 22:00:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("2689", "918", "acción completa vía WP Cron", "2025-03-29 21:00:22", "2025-03-29 22:00:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("2690", "919", "acción creada", "2025-03-29 21:00:22", "2025-03-29 22:00:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("2691", "917", "acción empezada vía WP Cron", "2025-03-30 05:22:41", "2025-03-30 07:22:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2692", "917", "acción completa vía WP Cron", "2025-03-30 05:22:41", "2025-03-30 07:22:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2693", "920", "acción creada", "2025-03-30 05:22:41", "2025-03-30 07:22:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2694", "919", "acción empezada vía WP Cron", "2025-03-30 09:11:11", "2025-03-30 11:11:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2695", "919", "acción completa vía WP Cron", "2025-03-30 09:11:12", "2025-03-30 11:11:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2696", "921", "acción creada", "2025-03-30 09:11:12", "2025-03-30 11:11:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2697", "921", "acción empezada vía WP Cron", "2025-03-30 21:13:58", "2025-03-30 23:13:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2698", "921", "acción completa vía WP Cron", "2025-03-30 21:13:59", "2025-03-30 23:13:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2699", "922", "acción creada", "2025-03-30 21:13:59", "2025-03-30 23:13:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2700", "920", "acción empezada vía WP Cron", "2025-03-31 05:36:47", "2025-03-31 07:36:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2701", "920", "acción completa vía WP Cron", "2025-03-31 05:36:47", "2025-03-31 07:36:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2702", "923", "acción creada", "2025-03-31 05:36:47", "2025-03-31 07:36:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2703", "922", "acción empezada vía WP Cron", "2025-03-31 09:17:38", "2025-03-31 11:17:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("2704", "922", "acción completa vía WP Cron", "2025-03-31 09:17:38", "2025-03-31 11:17:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("2705", "924", "acción creada", "2025-03-31 09:17:38", "2025-03-31 11:17:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("2706", "924", "acción empezada vía WP Cron", "2025-03-31 21:21:07", "2025-03-31 23:21:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("2707", "924", "acción completa vía WP Cron", "2025-03-31 21:21:07", "2025-03-31 23:21:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("2708", "925", "acción creada", "2025-03-31 21:21:07", "2025-03-31 23:21:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("2709", "923", "acción empezada vía Async Request", "2025-04-01 05:59:34", "2025-04-01 07:59:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2710", "923", "acción completa vía Async Request", "2025-04-01 05:59:34", "2025-04-01 07:59:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2711", "926", "acción creada", "2025-04-01 05:59:34", "2025-04-01 07:59:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2712", "925", "acción empezada vía WP Cron", "2025-04-01 09:46:21", "2025-04-01 11:46:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2713", "925", "acción completa vía WP Cron", "2025-04-01 09:46:21", "2025-04-01 11:46:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2714", "927", "acción creada", "2025-04-01 09:46:21", "2025-04-01 11:46:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2715", "927", "acción empezada vía WP Cron", "2025-04-01 21:46:25", "2025-04-01 23:46:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2716", "927", "acción completa vía WP Cron", "2025-04-01 21:46:25", "2025-04-01 23:46:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2717", "928", "acción creada", "2025-04-01 21:46:25", "2025-04-01 23:46:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2718", "926", "acción empezada vía WP Cron", "2025-04-02 06:05:47", "2025-04-02 08:05:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2719", "926", "acción completa vía WP Cron", "2025-04-02 06:05:47", "2025-04-02 08:05:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2720", "929", "acción creada", "2025-04-02 06:05:47", "2025-04-02 08:05:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2721", "928", "acción empezada vía WP Cron", "2025-04-02 09:51:43", "2025-04-02 11:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("2722", "928", "acción completa vía WP Cron", "2025-04-02 09:51:43", "2025-04-02 11:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("2723", "930", "acción creada", "2025-04-02 09:51:43", "2025-04-02 11:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("2724", "930", "acción empezada vía WP Cron", "2025-04-02 21:56:12", "2025-04-02 23:56:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2725", "930", "acción completa vía WP Cron", "2025-04-02 21:56:12", "2025-04-02 23:56:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2726", "931", "acción creada", "2025-04-02 21:56:12", "2025-04-02 23:56:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2727", "929", "acción empezada vía WP Cron", "2025-04-03 06:17:10", "2025-04-03 08:17:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2728", "929", "acción completa vía WP Cron", "2025-04-03 06:17:10", "2025-04-03 08:17:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2729", "932", "acción creada", "2025-04-03 06:17:10", "2025-04-03 08:17:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2730", "931", "acción empezada vía WP Cron", "2025-04-03 09:59:14", "2025-04-03 11:59:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2731", "931", "acción completa vía WP Cron", "2025-04-03 09:59:14", "2025-04-03 11:59:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2732", "933", "acción creada", "2025-04-03 09:59:14", "2025-04-03 11:59:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2733", "933", "acción empezada vía WP Cron", "2025-04-03 21:59:44", "2025-04-03 23:59:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("2734", "933", "acción completa vía WP Cron", "2025-04-03 21:59:45", "2025-04-03 23:59:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2735", "934", "acción creada", "2025-04-03 21:59:45", "2025-04-03 23:59:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2736", "932", "acción empezada vía Async Request", "2025-04-04 06:18:52", "2025-04-04 08:18:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("2737", "932", "acción completa vía Async Request", "2025-04-04 06:18:52", "2025-04-04 08:18:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("2738", "935", "acción creada", "2025-04-04 06:18:52", "2025-04-04 08:18:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("2739", "934", "acción empezada vía WP Cron", "2025-04-04 10:45:53", "2025-04-04 12:45:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2740", "934", "acción completa vía WP Cron", "2025-04-04 10:45:53", "2025-04-04 12:45:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2741", "936", "acción creada", "2025-04-04 10:45:53", "2025-04-04 12:45:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2742", "936", "acción empezada vía WP Cron", "2025-04-04 22:46:30", "2025-04-05 00:46:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2743", "936", "acción completa vía WP Cron", "2025-04-04 22:46:30", "2025-04-05 00:46:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2744", "937", "acción creada", "2025-04-04 22:46:30", "2025-04-05 00:46:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2745", "935", "acción empezada vía WP Cron", "2025-04-05 06:21:11", "2025-04-05 08:21:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2746", "935", "acción completa vía WP Cron", "2025-04-05 06:21:11", "2025-04-05 08:21:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2747", "938", "acción creada", "2025-04-05 06:21:11", "2025-04-05 08:21:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2748", "937", "acción empezada vía WP Cron", "2025-04-05 11:29:55", "2025-04-05 13:29:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2749", "937", "acción completa vía WP Cron", "2025-04-05 11:29:55", "2025-04-05 13:29:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2750", "939", "acción creada", "2025-04-05 11:29:55", "2025-04-05 13:29:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2751", "939", "acción empezada vía WP Cron", "2025-04-06 00:00:19", "2025-04-06 02:00:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("2752", "939", "acción completa vía WP Cron", "2025-04-06 00:00:19", "2025-04-06 02:00:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("2753", "940", "acción creada", "2025-04-06 00:00:19", "2025-04-06 02:00:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("2754", "938", "acción empezada vía WP Cron", "2025-04-06 06:26:59", "2025-04-06 08:26:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2755", "938", "acción completa vía WP Cron", "2025-04-06 06:26:59", "2025-04-06 08:26:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2756", "941", "acción creada", "2025-04-06 06:26:59", "2025-04-06 08:26:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2757", "940", "acción empezada vía WP Cron", "2025-04-06 12:43:11", "2025-04-06 14:43:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2758", "940", "acción completa vía WP Cron", "2025-04-06 12:43:11", "2025-04-06 14:43:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2759", "942", "acción creada", "2025-04-06 12:43:11", "2025-04-06 14:43:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2760", "942", "acción empezada vía WP Cron", "2025-04-07 01:08:52", "2025-04-07 03:08:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("2761", "942", "acción completa vía WP Cron", "2025-04-07 01:08:52", "2025-04-07 03:08:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("2762", "943", "acción creada", "2025-04-07 01:08:52", "2025-04-07 03:08:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("2763", "941", "acción empezada vía WP Cron", "2025-04-07 06:41:39", "2025-04-07 08:41:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2764", "941", "acción completa vía WP Cron", "2025-04-07 06:41:39", "2025-04-07 08:41:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2765", "944", "acción creada", "2025-04-07 06:41:39", "2025-04-07 08:41:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2766", "943", "acción empezada vía WP Cron", "2025-04-07 13:15:50", "2025-04-07 15:15:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2767", "943", "acción completa vía WP Cron", "2025-04-07 13:15:50", "2025-04-07 15:15:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2768", "945", "acción creada", "2025-04-07 13:15:50", "2025-04-07 15:15:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2769", "945", "acción empezada vía WP Cron", "2025-04-08 01:28:09", "2025-04-08 03:28:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("2770", "945", "acción completa vía WP Cron", "2025-04-08 01:28:09", "2025-04-08 03:28:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("2771", "946", "acción creada", "2025-04-08 01:28:09", "2025-04-08 03:28:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("2772", "944", "acción empezada vía Async Request", "2025-04-08 06:50:34", "2025-04-08 08:50:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2773", "944", "acción completa vía Async Request", "2025-04-08 06:50:34", "2025-04-08 08:50:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2774", "947", "acción creada", "2025-04-08 06:50:34", "2025-04-08 08:50:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2775", "946", "acción empezada vía WP Cron", "2025-04-08 13:33:21", "2025-04-08 15:33:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2776", "946", "acción completa vía WP Cron", "2025-04-08 13:33:21", "2025-04-08 15:33:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2777", "948", "acción creada", "2025-04-08 13:33:21", "2025-04-08 15:33:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2778", "948", "acción empezada vía WP Cron", "2025-04-09 01:44:41", "2025-04-09 03:44:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2779", "948", "acción completa vía WP Cron", "2025-04-09 01:44:41", "2025-04-09 03:44:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2780", "949", "acción creada", "2025-04-09 01:44:41", "2025-04-09 03:44:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2781", "947", "acción empezada vía WP Cron", "2025-04-09 06:54:23", "2025-04-09 08:54:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("2782", "947", "acción completa vía WP Cron", "2025-04-09 06:54:23", "2025-04-09 08:54:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("2783", "950", "acción creada", "2025-04-09 06:54:23", "2025-04-09 08:54:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("2784", "949", "acción empezada vía WP Cron", "2025-04-09 13:47:59", "2025-04-09 15:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2785", "949", "acción completa vía WP Cron", "2025-04-09 13:47:59", "2025-04-09 15:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2786", "951", "acción creada", "2025-04-09 13:47:59", "2025-04-09 15:47:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2787", "951", "acción empezada vía WP Cron", "2025-04-10 01:48:03", "2025-04-10 03:48:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2788", "951", "acción completa vía WP Cron", "2025-04-10 01:48:03", "2025-04-10 03:48:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2789", "952", "acción creada", "2025-04-10 01:48:03", "2025-04-10 03:48:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2790", "950", "acción empezada vía Async Request", "2025-04-10 07:12:26", "2025-04-10 09:12:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2791", "950", "acción completa vía Async Request", "2025-04-10 07:12:26", "2025-04-10 09:12:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2792", "953", "acción creada", "2025-04-10 07:12:26", "2025-04-10 09:12:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2793", "952", "acción empezada vía WP Cron", "2025-04-10 14:08:48", "2025-04-10 16:08:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2794", "952", "acción completa vía WP Cron", "2025-04-10 14:08:49", "2025-04-10 16:08:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("2795", "954", "acción creada", "2025-04-10 14:08:49", "2025-04-10 16:08:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("2796", "954", "acción empezada vía WP Cron", "2025-04-11 03:18:46", "2025-04-11 05:18:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("2797", "954", "acción completa vía WP Cron", "2025-04-11 03:18:47", "2025-04-11 05:18:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2798", "955", "acción creada", "2025-04-11 03:18:47", "2025-04-11 05:18:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2799", "953", "acción empezada vía Async Request", "2025-04-11 07:18:16", "2025-04-11 09:18:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("2800", "953", "acción completa vía Async Request", "2025-04-11 07:18:16", "2025-04-11 09:18:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("2801", "956", "acción creada", "2025-04-11 07:18:16", "2025-04-11 09:18:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("2802", "955", "acción empezada vía WP Cron", "2025-04-11 15:19:20", "2025-04-11 17:19:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2803", "955", "acción completa vía WP Cron", "2025-04-11 15:19:20", "2025-04-11 17:19:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2804", "957", "acción creada", "2025-04-11 15:19:20", "2025-04-11 17:19:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2809", "960", "acción creada", "2025-04-11 21:57:12", "2025-04-11 23:57:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2810", "961", "acción creada", "2025-04-11 21:57:12", "2025-04-11 23:57:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2813", "960", "acción empezada vía Async Request", "2025-04-11 21:57:42", "2025-04-11 23:57:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("2814", "960", "acción completa vía Async Request", "2025-04-11 21:57:43", "2025-04-11 23:57:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("2815", "961", "acción empezada vía Async Request", "2025-04-11 21:57:43", "2025-04-11 23:57:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("2816", "961", "acción completa vía Async Request", "2025-04-11 21:57:43", "2025-04-11 23:57:43");

/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("1", "2", "trx_addons_comment_likes_count", "0");
INSERT INTO `wp_commentmeta` VALUES("2", "3", "trx_addons_comment_likes_count", "0");
INSERT INTO `wp_commentmeta` VALUES("3", "4", "trx_addons_comment_likes_count", "0");
INSERT INTO `wp_commentmeta` VALUES("4", "5", "trx_addons_comment_likes_count", "0");
INSERT INTO `wp_commentmeta` VALUES("5", "6", "trx_addons_comment_likes_count", "0");
INSERT INTO `wp_commentmeta` VALUES("6", "7", "trx_addons_comment_likes_count", "0");
INSERT INTO `wp_commentmeta` VALUES("17", "268", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("18", "268", "trx_addons_comment_likes_count", "0");
INSERT INTO `wp_commentmeta` VALUES("19", "268", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("20", "269", "trx_addons_comment_likes_count", "0");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("2", "126", "Miki Williams", "trex.mikiwilliams@themerex.net", "", "37.25.105.136", "2018-07-24 12:13:36", "2018-07-24 12:13:36", "I am joining this team to support the ecology improving programs!", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("3", "128", "Jhon Miller", "trex.jhonmiller@themerex.net", "", "37.25.105.136", "2018-07-24 12:14:14", "2018-07-24 12:14:14", "The website is awesome. It has everything for having a successful ecological campaign!", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("4", "136", "Martin Moore", "trex.martinmoore@themerex.net", "", "37.25.105.136", "2018-07-24 12:14:56", "2018-07-24 12:14:56", "I would like to thank you for what your team does for our planet! Great job!", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("5", "126", "Jhon Miller", "trex.jhonmiller@themerex.net", "", "37.25.105.136", "2018-07-24 12:21:23", "2018-07-24 12:21:23", "Well done! Good luck with your amazing projects!", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "comment", "2", "0");
INSERT INTO `wp_comments` VALUES("6", "128", "Martin Moore", "trex.martinmoore@themerex.net", "", "37.25.105.136", "2018-07-24 12:21:55", "2018-07-24 12:21:55", "I love how this theme looks great on any device!", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("7", "128", "Alisha Williams", "alisha.williams@bigmir.net", "", "37.25.105.136", "2018-07-24 12:31:05", "2018-07-24 12:31:05", "Thanks for the feedback!", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "comment", "6", "1");
INSERT INTO `wp_comments` VALUES("268", "313", "Christian Spaulding", "christianspaulding@bigmir.net", "", "176.115.100.19", "2020-03-04 16:58:27", "2020-03-04 16:58:27", "Awesome", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36", "review", "0", "1");
INSERT INTO `wp_comments` VALUES("269", "5039", "expertsphp pinterest video downloader", "emmalee_enim@yahoo.com", "https://downloader.run/pinterest-downloader/", "172.236.1.128", "2024-11-02 11:00:47", "2024-11-02 10:00:47", "Your blog is a treasure trove of knowledge! I\'m constantly amazed by the depth of your insights and the clarity of your writing. Keep up the phenomenal work!", "0", "0", "", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20250411_ekoterra", "f969fc7603cdb10d9816_20250411215928", "20", "2025-04-11 22:00:39", "stgesso.com", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-04-11 21:59:28\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.7.2\";s:9:\"VersionDB\";s:8:\"10.11.10\";s:10:\"VersionPHP\";s:6:\"8.1.31\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:17:\"20250411_ekoterra\";s:4:\"Hash\";s:35:\"f969fc7603cdb10d9816_20250411215928\";s:8:\"NameHash\";s:53:\"20250411_ekoterra_f969fc7603cdb10d9816_20250411215928\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:63:\"20250411_ekoterra_f969fc7603cdb10d9816_20250411215928_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.7\";s:6:\"WPUser\";s:11:\"stgesso.com\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:65:\"20250411_ekoterra_f969fc7603cdb10d9816_20250411215928_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:48:\"/home/u631883912/domains/stgesso.com/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:5154;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:30283;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-04-11 21:59:28\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.7.2\";s:9:\"VersionDB\";s:8:\"10.11.10\";s:10:\"VersionPHP\";s:6:\"8.1.31\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:17:\"20250411_ekoterra\";s:4:\"Hash\";s:35:\"f969fc7603cdb10d9816_20250411215928\";s:8:\"NameHash\";s:53:\"20250411_ekoterra_f969fc7603cdb10d9816_20250411215928\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:71:\"20250411_ekoterra_f969fc7603cdb10d9816_20250411215928_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:62:\"/home/u631883912/domains/stgesso.com/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:66:\"20250411_ekoterra_f969fc7603cdb10d9816_20250411215928_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:147:\"/home/u631883912/domains/stgesso.com/public_html/wp-content/backups-dup-lite/tmp/20250411_ekoterra_f969fc7603cdb10d9816_20250411215928_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:57:\"/home/u631883912/domains/stgesso.com/public_html/wp-admin\";i:1;s:60:\"/home/u631883912/domains/stgesso.com/public_html/wp-includes\";i:2;s:69:\"/home/u631883912/domains/stgesso.com/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:48:\"/home/u631883912/domains/stgesso.com/public_html\";i:1;s:48:\"/home/u631883912/domains/stgesso.com/public_html\";i:2;s:59:\"/home/u631883912/domains/stgesso.com/public_html/wp-content\";i:3;s:67:\"/home/u631883912/domains/stgesso.com/public_html/wp-content/uploads\";i:4;s:67:\"/home/u631883912/domains/stgesso.com/public_html/wp-content/plugins\";i:5;s:70:\"/home/u631883912/domains/stgesso.com/public_html/wp-content/mu-plugins\";i:6;s:66:\"/home/u631883912/domains/stgesso.com/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:80:\"/home/u631883912/domains/stgesso.com/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_eg_grids */
INSERT INTO `wp_eg_grids` VALUES("1", "Blog Gallery", "blog_gallery", "{\"source-type\":\"post\",\"post_types\":\"post\",\"post_category\":\"category_18\",\"category-relation\":\"OR\",\"additional-query\":\"\",\"selected_pages\":\"\",\"max_entries\":\"-1\",\"max_entries_preview\":\"20\",\"stream-source-type\":\"instagram\",\"youtube-api\":\"\",\"youtube-channel-id\":\"\",\"youtube-type-source\":\"channel\",\"youtube-playlist\":\"\",\"youtube-playlist-select\":\"\",\"youtube-thumb-size\":\"default\",\"youtube-full-size\":\"default\",\"youtube-count\":\"12\",\"youtube-transient-sec\":\"86400\",\"vimeo-type-source\":\"user\",\"vimeo-username\":\"\",\"vimeo-groupname\":\"\",\"vimeo-albumid\":\"\",\"vimeo-channelname\":\"\",\"vimeo-thumb-size\":\"thumbnail_small\",\"vimeo-count\":\"12\",\"vimeo-transient-sec\":\"86400\",\"instagram-type-source-users\":\"false\",\"instagram-type-source-tags\":\"false\",\"instagram-type-source-places\":\"false\",\"instagram-user-id\":\"\",\"instagram-tags\":\"\",\"instagram-places\":\"\",\"instagram-thumb-size\":\"Low Resolution\",\"instagram-full-size\":\"Standard Resolution\",\"instagram-count\":\"12\",\"instagram-transient-sec\":\"86400\",\"flickr-api-key\":\"\",\"flickr-type\":\"publicphotos\",\"flickr-user-url\":\"\",\"flickr-photoset\":\"\",\"flickr-photoset-select\":\"\",\"flickr-gallery-url\":\"\",\"flickr-group-url\":\"\",\"flickr-thumb-size\":\"Small 320\",\"flickr-full-size\":\"Medium 800\",\"flickr-count\":\"12\",\"flickr-transient-sec\":\"86400\",\"facebook-app-id\":\"\",\"facebook-app-secret\":\"\",\"facebook-page-url\":\"\",\"facebook-type-source\":\"timeline\",\"facebook-album\":\"\",\"facebook-album-select\":\"\",\"facebook-count\":\"12\",\"facebook-transient-sec\":\"86400\",\"twitter-consumer-key\":\"\",\"twitter-consumer-secret\":\"\",\"twitter-access-token\":\"\",\"twitter-access-secret\":\"\",\"twitter-user-id\":\"\",\"twitter-image-only\":\"true\",\"twitter-include-retweets\":\"on\",\"twitter-exclude-replies\":\"on\",\"twitter-count\":\"12\",\"twitter-transient-sec\":\"86400\",\"behance-api\":\"\",\"behance-user-id\":\"\",\"behance-type\":\"projects\",\"behance-project\":\"\",\"behance-project-select\":\"\",\"behance-projects-thumb-size\":\"202\",\"behance-projects-full-size\":\"202\",\"behance-project-thumb-size\":\"max_1240\",\"behance-project-full-size\":\"max1240\",\"behance-count\":\"12\",\"behance-transient-sec\":\"86400\",\"dribbble-api\":\"\",\"media-source-order\":[\"featured-image\"],\"poster-source-order\":[\"featured-image\"],\"image-source-type\":\"full\",\"image-source-type-mobile\":\"full\",\"default-image\":\"0\",\"youtube-default-image\":\"0\",\"vimeo-default-image\":\"0\",\"html-default-image\":\"0\"}", "{\"layout-sizing\":\"boxed\",\"fullscreen-offset-container\":\"\",\"layout\":\"masonry\",\"content-push\":\"off\",\"x-ratio\":\"4\",\"y-ratio\":\"3\",\"auto-ratio\":\"true\",\"rtl\":\"off\",\"use-cobbles-pattern\":\"off\",\"columns-advanced\":\"off\",\"columns-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns-width\":[1900,\"1\",\"1\",\"1\",\"9\",\"7\",\"6\",\"4\"],\"mascontent-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns\":[\"3\",\"3\",\"3\",\"3\",\"3\",\"3\",\"3\",\"1\"],\"rows-unlimited\":\"on\",\"rows\":\"4\",\"pagination-autoplay\":\"off\",\"pagination-autoplay-speed\":\"5000\",\"load-more\":\"button\",\"load-more-hide\":\"off\",\"load-more-text\":\"More Posts\",\"load-more-show-number\":\"on\",\"load-more-start\":\"12\",\"load-more-amount\":\"3\",\"lazy-loading\":\"off\",\"lazy-loading-blur\":\"on\",\"lazy-load-color\":\"#FFFFFF\",\"spacings\":\"30\",\"grid-padding\":[\"0\",\"0\",\"0\",\"0\"],\"main-background-color\":\"transparent\",\"navigation-skin\":\"minimal-light\",\"entry-skin\":\"1\",\"grid-animation\":\"fade\",\"grid-animation-speed\":\"1000\",\"grid-animation-delay\":\"1\",\"grid-item-animation\":\"none\",\"grid-item-animation-zoomin\":\"125\",\"grid-item-animation-zoomout\":\"75\",\"grid-item-animation-fade\":\"75\",\"grid-item-animation-blur\":\"5\",\"grid-item-animation-rotate\":\"30\",\"grid-item-animation-shift\":\"up\",\"grid-item-animation-shift-amount\":\"10\",\"grid-item-animation-other\":\"none\",\"grid-item-other-zoomin\":\"125\",\"grid-item-other-zoomout\":\"75\",\"grid-item-other-fade\":\"75\",\"grid-item-other-blur\":\"5\",\"grid-item-other-rotate\":\"30\",\"grid-item-other-shift\":\"up\",\"grid-item-other-shift-amount\":\"10\",\"hover-animation-delay\":\"1\",\"top-1-align\":\"center\",\"top-1-margin-bottom\":\"0\",\"top-2-align\":\"center\",\"top-2-margin-bottom\":\"0\",\"bottom-1-align\":\"center\",\"bottom-1-margin-top\":\"0\",\"bottom-2-align\":\"center\",\"bottom-2-margin-top\":\"0\",\"left-margin-left\":\"0\",\"right-margin-right\":\"0\",\"module-spacings\":\"5\",\"pagination-numbers\":\"smart\",\"pagination-scroll\":\"off\",\"pagination-scroll-offset\":\"0\",\"filter-arrows\":\"single\",\"filter-logic\":\"or\",\"filter-start\":\"\",\"filter-deep-link\":\"off\",\"filter-show-on\":\"hover\",\"filter-all-text\":\"Filter - All\",\"filter-listing\":\"list\",\"filter-dropdown-text\":\"Filter Categories\",\"filter-counter\":\"off\",\"filter-selected\":[\"category_18\"],\"sort-by-text\":\"Sort By \",\"sorting-order-by\":\"date\",\"sorting-order-by-start\":\"none\",\"sorting-order-by-start-meta\":\"\",\"sorting-order-type\":\"ASC\",\"search-text\":\"Search...\",\"lb-source-order\":[\"featured-image\"],\"lightbox-mode\":\"single\",\"lightbox-exclude-media\":\"off\",\"lightbox-deep-link\":\"group\",\"lightbox-title\":\"off\",\"lbox-padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-effect-open-close\":\"fade\",\"lightbox-effect-open-close-speed\":\"500\",\"lightbox-effect-next-prev\":\"fade\",\"lightbox-effect-next-prev-speed\":\"500\",\"lightbox-autoplay\":\"off\",\"lbox-playspeed\":\"3000\",\"lightbox-arrows\":\"on\",\"lightbox-loop\":\"on\",\"lightbox-numbers\":\"on\",\"lightbox-mousewheel\":\"off\",\"lb-button-order\":[\"share\",\"thumbs\",\"close\"],\"lightbox-post-content-min-width\":\"75\",\"lightbox-post-content-min-perc\":\"on\",\"lightbox-post-content-max-width\":\"75\",\"lightbox-post-content-max-perc\":\"on\",\"lightbox-post-content-overflow\":\"on\",\"lbox-content_padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-spinner\":\"off\",\"lightbox-post-content-img\":\"off\",\"lightbox-post-content-img-position\":\"top\",\"lightbox-post-content-img-width\":\"50\",\"lightbox-post-content-img-margin\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-content-title\":\"off\",\"lightbox-post-content-title-tag\":\"h2\",\"aj-source-order\":[\"post-content\"],\"ajax-container-id\":\"ess-grid-ajax-container-\",\"ajax-container-position\":\"top\",\"ajax-scroll-onload\":\"on\",\"ajax-scrollto-offset\":\"0\",\"ajax-close-button\":\"off\",\"ajax-button-text\":\"Close\",\"ajax-nav-button\":\"off\",\"ajax-button-skin\":\"light\",\"ajax-button-type\":\"type1\",\"ajax-button-inner\":\"false\",\"ajax-button-h-pos\":\"r\",\"ajax-button-v-pos\":\"t\",\"0\":\"\",\"ajax-container-pre\":\"\",\"ajax-container-post\":\"\",\"ajax-container-css\":\"\",\"ajax-callback\":\"\",\"ajax-callback-arg\":\"true\",\"ajax-css-url\":\"\",\"ajax-js-url\":\"\",\"use-spinner\":\"0\",\"spinner-color\":\"#FFFFFF\",\"hide-markup-before-load\":\"off\",\"custom-javascript\":\"\",\"cookie-save-time\":\"30\",\"cookie-save-search\":\"off\",\"cookie-save-filter\":\"off\",\"cookie-save-pagination\":\"off\",\"css-id\":\"\"}", "[]", NULL, "2024-06-05 03:20:32");

/* INSERT TABLE DATA: wp_eg_item_skins */
INSERT INTO `wp_eg_item_skins` VALUES("1", "Washington", "washington", "{\"eg-item-skin-element-last-id\":\"9\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.65)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#3f424a\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css\":\"\",\"css-hover\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":1,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"20\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"css\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css-hover\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"3\",\"order\":4,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"8\",\"order\":2,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":5,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("2", "Adams", "adams", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(137,175,114,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"transparent\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"10\",\"cover-animation-center\":\"flipleft\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"turnout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css\":\".eg-adams-element-0{}\",\"css-hover\":\".eg-adams-element-0{}\",\"transition-type\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":1,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"20\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"3\",\"order\":4,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"css\":\".eg-adams-element-3{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-adams-element-3{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"5\",\"order\":7,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-adams-element-5{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-adams-element-5{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"words\",\"limit-num\":\"6\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":2,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"8\",\"order\":5,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("3", "Jefferson", "jefferson", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(227,58,12,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fliphorizontal\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"fliphorizontalout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"46\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":1,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"50\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"3\",\"order\":3,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"17\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"60\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"5\",\"order\":6,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"1\",\"5\",\"1\",\"5\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"3\",\"3\",\"3\",\"3\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"3\",\"3\",\"3\",\"3\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"70\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\"   \",\"limit-type\":\"words\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":2,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"8\",\"order\":4,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("4", "Madison", "madison", "{\"eg-item-skin-element-last-id\":\"7\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(88,92,103,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#585c67\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"flipvertical\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"flipverticalout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"19\",\"19\",\"19\",\"19\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"50\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":1,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"19\",\"19\",\"19\",\"19\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"35\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"3\",\"order\":4,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"35\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"5\",\"order\":7,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"45\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"words\",\"limit-num\":\"6\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"6\",\"order\":2,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":5,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("5", "ESGBlankSkin", "esgblankskin", "{\"eg-item-skin-element-last-id\":\"0\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"splitted-item\":\"none\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0, 0, 0, 0)\",\"cover-always-visible-desktop\":\"false\",\"cover-always-visible-mobile\":\"false\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"rgba(255, 255, 255, 0)\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"rgba(255, 255, 255, 0)\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"none\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"element-hover-image\":\"false\",\"hover-image-animation\":\"fade\",\"hover-image-animation-delay\":\"0\",\"link-set-to\":\"none\",\"link-link-type\":\"none\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("6", "Adams-032032", "adams-032032", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(137,175,114,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"transparent\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"10\",\"cover-animation-center\":\"flipleft\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"turnout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css\":\".eg-adams-element-0{}\",\"css-hover\":\".eg-adams-element-0{}\",\"transition-type\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"20\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"css\":\".eg-adams-element-3{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-adams-element-3{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"7\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-adams-element-5{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-adams-element-5{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"words\",\"limit-num\":\"6\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"8\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("7", "Adams-195032", "adams-195032", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(137,175,114,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"transparent\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"10\",\"cover-animation-center\":\"flipleft\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"turnout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css\":\".eg-adams-element-0{}\",\"css-hover\":\".eg-adams-element-0{}\",\"transition-type\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"20\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"css\":\".eg-adams-element-3{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-adams-element-3{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"7\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-adams-element-5{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-adams-element-5{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"words\",\"limit-num\":\"6\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"8\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("8", "Arthur", "arthur", "{\"eg-item-skin-element-last-id\":\"31\",\"choose-layout\":\"masonry\",\"show-content\":\"top\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(137,175,114,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"1\",\"1\",\"1\",\"1\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#f5f5f5\",\"content-padding\":[\"30\",\"30\",\"25\",\"30\"],\"content-border\":[\"0\",\"0\",\"1\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"-1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"22\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"20\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"28\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"4\",\"10\"],\"background-color\":\"rgba(0,0,0,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-woocommerce\":\"wc_add_to_cart_button\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"25\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"woocommerce\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"2\",\"7\",\"1\",\"7\"],\"background-color\":\"rgba(227,58,12,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"source-woocommerce\":\"wc_full_price\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"26\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#aaaaaa\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-woocommerce\":\"wc_categories\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"31\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"30\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"source-woocommerce\":\"wc_star_rating\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("9", "Arthur-195032", "arthur-195032", "{\"eg-item-skin-element-last-id\":\"31\",\"choose-layout\":\"masonry\",\"show-content\":\"top\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(137,175,114,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"1\",\"1\",\"1\",\"1\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#f5f5f5\",\"content-padding\":[\"30\",\"30\",\"25\",\"30\"],\"content-border\":[\"0\",\"0\",\"1\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"-1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"22\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"20\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"28\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"4\",\"10\"],\"background-color\":\"rgba(0,0,0,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-woocommerce\":\"wc_add_to_cart_button\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"25\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"woocommerce\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"2\",\"7\",\"1\",\"7\"],\"background-color\":\"rgba(227,58,12,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"source-woocommerce\":\"wc_full_price\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"26\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#aaaaaa\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-woocommerce\":\"wc_categories\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"31\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"30\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"source-woocommerce\":\"wc_star_rating\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("10", "Buchanan", "buchanan", "{\"eg-item-skin-element-last-id\":\"6\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"slidedown\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollright\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"21\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"40\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"excerpt\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("11", "Buchanan-195032", "buchanan-195032", "{\"eg-item-skin-element-last-id\":\"6\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"slidedown\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollright\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"21\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"40\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"excerpt\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("12", "Cleveland", "cleveland", "{\"eg-item-skin-element-last-id\":\"22\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#333333\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#333333\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-cleveland-element-0{}\",\"font-size-hover\":\"20\",\"line-height-hover\":\"25\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-cleveland-element-0{}\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"right\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(0,0,0,0.25)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link-ext\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(0,0,0,0.25)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"READ MORE\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"16\",\"color\":\"#aaaaaa\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#555555\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"16\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#555555\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-post\":\"date\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"16\",\"color\":\"#aaaaaa\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"16\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},\"\",{\"id\":\"6\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#eeeeee\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"words\",\"limit-num\":\"15\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"22\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("13", "Cleveland-195032", "cleveland-195032", "{\"eg-item-skin-element-last-id\":\"22\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#333333\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#333333\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-cleveland-element-0{}\",\"font-size-hover\":\"20\",\"line-height-hover\":\"25\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-cleveland-element-0{}\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"right\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(0,0,0,0.25)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link-ext\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(0,0,0,0.25)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"READ MORE\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"16\",\"color\":\"#aaaaaa\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#555555\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"16\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#555555\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-post\":\"date\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"16\",\"color\":\"#aaaaaa\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"16\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},\"\",{\"id\":\"6\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#eeeeee\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"words\",\"limit-num\":\"15\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"22\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("14", "Coolidge", "coolidge", "{\"eg-item-skin-element-last-id\":\"19\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"1\",\"1\",\"1\",\"1\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.15)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Droid+Serif:400,700\",\"Open+Sans:400,600,700,800\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"33\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\",\"font-weight\":\"600\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-text\":\"<i class=\\\"eg-icon-tools\\\"><\\/i>\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"19\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-post\":\"title\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-text\":\"LINE-BREAK\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#000000\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"4\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"5\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"40\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"6\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"7\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"14\",\"color\":\"#40dc8d\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"20\",\"0\",\"0\",\"-15\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#363839\",\"font-family-hover\":\"\",\"font-weight-hover\":\"600\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-text\":\"<i class=\\\"eg-icon-angle-right\\\"><\\/i> Learn More\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("15", "Coolidge-195032", "coolidge-195032", "{\"eg-item-skin-element-last-id\":\"19\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"1\",\"1\",\"1\",\"1\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.15)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Droid+Serif:400,700\",\"Open+Sans:400,600,700,800\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"33\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\",\"font-weight\":\"600\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-text\":\"<i class=\\\"eg-icon-tools\\\"><\\/i>\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"19\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-post\":\"title\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-text\":\"LINE-BREAK\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#000000\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"4\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"5\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"40\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"6\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"7\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"14\",\"color\":\"#40dc8d\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"20\",\"0\",\"0\",\"-15\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#363839\",\"font-family-hover\":\"\",\"font-weight-hover\":\"600\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-text\":\"<i class=\\\"eg-icon-angle-right\\\"><\\/i> Learn More\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("16", "Eisenhower", "eisenhower", "{\"eg-item-skin-element-last-id\":\"24\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"20\",\"20\",\"20\",\"20\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"5\",\"5\",\"5\",\"5\"],\"full-border-color\":\"#606060\",\"full-border-style\":\"solid\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"0\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.15)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Droid+Serif:400,700\",\"Open+Sans:400,600,700,800\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"19\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-post\":\"title\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"15\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.85)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-text\":\"LINE-BREAK\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.85)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"%\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"18\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-icon\":\"eg-icon-forward\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#40dc8d\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"5\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"6\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"5\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("17", "Eisenhower-195032", "eisenhower-195032", "{\"eg-item-skin-element-last-id\":\"24\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"20\",\"20\",\"20\",\"20\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"5\",\"5\",\"5\",\"5\"],\"full-border-color\":\"#606060\",\"full-border-style\":\"solid\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"0\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.15)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Droid+Serif:400,700\",\"Open+Sans:400,600,700,800\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"19\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-post\":\"title\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"15\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.85)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-text\":\"LINE-BREAK\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.85)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"%\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"18\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-icon\":\"eg-icon-forward\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#40dc8d\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"5\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"6\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"5\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("18", "ESGBlankSkin-032032", "esgblankskin-032032", "{\"eg-item-skin-element-last-id\":\"0\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"splitted-item\":\"none\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0, 0, 0, 0)\",\"cover-always-visible-desktop\":\"false\",\"cover-always-visible-mobile\":\"false\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"rgba(255, 255, 255, 0)\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"rgba(255, 255, 255, 0)\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"none\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"element-hover-image\":\"false\",\"hover-image-animation\":\"fade\",\"hover-image-animation-delay\":\"0\",\"link-set-to\":\"none\",\"link-link-type\":\"none\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("19", "Essential Preview", "essential-preview", "{\"eg-item-skin-element-last-id\":\"9\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(10,10,10,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#000000\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"out\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"none\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"out\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"none\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Open+Sans:700;800\"]}", "[{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"24\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"4\",\"12\",\"3\",\"12\"],\"background-color\":\"rgba(255,255,255,0.10)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"transparent\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.20)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"0\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"24\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"3\",\"10\",\"2\",\"10\"],\"background-color\":\"rgba(227,58,12,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"transparent\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#617f52\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"24\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,77,28,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"transparent\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#617f52\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"0\",\"link-type\":\"meta\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-text\":\"Check it Out\",\"link-type-meta\":\"eg-demogrid-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("20", "Essential Preview-195032", "essential-preview-195032", "{\"eg-item-skin-element-last-id\":\"9\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(10,10,10,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#000000\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"out\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"none\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"out\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"none\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Open+Sans:700;800\"]}", "[{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"24\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"4\",\"12\",\"3\",\"12\"],\"background-color\":\"rgba(255,255,255,0.10)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"transparent\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.20)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"0\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"24\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"3\",\"10\",\"2\",\"10\"],\"background-color\":\"rgba(227,58,12,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"transparent\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#617f52\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"24\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,77,28,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"transparent\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#617f52\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"0\",\"link-type\":\"meta\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-text\":\"Check it Out\",\"link-type-meta\":\"eg-demogrid-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("21", "FacebookStream", "facebookstream", "{\"eg-item-skin-element-last-id\":\"33\",\"choose-layout\":\"masonry\",\"show-content\":\"top\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,88,153,0.65)\",\"0\":\"Default\",\"cover-always-visible-desktop\":\"\",\"cover-always-visible-mobile\":\"\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"26\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"10\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"link-set-to\":\"none\",\"link-link-type\":\"none\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"14\",\"line-height\":\"22\",\"color\":\"#363839\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"20\",\"line-height-hover\":\"25\",\"color-hover\":\"#13c0df\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_blank\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"\",\"source-post\":\"title\"}},{\"id\":\"25\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"3\",\"10\"],\"background-color\":\"rgba(0,0,0,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"true\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"\",\"source-text\":\"SHOW IMAGE\"}},{\"id\":\"28\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"5\"],\"padding\":[\"5\",\"10\",\"3\",\"10\"],\"background-color\":\"rgba(0,0,0,0.15)\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"true\",\"source-text\":\"PLAY VIDEO\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"14\",\"line-height\":\"22\",\"color\":\"#365899\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"10\",\"15\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"14\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e5e5e5\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"show-on-lightbox-video\":\"\",\"source-text\":\"<i class=\\\"eg-icon-thumbs-up-alt\\\" style=\\\"background:#365899;color:#fff;float:left;width:23px;height:23px;font-size:12px;text-align:center;border-radius:14px;margin-right:5px;\\\"><\\/i> %likes_short%\"}},{\"id\":\"33\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\", \",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"14\",\"line-height\":\"22\",\"color\":\"#90949c\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"14\",\"line-height-hover\":\"22\",\"color-hover\":\"#7f7f7f\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"900\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"skewleft\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"show-on-lightbox-video\":\"\",\"source-text\":\"<i class=\\\"eg-icon-calendar-empty\\\" style=\\\"background:#90949c;color:#fff;float:left;width:23px;height:23px;font-size:12px;text-align:center;border-radius:14px;margin-right:5px;\\\"><\\/i> %date%\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("22", "FacebookStream-195032", "facebookstream-195032", "{\"eg-item-skin-element-last-id\":\"33\",\"choose-layout\":\"masonry\",\"show-content\":\"top\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,88,153,0.65)\",\"0\":\"Default\",\"cover-always-visible-desktop\":\"\",\"cover-always-visible-mobile\":\"\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"26\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"10\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"link-set-to\":\"none\",\"link-link-type\":\"none\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"14\",\"line-height\":\"22\",\"color\":\"#363839\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"20\",\"line-height-hover\":\"25\",\"color-hover\":\"#13c0df\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_blank\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"\",\"source-post\":\"title\"}},{\"id\":\"25\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"3\",\"10\"],\"background-color\":\"rgba(0,0,0,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"true\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"\",\"source-text\":\"SHOW IMAGE\"}},{\"id\":\"28\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"5\"],\"padding\":[\"5\",\"10\",\"3\",\"10\"],\"background-color\":\"rgba(0,0,0,0.15)\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"true\",\"source-text\":\"PLAY VIDEO\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"14\",\"line-height\":\"22\",\"color\":\"#365899\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"10\",\"15\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"14\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e5e5e5\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"show-on-lightbox-video\":\"\",\"source-text\":\"<i class=\\\"eg-icon-thumbs-up-alt\\\" style=\\\"background:#365899;color:#fff;float:left;width:23px;height:23px;font-size:12px;text-align:center;border-radius:14px;margin-right:5px;\\\"><\\/i> %likes_short%\"}},{\"id\":\"33\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\", \",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"14\",\"line-height\":\"22\",\"color\":\"#90949c\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"14\",\"line-height-hover\":\"22\",\"color-hover\":\"#7f7f7f\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"900\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"skewleft\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"show-on-lightbox-video\":\"\",\"source-text\":\"<i class=\\\"eg-icon-calendar-empty\\\" style=\\\"background:#90949c;color:#fff;float:left;width:23px;height:23px;font-size:12px;text-align:center;border-radius:14px;margin-right:5px;\\\"><\\/i> %date%\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("23", "Fillmore", "fillmore", "{\"eg-item-skin-element-last-id\":\"7\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#363839\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-fillmore-element-0{cursor:pointer}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-fillmore-element-0{cursor:pointer}\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"13\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"transition-type\":\"out\",\"tag-type\":\"div\",\"align\":\"c_c\",\"margin-unit\":\"px\",\"source-post\":\"date\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#363839\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-fillmore-element-1{ cursor:pointer}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-fillmore-element-1{cursor:pointer}\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-icon\":\"eg-icon-unlink\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"4\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"excerpt\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("24", "Fillmore-195032", "fillmore-195032", "{\"eg-item-skin-element-last-id\":\"7\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#363839\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-fillmore-element-0{cursor:pointer}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-fillmore-element-0{cursor:pointer}\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"13\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"transition-type\":\"out\",\"tag-type\":\"div\",\"align\":\"c_c\",\"margin-unit\":\"px\",\"source-post\":\"date\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#363839\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-fillmore-element-1{ cursor:pointer}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-fillmore-element-1{cursor:pointer}\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-icon\":\"eg-icon-unlink\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"4\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"excerpt\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("25", "FlickrStream", "flickrstream", "{\"eg-item-skin-element-last-id\":\"19\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.50)\",\"0\":\"Default\",\"cover-always-visible-desktop\":\"\",\"cover-always-visible-mobile\":\"\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#222222\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#222222\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"link-set-to\":\"cover\",\"link-link-type\":\"lightbox\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"right\",\"clear\":\"none\",\"margin\":[\"0\",\"15\",\"10\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"css\":\"\",\"css-hover\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_blank\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"\",\"source-icon\":\"eg-icon-link\"}},\"\",{\"id\":\"15\",\"order\":\"1\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"15\",\"20\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"source-post\":\"title\"}},\"\",{\"id\":\"17\",\"order\":\"2\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"15\",\"20\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"show-on-lightbox-video\":\"\",\"source-text\":\"<i class=\\\"eg-icon-star-empty\\\"><\\/i> %favorites%\"}},{\"id\":\"19\",\"order\":\"3\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-function\":\"link\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"source-text-style-disable\":\"\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"rgba(255,255,255,0.5)\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"15\",\"20\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"link-target\":\"_self\",\"tag-type\":\"div\",\"force-important\":\"true\",\"facebook-sharing-link\":\"site\",\"facebook-link-url\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"show-on-lightbox-video\":\"\",\"source-text\":\"by %author_name%\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("26", "FlickrStream-195032", "flickrstream-195032", "{\"eg-item-skin-element-last-id\":\"19\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.50)\",\"0\":\"Default\",\"cover-always-visible-desktop\":\"\",\"cover-always-visible-mobile\":\"\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#222222\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#222222\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"link-set-to\":\"cover\",\"link-link-type\":\"lightbox\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"right\",\"clear\":\"none\",\"margin\":[\"0\",\"15\",\"10\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"css\":\"\",\"css-hover\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_blank\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"\",\"source-icon\":\"eg-icon-link\"}},\"\",{\"id\":\"15\",\"order\":\"1\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"15\",\"20\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"source-post\":\"title\"}},\"\",{\"id\":\"17\",\"order\":\"2\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"15\",\"20\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"show-on-lightbox-video\":\"\",\"source-text\":\"<i class=\\\"eg-icon-star-empty\\\"><\\/i> %favorites%\"}},{\"id\":\"19\",\"order\":\"3\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-function\":\"link\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"source-text-style-disable\":\"\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"rgba(255,255,255,0.5)\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"15\",\"20\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"link-target\":\"_self\",\"tag-type\":\"div\",\"force-important\":\"true\",\"facebook-sharing-link\":\"site\",\"facebook-link-url\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"show-on-lightbox-video\":\"\",\"source-text\":\"by %author_name%\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("27", "Garfield", "garfield", "{\"eg-item-skin-element-last-id\":\"22\",\"choose-layout\":\"masonry\",\"show-content\":\"top\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"transparent\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"-1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"right\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(0,0,0,0.25)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link-ext\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(0,0,0,0.25)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"READ MORE\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"16\",\"color\":\"#777777\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"16\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e5e5e5\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"date\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"16\",\"color\":\"#777\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"10\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"16\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"22\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"6\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#333333\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"words\",\"limit-num\":\"15\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("28", "Garfield-195032", "garfield-195032", "{\"eg-item-skin-element-last-id\":\"22\",\"choose-layout\":\"masonry\",\"show-content\":\"top\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"transparent\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"-1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"right\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(0,0,0,0.25)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link-ext\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(0,0,0,0.25)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"READ MORE\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"16\",\"color\":\"#777777\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"16\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e5e5e5\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"date\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"16\",\"color\":\"#777\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"10\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"16\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"22\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"6\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#333333\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"words\",\"limit-num\":\"15\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("29", "GeorgeBush", "georgebush", "{\"eg-item-skin-element-last-id\":\"4\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"content\",\"container-background-color\":\"rgba(227,58,12,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"covergrowup\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Raleway:400,800,900\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"none\",\"limit-num\":\"3\",\"enable-hover\":\"\",\"font-size\":\"35\",\"line-height\":\"38\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"0\",\"20\"],\"padding\":[\"0\",\"20\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"margin-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"words\",\"limit-num\":\"8\",\"enable-hover\":\"\",\"font-size\":\"18\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"20\",\"20\"],\"padding\":[\"0\",\"20\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"margin-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("30", "GeorgeBush-195032", "georgebush-195032", "{\"eg-item-skin-element-last-id\":\"4\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"content\",\"container-background-color\":\"rgba(227,58,12,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"covergrowup\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Raleway:400,800,900\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"none\",\"limit-num\":\"3\",\"enable-hover\":\"\",\"font-size\":\"35\",\"line-height\":\"38\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"0\",\"20\"],\"padding\":[\"0\",\"20\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"margin-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"words\",\"limit-num\":\"8\",\"enable-hover\":\"\",\"font-size\":\"18\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"20\",\"20\"],\"padding\":[\"0\",\"20\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"margin-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("31", "Gerald Ford", "gerald-ford", "{\"eg-item-skin-element-last-id\":\"15\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(255,255,255,0.25)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#f5f5f5\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"1\",\"1\",\"1\",\"1\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#f5f5f5\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"1\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"30\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"PREMIUM PRODUCT\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"14\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"5\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.65)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"22\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"The best for your small business\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"15\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.65)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"%\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"20\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-basket\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"11\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"50\",\"line-height\":\"50\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"20\",\"20\",\"0\",\"20\"],\"background-color\":\"rgba(238,238,238,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"<span style=\\\"font-size:30px; font-weight:300;\\\">$<\\/span> 39.99\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"12\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"15\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"20\",\"20\",\"20\"],\"background-color\":\"rgba(238,238,238,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"INCL. SHIPPING\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"5\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"4GB Webspace Included\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"6\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"2 Domains\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"PHP5 Enabled\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"8\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"20\",\"20\",\"20\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"1\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"24h Support\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":\"8\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"top\":\"0\",\"top-unit-hover\":\"px\",\"right\":\"0\",\"right-unit-hover\":\"px\",\"bottom\":\"0\",\"bottom-unit-hover\":\"px\",\"left\":\"0\",\"left-unit-hover\":\"px\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"20\",\"0\"],\"padding\":[\"8\",\"25\",\"8\",\"25\"],\"background-color\":\"rgba(227,58,12,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"hideunder\":\"0\",\"transition\":\"skewright\",\"transition-type\":\"\",\"delay\":\"34\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"BUY NOW\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"13\",\"order\":\"9\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("32", "Gerald Ford-195032", "gerald-ford-195032", "{\"eg-item-skin-element-last-id\":\"15\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(255,255,255,0.25)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#f5f5f5\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"1\",\"1\",\"1\",\"1\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#f5f5f5\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"1\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"30\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"PREMIUM PRODUCT\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"14\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"5\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.65)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"22\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"The best for your small business\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"15\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.65)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"%\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"20\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-basket\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"11\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"50\",\"line-height\":\"50\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"20\",\"20\",\"0\",\"20\"],\"background-color\":\"rgba(238,238,238,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"<span style=\\\"font-size:30px; font-weight:300;\\\">$<\\/span> 39.99\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"12\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"15\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"20\",\"20\",\"20\"],\"background-color\":\"rgba(238,238,238,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"INCL. SHIPPING\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"5\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"4GB Webspace Included\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"6\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"2 Domains\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"PHP5 Enabled\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"8\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"20\",\"20\",\"20\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"1\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"24h Support\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":\"8\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"top\":\"0\",\"top-unit-hover\":\"px\",\"right\":\"0\",\"right-unit-hover\":\"px\",\"bottom\":\"0\",\"bottom-unit-hover\":\"px\",\"left\":\"0\",\"left-unit-hover\":\"px\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"20\",\"0\"],\"padding\":[\"8\",\"25\",\"8\",\"25\"],\"background-color\":\"rgba(227,58,12,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"hideunder\":\"0\",\"transition\":\"skewright\",\"transition-type\":\"\",\"delay\":\"34\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"BUY NOW\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"13\",\"order\":\"9\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("33", "Grant", "grant", "{\"eg-item-skin-element-last-id\":\"22\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\",\"font-weight\":\"600\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-grant-element-0{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-grant-element-0{}\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"right\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(0,0,0,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.40)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link-ext\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"600\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(0,0,0,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-text\":\"READ MORE\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"date\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",\"\",{\"id\":\"6\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#777777\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-post\":\"excerpt\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"22\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("34", "Grant-195032", "grant-195032", "{\"eg-item-skin-element-last-id\":\"22\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\",\"font-weight\":\"600\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-grant-element-0{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-grant-element-0{}\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"right\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(0,0,0,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.40)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link-ext\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"600\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(0,0,0,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-text\":\"READ MORE\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"date\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",\"\",{\"id\":\"6\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#777777\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-post\":\"excerpt\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"22\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("35", "Harding", "harding", "{\"eg-item-skin-element-last-id\":\"17\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"transparent\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Droid+Serif:400,700\",\"Open+Sans:400,600,700,800\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"25\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"40\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-post\":\"title\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"1\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#444444\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"500\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#363839\",\"font-family-hover\":\"\",\"font-weight-hover\":\"600\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-text\":\"Frontend Developer\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"2\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"3\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#000000\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"4\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"5\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"50\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"6\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("36", "Harding-195032", "harding-195032", "{\"eg-item-skin-element-last-id\":\"17\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"transparent\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Droid+Serif:400,700\",\"Open+Sans:400,600,700,800\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"25\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"40\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-post\":\"title\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"1\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#444444\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"500\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#363839\",\"font-family-hover\":\"\",\"font-weight-hover\":\"600\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-text\":\"Frontend Developer\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"2\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"3\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#000000\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"4\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"5\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"50\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"6\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("37", "Harrison", "harrison", "{\"eg-item-skin-element-last-id\":\"24\",\"choose-layout\":\"masonry\",\"show-content\":\"top\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#363839\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"-1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"500\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-post\":\"date\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"10\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("38", "Harrison-195032", "harrison-195032", "{\"eg-item-skin-element-last-id\":\"24\",\"choose-layout\":\"masonry\",\"show-content\":\"top\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#363839\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"-1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"500\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-post\":\"date\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"10\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("39", "Hayes", "hayes", "{\"eg-item-skin-element-last-id\":\"23\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\",\"font-weight\":\"600\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"date\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"10\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("40", "Hayes-195032", "hayes-195032", "{\"eg-item-skin-element-last-id\":\"23\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\",\"font-weight\":\"600\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"date\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"10\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("41", "HenryHarrison", "henryharrison", "{\"eg-item-skin-element-last-id\":\"5\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(49,165,203,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"30\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"10\",\"0\"],\"padding\":[\"0\",\"20\",\"0\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"transparent\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"5\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"2\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"20\",\"line-height\":\"27\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"0\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"20\",\"line-height-hover\":\"27\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"normal\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"0\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rotatescale\",\"delay\":\"5\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-plus\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("42", "HenryHarrison-195032", "henryharrison-195032", "{\"eg-item-skin-element-last-id\":\"5\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(49,165,203,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"30\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"10\",\"0\"],\"padding\":[\"0\",\"20\",\"0\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"transparent\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"5\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"2\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"20\",\"line-height\":\"27\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"0\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"20\",\"line-height-hover\":\"27\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"normal\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"0\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rotatescale\",\"delay\":\"5\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-plus\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("43", "Herbert Hoover", "herbert-hoover", "{\"eg-item-skin-element-last-id\":\"25\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"1\",\"1\",\"1\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"transparent\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"25\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"hide-on-video\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"24\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.50)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.75)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"%\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"true\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#444444\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#aaaaaa\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\", \",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"25\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"5\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.50)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.75)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"embedded_video\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-play\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"10\",\"order\":\"10\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-num\":\"10\",\"limit-type\":\"none\",\"enable-hover\":\"on\",\"font-size\":\"22\",\"line-height\":\"7\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"25\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"22\",\"line-height-hover\":\"7\",\"color-hover\":\"#c32524\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-pinterest\",\"link-type-url\":\"#\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"4\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#000000\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"5\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"6\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"15\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"7\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"8\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-num\":\"10\",\"limit-type\":\"none\",\"enable-hover\":\"on\",\"font-size\":\"22\",\"line-height\":\"7\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"25\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"22\",\"line-height-hover\":\"7\",\"color-hover\":\"#4672b3\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-facebook-1\",\"link-type-url\":\"#\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":\"8\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-num\":\"10\",\"limit-type\":\"none\",\"enable-hover\":\"on\",\"font-size\":\"22\",\"line-height\":\"7\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"25\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"22\",\"line-height-hover\":\"7\",\"color-hover\":\"#099bcc\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-twitter-1\",\"link-type-url\":\"#\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"9\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-num\":\"10\",\"limit-type\":\"none\",\"enable-hover\":\"on\",\"font-size\":\"22\",\"line-height\":\"7\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"25\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"22\",\"line-height-hover\":\"7\",\"color-hover\":\"#da4a38\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-gplus-1\",\"link-type-url\":\"#\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("44", "Herbert Hoover-195032", "herbert-hoover-195032", "{\"eg-item-skin-element-last-id\":\"25\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"1\",\"1\",\"1\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"transparent\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"25\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"hide-on-video\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"24\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.50)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.75)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"%\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"true\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#444444\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#aaaaaa\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\", \",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"25\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"5\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.50)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.75)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"embedded_video\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-play\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"10\",\"order\":\"10\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-num\":\"10\",\"limit-type\":\"none\",\"enable-hover\":\"on\",\"font-size\":\"22\",\"line-height\":\"7\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"25\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"22\",\"line-height-hover\":\"7\",\"color-hover\":\"#c32524\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-pinterest\",\"link-type-url\":\"#\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"4\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#000000\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"5\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"6\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"15\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"7\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"8\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-num\":\"10\",\"limit-type\":\"none\",\"enable-hover\":\"on\",\"font-size\":\"22\",\"line-height\":\"7\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"25\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"22\",\"line-height-hover\":\"7\",\"color-hover\":\"#4672b3\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-facebook-1\",\"link-type-url\":\"#\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":\"8\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-num\":\"10\",\"limit-type\":\"none\",\"enable-hover\":\"on\",\"font-size\":\"22\",\"line-height\":\"7\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"25\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"22\",\"line-height-hover\":\"7\",\"color-hover\":\"#099bcc\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-twitter-1\",\"link-type-url\":\"#\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"9\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-num\":\"10\",\"limit-type\":\"none\",\"enable-hover\":\"on\",\"font-size\":\"22\",\"line-height\":\"7\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"25\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"22\",\"line-height-hover\":\"7\",\"color-hover\":\"#da4a38\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-gplus-1\",\"link-type-url\":\"#\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("45", "HowardTaft", "howardtaft", "{\"eg-item-skin-element-last-id\":\"14\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(111,33,44,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#000000\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#000000\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"slide\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-howardtaft-element-0{letter-spacing:1px;}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-howardtaft-element-0{}\",\"hideunder\":\"0\",\"transition\":\"slide\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"css-hover\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\".eg-howardtaft-element-2{ min-width:50px}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-howardtaft-element-2{}\",\"hideunder\":\"0\",\"transition\":\"zoomback\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"absolute-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"css\":\"\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"css-hover\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"6\",\"order\":\"6\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"200\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"7\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slide\",\"delay\":\"35\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"hide-on-video\":\"true\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":\"7\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"7\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slide\",\"delay\":\"35\",\"link-type\":\"embedded_video\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-play\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("46", "HowardTaft-195032", "howardtaft-195032", "{\"eg-item-skin-element-last-id\":\"14\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(111,33,44,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#000000\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#000000\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"slide\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-howardtaft-element-0{letter-spacing:1px;}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-howardtaft-element-0{}\",\"hideunder\":\"0\",\"transition\":\"slide\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"css-hover\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\".eg-howardtaft-element-2{ min-width:50px}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-howardtaft-element-2{}\",\"hideunder\":\"0\",\"transition\":\"zoomback\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"absolute-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"css\":\"\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"css-hover\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"6\",\"order\":\"6\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"200\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"7\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slide\",\"delay\":\"35\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"hide-on-video\":\"true\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":\"7\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"7\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slide\",\"delay\":\"35\",\"link-type\":\"embedded_video\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-play\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("47", "InstagramStream", "instagramstream", "{\"eg-item-skin-element-last-id\":\"37\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"splitted-item\":\"none\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.50)\",\"cover-always-visible-desktop\":\"false\",\"cover-always-visible-mobile\":\"false\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"20\",\"20\",\"20\",\"20\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-box-shadow\":[\"0\",\"1\",\"10\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"element-hover-image\":\"false\",\"hover-image-animation\":\"fade\",\"hover-image-animation-delay\":\"0\",\"link-set-to\":\"none\",\"link-link-type\":\"lightbox\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"16\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"5\",\"0\",\"5\"],\"background-color\":\"transparent\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"24\",\"line-height-hover\":\"28\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"900\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"false\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"hide\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-text\":\"<i class=\\\"eg-icon-heart\\\"><\\/i> %likes_short%\"}},{\"id\":\"35\",\"order\":\"0\",\"container\":\"tl\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"24\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"right\",\"clear\":\"none\",\"margin\":[\"10\",\"7\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"24\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"none\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"adv-rules\":{\"ar-show\":\"show\",\"ar-type\":[\"off\",\"off\",\"off\",\"off\",\"off\",\"off\",\"off\",\"off\",\"off\"],\"ar-meta\":[\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\"],\"ar-operator\":[\"isset\",\"isset\",\"isset\",\"isset\",\"isset\",\"isset\",\"isset\",\"isset\",\"isset\"],\"ar-value\":[\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\"],\"ar-value-2\":[\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\"],\"ar-logic\":[\"and\",\"and\",\"and\",\"and\",\"and\",\"and\"],\"ar-logic-glob\":[\"and\",\"and\"]},\"show-on-lightbox-video\":\"true\",\"source-icon\":\"eg-icon-videocam\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"37\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"16\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"5\",\"0\",\"5\"],\"background-color\":\"transparent\",\"shadow-color\":\"#000000\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"20\",\"line-height-hover\":\"25\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"shadow-color-hover\":\"#000000\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"show-on-lightbox-video\":\"true\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-text\":\"<i class=\\\"eg-icon-play\\\"><\\/i> %likes_short%\"}},{\"id\":\"36\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"16\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"5\",\"0\",\"5\"],\"background-color\":\"transparent\",\"shadow-color\":\"#000000\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"17\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"shadow-color-hover\":\"#000000\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"show-on-lightbox-video\":\"false\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-text\":\"<i class=\\\"eg-icon-align-left\\\"><\\/i> %num_comments%\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("48", "InstagramStream-195032", "instagramstream-195032", "{\"eg-item-skin-element-last-id\":\"37\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"splitted-item\":\"none\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.50)\",\"cover-always-visible-desktop\":\"false\",\"cover-always-visible-mobile\":\"false\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"20\",\"20\",\"20\",\"20\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-box-shadow\":[\"0\",\"1\",\"10\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"element-hover-image\":\"false\",\"hover-image-animation\":\"fade\",\"hover-image-animation-delay\":\"0\",\"link-set-to\":\"none\",\"link-link-type\":\"lightbox\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"16\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"5\",\"0\",\"5\"],\"background-color\":\"transparent\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"24\",\"line-height-hover\":\"28\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"900\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"false\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"hide\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-text\":\"<i class=\\\"eg-icon-heart\\\"><\\/i> %likes_short%\"}},{\"id\":\"35\",\"order\":\"0\",\"container\":\"tl\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"24\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"right\",\"clear\":\"none\",\"margin\":[\"10\",\"7\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"24\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"none\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"adv-rules\":{\"ar-show\":\"show\",\"ar-type\":[\"off\",\"off\",\"off\",\"off\",\"off\",\"off\",\"off\",\"off\",\"off\"],\"ar-meta\":[\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\"],\"ar-operator\":[\"isset\",\"isset\",\"isset\",\"isset\",\"isset\",\"isset\",\"isset\",\"isset\",\"isset\"],\"ar-value\":[\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\"],\"ar-value-2\":[\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\"],\"ar-logic\":[\"and\",\"and\",\"and\",\"and\",\"and\",\"and\"],\"ar-logic-glob\":[\"and\",\"and\"]},\"show-on-lightbox-video\":\"true\",\"source-icon\":\"eg-icon-videocam\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"37\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"16\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"5\",\"0\",\"5\"],\"background-color\":\"transparent\",\"shadow-color\":\"#000000\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"20\",\"line-height-hover\":\"25\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"shadow-color-hover\":\"#000000\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"show-on-lightbox-video\":\"true\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-text\":\"<i class=\\\"eg-icon-play\\\"><\\/i> %likes_short%\"}},{\"id\":\"36\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"16\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"5\",\"0\",\"5\"],\"background-color\":\"transparent\",\"shadow-color\":\"#000000\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"17\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"shadow-color-hover\":\"#000000\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"show-on-lightbox-video\":\"false\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-text\":\"<i class=\\\"eg-icon-align-left\\\"><\\/i> %num_comments%\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("49", "J.F.Kennedy", "j-f-kennedy", "{\"eg-item-skin-element-last-id\":\"24\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#111111\",\"full-padding\":[\"20\",\"20\",\"20\",\"20\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"5\",\"5\",\"5\",\"5\"],\"full-border-color\":\"#606060\",\"full-border-style\":\"solid\",\"content-bg-color\":\"#111111\",\"content-padding\":[\"30\",\"30\",\"0\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.15)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Droid+Serif:400,700\",\"Open+Sans:400,600,700,800\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-post\":\"title\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"15\",\"0\",\"0\"],\"padding\":[\"19\",\"19\",\"19\",\"19\"],\"background-color\":\"rgba(0,0,0,0.85)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-text\":\"LINE-BREAK\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"19\",\"19\",\"19\",\"19\"],\"background-color\":\"rgba(0,0,0,0.85)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"19\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"%\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"18\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-icon\":\"eg-icon-forward\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#40dc8d\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"5\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"6\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#888888\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"5\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("50", "J.F.Kennedy-195032", "j-f-kennedy-195032", "{\"eg-item-skin-element-last-id\":\"24\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#111111\",\"full-padding\":[\"20\",\"20\",\"20\",\"20\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"5\",\"5\",\"5\",\"5\"],\"full-border-color\":\"#606060\",\"full-border-style\":\"solid\",\"content-bg-color\":\"#111111\",\"content-padding\":[\"30\",\"30\",\"0\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.15)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Droid+Serif:400,700\",\"Open+Sans:400,600,700,800\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-post\":\"title\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"15\",\"0\",\"0\"],\"padding\":[\"19\",\"19\",\"19\",\"19\"],\"background-color\":\"rgba(0,0,0,0.85)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-text\":\"LINE-BREAK\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"19\",\"19\",\"19\",\"19\"],\"background-color\":\"rgba(0,0,0,0.85)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"19\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"%\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"18\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-icon\":\"eg-icon-forward\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#40dc8d\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"5\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"6\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#888888\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"5\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("51", "Jackson", "jackson", "{\"eg-item-skin-element-last-id\":\"7\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(255,255,255,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#eeeeee\",\"full-padding\":[\"5\",\"5\",\"5\",\"5\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"zoomback\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(245,245,245,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(238,238,238,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomback\",\"delay\":\"5\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-jackson-element-0{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-jackson-element-0{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(245,245,245,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(238,238,238,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomback\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"18\",\"line-height\":\"20\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"18\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"skewright\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"7\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#888888\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"skewleft\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"6\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"7\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("52", "Jackson-195032", "jackson-195032", "{\"eg-item-skin-element-last-id\":\"7\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(255,255,255,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#eeeeee\",\"full-padding\":[\"5\",\"5\",\"5\",\"5\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"zoomback\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(245,245,245,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(238,238,238,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomback\",\"delay\":\"5\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-jackson-element-0{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-jackson-element-0{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(245,245,245,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(238,238,238,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomback\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"18\",\"line-height\":\"20\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"18\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"skewright\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"7\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#888888\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"skewleft\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"6\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"7\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("53", "Jason", "jason", "{\"eg-item-skin-element-last-id\":\"32\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(255,255,255,0.20)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"1\",\"1\",\"1\",\"1\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"true\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"1\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"-1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"20\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"32\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(227,58,12,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slide\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"25\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"woocommerce\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#89af72\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"2\",\"7\",\"1\",\"7\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"source-woocommerce\":\"wc_full_price\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"31\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"30\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"30\",\"color\":\"#000000\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"source-woocommerce\":\"wc_star_rating\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"26\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"28\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"4\",\"10\"],\"background-color\":\"rgba(227,58,12,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"5\",\"5\",\"5\",\"5\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"5\",\"5\",\"5\",\"5\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e33a0c\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-woocommerce\":\"wc_add_to_cart_button\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("54", "Jason-195032", "jason-195032", "{\"eg-item-skin-element-last-id\":\"32\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(255,255,255,0.20)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"1\",\"1\",\"1\",\"1\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"true\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"1\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"-1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"20\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"32\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(227,58,12,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slide\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"25\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"woocommerce\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#89af72\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"2\",\"7\",\"1\",\"7\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"source-woocommerce\":\"wc_full_price\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"31\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"30\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"30\",\"color\":\"#000000\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"source-woocommerce\":\"wc_star_rating\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"26\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"28\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"4\",\"10\"],\"background-color\":\"rgba(227,58,12,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"5\",\"5\",\"5\",\"5\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"5\",\"5\",\"5\",\"5\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e33a0c\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-woocommerce\":\"wc_add_to_cart_button\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("55", "Jefferson-032032", "jefferson-032032", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(227,58,12,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fliphorizontal\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"fliphorizontalout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"46\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"50\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"17\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"60\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"6\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"1\",\"5\",\"1\",\"5\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"3\",\"3\",\"3\",\"3\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"3\",\"3\",\"3\",\"3\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"70\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\"   \",\"limit-type\":\"words\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"7\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-h