<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0
 */

$ekoterra_template_args = get_query_var( 'ekoterra_template_args' );
if ( is_array( $ekoterra_template_args ) ) {
	$ekoterra_columns    = empty( $ekoterra_template_args['columns'] ) ? 1 : max( 1, min( 3, $ekoterra_template_args['columns'] ) );
	$ekoterra_blog_style = array( $ekoterra_template_args['type'], $ekoterra_columns );
} else {
	$ekoterra_blog_style = explode( '_', ekoterra_get_theme_option( 'blog_style' ) );
	$ekoterra_columns    = empty( $ekoterra_blog_style[1] ) ? 1 : max( 1, min( 3, $ekoterra_blog_style[1] ) );
}
$ekoterra_expanded    = ! ekoterra_sidebar_present() && ekoterra_is_on( ekoterra_get_theme_option( 'expand_content' ) );
$ekoterra_post_format = get_post_format();
$ekoterra_post_format = empty( $ekoterra_post_format ) ? 'standard' : str_replace( 'post-format-', '', $ekoterra_post_format );
$ekoterra_animation   = ekoterra_get_theme_option( 'blog_animation' );

?><article id="post-<?php the_ID(); ?>" 
									<?php
									post_class(
										'post_item'
										. ' post_layout_chess'
										. ' post_layout_chess_' . esc_attr( $ekoterra_columns )
										. ' post_format_' . esc_attr( $ekoterra_post_format )
										. ( ! empty( $ekoterra_template_args['slider'] ) ? ' slider-slide swiper-slide' : '' )
									);
									echo ( ! ekoterra_is_off( $ekoterra_animation ) && empty( $ekoterra_template_args['slider'] ) ? ' data-animation="' . esc_attr( ekoterra_get_animation_classes( $ekoterra_animation ) ) . '"' : '' );
									?>
	>

	<?php
	// Add anchor
	if ( 1 == $ekoterra_columns && ! is_array( $ekoterra_template_args ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode( '[trx_sc_anchor id="post_' . esc_attr( get_the_ID() ) . '" title="' . the_title_attribute( array( 'echo' => false ) ) . '" icon="' . esc_attr( ekoterra_get_post_icon() ) . '"]' );
	}

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
        <span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$ekoterra_hover = ! empty( $ekoterra_template_args['hover'] ) && ! ekoterra_is_inherit( $ekoterra_template_args['hover'] )
						? $ekoterra_template_args['hover']
						: ekoterra_get_theme_option( 'image_hover' );
	ekoterra_show_post_featured(
		array(
			'class'         => 1 == $ekoterra_columns && ! is_array( $ekoterra_template_args ) ? 'ekoterra-full-height' : '',
			'singular'      => false,
			'hover'         => $ekoterra_hover,
			'no_links'      => ! empty( $ekoterra_template_args['no_links'] ),
			'show_no_image' => true,
			'thumb_ratio'   => '1:1',
			'thumb_bg'      => true,
			'thumb_size'    => ekoterra_get_thumb_size(
				strpos( ekoterra_get_theme_option( 'body_style' ), 'full' ) !== false
										? ( 1 < $ekoterra_columns ? 'huge' : 'original' )
										: ( 2 < $ekoterra_columns ? 'big' : 'huge' )
			),
		)
	);

	?>
	<div class="post_inner"><div class="post_inner_content"><div class="post_header entry-header">
		<?php
			do_action( 'ekoterra_action_before_post_title' );

			// Post title
		if ( empty( $ekoterra_template_args['no_links'] ) ) {
			the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
		} else {
			the_title( '<h3 class="post_title entry-title">', '</h3>' );
		}

			do_action( 'ekoterra_action_before_post_meta' );

			// Post meta
			$ekoterra_components = ekoterra_array_get_keys_by_value( ekoterra_get_theme_option( 'meta_parts' ) );
			$ekoterra_counters   = ekoterra_array_get_keys_by_value( ekoterra_get_theme_option( 'counters' ) );
			$ekoterra_post_meta  = empty( $ekoterra_components ) || in_array( $ekoterra_hover, array( 'border', 'pull', 'slide', 'fade' ) )
										? ''
										: ekoterra_show_post_meta(
											apply_filters(
												'ekoterra_filter_post_meta_args', array(
													'components' => $ekoterra_components,
													'counters' => $ekoterra_counters,
													'seo'  => false,
													'echo' => false,
												), $ekoterra_blog_style[0], $ekoterra_columns
											)
										);
			ekoterra_show_layout( $ekoterra_post_meta );
			?>
		</div><!-- .entry-header -->

		<div class="post_content entry-content">
		<?php
		if ( empty( $ekoterra_template_args['hide_excerpt'] ) && ekoterra_get_theme_option( 'excerpt_length' ) > 0 ) {
			?>
				<div class="post_content_inner">
				<?php
				if ( has_excerpt() ) {
					the_excerpt();
				} elseif ( strpos( get_the_content( '!--more' ), '!--more' ) !== false ) {
					the_content( '' );
				} elseif ( in_array( $ekoterra_post_format, array( 'link', 'aside', 'status' ) ) ) {
					the_content();
				} elseif ( 'quote' == $ekoterra_post_format ) {
					$quote = ekoterra_get_tag( get_the_content(), '<blockquote>', '</blockquote>' );
					if ( ! empty( $quote ) ) {
						ekoterra_show_layout( wpautop( $quote ) );
					} else {
						the_excerpt();
					}
				} elseif ( substr( get_the_content(), 0, 4 ) != '[vc_' ) {
					the_excerpt();
				}
				?>
				</div>
				<?php
		}
			// Post meta
		if ( in_array( $ekoterra_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
			ekoterra_show_layout( $ekoterra_post_meta );
		}
			// More button
		if ( empty( $ekoterra_template_args['no_links'] ) && ! in_array( $ekoterra_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
			?>
				<p><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read more', 'ekoterra' ); ?></a></p>
				<?php
		}
		?>
		</div><!-- .entry-content -->

	</div></div><!-- .post_inner -->

</article><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!
