<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0.50
 */

$ekoterra_template_args = get_query_var( 'ekoterra_template_args' );
if ( is_array( $ekoterra_template_args ) ) {
	$ekoterra_columns    = empty( $ekoterra_template_args['columns'] ) ? 2 : max( 1, $ekoterra_template_args['columns'] );
	$ekoterra_blog_style = array( $ekoterra_template_args['type'], $ekoterra_columns );
} else {
	$ekoterra_blog_style = explode( '_', ekoterra_get_theme_option( 'blog_style' ) );
	$ekoterra_columns    = empty( $ekoterra_blog_style[1] ) ? 2 : max( 1, $ekoterra_blog_style[1] );
}
$ekoterra_blog_id       = ekoterra_get_custom_blog_id( join( '_', $ekoterra_blog_style ) );
$ekoterra_blog_style[0] = str_replace( 'blog-custom-', '', $ekoterra_blog_style[0] );
$ekoterra_expanded      = ! ekoterra_sidebar_present() && ekoterra_is_on( ekoterra_get_theme_option( 'expand_content' ) );
$ekoterra_animation     = ekoterra_get_theme_option( 'blog_animation' );
$ekoterra_components    = ekoterra_array_get_keys_by_value( ekoterra_get_theme_option( 'meta_parts' ) );
$ekoterra_counters      = ekoterra_array_get_keys_by_value( ekoterra_get_theme_option( 'counters' ) );

$ekoterra_post_format   = get_post_format();
$ekoterra_post_format   = empty( $ekoterra_post_format ) ? 'standard' : str_replace( 'post-format-', '', $ekoterra_post_format );

$ekoterra_blog_meta     = ekoterra_get_custom_layout_meta( $ekoterra_blog_id );
$ekoterra_custom_style  = ! empty( $ekoterra_blog_meta['scripts_required'] ) ? $ekoterra_blog_meta['scripts_required'] : 'none';

if ( ! empty( $ekoterra_template_args['slider'] ) || $ekoterra_columns > 1 || ! ekoterra_is_off( $ekoterra_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $ekoterra_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo ( ekoterra_is_off( $ekoterra_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $ekoterra_custom_style ) ) . '-1_' . esc_attr( $ekoterra_columns );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" 
<?php
	post_class(
			'post_item post_format_' . esc_attr( $ekoterra_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $ekoterra_columns )
					. ' post_layout_' . esc_attr( $ekoterra_blog_style[0] )
					. ' post_layout_' . esc_attr( $ekoterra_blog_style[0] ) . '_' . esc_attr( $ekoterra_columns )
					. ( ! ekoterra_is_off( $ekoterra_custom_style )
						? ' post_layout_' . esc_attr( $ekoterra_custom_style )
							. ' post_layout_' . esc_attr( $ekoterra_custom_style ) . '_' . esc_attr( $ekoterra_columns )
						: ''
						)
		);
	echo ( ! ekoterra_is_off( $ekoterra_animation ) && empty( $ekoterra_template_args['slider'] ) ? ' data-animation="' . esc_attr( ekoterra_get_animation_classes( $ekoterra_animation ) ) . '"' : '' );
?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
        <span class="post_label label_sticky"><?php esc_html_e('Sticky Post', 'ekoterra')?></span>
		<?php
	}
	// Custom header's layout
	do_action( 'ekoterra_action_show_layout', $ekoterra_blog_id );
	?>
</article><?php
if ( ! empty( $ekoterra_template_args['slider'] ) || $ekoterra_columns > 1 || ! ekoterra_is_off( $ekoterra_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
