<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0
 */

$ekoterra_template_args = get_query_var( 'ekoterra_template_args' );
if ( is_array( $ekoterra_template_args ) ) {
	$ekoterra_columns    = empty( $ekoterra_template_args['columns'] ) ? 1 : max( 1, $ekoterra_template_args['columns'] );
	$ekoterra_blog_style = array( $ekoterra_template_args['type'], $ekoterra_columns );
	if ( ! empty( $ekoterra_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $ekoterra_columns > 1 ) {
		?>
		<div class="column-1_<?php echo esc_attr( $ekoterra_columns ); ?>">
		<?php
	}
}
$ekoterra_expanded    = ! ekoterra_sidebar_present() && ekoterra_is_on( ekoterra_get_theme_option( 'expand_content' ) );
$ekoterra_post_format = get_post_format();
$ekoterra_post_format = empty( $ekoterra_post_format ) ? 'standard' : str_replace( 'post-format-', '', $ekoterra_post_format );
$ekoterra_animation   = ekoterra_get_theme_option( 'blog_animation' );
$ekoterra_sticky = !empty( is_sticky() ) ? ' sticky' : '';
?>
<article id="post-<?php the_ID(); ?>"
	<?php post_class( 'post_item post_layout_excerpt'. $ekoterra_sticky .' post_format_' . esc_attr( $ekoterra_post_format ) ); ?>
	<?php echo ( ! ekoterra_is_off( $ekoterra_animation ) && empty( $ekoterra_template_args['slider'] ) ? ' data-animation="' . esc_attr( ekoterra_get_animation_classes( $ekoterra_animation ) ) . '"' : '' ); ?>
	>
	<?php


if ( ! in_array($ekoterra_post_format, array('audio')) ) {
	// Featured image
	$ekoterra_hover = ! empty( $ekoterra_template_args['hover'] ) && ! ekoterra_is_inherit( $ekoterra_template_args['hover'] )
						? $ekoterra_template_args['hover']
						: ekoterra_get_theme_option( 'image_hover' );
	ekoterra_show_post_featured(
		array(
			'singular'   => false,
			'no_links'   => ! empty( $ekoterra_template_args['no_links'] ),
			'hover'      => $ekoterra_hover,
			'thumb_ratio'   => '790:518',
			'thumb_size' => ekoterra_get_thumb_size( strpos( ekoterra_get_theme_option( 'body_style' ), 'full' ) !== false ? 'full' : ( $ekoterra_expanded ? 'big' : 'big' ) ),
		)
	);
}
	// Title and post meta
	if ( get_the_title() != '' ) {
		?>
		<div class="post_header entry-header">
		    <div class="meta-wrap is_sticky">
		    <?php
		    if ( is_sticky() && ! is_paged()  ) {
                    ?>
		        <div class="meta-left-block">
                    <span class="sticky-ico"></span>
                </div>
            <?php } ?>
		        <div class="meta-right-block">
			<?php
                // Post meta
                $ekoterra_components = ekoterra_array_get_keys_by_value( ekoterra_get_theme_option( 'meta_parts' ) );
                $ekoterra_counters   = ekoterra_array_get_keys_by_value( ekoterra_get_theme_option( 'counters' ) );
 $ekoterra_hover = ! empty( $ekoterra_template_args['hover'] ) && ! ekoterra_is_inherit( $ekoterra_template_args['hover'] )
                            ? $ekoterra_template_args['hover']
                            : ekoterra_get_theme_option( 'image_hover' );
                if ( ! empty( $ekoterra_components ) && ! in_array( $ekoterra_hover, array( 'border', 'pull', 'slide', 'fade' ) ) ) {



                    ekoterra_show_post_meta(
                        apply_filters(
                            'ekoterra_filter_post_meta_args', array(
                                'components' => $ekoterra_components,
                                'counters'   => $ekoterra_counters,
                                'seo'        => false,
                            ), 'excerpt', 1
                        )
                    );
                }
                        // Sticky label

                    ?>
                    <span class="post_label label_sticky"><?php
                       // Post title
                          // Post title
                        if ( empty( $ekoterra_template_args['no_links'] ) ) {
                            the_title( sprintf( '<h5 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h5>' );
                        } else {
                            the_title( '<h5 class="post_title entry-title">', '</h5>' );
                        }
                    ?></span>

                </div>
            </div>
            <?php


			?>
		</div><!-- .post_header -->
		<?php
	}
	if ( in_array($ekoterra_post_format, array('audio')) ) {
// Featured image
        $ekoterra_hover = ! empty( $ekoterra_template_args['hover'] ) && ! ekoterra_is_inherit( $ekoterra_template_args['hover'] )
                            ? $ekoterra_template_args['hover']
                            : ekoterra_get_theme_option( 'image_hover' );
        ekoterra_show_post_featured(
            array(
                'singular'   => false,
                'no_links'   => ! empty( $ekoterra_template_args['no_links'] ),
                'hover'      => $ekoterra_hover,
                'thumb_size' => ekoterra_get_thumb_size( strpos( ekoterra_get_theme_option( 'body_style' ), 'full' ) !== false ? 'full' : ( $ekoterra_expanded ? 'huge' : 'big' ) ),
            )
        );
        }


	// Post content
	if ( empty( $ekoterra_template_args['hide_excerpt'] ) && ekoterra_get_theme_option( 'excerpt_length' ) > 0 && ! in_array( $ekoterra_post_format, array( 'audio' ) ) ) {

		?>
		<div class="post_content entry-content">
		<?php
		if ( ekoterra_get_theme_option( 'blog_content' ) == 'fullpost' ) {
			// Post content area
			?>
				<div class="post_content_inner">
				<?php
				the_content( '' );
				?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'ekoterra' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'ekoterra' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
		} else {
			// Post content area
			?>
				<div class="post_content_inner">
				<?php
				if ( has_excerpt() ) {
						the_excerpt();
				} elseif ( strpos( get_the_content( '!--more' ), '!--more' ) !== false ) {
						the_content( '' );
				} elseif ( in_array( $ekoterra_post_format, array( 'link', 'aside', 'status' ) ) ) {
						the_content();
				} elseif ( 'quote' == $ekoterra_post_format ) {
					$quote = ekoterra_get_tag( get_the_content(), '<blockquote>', '</blockquote>' );
					if ( ! empty( $quote ) ) {
						ekoterra_show_layout( wpautop( $quote ) );
					} else {
						the_excerpt();
					}
				} elseif ( substr( get_the_content(), 0, 4 ) != '[vc_' ) {
					the_excerpt();
				}
				?>
				</div>
				<?php
				// More button
				if ( empty( $ekoterra_template_args['no_links'] ) && ! in_array( $ekoterra_post_format, array( 'link', 'aside', 'status', 'quote', 'audio' ) ) ) {
					?>
					<p><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e( 'Continue Reading', 'ekoterra' ); ?></a></p>
					<?php
				}
				if (  in_array( $ekoterra_post_format, array( 'quote' ) ) ) {
				         // Post meta
                $ekoterra_components = ekoterra_array_get_keys_by_value( ekoterra_get_theme_option( 'meta_parts' ) );
                $ekoterra_counters   = ekoterra_array_get_keys_by_value( ekoterra_get_theme_option( 'counters' ) );

                if ( ! empty( $ekoterra_components ) && ! in_array( $ekoterra_hover, array( 'border', 'pull', 'slide', 'fade' ) ) ) {
                    ekoterra_show_post_meta(
                        apply_filters(
                            'ekoterra_filter_post_meta_args', array(
                                'components' => $ekoterra_components,
                                'counters'   => $ekoterra_counters,
                                'seo'        => false,
                            ), 'excerpt', 1
                        )
                    );
                }
				}
		}
		?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
	</article>
<?php

if ( is_array( $ekoterra_template_args ) ) {
	if ( ! empty( $ekoterra_template_args['slider'] ) || $ekoterra_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
