<?php
/**
 * The Gallery template to display posts
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0
 */

$ekoterra_template_args = get_query_var( 'ekoterra_template_args' );
if ( is_array( $ekoterra_template_args ) ) {
	$ekoterra_columns    = empty( $ekoterra_template_args['columns'] ) ? 2 : max( 1, $ekoterra_template_args['columns'] );
	$ekoterra_blog_style = array( $ekoterra_template_args['type'], $ekoterra_columns );
} else {
	$ekoterra_blog_style = explode( '_', ekoterra_get_theme_option( 'blog_style' ) );
	$ekoterra_columns    = empty( $ekoterra_blog_style[1] ) ? 2 : max( 1, $ekoterra_blog_style[1] );
}
$ekoterra_post_format = get_post_format();
$ekoterra_post_format = empty( $ekoterra_post_format ) ? 'standard' : str_replace( 'post-format-', '', $ekoterra_post_format );
$ekoterra_animation   = ekoterra_get_theme_option( 'blog_animation' );
$ekoterra_image       = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );

?><div class="
<?php
if ( ! empty( $ekoterra_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo 'masonry_item masonry_item-1_' . esc_attr( $ekoterra_columns );
}
?>
"><article id="post-<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_format_' . esc_attr( $ekoterra_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $ekoterra_columns )
		. ' post_layout_gallery'
		. ' post_layout_gallery_' . esc_attr( $ekoterra_columns )
	);
	echo ( ! ekoterra_is_off( $ekoterra_animation ) && empty( $ekoterra_template_args['slider'] ) ? ' data-animation="' . esc_attr( ekoterra_get_animation_classes( $ekoterra_animation ) ) . '"' : '' );
	?>
	data-size="
		<?php
		if ( ! empty( $ekoterra_image[1] ) && ! empty( $ekoterra_image[2] ) ) {
			echo intval( $ekoterra_image[1] ) . 'x' . intval( $ekoterra_image[2] );}
		?>
	"
	data-src="
		<?php
		if ( ! empty( $ekoterra_image[0] ) ) {
			echo esc_url( $ekoterra_image[0] );}
		?>
	"
>
<?php

	// Sticky label
if ( is_sticky() && ! is_paged() ) {
	?>
    <span class="post_label label_sticky"><?php esc_html_e('Sticky Post', 'ekoterra')?></span>
		<?php
}

	// Featured image
	$ekoterra_image_hover = 'icon';  
if ( in_array( $ekoterra_image_hover, array( 'icons', 'zoom' ) ) ) {
	$ekoterra_image_hover = 'dots';
}
$ekoterra_components = ekoterra_array_get_keys_by_value( ekoterra_get_theme_option( 'meta_parts' ) );
$ekoterra_counters   = ekoterra_array_get_keys_by_value( ekoterra_get_theme_option( 'counters' ) );
ekoterra_show_post_featured(
	array(
		'hover'         => $ekoterra_image_hover,
		'singular'      => false,
		'no_links'      => ! empty( $ekoterra_template_args['no_links'] ),
		'thumb_size'    => ekoterra_get_thumb_size( strpos( ekoterra_get_theme_option( 'body_style' ), 'full' ) !== false || $ekoterra_columns < 3 ? 'masonry-big' : 'masonry' ),
		'thumb_only'    => true,
		'show_no_image' => true,
		'post_info'     => '<div class="post_details">'
						. '<h2 class="post_title">'
							. ( empty( $ekoterra_template_args['no_links'] )
								? '<a href="' . esc_url( get_permalink() ) . '">' . esc_html( get_the_title() ) . '</a>'
								: esc_html( get_the_title() )
								)
						. '</h2>'
						. '<div class="post_description">'
							. ( ! empty( $ekoterra_components )
								? ekoterra_show_post_meta(
									apply_filters(
										'ekoterra_filter_post_meta_args', array(
											'components' => $ekoterra_components,
											'counters' => $ekoterra_counters,
											'seo'      => false,
											'echo'     => false,
										), $ekoterra_blog_style[0], $ekoterra_columns
									)
								)
								: ''
								)
							. ( empty( $ekoterra_template_args['hide_excerpt'] )
								? '<div class="post_description_content">' . get_the_excerpt() . '</div>'
								: ''
								)
							. ( empty( $ekoterra_template_args['no_links'] )
								? '<a href="' . esc_url( get_permalink() ) . '" class="theme_button post_readmore"><span class="post_readmore_label">' . esc_html__( 'Learn more', 'ekoterra' ) . '</span></a>'
								: ''
								)
						. '</div>'
					. '</div>',
	)
);
?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!
