<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0
 */

$ekoterra_template_args = get_query_var( 'ekoterra_template_args' );
if ( is_array( $ekoterra_template_args ) ) {
	$ekoterra_columns    = empty( $ekoterra_template_args['columns'] ) ? 2 : max( 1, $ekoterra_template_args['columns'] );
	$ekoterra_blog_style = array( $ekoterra_template_args['type'], $ekoterra_columns );
} else {
	$ekoterra_blog_style = explode( '_', ekoterra_get_theme_option( 'blog_style' ) );
	$ekoterra_columns    = empty( $ekoterra_blog_style[1] ) ? 2 : max( 1, $ekoterra_blog_style[1] );
}
$ekoterra_post_format = get_post_format();
$ekoterra_post_format = empty( $ekoterra_post_format ) ? 'standard' : str_replace( 'post-format-', '', $ekoterra_post_format );
$ekoterra_animation   = ekoterra_get_theme_option( 'blog_animation' );

?><div class="
<?php
if ( ! empty( $ekoterra_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo 'masonry_item masonry_item-1_' . esc_attr( $ekoterra_columns );
}
?>
"><article id="post-<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_format_' . esc_attr( $ekoterra_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $ekoterra_columns )
		. ( is_sticky() && ! is_paged() ? ' sticky' : '' )
	);
	echo ( ! ekoterra_is_off( $ekoterra_animation ) && empty( $ekoterra_template_args['slider'] ) ? ' data-animation="' . esc_attr( ekoterra_get_animation_classes( $ekoterra_animation ) ) . '"' : '' );
	?>
>
<?php

// Sticky label
if ( is_sticky() && ! is_paged() ) {
	?>
    <span class="post_label label_sticky"></span>
		<?php
}

	$ekoterra_image_hover = ! empty( $ekoterra_template_args['hover'] ) && ! ekoterra_is_inherit( $ekoterra_template_args['hover'] )
								? $ekoterra_template_args['hover']
								: ekoterra_get_theme_option( 'image_hover' );
	// Featured image
	ekoterra_show_post_featured(
		array(
			'singular'      => false,
			'hover'         => $ekoterra_image_hover,
			'no_links'      => ! empty( $ekoterra_template_args['no_links'] ),
			'thumb_size'    => ekoterra_get_thumb_size(
				strpos( ekoterra_get_theme_option( 'body_style' ), 'full' ) !== false || $ekoterra_columns < 3
								? 'masonry-big'
				: 'masonry'
			),
			'show_no_image' => true,
			'class'         => 'dots' == $ekoterra_image_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $ekoterra_image_hover ? '<div class="post_info">' . esc_html( get_the_title() ) . '</div>' : '',
		)
	);
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!