<?php
/**
 * The Sticky template to display the sticky posts
 *
 * Used for index/archive
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0
 */

$ekoterra_columns     = max( 1, min( 3, count( get_option( 'sticky_posts' ) ) ) );
$ekoterra_post_format = get_post_format();
$ekoterra_post_format = empty( $ekoterra_post_format ) ? 'standard' : str_replace( 'post-format-', '', $ekoterra_post_format );
$ekoterra_animation   = ekoterra_get_theme_option( 'blog_animation' );

?><div class="column-1_<?php echo esc_attr( $ekoterra_columns ); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_sticky post_format_' . esc_attr( $ekoterra_post_format ) ); ?>
	<?php echo ( ! ekoterra_is_off( $ekoterra_animation ) ? ' data-animation="' . esc_attr( ekoterra_get_animation_classes( $ekoterra_animation ) ) . '"' : '' ); ?>
	>

	<?php
	if ( is_sticky() && is_home() && ! is_paged() ) {
		?>
        <span class="post_label label_sticky"><?php esc_html_e('Sticky Post', 'ekoterra')?></span>
		<?php
	}

	// Featured image
	ekoterra_show_post_featured(
		array(
			'thumb_size' => ekoterra_get_thumb_size( 1 == $ekoterra_columns ? 'big' : ( 2 == $ekoterra_columns ? 'med' : 'avatar' ) ),
		)
	);

	if ( ! in_array( $ekoterra_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			the_title( sprintf( '<h6 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h6>' );
			// Post meta
			ekoterra_show_post_meta( apply_filters( 'ekoterra_filter_post_meta_args', array(), 'sticky', $ekoterra_columns ) );
			?>
		</div><!-- .entry-header -->
		<?php
	}
	?>
</article></div><?php

// div.column-1_X is a inline-block and new lines and spaces after it are forbidden
