<?php
/**
 * The default template to display the content of the single post, page or attachment
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0
 */

$ekoterra_seo = ekoterra_is_on( ekoterra_get_theme_option( 'seo_snippets' ) );
?>
<article id="post-<?php the_ID(); ?>" 
	<?php
	post_class('post_item_single post_type_' . esc_attr( get_post_type() ) 
		. ' post_format_' . esc_attr( str_replace( 'post-format-', '', get_post_format() ) )
	);
	if ( $ekoterra_seo ) {
		?>
		itemscope="itemscope" 
		itemprop="articleBody" 
		itemtype="//schema.org/<?php echo esc_attr( ekoterra_get_markup_schema() ); ?>" 
		itemid="<?php echo esc_url( get_the_permalink() ); ?>"
		content="<?php the_title_attribute(); ?>"
		<?php
	}
	?>
>
<?php

	do_action( 'ekoterra_action_before_post_data' );

	// Structured data snippets
	if ( $ekoterra_seo ) {
		get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'templates/seo' ) );
	}

	if ( is_singular( 'post' ) ) {
		$ekoterra_post_thumbnail_type  = ekoterra_get_theme_option( 'post_thumbnail_type' );
		$ekoterra_post_header_position = ekoterra_get_theme_option( 'post_header_position' );
		$ekoterra_post_header_align    = ekoterra_get_theme_option( 'post_header_align' );

		if ( 'default' === $ekoterra_post_thumbnail_type ) {
			?>
			<div class="header_content_wrap header_align_<?php echo esc_attr( $ekoterra_post_header_align ); ?>">
				<?php
				// Post title and meta
				if ( 'above' === $ekoterra_post_header_position ) {
					ekoterra_show_post_title_and_meta();
				}

				// Featured image
				ekoterra_show_post_featured_image();

				// Post title and meta
				if ( 'above' !== $ekoterra_post_header_position ) {
					ekoterra_show_post_title_and_meta();
				}
				?>
			</div>
			<?php
		} elseif ( 'default' === $ekoterra_post_header_position ) {
			// Post title and meta
			ekoterra_show_post_title_and_meta();
		}
	}

	do_action( 'ekoterra_action_before_post_content' );

	// Post content
	?>
	<div class="post_content post_content_single entry-content" itemprop="mainEntityOfPage">
		<?php
		the_content();

		do_action( 'ekoterra_action_before_post_pagination' );

		wp_link_pages(
			array(
				'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'ekoterra' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'ekoterra' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			)
		);

		// Taxonomies and share
		if ( is_single() && ! is_attachment() ) {

			do_action( 'ekoterra_action_before_post_meta' );

			// Post rating
			do_action(
				'trx_addons_action_post_rating', array(
					'class'                => 'single_post_rating',
					'rating_text_template' => esc_html__( 'Post rating: {{X}} from {{Y}} (according {{V}})', 'ekoterra' ),
				)
			);
			?>
			<div class="post_meta post_meta_single">
				<?php

				// Post taxonomies
				the_tags( '<span class="post_meta_item post_tags"><span class="post_meta_label">' . esc_html__( 'Tags:', 'ekoterra' ) . '</span> ', ' ', '</span>' );

				// Share
				if ( ekoterra_is_on( ekoterra_get_theme_option( 'show_share_links' ) ) ) {
					ekoterra_show_share_links(
						array(
							'type'    => 'block',
							'caption' => '',
							'before'  => '<span class="post_meta_item post_share">',
							'after'   => '</span>',
						)
					);
				}
				?>
			</div>
			<?php

			do_action( 'ekoterra_action_after_post_meta' );
		}
		?>
	</div><!-- .entry-content -->


	<?php
	do_action( 'ekoterra_action_after_post_content' );

	// Author bio
	if ( ekoterra_get_theme_option( 'show_author_info' ) == 1 && is_single() && ! is_attachment() && get_the_author_meta( 'description' ) ) { 
		do_action( 'ekoterra_action_before_post_author' );
		get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'templates/author-bio' ) );
		do_action( 'ekoterra_action_after_post_author' );
	}

	do_action( 'ekoterra_action_after_post_data' );
	?>
</article>
