<div class="front_page_section front_page_section_googlemap<?php
	$ekoterra_scheme = ekoterra_get_theme_option( 'front_page_googlemap_scheme' );
	if ( ! ekoterra_is_inherit( $ekoterra_scheme ) ) {
		echo ' scheme_' . esc_attr( $ekoterra_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( ekoterra_get_theme_option( 'front_page_googlemap_paddings' ) );
?>"
		<?php
		$ekoterra_css      = '';
		$ekoterra_bg_image = ekoterra_get_theme_option( 'front_page_googlemap_bg_image' );
		if ( ! empty( $ekoterra_bg_image ) ) {
			$ekoterra_css .= 'background-image: url(' . esc_url( ekoterra_get_attachment_url( $ekoterra_bg_image ) ) . ');';
		}
		if ( ! empty( $ekoterra_css ) ) {
			echo ' style="' . esc_attr( $ekoterra_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$ekoterra_anchor_icon = ekoterra_get_theme_option( 'front_page_googlemap_anchor_icon' );
	$ekoterra_anchor_text = ekoterra_get_theme_option( 'front_page_googlemap_anchor_text' );
if ( ( ! empty( $ekoterra_anchor_icon ) || ! empty( $ekoterra_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_googlemap"'
									. ( ! empty( $ekoterra_anchor_icon ) ? ' icon="' . esc_attr( $ekoterra_anchor_icon ) . '"' : '' )
									. ( ! empty( $ekoterra_anchor_text ) ? ' title="' . esc_attr( $ekoterra_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_googlemap_inner
	<?php
	if ( ekoterra_get_theme_option( 'front_page_googlemap_fullheight' ) ) {
		echo ' ekoterra-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$ekoterra_css      = '';
			$ekoterra_bg_mask  = ekoterra_get_theme_option( 'front_page_googlemap_bg_mask' );
			$ekoterra_bg_color_type = ekoterra_get_theme_option( 'front_page_googlemap_bg_color_type' );
			if ( 'custom' == $ekoterra_bg_color_type ) {
				$ekoterra_bg_color = ekoterra_get_theme_option( 'front_page_googlemap_bg_color' );
			} elseif ( 'scheme_bg_color' == $ekoterra_bg_color_type ) {
				$ekoterra_bg_color = ekoterra_get_scheme_color( 'bg_color', $ekoterra_scheme );
			} else {
				$ekoterra_bg_color = '';
			}
			if ( ! empty( $ekoterra_bg_color ) && $ekoterra_bg_mask > 0 ) {
				$ekoterra_css .= 'background-color: ' . esc_attr(
					1 == $ekoterra_bg_mask ? $ekoterra_bg_color : ekoterra_hex2rgba( $ekoterra_bg_color, $ekoterra_bg_mask )
				) . ';';
			}
			if ( ! empty( $ekoterra_css ) ) {
				echo ' style="' . esc_attr( $ekoterra_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_googlemap_content_wrap
		<?php
			$ekoterra_layout = ekoterra_get_theme_option( 'front_page_googlemap_layout' );
		if ( 'fullwidth' != $ekoterra_layout ) {
			echo ' content_wrap';
		}
		?>
		">
			<?php
			// Content wrap with title and description
			$ekoterra_caption     = ekoterra_get_theme_option( 'front_page_googlemap_caption' );
			$ekoterra_description = ekoterra_get_theme_option( 'front_page_googlemap_description' );
			if ( ! empty( $ekoterra_caption ) || ! empty( $ekoterra_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				if ( 'fullwidth' == $ekoterra_layout ) {
					?>
					<div class="content_wrap">
					<?php
				}
					// Caption
				if ( ! empty( $ekoterra_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_googlemap_caption front_page_block_<?php echo ! empty( $ekoterra_caption ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( $ekoterra_caption, 'ekoterra_kses_content' );
					?>
					</h2>
					<?php
				}

					// Description (text)
				if ( ! empty( $ekoterra_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_googlemap_description front_page_block_<?php echo ! empty( $ekoterra_description ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( wpautop( $ekoterra_description ), 'ekoterra_kses_content' );
					?>
					</div>
					<?php
				}
				if ( 'fullwidth' == $ekoterra_layout ) {
					?>
					</div>
					<?php
				}
			}

			// Content (text)
			$ekoterra_content = ekoterra_get_theme_option( 'front_page_googlemap_content' );
			if ( ! empty( $ekoterra_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				if ( 'columns' == $ekoterra_layout ) {
					?>
					<div class="front_page_section_columns front_page_section_googlemap_columns columns_wrap">
						<div class="column-1_3">
					<?php
				} elseif ( 'fullwidth' == $ekoterra_layout ) {
					?>
					<div class="content_wrap">
					<?php
				}

				?>
				<div class="front_page_section_content front_page_section_googlemap_content front_page_block_<?php echo ! empty( $ekoterra_content ) ? 'filled' : 'empty'; ?>">
				<?php
					echo wp_kses( $ekoterra_content, 'ekoterra_kses_content' );
				?>
				</div>
				<?php

				if ( 'columns' == $ekoterra_layout ) {
					?>
					</div><div class="column-2_3">
					<?php
				} elseif ( 'fullwidth' == $ekoterra_layout ) {
					?>
					</div>
					<?php
				}
			}

			// Widgets output
			?>
			<div class="front_page_section_output front_page_section_googlemap_output">
			<?php
			if ( is_active_sidebar( 'front_page_googlemap_widgets' ) ) {
				dynamic_sidebar( 'front_page_googlemap_widgets' );
			} elseif ( current_user_can( 'edit_theme_options' ) ) {
				if ( ! ekoterra_exists_trx_addons() ) {
					ekoterra_customizer_need_trx_addons_message();
				} else {
					ekoterra_customizer_need_widgets_message( 'front_page_googlemap_caption', 'ThemeREX Addons - Google map' );
				}
			}
			?>
			</div>
			<?php

			if ( 'columns' == $ekoterra_layout && ( ! empty( $ekoterra_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div></div>
				<?php
			}
			?>
		</div>
	</div>
</div>
