<?php
$ekoterra_slider_sc = ekoterra_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $ekoterra_slider_sc ) && strpos( $ekoterra_slider_sc, '[' ) !== false && strpos( $ekoterra_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider">
	<?php
		// Add anchor
		$ekoterra_anchor_icon = ekoterra_get_theme_option( 'front_page_title_anchor_icon' );
		$ekoterra_anchor_text = ekoterra_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $ekoterra_anchor_icon ) || ! empty( $ekoterra_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $ekoterra_anchor_icon ) ? ' icon="' . esc_attr( $ekoterra_anchor_icon ) . '"' : '' )
									. ( ! empty( $ekoterra_anchor_text ) ? ' title="' . esc_attr( $ekoterra_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $ekoterra_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$ekoterra_scheme = ekoterra_get_theme_option( 'front_page_title_scheme' );
		if ( ! ekoterra_is_inherit( $ekoterra_scheme ) ) {
			echo ' scheme_' . esc_attr( $ekoterra_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( ekoterra_get_theme_option( 'front_page_title_paddings' ) );
		?>
		"
		<?php
		$ekoterra_css      = '';
		$ekoterra_bg_image = ekoterra_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $ekoterra_bg_image ) ) {
			$ekoterra_css .= 'background-image: url(' . esc_url( ekoterra_get_attachment_url( $ekoterra_bg_image ) ) . ');';
		}
		if ( ! empty( $ekoterra_css ) ) {
			echo ' style="' . esc_attr( $ekoterra_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$ekoterra_anchor_icon = ekoterra_get_theme_option( 'front_page_title_anchor_icon' );
		$ekoterra_anchor_text = ekoterra_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $ekoterra_anchor_icon ) || ! empty( $ekoterra_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $ekoterra_anchor_icon ) ? ' icon="' . esc_attr( $ekoterra_anchor_icon ) . '"' : '' )
									. ( ! empty( $ekoterra_anchor_text ) ? ' title="' . esc_attr( $ekoterra_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( ekoterra_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' ekoterra-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$ekoterra_css      = '';
			$ekoterra_bg_mask  = ekoterra_get_theme_option( 'front_page_title_bg_mask' );
			$ekoterra_bg_color_type = ekoterra_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $ekoterra_bg_color_type ) {
				$ekoterra_bg_color = ekoterra_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $ekoterra_bg_color_type ) {
				$ekoterra_bg_color = ekoterra_get_scheme_color( 'bg_color', $ekoterra_scheme );
			} else {
				$ekoterra_bg_color = '';
			}
			if ( ! empty( $ekoterra_bg_color ) && $ekoterra_bg_mask > 0 ) {
				$ekoterra_css .= 'background-color: ' . esc_attr(
					1 == $ekoterra_bg_mask ? $ekoterra_bg_color : ekoterra_hex2rgba( $ekoterra_bg_color, $ekoterra_bg_mask )
				) . ';';
			}
			if ( ! empty( $ekoterra_css ) ) {
				echo ' style="' . esc_attr( $ekoterra_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$ekoterra_caption = ekoterra_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $ekoterra_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $ekoterra_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $ekoterra_caption, 'ekoterra_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$ekoterra_description = ekoterra_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $ekoterra_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $ekoterra_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $ekoterra_description ), 'ekoterra_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( ekoterra_get_theme_option( 'front_page_title_button1_link' ) != '' || ekoterra_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						ekoterra_show_layout( ekoterra_customizer_partial_refresh_front_page_title_button1_link() );
						ekoterra_show_layout( ekoterra_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
