<div class="front_page_section front_page_section_woocommerce<?php
	$ekoterra_scheme = ekoterra_get_theme_option( 'front_page_woocommerce_scheme' );
	if ( ! ekoterra_is_inherit( $ekoterra_scheme ) ) {
		echo ' scheme_' . esc_attr( $ekoterra_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( ekoterra_get_theme_option( 'front_page_woocommerce_paddings' ) );
?>"
		<?php
		$ekoterra_css      = '';
		$ekoterra_bg_image = ekoterra_get_theme_option( 'front_page_woocommerce_bg_image' );
		if ( ! empty( $ekoterra_bg_image ) ) {
			$ekoterra_css .= 'background-image: url(' . esc_url( ekoterra_get_attachment_url( $ekoterra_bg_image ) ) . ');';
		}
		if ( ! empty( $ekoterra_css ) ) {
			echo ' style="' . esc_attr( $ekoterra_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$ekoterra_anchor_icon = ekoterra_get_theme_option( 'front_page_woocommerce_anchor_icon' );
	$ekoterra_anchor_text = ekoterra_get_theme_option( 'front_page_woocommerce_anchor_text' );
if ( ( ! empty( $ekoterra_anchor_icon ) || ! empty( $ekoterra_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_woocommerce"'
									. ( ! empty( $ekoterra_anchor_icon ) ? ' icon="' . esc_attr( $ekoterra_anchor_icon ) . '"' : '' )
									. ( ! empty( $ekoterra_anchor_text ) ? ' title="' . esc_attr( $ekoterra_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_woocommerce_inner
	<?php
	if ( ekoterra_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
		echo ' ekoterra-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$ekoterra_css      = '';
			$ekoterra_bg_mask  = ekoterra_get_theme_option( 'front_page_woocommerce_bg_mask' );
			$ekoterra_bg_color_type = ekoterra_get_theme_option( 'front_page_woocommerce_bg_color_type' );
			if ( 'custom' == $ekoterra_bg_color_type ) {
				$ekoterra_bg_color = ekoterra_get_theme_option( 'front_page_woocommerce_bg_color' );
			} elseif ( 'scheme_bg_color' == $ekoterra_bg_color_type ) {
				$ekoterra_bg_color = ekoterra_get_scheme_color( 'bg_color', $ekoterra_scheme );
			} else {
				$ekoterra_bg_color = '';
			}
			if ( ! empty( $ekoterra_bg_color ) && $ekoterra_bg_mask > 0 ) {
				$ekoterra_css .= 'background-color: ' . esc_attr(
					1 == $ekoterra_bg_mask ? $ekoterra_bg_color : ekoterra_hex2rgba( $ekoterra_bg_color, $ekoterra_bg_mask )
				) . ';';
			}
			if ( ! empty( $ekoterra_css ) ) {
				echo ' style="' . esc_attr( $ekoterra_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
			<?php
			// Content wrap with title and description
			$ekoterra_caption     = ekoterra_get_theme_option( 'front_page_woocommerce_caption' );
			$ekoterra_description = ekoterra_get_theme_option( 'front_page_woocommerce_description' );
			if ( ! empty( $ekoterra_caption ) || ! empty( $ekoterra_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				// Caption
				if ( ! empty( $ekoterra_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $ekoterra_caption ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( $ekoterra_caption, 'ekoterra_kses_content' );
					?>
					</h2>
					<?php
				}

				// Description (text)
				if ( ! empty( $ekoterra_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $ekoterra_description ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( wpautop( $ekoterra_description ), 'ekoterra_kses_content' );
					?>
					</div>
					<?php
				}
			}

			// Content (widgets)
			?>
			<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
			<?php
				$ekoterra_woocommerce_sc = ekoterra_get_theme_option( 'front_page_woocommerce_products' );
			if ( 'products' == $ekoterra_woocommerce_sc ) {
				$ekoterra_woocommerce_sc_ids      = ekoterra_get_theme_option( 'front_page_woocommerce_products_per_page' );
				$ekoterra_woocommerce_sc_per_page = count( explode( ',', $ekoterra_woocommerce_sc_ids ) );
			} else {
				$ekoterra_woocommerce_sc_per_page = max( 1, (int) ekoterra_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
			}
				$ekoterra_woocommerce_sc_columns = max( 1, min( $ekoterra_woocommerce_sc_per_page, (int) ekoterra_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
				echo do_shortcode(
					"[{$ekoterra_woocommerce_sc}"
									. ( 'products' == $ekoterra_woocommerce_sc
											? ' ids="' . esc_attr( $ekoterra_woocommerce_sc_ids ) . '"'
											: '' )
									. ( 'product_category' == $ekoterra_woocommerce_sc
											? ' category="' . esc_attr( ekoterra_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
											: '' )
									. ( 'best_selling_products' != $ekoterra_woocommerce_sc
											? ' orderby="' . esc_attr( ekoterra_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
												. ' order="' . esc_attr( ekoterra_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
											: '' )
									. ' per_page="' . esc_attr( $ekoterra_woocommerce_sc_per_page ) . '"'
									. ' columns="' . esc_attr( $ekoterra_woocommerce_sc_columns ) . '"'
					. ']'
				);
				?>
			</div>
		</div>
	</div>
</div>
