<?php
/**
 * Theme storage manipulations
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) {
	exit; }

// Get theme variable
if ( ! function_exists( 'ekoterra_storage_get' ) ) {
	function ekoterra_storage_get( $var_name, $default = '' ) {
		global $EKOTERRA_STORAGE;
		return isset( $EKOTERRA_STORAGE[ $var_name ] ) ? $EKOTERRA_STORAGE[ $var_name ] : $default;
	}
}

// Set theme variable
if ( ! function_exists( 'ekoterra_storage_set' ) ) {
	function ekoterra_storage_set( $var_name, $value ) {
		global $EKOTERRA_STORAGE;
		$EKOTERRA_STORAGE[ $var_name ] = $value;
	}
}

// Check if theme variable is empty
if ( ! function_exists( 'ekoterra_storage_empty' ) ) {
	function ekoterra_storage_empty( $var_name, $key = '', $key2 = '' ) {
		global $EKOTERRA_STORAGE;
		if ( ! empty( $key ) && ! empty( $key2 ) ) {
			return empty( $EKOTERRA_STORAGE[ $var_name ][ $key ][ $key2 ] );
		} elseif ( ! empty( $key ) ) {
			return empty( $EKOTERRA_STORAGE[ $var_name ][ $key ] );
		} else {
			return empty( $EKOTERRA_STORAGE[ $var_name ] );
		}
	}
}

// Check if theme variable is set
if ( ! function_exists( 'ekoterra_storage_isset' ) ) {
	function ekoterra_storage_isset( $var_name, $key = '', $key2 = '' ) {
		global $EKOTERRA_STORAGE;
		if ( ! empty( $key ) && ! empty( $key2 ) ) {
			return isset( $EKOTERRA_STORAGE[ $var_name ][ $key ][ $key2 ] );
		} elseif ( ! empty( $key ) ) {
			return isset( $EKOTERRA_STORAGE[ $var_name ][ $key ] );
		} else {
			return isset( $EKOTERRA_STORAGE[ $var_name ] );
		}
	}
}

// Inc/Dec theme variable with specified value
if ( ! function_exists( 'ekoterra_storage_inc' ) ) {
	function ekoterra_storage_inc( $var_name, $value = 1 ) {
		global $EKOTERRA_STORAGE;
		if ( empty( $EKOTERRA_STORAGE[ $var_name ] ) ) {
			$EKOTERRA_STORAGE[ $var_name ] = 0;
		}
		$EKOTERRA_STORAGE[ $var_name ] += $value;
	}
}

// Concatenate theme variable with specified value
if ( ! function_exists( 'ekoterra_storage_concat' ) ) {
	function ekoterra_storage_concat( $var_name, $value ) {
		global $EKOTERRA_STORAGE;
		if ( empty( $EKOTERRA_STORAGE[ $var_name ] ) ) {
			$EKOTERRA_STORAGE[ $var_name ] = '';
		}
		$EKOTERRA_STORAGE[ $var_name ] .= $value;
	}
}

// Get array (one or two dim) element
if ( ! function_exists( 'ekoterra_storage_get_array' ) ) {
	function ekoterra_storage_get_array( $var_name, $key, $key2 = '', $default = '' ) {
		global $EKOTERRA_STORAGE;
		if ( empty( $key2 ) ) {
			return ! empty( $var_name ) && ! empty( $key ) && isset( $EKOTERRA_STORAGE[ $var_name ][ $key ] ) ? $EKOTERRA_STORAGE[ $var_name ][ $key ] : $default;
		} else {
			return ! empty( $var_name ) && ! empty( $key ) && isset( $EKOTERRA_STORAGE[ $var_name ][ $key ][ $key2 ] ) ? $EKOTERRA_STORAGE[ $var_name ][ $key ][ $key2 ] : $default;
		}
	}
}

// Set array element
if ( ! function_exists( 'ekoterra_storage_set_array' ) ) {
	function ekoterra_storage_set_array( $var_name, $key, $value ) {
		global $EKOTERRA_STORAGE;
		if ( ! isset( $EKOTERRA_STORAGE[ $var_name ] ) ) {
			$EKOTERRA_STORAGE[ $var_name ] = array();
		}
		if ( '' === $key ) {
			$EKOTERRA_STORAGE[ $var_name ][] = $value;
		} else {
			$EKOTERRA_STORAGE[ $var_name ][ $key ] = $value;
		}
	}
}

// Set two-dim array element
if ( ! function_exists( 'ekoterra_storage_set_array2' ) ) {
	function ekoterra_storage_set_array2( $var_name, $key, $key2, $value ) {
		global $EKOTERRA_STORAGE;
		if ( ! isset( $EKOTERRA_STORAGE[ $var_name ] ) ) {
			$EKOTERRA_STORAGE[ $var_name ] = array();
		}
		if ( ! isset( $EKOTERRA_STORAGE[ $var_name ][ $key ] ) ) {
			$EKOTERRA_STORAGE[ $var_name ][ $key ] = array();
		}
		if ( '' === $key2 ) {
			$EKOTERRA_STORAGE[ $var_name ][ $key ][] = $value;
		} else {
			$EKOTERRA_STORAGE[ $var_name ][ $key ][ $key2 ] = $value;
		}
	}
}

// Merge array elements
if ( ! function_exists( 'ekoterra_storage_merge_array' ) ) {
	function ekoterra_storage_merge_array( $var_name, $key, $value ) {
		global $EKOTERRA_STORAGE;
		if ( ! isset( $EKOTERRA_STORAGE[ $var_name ] ) ) {
			$EKOTERRA_STORAGE[ $var_name ] = array();
		}
		if ( '' === $key ) {
			$EKOTERRA_STORAGE[ $var_name ] = array_merge( $EKOTERRA_STORAGE[ $var_name ], $value );
		} else {
			$EKOTERRA_STORAGE[ $var_name ][ $key ] = array_merge( $EKOTERRA_STORAGE[ $var_name ][ $key ], $value );
		}
	}
}

// Add array element after the key
if ( ! function_exists( 'ekoterra_storage_set_array_after' ) ) {
	function ekoterra_storage_set_array_after( $var_name, $after, $key, $value = '' ) {
		global $EKOTERRA_STORAGE;
		if ( ! isset( $EKOTERRA_STORAGE[ $var_name ] ) ) {
			$EKOTERRA_STORAGE[ $var_name ] = array();
		}
		if ( is_array( $key ) ) {
			ekoterra_array_insert_after( $EKOTERRA_STORAGE[ $var_name ], $after, $key );
		} else {
			ekoterra_array_insert_after( $EKOTERRA_STORAGE[ $var_name ], $after, array( $key => $value ) );
		}
	}
}

// Add array element before the key
if ( ! function_exists( 'ekoterra_storage_set_array_before' ) ) {
	function ekoterra_storage_set_array_before( $var_name, $before, $key, $value = '' ) {
		global $EKOTERRA_STORAGE;
		if ( ! isset( $EKOTERRA_STORAGE[ $var_name ] ) ) {
			$EKOTERRA_STORAGE[ $var_name ] = array();
		}
		if ( is_array( $key ) ) {
			ekoterra_array_insert_before( $EKOTERRA_STORAGE[ $var_name ], $before, $key );
		} else {
			ekoterra_array_insert_before( $EKOTERRA_STORAGE[ $var_name ], $before, array( $key => $value ) );
		}
	}
}

// Push element into array
if ( ! function_exists( 'ekoterra_storage_push_array' ) ) {
	function ekoterra_storage_push_array( $var_name, $key, $value ) {
		global $EKOTERRA_STORAGE;
		if ( ! isset( $EKOTERRA_STORAGE[ $var_name ] ) ) {
			$EKOTERRA_STORAGE[ $var_name ] = array();
		}
		if ( '' === $key ) {
			array_push( $EKOTERRA_STORAGE[ $var_name ], $value );
		} else {
			if ( ! isset( $EKOTERRA_STORAGE[ $var_name ][ $key ] ) ) {
				$EKOTERRA_STORAGE[ $var_name ][ $key ] = array();
			}
			array_push( $EKOTERRA_STORAGE[ $var_name ][ $key ], $value );
		}
	}
}

// Pop element from array
if ( ! function_exists( 'ekoterra_storage_pop_array' ) ) {
	function ekoterra_storage_pop_array( $var_name, $key = '', $defa = '' ) {
		global $EKOTERRA_STORAGE;
		$rez = $defa;
		if ( '' === $key ) {
			if ( isset( $EKOTERRA_STORAGE[ $var_name ] ) && is_array( $EKOTERRA_STORAGE[ $var_name ] ) && count( $EKOTERRA_STORAGE[ $var_name ] ) > 0 ) {
				$rez = array_pop( $EKOTERRA_STORAGE[ $var_name ] );
			}
		} else {
			if ( isset( $EKOTERRA_STORAGE[ $var_name ][ $key ] ) && is_array( $EKOTERRA_STORAGE[ $var_name ][ $key ] ) && count( $EKOTERRA_STORAGE[ $var_name ][ $key ] ) > 0 ) {
				$rez = array_pop( $EKOTERRA_STORAGE[ $var_name ][ $key ] );
			}
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if ( ! function_exists( 'ekoterra_storage_inc_array' ) ) {
	function ekoterra_storage_inc_array( $var_name, $key, $value = 1 ) {
		global $EKOTERRA_STORAGE;
		if ( ! isset( $EKOTERRA_STORAGE[ $var_name ] ) ) {
			$EKOTERRA_STORAGE[ $var_name ] = array();
		}
		if ( empty( $EKOTERRA_STORAGE[ $var_name ][ $key ] ) ) {
			$EKOTERRA_STORAGE[ $var_name ][ $key ] = 0;
		}
		$EKOTERRA_STORAGE[ $var_name ][ $key ] += $value;
	}
}

// Concatenate array element with specified value
if ( ! function_exists( 'ekoterra_storage_concat_array' ) ) {
	function ekoterra_storage_concat_array( $var_name, $key, $value ) {
		global $EKOTERRA_STORAGE;
		if ( ! isset( $EKOTERRA_STORAGE[ $var_name ] ) ) {
			$EKOTERRA_STORAGE[ $var_name ] = array();
		}
		if ( empty( $EKOTERRA_STORAGE[ $var_name ][ $key ] ) ) {
			$EKOTERRA_STORAGE[ $var_name ][ $key ] = '';
		}
		$EKOTERRA_STORAGE[ $var_name ][ $key ] .= $value;
	}
}

// Call object's method
if ( ! function_exists( 'ekoterra_storage_call_obj_method' ) ) {
	function ekoterra_storage_call_obj_method( $var_name, $method, $param = null ) {
		global $EKOTERRA_STORAGE;
		if ( null === $param ) {
			return ! empty( $var_name ) && ! empty( $method ) && isset( $EKOTERRA_STORAGE[ $var_name ] ) ? $EKOTERRA_STORAGE[ $var_name ]->$method() : '';
		} else {
			return ! empty( $var_name ) && ! empty( $method ) && isset( $EKOTERRA_STORAGE[ $var_name ] ) ? $EKOTERRA_STORAGE[ $var_name ]->$method( $param ) : '';
		}
	}
}

// Get object's property
if ( ! function_exists( 'ekoterra_storage_get_obj_property' ) ) {
	function ekoterra_storage_get_obj_property( $var_name, $prop, $default = '' ) {
		global $EKOTERRA_STORAGE;
		return ! empty( $var_name ) && ! empty( $prop ) && isset( $EKOTERRA_STORAGE[ $var_name ]->$prop ) ? $EKOTERRA_STORAGE[ $var_name ]->$prop : $default;
	}
}
