<?php
/**
 * The template for homepage posts with "Classic" style
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0
 */

ekoterra_storage_set( 'blog_archive', true );

get_header();

if ( have_posts() ) {

	ekoterra_blog_archive_start();

	$ekoterra_classes    = 'posts_container '
						. ( substr( ekoterra_get_theme_option( 'blog_style' ), 0, 7 ) == 'classic'
							? 'columns_wrap columns_padding_bottom'
							: 'masonry_wrap'
							);
	$ekoterra_stickies   = is_home() ? get_option( 'sticky_posts' ) : false;
	$ekoterra_sticky_out = ekoterra_get_theme_option( 'sticky_style' ) == 'columns'
							&& is_array( $ekoterra_stickies ) && count( $ekoterra_stickies ) > 0 && get_query_var( 'paged' ) < 1;
	if ( $ekoterra_sticky_out ) {
		?>
		<div class="sticky_wrap columns_wrap">
		<?php
	}
	if ( ! $ekoterra_sticky_out ) {
		if ( ekoterra_get_theme_option( 'first_post_large' ) && ! is_paged() && ! in_array( ekoterra_get_theme_option( 'body_style' ), array( 'fullwide', 'fullscreen' ) ) ) {
			the_post();
			get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'content', 'excerpt' ), 'excerpt' );
		}

		?>
		<div class="<?php echo esc_attr( $ekoterra_classes ); ?>">
		<?php
	}
	while ( have_posts() ) {
		the_post();
		if ( $ekoterra_sticky_out && ! is_sticky() ) {
			$ekoterra_sticky_out = false;
			?>
			</div><div class="<?php echo esc_attr( $ekoterra_classes ); ?>">
			<?php
		}
		$ekoterra_part = $ekoterra_sticky_out && is_sticky() ? 'sticky' : 'classic';
		get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'content', $ekoterra_part ), $ekoterra_part );
	}

	?>
	</div>
	<?php

	ekoterra_show_pagination();

	ekoterra_blog_archive_end();

} else {

	if ( is_search() ) {
		get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'content', 'none-search' ), 'none-search' );
	} else {
		get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'content', 'none-archive' ), 'none-archive' );
	}
}

get_footer();
