<?php
/**
 * The template for homepage posts with custom style
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0.50
 */

ekoterra_storage_set( 'blog_archive', true );

get_header();

if ( have_posts() ) {

	$ekoterra_blog_style = ekoterra_get_theme_option( 'blog_style' );
	$ekoterra_parts      = explode( '_', $ekoterra_blog_style );
	$ekoterra_columns    = ! empty( $ekoterra_parts[1] ) ? max( 1, min( 6, (int) $ekoterra_parts[1] ) ) : 1;
	$ekoterra_blog_id    = ekoterra_get_custom_blog_id( $ekoterra_blog_style );
	$ekoterra_blog_meta  = ekoterra_get_custom_layout_meta( $ekoterra_blog_id );
	if ( ! empty( $ekoterra_blog_meta['margin'] ) ) {
		ekoterra_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( ekoterra_prepare_css_value( $ekoterra_blog_meta['margin'] ) ) ) );
	}
	$ekoterra_custom_style = ! empty( $ekoterra_blog_meta['scripts_required'] ) ? $ekoterra_blog_meta['scripts_required'] : 'none';

	ekoterra_blog_archive_start();

	$ekoterra_classes    = 'posts_container blog_custom_wrap' 
							. ( ! ekoterra_is_off( $ekoterra_custom_style )
								? sprintf( ' %s_wrap', $ekoterra_custom_style )
								: ( $ekoterra_columns > 1 
									? ' columns_wrap columns_padding_bottom' 
									: ''
									)
								);
	$ekoterra_stickies   = is_home() ? get_option( 'sticky_posts' ) : false;
	$ekoterra_sticky_out = ekoterra_get_theme_option( 'sticky_style' ) == 'columns'
							&& is_array( $ekoterra_stickies ) && count( $ekoterra_stickies ) > 0 && get_query_var( 'paged' ) < 1;
	if ( $ekoterra_sticky_out ) {
		?>
		<div class="sticky_wrap columns_wrap">
		<?php
	}
	if ( ! $ekoterra_sticky_out ) {
		if ( ekoterra_get_theme_option( 'first_post_large' ) && ! is_paged() && ! in_array( ekoterra_get_theme_option( 'body_style' ), array( 'fullwide', 'fullscreen' ) ) ) {
			the_post();
			get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'content', 'excerpt' ), 'excerpt' );
		}
		?>
		<div class="<?php echo esc_attr( $ekoterra_classes ); ?>">
		<?php
	}
	while ( have_posts() ) {
		the_post();
		if ( $ekoterra_sticky_out && ! is_sticky() ) {
			$ekoterra_sticky_out = false;
			?>
			</div><div class="<?php echo esc_attr( $ekoterra_classes ); ?>">
			<?php
		}
		$ekoterra_part = $ekoterra_sticky_out && is_sticky() ? 'sticky' : 'custom';
		get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'content', $ekoterra_part ), $ekoterra_part );
	}
	?>
	</div>
	<?php

	ekoterra_show_pagination();

	ekoterra_blog_archive_end();

} else {

	if ( is_search() ) {
		get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'content', 'none-search' ), 'none-search' );
	} else {
		get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'content', 'none-archive' ), 'none-archive' );
	}
}

get_footer();
