<?php
/**
 * The template for homepage posts with "Excerpt" style
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0
 */

ekoterra_storage_set( 'blog_archive', true );

get_header();

if ( have_posts() ) {

	ekoterra_blog_archive_start();

	?><div class="posts_container">
		<?php

		$ekoterra_stickies   = is_home() ? get_option( 'sticky_posts' ) : false;
		$ekoterra_sticky_out = ekoterra_get_theme_option( 'sticky_style' ) == 'columns'
								&& is_array( $ekoterra_stickies ) && count( $ekoterra_stickies ) > 0 && get_query_var( 'paged' ) < 1;
		if ( $ekoterra_sticky_out ) {
			?>
			<div class="sticky_wrap columns_wrap">
			<?php
		}
		while ( have_posts() ) {
			the_post();
			if ( $ekoterra_sticky_out && ! is_sticky() ) {
				$ekoterra_sticky_out = false;
				?>
				</div>
				<?php
			}
			$ekoterra_part = $ekoterra_sticky_out && is_sticky() ? 'sticky' : 'excerpt';
			get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'content', $ekoterra_part ), $ekoterra_part );
		}
		if ( $ekoterra_sticky_out ) {
			$ekoterra_sticky_out = false;
			?>
			</div>
			<?php
		}

		?>
	</div>
	<?php

	ekoterra_show_pagination();

	ekoterra_blog_archive_end();

} else {

	if ( is_search() ) {
		get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'content', 'none-search' ), 'none-search' );
	} else {
		get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'content', 'none-archive' ), 'none-archive' );
	}
}

get_footer();
