<?php
/**
 * The template for homepage posts with "Portfolio" style
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0
 */

ekoterra_storage_set( 'blog_archive', true );

get_header();

if ( have_posts() ) {

	ekoterra_blog_archive_start();

	$ekoterra_stickies   = is_home() ? get_option( 'sticky_posts' ) : false;
	$ekoterra_sticky_out = ekoterra_get_theme_option( 'sticky_style' ) == 'columns'
							&& is_array( $ekoterra_stickies ) && count( $ekoterra_stickies ) > 0 && get_query_var( 'paged' ) < 1;

	// Show filters
	$ekoterra_cat          = ekoterra_get_theme_option( 'parent_cat' );
	$ekoterra_post_type    = ekoterra_get_theme_option( 'post_type' );
	$ekoterra_taxonomy     = ekoterra_get_post_type_taxonomy( $ekoterra_post_type );
	$ekoterra_show_filters = ekoterra_get_theme_option( 'show_filters' );
	$ekoterra_tabs         = array();
	if ( ! ekoterra_is_off( $ekoterra_show_filters ) ) {
		$ekoterra_args           = array(
			'type'         => $ekoterra_post_type,
			'child_of'     => $ekoterra_cat,
			'orderby'      => 'name',
			'order'        => 'ASC',
			'hide_empty'   => 1,
			'hierarchical' => 0,
			'taxonomy'     => $ekoterra_taxonomy,
			'pad_counts'   => false,
		);
		$ekoterra_portfolio_list = get_terms( $ekoterra_args );
		if ( is_array( $ekoterra_portfolio_list ) && count( $ekoterra_portfolio_list ) > 0 ) {
			$ekoterra_tabs[ $ekoterra_cat ] = esc_html__( 'All', 'ekoterra' );
			foreach ( $ekoterra_portfolio_list as $ekoterra_term ) {
				if ( isset( $ekoterra_term->term_id ) ) {
					$ekoterra_tabs[ $ekoterra_term->term_id ] = $ekoterra_term->name;
				}
			}
		}
	}
	if ( count( $ekoterra_tabs ) > 0 ) {
		$ekoterra_portfolio_filters_ajax   = true;
		$ekoterra_portfolio_filters_active = $ekoterra_cat;
		$ekoterra_portfolio_filters_id     = 'portfolio_filters';
		?>
		<div class="portfolio_filters ekoterra_tabs ekoterra_tabs_ajax">
			<ul class="portfolio_titles ekoterra_tabs_titles">
				<?php
				foreach ( $ekoterra_tabs as $ekoterra_id => $ekoterra_title ) {
					?>
					<li><a href="<?php echo esc_url( ekoterra_get_hash_link( sprintf( '#%s_%s_content', $ekoterra_portfolio_filters_id, $ekoterra_id ) ) ); ?>" data-tab="<?php echo esc_attr( $ekoterra_id ); ?>"><?php echo esc_html( $ekoterra_title ); ?></a></li>
					<?php
				}
				?>
			</ul>
			<?php
			$ekoterra_ppp = ekoterra_get_theme_option( 'posts_per_page' );
			if ( ekoterra_is_inherit( $ekoterra_ppp ) ) {
				$ekoterra_ppp = '';
			}
			foreach ( $ekoterra_tabs as $ekoterra_id => $ekoterra_title ) {
				$ekoterra_portfolio_need_content = $ekoterra_id == $ekoterra_portfolio_filters_active || ! $ekoterra_portfolio_filters_ajax;
				?>
				<div id="<?php echo esc_attr( sprintf( '%s_%s_content', $ekoterra_portfolio_filters_id, $ekoterra_id ) ); ?>"
					class="portfolio_content ekoterra_tabs_content"
					data-blog-template="<?php echo esc_attr( ekoterra_storage_get( 'blog_template' ) ); ?>"
					data-blog-style="<?php echo esc_attr( ekoterra_get_theme_option( 'blog_style' ) ); ?>"
					data-posts-per-page="<?php echo esc_attr( $ekoterra_ppp ); ?>"
					data-post-type="<?php echo esc_attr( $ekoterra_post_type ); ?>"
					data-taxonomy="<?php echo esc_attr( $ekoterra_taxonomy ); ?>"
					data-cat="<?php echo esc_attr( $ekoterra_id ); ?>"
					data-parent-cat="<?php echo esc_attr( $ekoterra_cat ); ?>"
					data-need-content="<?php echo ( false === $ekoterra_portfolio_need_content ? 'true' : 'false' ); ?>"
				>
					<?php
					if ( $ekoterra_portfolio_need_content ) {
						ekoterra_show_portfolio_posts(
							array(
								'cat'        => $ekoterra_id,
								'parent_cat' => $ekoterra_cat,
								'taxonomy'   => $ekoterra_taxonomy,
								'post_type'  => $ekoterra_post_type,
								'page'       => 1,
								'sticky'     => $ekoterra_sticky_out,
							)
						);
					}
					?>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	} else {
		ekoterra_show_portfolio_posts(
			array(
				'cat'        => $ekoterra_cat,
				'parent_cat' => $ekoterra_cat,
				'taxonomy'   => $ekoterra_taxonomy,
				'post_type'  => $ekoterra_post_type,
				'page'       => 1,
				'sticky'     => $ekoterra_sticky_out,
			)
		);
	}

	ekoterra_blog_archive_end();

} else {

	if ( is_search() ) {
		get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'content', 'none-search' ), 'none-search' );
	} else {
		get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'content', 'none-archive' ), 'none-archive' );
	}
}

get_footer();
