<?php
/* Elementor timeline widget support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'ekoterra_elementor_timeline_widget_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'ekoterra_elementor_timeline_widget_theme_setup9', 9 );
	function ekoterra_elementor_timeline_widget_theme_setup9() {
		if ( is_admin() ) {
			add_filter( 'ekoterra_filter_tgmpa_required_plugins', 'ekoterra_elementor_timeline_widget_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'ekoterra_elementor_timeline_widget_tgmpa_required_plugins' ) ) {

	function ekoterra_elementor_timeline_widget_tgmpa_required_plugins( $list = array() ) {
		if ( ekoterra_storage_isset( 'required_plugins', '3r-elementor-timeline-widget' ) ) {
			// elementor_timeline_widget plugin
			$list[] = array(
				'name'     => ekoterra_storage_get_array( 'required_plugins', '3r-elementor-timeline-widget' ),
				'slug'     => '3r-elementor-timeline-widget',
				'required' => false,
			);
		}
		return $list;
	}
}

// Check if elementor_timeline_widget installed and activated
if ( ! function_exists( 'ekoterra_exists_elementor_timeline_widget' ) ) {
	function ekoterra_exists_elementor_timeline_widget() {
		return class_exists( 'ThreeElementorTimeline' );
	}
}