<?php
/* Civist support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'ekoterra_civist_theme_setup9' ) ) {
    add_action( 'after_setup_theme', 'ekoterra_civist_theme_setup9', 9 );
    function ekoterra_civist_theme_setup9() {
        if ( ekoterra_exists_civist() ) {
        }
        if ( is_admin() ) {
            add_filter( 'ekoterra_filter_tgmpa_required_plugins', 'ekoterra_civist_tgmpa_required_plugins' );
        }
    }
}

// Filter to add in the required plugins list
if ( ! function_exists( 'ekoterra_civist_tgmpa_required_plugins' ) ) {
        function ekoterra_civist_tgmpa_required_plugins( $list = array() ) {
        if ( ekoterra_storage_isset( 'required_plugins', 'civist' ) ) {
            $list[] = array(
                'name'     => ekoterra_storage_get_array( 'required_plugins', 'civist' ),
                'slug'     => 'civist',
                'required' => false,
            );
        }
        return $list;
    }
}

// Check if plugin installed and activated
if ( ! function_exists( 'ekoterra_exists_civist' ) ) {
    function ekoterra_exists_civist() {
        return function_exists( 'run_civist' );
    }
}