<?php
/* Contact Form 7 support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'ekoterra_cf7_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'ekoterra_cf7_theme_setup9', 9 );
	function ekoterra_cf7_theme_setup9() {

		add_filter( 'ekoterra_filter_merge_scripts', 'ekoterra_cf7_merge_scripts' );
		add_filter( 'ekoterra_filter_merge_styles', 'ekoterra_cf7_merge_styles' );

		if ( ekoterra_exists_cf7() ) {
			add_filter('wpcf7_autop_or_not', '__return_false');
			add_action( 'wp_enqueue_scripts', 'ekoterra_cf7_frontend_scripts', 1100 );
		}

		if ( is_admin() ) {
			add_filter( 'ekoterra_filter_tgmpa_required_plugins', 'ekoterra_cf7_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'ekoterra_cf7_tgmpa_required_plugins' ) ) {
	
	function ekoterra_cf7_tgmpa_required_plugins( $list = array() ) {
		if ( ekoterra_storage_isset( 'required_plugins', 'contact-form-7' ) ) {
			// CF7 plugin
			$list[] = array(
				'name'     => ekoterra_storage_get_array( 'required_plugins', 'contact-form-7' ),
				'slug'     => 'contact-form-7',
				'required' => false,
			);
		}
		return $list;
	}
}



// Check if cf7 installed and activated
if ( ! function_exists( 'ekoterra_exists_cf7' ) ) {
	function ekoterra_exists_cf7() {
		return class_exists( 'WPCF7' );
	}
}

// Enqueue custom scripts
if ( ! function_exists( 'ekoterra_cf7_frontend_scripts' ) ) {
	
	function ekoterra_cf7_frontend_scripts() {
		if ( ekoterra_exists_cf7() ) {
			if ( ekoterra_is_on( ekoterra_get_theme_option( 'debug_mode' ) ) ) {
				$ekoterra_url = ekoterra_get_file_url( 'plugins/contact-form-7/contact-form-7.js' );
				if ( '' != $ekoterra_url ) {
					wp_enqueue_script( 'ekoterra-cf7', $ekoterra_url, array( 'jquery' ), null, true );
				}
			}
		}
	}
}

// Merge custom scripts
if ( ! function_exists( 'ekoterra_cf7_merge_scripts' ) ) {
	
	function ekoterra_cf7_merge_scripts( $list ) {
		if ( ekoterra_exists_cf7() ) {
			$list[] = 'plugins/contact-form-7/contact-form-7.js';
		}
		return $list;
	}
}

// Merge custom styles
if ( ! function_exists( 'ekoterra_cf7_merge_styles' ) ) {
	
	function ekoterra_cf7_merge_styles( $list ) {
		if ( ekoterra_exists_cf7() ) {
			$list[] = 'plugins/contact-form-7/_contact-form-7.scss';
		}
		return $list;
	}
}

