<?php
// Add plugin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'ekoterra_content_timeline_get_css' ) ) {
	add_filter( 'ekoterra_filter_get_css', 'ekoterra_content_timeline_get_css', 10, 2 );
	function ekoterra_content_timeline_get_css( $css, $args ) {
		if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
			$fonts         = $args['fonts'];
			$css['fonts'] .= <<<CSS
			
.timeline.my_style_style_4 .t_line_month,
.timeline.my_style_style_4 a.t_line_node,
.timeline.my_style_style_4 .item .my_timeline_content .read_more {
	{$fonts['p_font-family']}
}

.timeline .item .post_date{
    {$fonts['info_font-family']}
	{$fonts['info_font-weight']}
	{$fonts['info_font-style']}
	{$fonts['info_line-height']}
	{$fonts['info_text-decoration']}
	{$fonts['info_text-transform']}
	{$fonts['info_letter-spacing']}
	{$fonts['info_margin-top']}
	{$fonts['info_margin-bottom']}
}

.timeline .item .read_more, #content .timeline .item .read_more{
    {$fonts['button_font-family']}
	{$fonts['button_font-size']}
	{$fonts['button_font-weight']}
	{$fonts['button_font-style']}
	{$fonts['button_line-height']}
	{$fonts['button_text-decoration']}
	{$fonts['button_text-transform']}
	{$fonts['button_letter-spacing']}
}


CSS;
		}

		if ( isset( $css['colors'] ) && isset( $args['colors'] ) ) {
			$colors         = $args['colors'];
			$css['colors'] .= <<<CSS

/* Timeline */
.timeline.my_style_style_4 .timeline_line {
	background-color: {$colors['text_dark']};
	color: {$colors['text']};
}
.timeline.my_style_style_4 .t_line_month {
	color: {$colors['bg_color']};
}
.timeline.my_style_style_4 .t_line_wrapper:after {
	border-bottom-color: {$colors['text_link']} !important;
}
#tl1.timeline.my_style_style_4 .t_line_node {
	color: {$colors['text']} !important;
}
#tl1.timeline.my_style_style_4 .t_line_node.active {
	color: {$colors['bg_color']} !important;
}
#tl1.timeline.my_style_style_4 .t_line_node:after {
	background: {$colors['text_link']} !important;
}
#tl1.timeline.my_style_style_4 .t_line_node.active:after {
	border-color: {$colors['text_link']} !important;
	background: {$colors['text_dark']} !important;
}
#tl1.timeline.my_style_style_4 #t_line_left, 
#tl1.timeline.my_style_style_4 #t_line_right {
	color: {$colors['text_link']} !important;
}
#tl1.timeline.my_style_style_4 #t_line_left:hover, 
#tl1.timeline.my_style_style_4 #t_line_right:hover {
	color: {$colors['bg_color']} !important;
}
.timeline.my_style_style_4 .t_node_desc {
	color: {$colors['bg_color']};
}
.timeline.my_style_style_4 .t_node_desc span {
	background: {$colors['text_link']} !important;
}
#tl1.timeline.my_style_style_4 .t_node_desc span:after {
	border-top-color: {$colors['text_link']};
}

/* Items */
.timeline.my_style_style_4 .item {
	background: {$colors['bg_color']} !important;
}
.timeline.my_style_style_4 .timeline_items_wrapper .item h2 {
	color: {$colors['text_dark']} !important;
}
.timeline.my_style_style_4 .my_post_date {
	color: {$colors['text_light']} !important;
}
.timeline.my_style_style_4 .my_timeline_content span {
	color: {$colors['text']} !important;
}
#tl1.timeline.my_style_style_4 .my_timeline_content .read_more {
	color: {$colors['text_link']} !important;
}
#tl1.timeline.my_style_style_4 .my_timeline_content .read_more:hover {
	color: {$colors['text_dark']} !important;
}
#tl1.timeline.my_style_style_4 .item_node_hover:before {
	background-color: {$colors['text_link']} !important;
}
#tl1.timeline.my_style_style_4 .item_node_hover:after {
	border-top-color: {$colors['text_link']} !important;
}

#tl1 .item .con_borderImage:before, #content #tl1 .item .con_borderImage:before{
	background-color: {$colors['extra_bg_color']} !important;
}

.timeline .item .post_date{
    color: {$colors['text_light']} !important;
}

#tl1 #t_line_right:hover:before, 
#content #tl1 #t_line_right:hover:before,
#tl1 #t_line_left:hover:before, 
#content #tl1 #t_line_left:hover:before,
.timeline .item .read_more{
    color: {$colors['text_link']} !important;
}
.timeline .item .read_more:hover{
    color: {$colors['text_hover']} !important;
}
#tl1 .t_line_node:after, 
#content #tl1 .t_line_node:after{
     background-color: {$colors['alter_bg_color']} !important;
}

.timeline .t_line_holder:before, #content .timeline .t_line_holder:before{
    background-color: {$colors['input_bd_color']} !important;
}


#tl1 .t_line_node:before, #content #tl1 .t_line_node:before{
    background-color: {$colors['text_link']} !important;
}

#tl1 .t_line_node:after, #content #tl1 .t_line_node:after{
    border-color: {$colors['input_bd_color']} !important;
}


#tl1 .t_line_node.active:after, 
#content #tl1 .t_line_node.active:after,
.timeline a.t_line_node.active:after, 
#content .timeline a.t_line_node.active:after{
    border-color: {$colors['text_link']} !important;
}



CSS;
		}

		return $css;
	}
}

