<?php
/* Content Timeline support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'ekoterra_content_timeline_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'ekoterra_content_timeline_theme_setup9', 9 );
	function ekoterra_content_timeline_theme_setup9() {

		add_filter( 'ekoterra_filter_merge_styles', 'ekoterra_content_timeline_merge_styles' );
		if ( is_admin() ) {
			add_filter( 'ekoterra_filter_tgmpa_required_plugins', 'ekoterra_content_timeline_tgmpa_required_plugins' );
		}

	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'ekoterra_content_timeline_tgmpa_required_plugins' ) ) {
	
	function ekoterra_content_timeline_tgmpa_required_plugins( $list = array() ) {
		if ( ekoterra_storage_isset( 'required_plugins', 'content_timeline' ) && ekoterra_is_theme_activated() ) {
			$path = ekoterra_get_plugin_source_path( 'plugins/content_timeline/content_timeline.zip' );
			if ( ! empty( $path ) || ekoterra_get_theme_setting( 'tgmpa_upload' ) ) {
				$list[] = array(
					'name'     => ekoterra_storage_get_array( 'required_plugins', 'content_timeline' ),
					'slug'     => 'content_timeline',
					'source'   => ! empty( $path ) ? $path : 'upload://content_timeline.zip',
					'required' => false,
				);
			}
		}
		return $list;
	}
}

// Check if plugin is installed and activated
if ( ! function_exists( 'ekoterra_exists_content_timeline' ) ) {
	function ekoterra_exists_content_timeline() {
		return class_exists( 'ContentTimelineAdmin' );
	}
}

// Merge custom styles
if ( ! function_exists( 'ekoterra_content_timeline_merge_styles' ) ) {
	
	function ekoterra_content_timeline_merge_styles( $list ) {
		if ( ekoterra_exists_content_timeline() ) {
			$list[] = 'plugins/content_timeline/_content_timeline.scss';
		}
		return $list;
	}
}



// Add plugin-specific colors and fonts to the custom CSS
if ( ekoterra_exists_content_timeline() ) {
	require_once EKOTERRA_THEME_DIR . 'plugins/content_timeline/content_timeline-styles.php'; }

