<?php
/* Elegro Payment support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'ekoterra_elegro_payment_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'ekoterra_elegro_payment_theme_setup9', 9 );
	function ekoterra_elegro_payment_theme_setup9() {
		if ( is_admin() ) {
			add_filter( 'ekoterra_filter_tgmpa_required_plugins', 'ekoterra_elegro_payment_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'ekoterra_elegro_payment_tgmpa_required_plugins' ) ) {

	function ekoterra_elegro_payment_tgmpa_required_plugins( $list = array() ) {
		if ( ekoterra_storage_isset( 'required_plugins', 'elegro-payment' ) ) {
			// elegro_payment plugin
			$list[] = array(
				'name'     => ekoterra_storage_get_array( 'required_plugins', 'elegro-payment' ),
				'slug'     => 'elegro-payment',
				'required' => false,
			);
		}
		return $list;
	}
}

// Check if elegro_payment installed and activated
if ( ! function_exists( 'ekoterra_exists_elegro_payment' ) ) {
	function ekoterra_exists_elegro_payment() {
		return class_exists( 'WC_Elegro_Payment' );
	}
}