<?php
/* Give (donation forms) support functions
------------------------------------------------------------------------------- */
// Theme init priorities:
// 1 - register filters, that add/remove lists items for the Theme Options
if ( ! function_exists( 'ekoterra_give_theme_setup1' ) ) {
    add_action( 'after_setup_theme', 'ekoterra_give_theme_setup1', 1 );
    function ekoterra_give_theme_setup1() {
        add_filter( 'ekoterra_filter_list_sidebars', 'ekoterra_give_list_sidebars' );
        add_filter( 'ekoterra_filter_detect_blog_mode', 'ekoterra_give_detect_blog_mode' );
    }
}

// Theme init priorities:
// 3 - add/remove Theme Options elements
if ( ! function_exists( 'ekoterra_give_theme_setup3' ) ) {
    add_action( 'after_setup_theme', 'ekoterra_give_theme_setup3', 3 );
    function ekoterra_give_theme_setup3() {
        if ( ekoterra_exists_give() ) {

            // Section 'Give Donation'
            ekoterra_storage_merge_array(
                'options', '', array_merge(
                    array(
                        'give'     => array(
                            'title' => esc_html__( 'Give Donation', 'ekoterra' ),
                            'desc'  => wp_kses_data( __( 'Select parameters to display the community pages', 'ekoterra' ) ),
                            'type'  => 'section',
                        ),
                    ),
                    ekoterra_options_get_list_cpt_options( 'give' )
                )
            );
        }
    }
}
// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'ekoterra_give_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'ekoterra_give_theme_setup9', 9 );
	function ekoterra_give_theme_setup9() {

		add_filter( 'ekoterra_filter_merge_styles', 'ekoterra_give_merge_styles' );

		if ( is_admin() ) {
			add_filter( 'ekoterra_filter_tgmpa_required_plugins', 'ekoterra_give_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'ekoterra_give_tgmpa_required_plugins' ) ) {
	
	function ekoterra_give_tgmpa_required_plugins( $list = array() ) {
		if ( ekoterra_storage_isset( 'required_plugins', 'give' ) ) {

			$list[] = array(
				'name'     => ekoterra_storage_get_array( 'required_plugins', 'give' ),
				'slug'     => 'give',
				'required' => false,
			);
		}
		return $list;
	}
}

// Check if plugin installed and activated
if ( ! function_exists( 'ekoterra_exists_give' ) ) {
    function ekoterra_exists_give() {
        return class_exists( 'Give' );
    }
}

// Return true, if current page is any give page
if ( ! function_exists( 'ekoterra_is_give_page' ) ) {
    function ekoterra_is_give_page() {
        $rez = false;
        if ( ekoterra_exists_give() ) {
            $rez =  is_give_form() || is_singular( 'give_forms' ) || is_give_category() || is_give_tag() || is_give_taxonomy();
        }
        return $rez;
    }
}

// Detect current blog mode
if ( ! function_exists( 'ekoterra_give_detect_blog_mode' ) ) {
    
    function ekoterra_give_detect_blog_mode( $mode = '' ) {
        if ( ekoterra_is_give_page() ) {
            $mode = 'give';
        }
        return $mode;
    }
}


// Return taxonomy for current post type
if ( ! function_exists( 'ekoterra_give_post_type_taxonomy' ) ) {
    
    function ekoterra_give_post_type_taxonomy( $tax = '', $post_type = '' ) {
        if ( 'give_forms' == $post_type ) {
            $tax = 'give_forms_category';
        }
        return $tax;
    }
}

// Merge custom styles
if ( ! function_exists( 'ekoterra_give_merge_styles' ) ) {
	
	function ekoterra_give_merge_styles( $list ) {
		if ( ekoterra_exists_give() ) {
			$list[] = 'plugins/give/_give.scss';
		}
		return $list;
	}
}


// Add Give specific items into lists
//------------------------------------------------------------------------

// Add sidebar
if ( ! function_exists( 'ekoterra_give_list_sidebars' ) ) {
    
    function ekoterra_give_list_sidebars( $list = array() ) {
        $list['give_widgets'] = array(
            'name'        => esc_html__( 'Give Widgets', 'ekoterra' ),
            'description' => esc_html__( 'Widgets to be shown on the Give pages', 'ekoterra' ),
        );
        return $list;
    }
}


// Add plugin-specific colors and fonts to the custom CSS
if ( ekoterra_exists_give() ) {
	require_once EKOTERRA_THEME_DIR . 'plugins/give/give-styles.php'; }

