<?php
/* Gutenberg support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'ekoterra_gutenberg_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'ekoterra_gutenberg_theme_setup9', 9 );
	function ekoterra_gutenberg_theme_setup9() {

		add_filter( 'ekoterra_filter_merge_styles', 'ekoterra_gutenberg_merge_styles' );
		add_filter( 'ekoterra_filter_merge_styles_responsive', 'ekoterra_gutenberg_merge_styles_responsive' );
		add_action( 'enqueue_block_editor_assets', 'ekoterra_gutenberg_editor_scripts' );
		add_filter( 'ekoterra_filter_localize_script_admin',	'ekoterra_gutenberg_localize_script');
		if ( is_admin() ) {
			add_filter( 'ekoterra_filter_tgmpa_required_plugins', 'ekoterra_gutenberg_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'ekoterra_gutenberg_tgmpa_required_plugins' ) ) {
	
	function ekoterra_gutenberg_tgmpa_required_plugins( $list = array() ) {
		if ( false && ekoterra_storage_isset( 'required_plugins', 'gutenberg' ) ) {
			$list[] = array(
				'name'     => ekoterra_storage_get_array( 'required_plugins', 'gutenberg' ),
				'slug'     => 'gutenberg',
				'required' => false,
			);
		}
		return $list;
	}
}

// Check if Gutenberg is installed and activated
if ( ! function_exists( 'ekoterra_exists_gutenberg' ) ) {
	function ekoterra_exists_gutenberg() {
		return function_exists( 'register_block_type' );	
	}
}

// Return true if Gutenberg exists and current mode is preview
if ( ! function_exists( 'ekoterra_gutenberg_is_preview' ) ) {
	function ekoterra_gutenberg_is_preview() {
		return false;
	}
}

// Merge custom styles
if ( ! function_exists( 'ekoterra_gutenberg_merge_styles' ) ) {
	
	function ekoterra_gutenberg_merge_styles( $list ) {
		if ( ekoterra_exists_gutenberg() ) {
			$list[] = 'plugins/gutenberg/_gutenberg.scss';
		}
		return $list;
	}
}

// Merge responsive styles
if ( ! function_exists( 'ekoterra_gutenberg_merge_styles_responsive' ) ) {
	
	function ekoterra_gutenberg_merge_styles_responsive( $list ) {
		if ( ekoterra_exists_gutenberg() ) {
			$list[] = 'plugins/gutenberg/_gutenberg-responsive.scss';
		}
		return $list;
	}
}


// Load required styles and scripts for Gutenberg Editor mode
if ( ! function_exists( 'ekoterra_gutenberg_editor_scripts' ) ) {
	
	function ekoterra_gutenberg_editor_scripts() {
		ekoterra_admin_scripts(true);
		ekoterra_admin_localize_scripts();
		// Editor styles
		wp_enqueue_style( 'ekoterra-gutenberg-preview', ekoterra_get_file_url( 'plugins/gutenberg/gutenberg-preview.css' ), array(), null );
		// Editor scripts
		wp_enqueue_script( 'ekoterra-gutenberg-preview', ekoterra_get_file_url( 'plugins/gutenberg/gutenberg-preview.js' ), array( 'jquery' ), null, true );
	}
}

// Add plugin's specific variables to the scripts
if ( ! function_exists( 'ekoterra_gutenberg_localize_script' ) ) {
	
	function ekoterra_gutenberg_localize_script( $arr ) {
		$arr['color_scheme'] = ekoterra_get_theme_option( 'color_scheme' );
		return $arr;
	}
}

// Save CSS with custom colors and fonts to the gutenberg-editor-style.css
if ( ! function_exists( 'ekoterra_gutenberg_save_css' ) ) {
	add_action( 'ekoterra_action_save_options', 'ekoterra_gutenberg_save_css', 30 );
	add_action( 'trx_addons_action_save_options', 'ekoterra_gutenberg_save_css', 30 );
	function ekoterra_gutenberg_save_css() {

		$msg = '/* ' . esc_html__( "ATTENTION! This file was generated automatically! Don't change it!!!", 'ekoterra' )
				. "\n----------------------------------------------------------------------- */\n";

		// Get main styles
		$css = ekoterra_fgc( ekoterra_get_file_dir( 'style.css' ) );

		// Append theme-vars styles
		$css .= ekoterra_customizer_get_css(
			array(
				'colors' => ekoterra_get_theme_setting( 'separate_schemes' ) ? false : null,
			)
		);
		
		// Append color schemes
		if ( ekoterra_get_theme_setting( 'separate_schemes' ) ) {
			$schemes = ekoterra_get_sorted_schemes();
			if ( is_array( $schemes ) ) {
				foreach ( $schemes as $scheme => $data ) {
					$css .= ekoterra_customizer_get_css(
						array(
							'fonts'  => false,
							'colors' => $data['colors'],
							'scheme' => $scheme,
						)
					);
				}
			}
		}

		// Add context class to each selector
		if ( function_exists( 'trx_addons_css_add_context' ) ) {
			$css = trx_addons_css_add_context($css, '.edit-post-visual-editor');
		}

		// Save styles to the file
		ekoterra_fpc( ekoterra_get_file_dir( 'plugins/gutenberg/gutenberg-preview.css' ), $msg . $css );
	}
}


// Add plugin-specific colors and fonts to the custom CSS
if ( ekoterra_exists_gutenberg() ) {
	require_once EKOTERRA_THEME_DIR . 'plugins/gutenberg/gutenberg-styles.php';
}
