<?php
/* Revolution Slider support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'ekoterra_revslider_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'ekoterra_revslider_theme_setup9', 9 );
	function ekoterra_revslider_theme_setup9() {

		add_filter( 'ekoterra_filter_merge_styles', 'ekoterra_revslider_merge_styles' );

		if ( is_admin() ) {
			add_filter( 'ekoterra_filter_tgmpa_required_plugins', 'ekoterra_revslider_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'ekoterra_revslider_tgmpa_required_plugins' ) ) {
	
	function ekoterra_revslider_tgmpa_required_plugins( $list = array() ) {

		if ( ekoterra_storage_isset( 'required_plugins', 'revslider' ) ) {

			$path = ekoterra_get_plugin_source_path( 'plugins/revslider/revslider.zip' );
			if ( ! empty( $path ) || ekoterra_get_theme_setting( 'tgmpa_upload' ) ) {
				$list[] = array(
					'name'     => ekoterra_storage_get_array( 'required_plugins', 'revslider' ),
					'slug'     => 'revslider',
					'source'   => ! empty( $path ) ? $path : 'upload://revslider.zip',
					'required' => false,
				);
			}
		}
		return $list;
	}
}

// Check if RevSlider installed and activated
if ( ! function_exists( 'ekoterra_exists_revslider' ) ) {
	function ekoterra_exists_revslider() {
		return function_exists( 'rev_slider_shortcode' );
	}
}

// Merge custom styles
if ( ! function_exists( 'ekoterra_revslider_merge_styles' ) ) {
	
	function ekoterra_revslider_merge_styles( $list ) {
		if ( ekoterra_exists_revslider() ) {
			$list[] = 'plugins/revslider/_revslider.scss';
		}
		return $list;
	}
}

