<?php
// Add plugin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'ekoterra_speakout_get_css' ) ) {
    add_filter( 'ekoterra_filter_get_css', 'ekoterra_speakout_get_css', 10, 2 );
    function ekoterra_speakout_get_css( $css, $args ) {
        if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
            $fonts         = $args['fonts'];
            $css['fonts'] .= <<<CSS
			
.dk-speakout-submit {
	{$fonts['button_font-family']}
	{$fonts['button_font-size']}
	{$fonts['button_font-weight']}
	{$fonts['button_font-style']}
	{$fonts['button_line-height']}
	{$fonts['button_text-decoration']}
	{$fonts['button_text-transform']}
	{$fonts['button_letter-spacing']}
}

.dk-speakout-petition-wrap h3{
    {$fonts['h4_font-family']}
	{$fonts['h4_font-size']}
	{$fonts['h4_font-weight']}
	{$fonts['h4_font-style']}
	{$fonts['h4_line-height']}
	{$fonts['h4_text-decoration']}
	{$fonts['h4_text-transform']}
	{$fonts['h4_letter-spacing']}
}
.dk-speakout-signaturelist-header,
.dk-speakout-signaturelist caption{
	{$fonts['h2_font-family']}
	{$fonts['h2_font-size']}
	{$fonts['h2_font-weight']}
	{$fonts['h2_font-style']}
	{$fonts['h2_line-height']}
	{$fonts['h2_text-decoration']}
	{$fonts['h2_text-transform']}
	{$fonts['h2_letter-spacing']}
}


CSS;
        }

        if ( isset( $css['colors'] ) && isset( $args['colors'] ) ) {
            $colors         = $args['colors'];
            $css['colors'] .= <<<CSS

.dk-speakout-submit{
    color: {$colors['inverse_link']};
	background-color: {$colors['text_hover']};
}
.dk-speakout-submit:hover{
    color: {$colors['inverse_link']};
	background-color: {$colors['text_hover2']};
}

.dk-speakout-signaturelist >tbody>tr:nth-child(2n+1)>td {
  background-color: {$colors['alter_bg_color']};
}

.dk-speakout-signaturelist >tbody>tr:nth-child(2n)>td {
    background-color: {$colors['alter_bg_hover']};
}

.scheme_default .dk-speakout-signaturelist td{
    color: {$colors['text']};
}

.dk-speakout-signaturelist-date{
    color: {$colors['text_light']} !important;
}
.dk-speakout-signaturelist-header,
.dk-speakout-signaturelist caption,
.dk-speakout-signaturelist-name{
    color: {$colors['alter_dark']} !important;
}
.scheme_default .dk-speakout-signaturelist td, 
.scheme_default .dk-speakout-signaturelist th + td, 
.scheme_default .dk-speakout-signaturelist td + td{
    border-color: {$colors['input_bd_color']};
}

CSS;
        }

        return $css;
    }
}

