<?php
/* Calculate Fields Form support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'ekoterra_speakout_theme_setup9' ) ) {
    add_action( 'after_setup_theme', 'ekoterra_speakout_theme_setup9', 9 );
    function ekoterra_speakout_theme_setup9() {

        add_filter( 'ekoterra_filter_merge_styles', 'ekoterra_speakout_merge_styles' );
        if ( is_admin() ) {
            add_filter( 'ekoterra_filter_tgmpa_required_plugins', 'ekoterra_speakout_tgmpa_required_plugins' );
        }
    }
}


// Filter to add in the required plugins list
if ( ! function_exists( 'ekoterra_speakout_tgmpa_required_plugins' ) ) {
    
    function ekoterra_speakout_tgmpa_required_plugins( $list = array() ) {
        if ( false && ekoterra_storage_isset( 'required_plugins', 'speakout' ) ) {
            $list[] = array(
                'name'     => ekoterra_storage_get_array( 'required_plugins', 'speakout' ),
                'slug'     => 'speakout',
                'required' => false,
            );
        }
        return $list;
    }
}


// Check if plugin installed and activated
if ( ! function_exists( 'ekoterra_exists_speakout' ) ) {
    function ekoterra_exists_speakout() {
        return function_exists( 'dk_speakout_translate' );
    }
}

// Merge custom styles
if ( ! function_exists( 'ekoterra_speakout_merge_styles' ) ) {
    
    function ekoterra_speakout_merge_styles( $list ) {
        if ( ekoterra_exists_speakout() ) {
            $list[] = 'plugins/speakout/_speakout.scss';
        }
        return $list;
    }
}


// Add plugin-specific colors and fonts to the custom CSS
if ( ekoterra_exists_speakout() ) {
    require_once EKOTERRA_THEME_DIR . 'plugins/speakout/speakout-styles.php'; }

