<?php
// Add plugin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'ekoterra_tribe_events_get_css' ) ) {
	add_filter( 'ekoterra_filter_get_css', 'ekoterra_tribe_events_get_css', 10, 2 );
	function ekoterra_tribe_events_get_css( $css, $args ) {
		if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
			$fonts         = $args['fonts'];
			$css['fonts'] .= <<<CSS
			
.tribe-events-list .tribe-events-list-event-title {
	{$fonts['h3_font-family']}
}
#tribe-bar-views-toggle,
#tribe-events .tribe-events-button,
.tribe-events-button,
.tribe-events-cal-links a,
.tribe-events-sub-nav li a,
.tribe-common .tribe-common-c-btn, 
.tribe-common a.tribe-common-c-btn,
body .tribe-events .tribe-events-c-top-bar__datepicker-button,
.tribe-common .tribe-common-c-btn-border, 
.tribe-common a.tribe-common-c-btn-border,
.tribe-events-calendar-month__header-column-title.tribe-common-b3,
.tribe-common .tribe-common-b1,
.tribe-events .tribe-events-c-ical__link{
	{$fonts['button_font-family']}
	{$fonts['button_font-size']}
	{$fonts['button_font-weight']}
	{$fonts['button_font-style']}
	{$fonts['button_line-height']}
	{$fonts['button_text-decoration']}
	{$fonts['button_text-transform']}
	{$fonts['button_letter-spacing']}
}
#tribe-bar-form button, #tribe-bar-form a,
.tribe-events-read-more,
.tribe-common--breakpoint-medium.tribe-common .tribe-common-c-btn-border-small,
.tribe-common--breakpoint-medium.tribe-common a.tribe-common-c-btn-border-small,
.tribe-common--breakpoint-medium.tribe-events .tribe-common-c-btn.tribe-events-c-search__button {
	{$fonts['button_font-family']}
	{$fonts['button_letter-spacing']}
}
.tribe-events-list .tribe-events-list-separator-month,
.tribe-events-calendar thead th,
.tribe-events-schedule, .tribe-events-schedule h2 {
	{$fonts['info_font-family']}
}
.tribe-events-content,
#tribe-bar-form input, #tribe-events-content.tribe-events-month,
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title,
#tribe-mobile-container .type-tribe_events,
.tribe-events-list-widget ol li .tribe-event-title,
.tribe-events .tribe-events-c-view-selector__list-item-text,
.tribe-common--breakpoint-medium.tribe-common .tribe-common-form-control-text__input, 
.tribe-common .tribe-common-form-control-text__input,
.tribe-common .tribe-common-h4,
.tribe-common .tribe-common-h7, 
.tribe-common .tribe-common-h8,
.tribe-events .datepicker .datepicker-switch,
.tribe-events .tribe-events-calendar-month__calendar-event-tooltip-datetime,
.tribe-common .tribe-common-b3,
.tribe-events .tribe-events-calendar-list__event-date-tag-weekday,
.tribe-common .tribe-common-b2,
.tribe-common .tribe-common-h5, 
.tribe-common .tribe-common-h6,
.tribe-events .datepicker .day, 
.tribe-events .datepicker .dow,
.single-tribe_events #tribe-events-content .tribe-events-event-meta dd {
	{$fonts['p_font-family']}
}
.tribe-events-tooltip .tribe-event-duration,
.tribe-events-loop .tribe-event-schedule-details,
.single-tribe_events #tribe-events-content .tribe-events-event-meta dt,
#tribe-mobile-container .type-tribe_events .tribe-event-date-start {
	{$fonts['info_font-family']};
}

.tribe-events-page-title{
    	{$fonts['h2_font-size']}
	    {$fonts['h2_font-weight']}
}



CSS;
		}

		if ( isset( $css['vars'] ) && isset( $args['vars'] ) ) {
			$vars         = $args['vars'];
			$css['vars'] .= <<<CSS

#tribe-bar-form .tribe-bar-submit input[type="submit"],
#tribe-bar-form button,
#tribe-bar-form a,
#tribe-events .tribe-events-button,
#tribe-bar-views .tribe-bar-views-list,
.tribe-events-button,
.tribe-events-cal-links a,
#tribe-events-footer ~ a.tribe-events-ical.tribe-events-button,
.tribe-events-sub-nav li a,
.tribe-events .tribe-events-c-ical__link {
	-webkit-border-radius: {$vars['rad']};
	    -ms-border-radius: {$vars['rad']};
			border-radius: {$vars['rad']};
}

CSS;
		}

		if ( isset( $css['colors'] ) && isset( $args['colors'] ) ) {
			$colors         = $args['colors'];
			$css['colors'] .= <<<CSS

/* Button */
#tribe-bar-form .tribe-bar-submit input[type="submit"],
#tribe-bar-form.tribe-bar-mini .tribe-bar-submit input[type="submit"],
#tribe-bar-views li.tribe-bar-views-option a,
#tribe-bar-views .tribe-bar-views-list .tribe-bar-views-option.tribe-bar-active a,
#tribe-events .tribe-events-button,
.tribe-events-button,
.tribe-events-cal-links a,
.tribe-events-sub-nav li a,
.tribe-events .tribe-events-c-ical__link{
	background-color: {$colors['text_hover']};	
	border-color: {$colors['bg_color_0']};	
	color: {$colors['extra_dark']} !important;
}
/* Tribe Events */
#tribe-bar-form .tribe-bar-submit input[type="submit"]:hover,
#tribe-bar-form .tribe-bar-submit input[type="submit"]:focus,
#tribe-bar-form.tribe-bar-mini .tribe-bar-submit input[type="submit"]:hover,
#tribe-bar-form.tribe-bar-mini .tribe-bar-submit input[type="submit"]:focus,
#tribe-bar-views li.tribe-bar-views-option a:hover,
#tribe-bar-views .tribe-bar-views-list .tribe-bar-views-option.tribe-bar-active a:hover,
#tribe-events .tribe-events-button:hover,
.tribe-events-button:hover,
.tribe-events-cal-links a:hover,
.tribe-events-sub-nav li a:hover,
.tribe-events .tribe-events-c-ical__link:hover,
.tribe-events .tribe-events-c-ical__link:focus,
.tribe-common .tribe-common-c-btn:focus, 
.tribe-common .tribe-common-c-btn:hover, 
.tribe-common a.tribe-common-c-btn:focus, 
.tribe-common a.tribe-common-c-btn:hover,
.tribe-events .datepicker .day.active, 
.tribe-events .datepicker .day.active.focused, 
.tribe-events .datepicker .day.active:focus, 
.tribe-events .datepicker .day.active:hover, 
.tribe-events .datepicker .month.active, 
.tribe-events .datepicker .month.active.focused, 
.tribe-events .datepicker .month.active:focus, 
.tribe-events .datepicker .month.active:hover, 
.tribe-events .datepicker .year.active, 
.tribe-events .datepicker .year.active.focused, 
.tribe-events .datepicker .year.active:focus, 
.tribe-events .datepicker .year.active:hover{
	color: {$colors['inverse_link']};	
	background-color: {$colors['alter_hover3']};
}

#tribe-bar-form .tribe-bar-views-toggle {
		color: {$colors['extra_dark']};
	background-color: {$colors['text_link3']};
}
#tribe-bar-form .tribe-bar-views-toggle:hover{
	background-color: {$colors['text_hover']};
}

/* Filters bar */
#tribe-bar-form {
	color: {$colors['text_dark']};
}
#tribe-bar-form input[type="text"] {
	color: {$colors['input_text']};
	border-color: {$colors['input_bd_color']};
}
#tribe-bar-form.tribe-bar-collapse input[type="text"] {
	color: {$colors['inverse_dark']};
}

.datepicker thead tr:first-child th:hover, .datepicker tfoot tr th:hover {
	color: {$colors['text_link']};
	background: {$colors['text_dark']};
}

/* Content */
.tribe-events-calendar thead th {
	color: {$colors['inverse_link']};
	background: {$colors['inverse_dark']} !important;
}

#tribe-events-content .tribe-events-calendar td,
#tribe-events-content .tribe-events-calendar th {
	border-color: {$colors['bg_color']} !important;

}


.tribe-events-calendar td div[id*="tribe-events-daynum-"],
.tribe-events-calendar td div[id*="tribe-events-daynum-"] > a,
.tribe-events-calendar td.tribe-events-othermonth.tribe-events-future div[id*=tribe-events-daynum-] {
	color: {$colors['extra_dark']};
	background: {$colors['alter_hover3']};
}
.tribe-events-calendar td.tribe-events-othermonth {
	color: {$colors['alter_light']};
	background-color: {$colors['alter_bg_color']} !important;
}

.tribe-events-calendar td.tribe-events-present div[id*="tribe-events-daynum-"],
.tribe-events-calendar td.tribe-events-present div[id*="tribe-events-daynum-"] > a {
	background-color: {$colors['text_hover']};
}
.tribe-events-calendar td.tribe-events-present:before {
	border-color: {$colors['text_link']};
}
.tribe-events-calendar .tribe-events-has-events:after {
	background-color: {$colors['text']};
}
.tribe-events-calendar .mobile-active.tribe-events-has-events:after {
	background-color: {$colors['bg_color']};
}
#tribe-events-content .tribe-events-calendar td,
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title a {
	color: {$colors['text_dark']};
}
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title a:hover {
	color: {$colors['text_link']};
}
#tribe-events-content .tribe-events-calendar td.mobile-active,
#tribe-events-content .tribe-events-calendar td.mobile-active:hover {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
}
#tribe-events-content .tribe-events-calendar td.mobile-active div[id*="tribe-events-daynum-"] {
	color: {$colors['bg_color']};
	background-color: {$colors['text_dark']};
}
#tribe-events-content .tribe-events-calendar td.tribe-events-othermonth.mobile-active div[id*="tribe-events-daynum-"] a,
.tribe-events-calendar .mobile-active div[id*="tribe-events-daynum-"] a {
	background-color: transparent;
	color: {$colors['bg_color']};
}
.events-archive.events-gridview #tribe-events-content table .type-tribe_events {
	border-color: {$colors['bd_color']};
}

/* Tooltip */
.recurring-info-tooltip,
.tribe-events-calendar .tribe-events-tooltip,
.tribe-events-week .tribe-events-tooltip,
.tribe-events-shortcode.view-week .tribe-events-tooltip {
	color: {$colors['alter_text']};
	background: {$colors['alter_bg_color']};
	border-color: {$colors['alter_bd_color']};
}
#tribe-events-content .tribe-events-tooltip .summary { 
	color: {$colors['inverse_link']};
	background: {$colors['inverse_dark']};
}
#tribe-events-content .tribe-events-abbr {
	color: {$colors['inverse_link']};
}
.tribe-events-tooltip .tribe-event-duration {
	color: {$colors['extra_text']};
}

.single-tribe_events #tribe-events-content .tribe-events-abbr {
	color: {$colors['text']};
}

/* Events list */
.tribe-events-list-separator-month {
	color: {$colors['text_dark']};
}
.tribe-events-list-separator-month:after {
	border-color: {$colors['bd_color']};
}
.tribe-events-list .type-tribe_events + .type-tribe_events,
.tribe-events-day .tribe-events-day-time-slot + .tribe-events-day-time-slot + .tribe-events-day-time-slot {
	border-color: {$colors['bd_color']};
}
.tribe-events-list-separator-month span {
	background-color: {$colors['bg_color']};	
}
.tribe-events-list .tribe-events-event-cost span {
	color: {$colors['inverse_link']};
	border-color: {$colors['inverse_dark']};
	background: {$colors['inverse_dark']};
}
.tribe-mobile .tribe-events-loop .tribe-events-event-meta {
	color: {$colors['alter_text']};
	border-color: {$colors['alter_bd_color']};
	background-color: {$colors['alter_bg_color']};
}
.tribe-mobile .tribe-events-loop .tribe-events-event-meta a {
	color: {$colors['alter_link']};
}
.tribe-mobile .tribe-events-loop .tribe-events-event-meta a:hover {
	color: {$colors['alter_hover']};
}
.tribe-mobile .tribe-events-list .tribe-events-venue-details {
	border-color: {$colors['alter_bd_color']};
}

.single-tribe_events #tribe-events-footer,
.tribe-events-day #tribe-events-footer,
.events-list #tribe-events-footer,
.tribe-events-map #tribe-events-footer,
.tribe-events-photo #tribe-events-footer {
	border-color: {$colors['bd_color']};	
}

#tribe-bar-views .tribe-bar-views-list {
	border-color: {$colors['bd_color']}!important;
}
#tribe-bar-views li.tribe-bar-views-option {
	background-color: {$colors['bg_color']};	
	color: {$colors['text']};
}
.datepicker table tr td span.focused, .datepicker table tr td span:hover {
	color: {$colors['text']};
}
/* Events day */
.tribe-events-day .tribe-events-day-time-slot h5,
.tribe-events-day .tribe-events-day-time-slot .tribe-events-day-time-slot-heading {
	color: {$colors['inverse_link']};
	background: {$colors['inverse_dark']};
}



/* Single Event */
.single-tribe_events .tribe-events-venue-map {
	color: {$colors['alter_text']};
	border-color: {$colors['alter_bd_hover']};
	background: {$colors['alter_bg_hover']};
}
.single-tribe_events .tribe-events-schedule .tribe-events-cost {
	color: {$colors['text_dark']};
}
.single-tribe_events .type-tribe_events {
	border-color: {$colors['bd_color']};
}
.single-tribe_events #tribe-events-content .tribe-events-event-meta dt a, 
.single-tribe_events #tribe-events-content .tribe-events-event-meta dd a {
	color: {$colors['text_link']};
}
.single-tribe_events #tribe-events-content .tribe-events-event-meta dt a:hover, 
.single-tribe_events #tribe-events-content .tribe-events-event-meta dd a:hover {
	color: {$colors['text_hover']};
}

/* Updated calendar designs */
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-events-bar--border{
	border-color: {$colors['input_bd_color']};
}
.tribe-events .tribe-events-c-view-selector__list-item-link:focus .tribe-events-c-view-selector__list-item-text, 
.tribe-events .tribe-events-c-view-selector__list-item-link:hover .tribe-events-c-view-selector__list-item-text,
.tribe-common .tribe-common-anchor-alt {
	border-color: {$colors['alter_hover3']};
}

body .tribe-events .tribe-events-c-top-bar__datepicker-button{
	color: {$colors['text']};
}

.tribe-events .tribe-events-calendar-month__multiday-event-bar-inner{
	background-color: {$colors['alter_hover3']};	
}
.tribe-common.tribe-events .tribe-common-h8{
	color: {$colors['inverse_link']};
}
.tribe-common .tribe-common-anchor-alt:active, 
.tribe-common .tribe-common-anchor-alt:focus, .tribe-common .tribe-common-anchor-alt:hover{
	color: {$colors['alter_hover3']};	
}
.tribe-events .tribe-events-c-view-selector__content,
.tribe-events .tribe-events-c-events-bar__search-filters-container{
	background-color: {$colors['input_bg_color']};	
}
.tribe-common a, 
.tribe-common a:active, 
.tribe-common a:visited,
.tribe-common .tribe-common-h7, 
.tribe-common .tribe-common-h8,
.tribe-common .tribe-common-b2,
.tribe-common .tribe-common-h5, .tribe-common .tribe-common-h6,
.tribe-events .tribe-events-c-view-selector__list-item-text,
.tribe-events .datepicker .day, 
.tribe-events .datepicker .dow,
.tribe-events .datepicker .month, 
.tribe-events .datepicker .year{
	color: {$colors['text']};	
}
.tribe-common a:focus, 
.tribe-common a:hover{
	color: {$colors['text_link']};
}

.tribe-common .tribe-common-anchor-thin-alt {
	border-color: {$colors['text']};
}
.tribe-common .tribe-common-anchor-thin-alt:hover {
	border-color: {$colors['text_link']};
}


.datepicker .day.active{
	color: {$colors['inverse_link']};	
}
.tribe-events .tribe-events-c-view-selector__list-item-link:focus .tribe-events-c-view-selector__list-item-text, 
.tribe-events .tribe-events-c-view-selector__list-item-link:hover .tribe-events-c-view-selector__list-item-text{
	color: {$colors['text_link']};	
}
.tribe-events .datepicker .past{
	color: {$colors['text_light']};	
}
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-view-selector--tabs .tribe-events-c-view-selector__list-item--active .tribe-events-c-view-selector__list-item-link:after{
	background-color: {$colors['text_link']};	
}
.tribe-common .tribe-common-c-btn-border:active, 
.tribe-common .tribe-common-c-btn-border:hover, 
.tribe-common a.tribe-common-c-btn-border:active,
.tribe-common a.tribe-common-c-btn-border:hover{
  border-color: {$colors['input_bd_hover']};	
}

.tribe-common .tribe-common-c-loader__dot,
.tribe-events .tribe-events-calendar-month__mobile-events-icon--event{
	background-color: {$colors['text_link']};	
}
.tribe-events .tribe-events-calendar-month__day-cell--selected .tribe-events-calendar-month__mobile-events-icon--event{
	background-color: {$colors['extra_hover3']};	
}

.tribe-events .tribe-events-calendar-month__day--current .tribe-events-calendar-month__day-date,
.tribe-events .tribe-events-calendar-month__day--current .tribe-events-calendar-month__day-date-link{
	color: {$colors['text_link']};	
}
.tribe-events .tribe-events-calendar-month__day--current .tribe-events-calendar-month__day-date:hover,
.tribe-events .tribe-events-calendar-month__day--current .tribe-events-calendar-month__day-date-link:hover{
	color: {$colors['text_hover']};	
}

.single-tribe_events .tribe-events-single .tribe-events-event-meta,
.tribe-events-content{
	color: {$colors['text']};	
}

.tribe-events-meta-group .tribe-events-single-section-title{
	color: {$colors['text_hover']};
}

.tribe-common .tribe-events-calendar-day__event-header address,
.tribe-common .tribe-events-calendar-list__event-header address,
.tribe-common .tribe-events-calendar-month__calendar-event-tooltip-datetime time,
.tribe-common .tribe-common-b2 time{
	color: {$colors['text_light']};
}

.tribe-common button[disabled],
.tribe-common input[disabled] {
    color: {$colors['text_light']} !important; 
    background-color: transparent !important;
}

.tribe-common .tribe-events-c-nav__list-item button[disabled] svg path {
	fill: {$colors['text_light']} !important;
}	

.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__prev,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__next,
.tribe-common--breakpoint-xsmall.tribe-events .tribe-events-c-nav__prev,
.tribe-common--breakpoint-xsmall.tribe-events .tribe-events-c-nav__next {
	color: {$colors['text_link']};
}

.tribe-events .tribe-events-c-nav__next .tribe-events-c-nav__next-icon-svg path,
.tribe-events .tribe-events-c-nav__prev .tribe-events-c-nav__prev-icon-svg path {
	fill: {$colors['text_link']};
}

.tribe-events .tribe-events-c-nav__next:hover .tribe-events-c-nav__next-icon-svg path,
.tribe-events .tribe-events-c-nav__prev:hover .tribe-events-c-nav__prev-icon-svg path {
	fill: {$colors['text_hover']};
}

.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__prev:hover,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__prev:focus,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__next:hover,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__next:focus,
.tribe-common--breakpoint-xsmall.tribe-events .tribe-events-c-nav__prev:hover,
.tribe-common--breakpoint-xsmall.tribe-events .tribe-events-c-nav__prev:focus,
.tribe-common--breakpoint-xsmall.tribe-events .tribe-events-c-nav__next:hover,
.tribe-common--breakpoint-xsmall.tribe-events .tribe-events-c-nav__next:focus {
	color: {$colors['text_hover']};
}

.tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-list__event-datetime-featured-text,
.tribe-common .tribe-common-c-svgicon {
	color: {$colors['alter_link2']};
}

.tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-list__event-datetime-featured-text,
.tribe-common .tribe-common-c-svgicon {
	color: {$colors['alter_link2']};
}

.tribe-common .tribe-common-c-btn-border svg,
.tribe-common a.tribe-common-c-btn-border svg {
	color: {$colors['inverse_link']}!important;
}
.tribe-common .tribe-common-c-btn-border:hover svg,
.tribe-common a.tribe-common-c-btn-border:hover svg {
	color: {$colors['inverse_link']}!important;
}

.tribe-events .tribe-events-calendar-list__event-row--featured .tribe-events-calendar-list__event-date-tag-datetime:after,
.tribe-events .tribe-events-calendar-day__event--featured:after,
.tribe-events .tribe-events-calendar-month__calendar-event--featured:before {
	background-color: {$colors['alter_link2']};
}

.tribe-events .tribe-events-c-view-selector__button:before {
	background-color: {$colors['text_link3']};
}

.tribe-common .tribe-common-c-svgicon--messages-not-found .tribe-common-c-svgicon__svg-stroke {
	color: {$colors['alter_link2']};
}

CSS;
		}

		return $css;
	}
}

