<?php
/* ThemeREX Popup
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'ekoterra_trx_popup_theme_setup9' ) ) {
    add_action( 'after_setup_theme', 'ekoterra_trx_popup_theme_setup9', 9 );
    function ekoterra_trx_popup_theme_setup9() {

        if ( is_admin() ) {
            add_filter( 'ekoterra_filter_tgmpa_required_plugins', 'ekoterra_trx_popup_tgmpa_required_plugins' );
        }
    }
}

// Filter to add in the required plugins list
if ( ! function_exists( 'ekoterra_trx_popup_tgmpa_required_plugins' ) ) {

    function ekoterra_trx_popup_tgmpa_required_plugins( $list = array() ) {
        if ( ekoterra_storage_isset( 'required_plugins', 'trx_popup' ) ) {
            $path = ekoterra_get_plugin_source_path( 'plugins/trx_popup/trx_popup.zip' );
            if ( ! empty( $path ) || ekoterra_get_theme_setting( 'tgmpa_upload' ) ) {
                $list[] = array(
                    'name'     => ekoterra_storage_get_array( 'required_plugins', 'trx_popup' ),
                    'slug'     => 'trx_popup',
                    'source'   => ! empty( $path ) ? $path : 'upload://trx_popup.zip',
                    'required' => false,
                );
            }
        }
        return $list;
    }
}

// Check if trx_popup installed and activated
if ( ! function_exists( 'ekoterra_exists_trx_popup' ) ) {
    function ekoterra_exists_trx_popup() {
        return defined( 'trx_popup_VERSION' );
    }
}