<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0
 */

if ( ekoterra_sidebar_present() ) {
    ob_start();
    $ekoterra_sidebar_name = ekoterra_get_theme_option( 'sidebar_widgets' );
    ekoterra_storage_set( 'current_sidebar', 'sidebar' );
    if ( is_active_sidebar( $ekoterra_sidebar_name ) ) {
        dynamic_sidebar( $ekoterra_sidebar_name );
    }
    $ekoterra_out = trim( ob_get_contents() );
    ob_end_clean();
    if ( ! empty( $ekoterra_out ) ) {
        $ekoterra_sidebar_position    = ekoterra_get_theme_option( 'sidebar_position' );
        $ekoterra_sidebar_position_mobile= ekoterra_get_theme_option( 'sidebar_position_mobile' );
        ?>
        <div class="sidebar widget_area
			<?php
        echo ' sidebar_' . esc_attr( $ekoterra_sidebar_position_mobile);
        echo '' . esc_attr( $ekoterra_sidebar_position );

        if ( 'float' == $ekoterra_sidebar_position_mobile) {
            echo ' sidebar_float';
        }
        $ekoterra_sidebar_scheme = ekoterra_get_theme_option( 'sidebar_scheme' );
        if ( ! empty( $ekoterra_sidebar_scheme ) && ! ekoterra_is_inherit( $ekoterra_sidebar_scheme ) ) {
            echo ' scheme_' . esc_attr( $ekoterra_sidebar_scheme );
        }
        ?>
		" role="complementary">
            <?php
            // Skip link anchor to fast access to the sidebar from keyboard
            ?>
            <a id="sidebar_skip_link_anchor" class="ekoterra_skip_link_anchor" href="#"></a>
            <?php
            // Single posts banner before sidebar
            ekoterra_show_post_banner( 'sidebar' );
            // Button to show/hide sidebar on mobile
            if ( in_array( $ekoterra_sidebar_position_mobile, array( 'above', 'float' ) ) ) {
                $ekoterra_title = apply_filters( 'ekoterra_filter_sidebar_control_title', 'float' == $ekoterra_sidebar_position_mobile?  esc_html__( 'Show Sidebar', 'ekoterra' ) : '' );
                $ekoterra_text  = apply_filters( 'ekoterra_filter_sidebar_control_text', 'above' == $ekoterra_sidebar_position_mobile?  esc_html__( 'Show Sidebar', 'ekoterra' ) : '' );
                ?>
                <a href="#" class="sidebar_control" title="<?php echo esc_attr( $ekoterra_title ); ?>"><?php echo esc_html( $ekoterra_text ); ?></a>
                <?php
            }
            ?>
            <div class="sidebar_inner">
                <?php
                do_action( 'ekoterra_action_before_sidebar' );
                ekoterra_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $ekoterra_out ) );
                do_action( 'ekoterra_action_after_sidebar' );
                ?>
            </div><!-- /.sidebar_inner -->
        </div><!-- /.sidebar -->
        <div class="clearfix"></div>
        <?php
    }
}
