<?php
/**
 * The template to display single post
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0
 */

get_header();

while ( have_posts() ) {
	the_post();

	get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'content', get_post_format() ), get_post_format() );

	// Previous/next post navigation.
	$ekoterra_show_posts_navigation = ! ekoterra_is_off( ekoterra_get_theme_option( 'show_posts_navigation' ) );
	$ekoterra_fixed_posts_navigation = ! ekoterra_is_off( ekoterra_get_theme_option( 'fixed_posts_navigation' ) ) ? 'nav-links-fixed fixed' : '';
	
	if ( $ekoterra_show_posts_navigation ) {
		?>
		<div class="nav-links-single<?php echo ' ' . esc_attr( $ekoterra_fixed_posts_navigation ); ?>">
			<?php
			the_post_navigation(
				array(
					'next_text' => '<span class="related-nav ">' . esc_html__( 'Next', 'ekoterra' ) . '</span> '
						. '<span class="nav-arrow related-next"></span>'
						. '<p class="post-title">%title</p>'
						. '<span class="post_date">%date</span>',
					'prev_text' => '<span class="nav-arrow related-prev"></span>'
						. '<span class="related-nav">' . esc_html__( 'Prev', 'ekoterra' ) . '</span> '
						. '<p class="post-title">%title</p>'
						. '<span class="post_date">%date</span>',
				)
			);
			?>
		</div>
		<?php
	}

	// Related posts
	if ( ekoterra_get_theme_option( 'related_position' ) == 'below_content' ) {
		do_action( 'ekoterra_action_related_posts' );
	}

	// If comments are open or we have at least one comment, load up the comment template.
	if ( comments_open() || get_comments_number() ) {
		comments_template();
	}
}

get_footer();
