<?php
// Add skin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'ekoterra_skin_get_css' ) ) {
	add_filter( 'ekoterra_filter_get_css', 'ekoterra_skin_get_css', 10, 2 );
	function ekoterra_skin_get_css( $css, $args ) {

		if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
			$fonts         = $args['fonts'];
			$css['fonts'] .= <<<CSS

CSS;
		}

		if ( isset( $css['vars'] ) && isset( $args['vars'] ) ) {
			$vars         = $args['vars'];
			$css['vars'] .= <<<CSS

CSS;
		}

		if ( isset( $css['colors'] ) && isset( $args['colors'] ) ) {
			$colors         = $args['colors'];
			$css['colors'] .= <<<CSS
		
        /* Menu */
				
        .sc_layouts_menu_mobile_button .sc_layouts_item_link:hover span,
        ul[class*="trx_addons_list_custom"]>li:before,
        .sc_layouts_menu_nav>li>a:hover, 
        .sc_layouts_menu_nav>li.sfHover>a ,
        .sc_layouts_menu_nav > li.current-menu-item > a,
        .sc_layouts_menu_nav > li.current-menu-parent > a,
        .sc_layouts_menu_nav > li.current-menu-ancestor > a {
            color: {$colors['text_link2']} !important;
        }
        .sc_layouts_menu_mobile_button .sc_layouts_item_link:hover .sc_layouts_item_icon,
        .sc_layouts_menu_mobile_button .sc_layouts_item_link:hover .sc_layouts_item_icon:before,
        .sc_layouts_menu_mobile_button .sc_layouts_item_link:hover .sc_layouts_item_icon:after{
            background-color: {$colors['extra_hover']}; 
        }
        .search_wrap .search_submit:hover, 
        .search_wrap .search_submit:hover:before, 
        .search_wrap .search_submit:hover,
        .sc_layouts_menu_mobile_button .sc_layouts_item_link:hover span{
            color: {$colors['extra_hover']} !important; 
        }

        .sc_layouts_title .sc_layouts_title_breadcrumbs,
        .sc_layouts_title .sc_layouts_title_breadcrumbs a{
          color: {$colors['alter_hover2']};
        }
        .menu_side_icons .toc_menu_item .toc_menu_icon,
        .menu_side_inner {
            background-color: {$colors['extra_bg_color']};
        }
        .scheme_dark .menu_side_icons .toc_menu_item .toc_menu_icon,
        .scheme_dark .menu_side_inner {
            background-color: {$colors['extra_link3']};
        }
        
        /* Page title and breadcrumbs */
        .sc_layouts_title .sc_layouts_title_breadcrumbs a:hover{
          color: {$colors['inverse_link']};
        }

        /* WP Standard classes */
        .sticky .label_sticky a:hover {
            color: {$colors['extra_link3']} !important;
        }

        /* Post layouts */
        .sticky .post_meta .post_meta_item a:after, 
        .sticky .post_meta .post_meta_item.post_edit a:after,
        .sticky .post_meta .vc_inline-link a:after,
        .sticky-ico:before,
        .sticky .post_meta,
        .sticky .post_meta_item,
        .sticky .post_meta_item:after,
        .sticky .post_meta_item:hover:after,
        .sticky .post_meta .vc_inline-link,
        .sticky .post_meta .vc_inline-link:after,
        .sticky .post_meta .vc_inline-link:hover:after,
        .sticky .post_meta_item a,
        .sticky .post_info .post_info_item,
        .sticky .post_info .post_info_item a,
        .sticky .post_info_counters .post_counters_item,
        .sticky .post_counters .socials_share .socials_caption:before,
        .sticky .post_counters .socials_share .socials_caption:hover:before {
            color: {$colors['extra_link3']};
        }
        .post_featured.hover_fade .post_info a:hover{
            color: {$colors['extra_hover']} !important;      
        }
               
        
        /* Normal button */
        .blog_mode_blog .nav-load-more,
        button:not(.components-button),
        input[type="reset"],
        input[type="submit"],
        input[type="button"],
        .comments_wrap .form-submit input[type="submit"],
        /* BB & Buddy Press */
        #buddypress .comment-reply-link,
        #buddypress .generic-button a,
        #buddypress a.button,
        #buddypress button,
        #buddypress input[type="button"],
        #buddypress input[type="reset"],
        #buddypress input[type="submit"],
        #buddypress ul.button-nav li a,
        a.bp-title-button,
        /* Booked */
        .booked-calendar-wrap .booked-appt-list .timeslot .timeslot-people button,
        #booked-profile-page .booked-profile-appt-list .appt-block .booked-cal-buttons .google-cal-button > a,
        #booked-profile-page input[type="submit"],
        #booked-profile-page button,
        .booked-list-view input[type="submit"],
        .booked-list-view button,
        table.booked-calendar input[type="submit"],
        table.booked-calendar button,
        .booked-modal input[type="submit"],
        .booked-modal button,
        /* ThemeREX Addons */
        .sc_button_default,
        .sc_button:not(.sc_button_simple):not(.sc_button_bordered):not(.sc_button_bg_image),
        .socials_share:not(.socials_type_drop) .social_icon,
        /* Tour Master */
        .tourmaster-tour-search-wrap input.tourmaster-tour-search-submit[type="submit"],
        /* Tribe Events */
        #tribe-bar-form .tribe-bar-submit input[type="submit"],
        #tribe-bar-form.tribe-bar-mini .tribe-bar-submit input[type="submit"],
        #tribe-bar-views li.tribe-bar-views-option a,
        #tribe-bar-views .tribe-bar-views-list .tribe-bar-views-option.tribe-bar-active a,
        #tribe-events .tribe-events-button,
        .tribe-events-button,
        .tribe-events-cal-links a,
        .tribe-events-sub-nav li a,
        /* EDD buttons */
        .edd_download_purchase_form .button,
        #edd-purchase-button,
        .edd-submit.button,
        .widget_edd_cart_widget .edd_checkout a,
        .sc_edd_details .downloads_page_tags .downloads_page_data > a,
        /* MailChimp */
        .mc4wp-form input[type="submit"],
        /*WP buttons*/
        .wp-block-button:not(.is-style-outline)>.wp-block-button__link ,
        /* WooCommerce */
        .woocommerce a.added_to_cart, .woocommerce-page a.added_to_cart,
        .woocommerce #respond input#submit,
        .woocommerce .button, .woocommerce-page .button,
        .woocommerce button.button, .woocommerce-page button.button,
        .woocommerce input.button, .woocommerce-page input.button,
        .woocommerce input[type="button"], .woocommerce-page input[type="button"],
        .woocommerce input[type="submit"], .woocommerce-page input[type="submit"],
        .woocommerce #respond input#submit.alt,
        .woocommerce a.button.alt,
        .woocommerce button.button.alt,
        .woocommerce input.button.alt {
            color: {$colors['extra_dark']};
            background-color: {$colors['extra_link2']};
        }

        .woocommerce a.button, 
        .woocommerce-page a.button{
            color: {$colors['inverse_link']};
            background-color: {$colors['extra_link3']};
        }
      
       
        .blog_mode_blog .nav-load-more:hover,
        button:hover,
        button:focus,
        input[type="submit"]:hover,
        input[type="submit"]:focus,
        input[type="reset"]:hover,
        input[type="reset"]:focus,
        input[type="button"]:hover,
        input[type="button"]:focus,
        
        .comments_wrap .form-submit input[type="submit"]:hover,
        .comments_wrap .form-submit input[type="submit"]:focus,
        /* BB & Buddy Press */
        #buddypress .comment-reply-link:hover,
        #buddypress .generic-button a:hover,
        #buddypress a.button:hover,
        #buddypress button:hover,
        #buddypress input[type="button"]:hover,
        #buddypress input[type="reset"]:hover,
        #buddypress input[type="submit"]:hover,
        #buddypress ul.button-nav li a:hover,
        a.bp-title-button:hover,
        /* Booked */
        .booked-calendar-wrap .booked-appt-list .timeslot .timeslot-people button:hover,
        body #booked-profile-page .booked-profile-appt-list .appt-block .booked-cal-buttons .google-cal-button > a:hover,
        body #booked-profile-page input[type="submit"]:hover,
        body #booked-profile-page button:hover,
        body .booked-list-view input[type="submit"]:hover,
        body .booked-list-view button:hover,
        body table.booked-calendar input[type="submit"]:hover,
        body table.booked-calendar button:hover,
        body .booked-modal input[type="submit"]:hover,
        body .booked-modal button:hover,
        /* ThemeREX Addons */
        .sc_button_default:hover,
        .sc_button:not(.sc_button_simple):not(.sc_button_bordered):not(.sc_button_bg_image):hover,
        .socials_share:not(.socials_type_drop) .social_icon:hover,
        /* Tour Master */
        .tourmaster-tour-search-wrap input.tourmaster-tour-search-submit[type="submit"]:hover,
        /* Tribe Events */
        #tribe-bar-form .tribe-bar-submit input[type="submit"]:hover,
        #tribe-bar-form .tribe-bar-submit input[type="submit"]:focus,
        #tribe-bar-form.tribe-bar-mini .tribe-bar-submit input[type="submit"]:hover,
        #tribe-bar-form.tribe-bar-mini .tribe-bar-submit input[type="submit"]:focus,
        #tribe-bar-views li.tribe-bar-views-option a:hover,
        #tribe-bar-views .tribe-bar-views-list .tribe-bar-views-option.tribe-bar-active a:hover,
        #tribe-events .tribe-events-button:hover,
        .tribe-events-button:hover,
        .tribe-events-cal-links a:hover,
        .tribe-events-sub-nav li a:hover,
        .tribe-common .tribe-common-c-btn:focus, 
        .tribe-common .tribe-common-c-btn:hover, 
        .tribe-common a.tribe-common-c-btn:focus, 
        .tribe-common a.tribe-common-c-btn:hover,
        /* EDD buttons */
        .edd_download_purchase_form .button:hover, .edd_download_purchase_form .button:active, .edd_download_purchase_form .button:focus,
        #edd-purchase-button:hover, #edd-purchase-button:active, #edd-purchase-button:focus,
        .edd-submit.button:hover, .edd-submit.button:active, .edd-submit.button:focus,
        .widget_edd_cart_widget .edd_checkout a:hover,
        .sc_edd_details .downloads_page_tags .downloads_page_data > a:hover,
        /* MailChimp */
        .mc4wp-form input[type="submit"]:hover,
        .mc4wp-form input[type="submit"]:focus,
        /*WP buttons*/
        .wp-block-button:not(.is-style-outline)>.wp-block-button__link :hover,
        /* WooCommerce */
        .woocommerce a.added_to_cart:hover .woocommerce-page a.added_to_cart:hover,
         .woocommerce a.added_to_cart:hover, .woocommerce-page a.added_to_cart:hover,
        .woocommerce #respond input#submit:hover,
        .woocommerce .button:hover, .woocommerce-page .button:hover,
        .woocommerce a.button:hover, .woocommerce-page a.button:hover,
        .woocommerce button.button:hover, .woocommerce-page button.button:hover,
        .woocommerce input.button:hover, .woocommerce-page input.button:hover,
        .woocommerce input[type="button"]:hover, .woocommerce-page input[type="button"]:hover,
        .woocommerce input[type="submit"]:hover, .woocommerce-page input[type="submit"]:hover {
            color: {$colors['inverse_link']};
            background-color: {$colors['text_link2']};
        }

        /* Team */
        .sc_team .sc_team_item_thumb .sc_team_item_socials .social_item .social_icon{
            background-color: {$colors['extra_hover']};
            border-color: {$colors['extra_hover']};
        }
        /* Speakout */
        .dk-speakout-signaturelist>tbody>tr:nth-child(2n)>td{
            background-color: {$colors['bg_color_08']};
        }

        /* Woocommerce */
        .give-wrap .give-card__text,
        .woocommerce-page ul.product_list_widget li a:hover{
            color: {$colors['text']} !important;
        }
        .sidebar .widget_shopping_cart{
             background-color: {$colors['text_link']};
        }
        
        /* Promo */
        .sc_promo .sc_promo_descr form.mc4wp-form .mc4wp-form-fields input[type="submit"]{
           color: {$colors['inverse_link']};
        }
        .sc_promo .sc_promo_descr form.mc4wp-form a{
            color: {$colors['extra_link2']};
        }
        .sc_promo .sc_promo_descr form.mc4wp-form a:hover{
            color: {$colors['input_bd_color']};
        }
        
        /* Mailchimp */
        form.mc4wp-form .mc4wp-form-fields input[type="submit"]:hover,
        .sc_promo .sc_promo_descr form.mc4wp-form .mc4wp-form-fields input[type="submit"]:hover{
            background-color: {$colors['alter_hover3']};
        }
        /* ELementor */
        .elementor-progress-percentage,
        .elementor-widget-progress .elementor-title span{
            color: {$colors['alter_hover3']} !important;
        }

        /* Give donation */
        .give-goal-progress .raised, 
        .give-wrap .give-card__progress .raised{
            color: {$colors['alter_link3']};
        }
        
CSS;
		}

		return $css;
	}
}

