<?php
/**
 * Skins support: Main skin file for the skin 'Honor'
 *
 * Setup skin-dependent fonts and colors, load scripts and styles,
 * and other operations that affect the appearance and behavior of the theme
 * when the skin is activated
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0.46
 */


// Theme init priorities:
// 3 - add/remove Theme Options elements
if ( ! function_exists( 'ekoterra_skin_theme_setup3' ) ) {
	add_action( 'after_setup_theme', 'ekoterra_skin_theme_setup3', 3 );
	function ekoterra_skin_theme_setup3() {
        ekoterra_storage_set(
            'schemes', array(

                // Color scheme: 'default'
                'default' => array(
                    'title'    => esc_html__( 'Default', 'ekoterra' ),
                    'internal' => true,
                    'colors'   => array(

                        // Whole block border and background
                        'bg_color'         => '#ffffff',//+
                        'bd_color'         => '#f6f5f1',//+

                        // Text and links colors
                        'text'             => '#404040',//+
                        'text_light'       => '#c0c8cb',//+
                        'text_dark'        => '#0e1736',//+
                        'text_link'        => '#44adb5',//+
                        'text_hover'       => '#192649',//+
                        'text_link2'       => '#ce1068',//+
                        'text_hover2'      => '#fe9e25',//+
                        'text_link3'       => '#640f76',//+
                        'text_hover3'      => '#f3f3f3',//

                        // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                        'alter_bg_color'   => '#f0f9fe',//+
                        'alter_bg_hover'   => '#e6eff6',//+
                        'alter_bd_color'   => '#e1eaf1',//+
                        'alter_bd_hover'   => '#c4ccd0',//
                        'alter_text'       => '#404040',//+
                        'alter_light'      => '#c0c8cb',//+
                        'alter_dark'       => '#0e1836',//+
                        'alter_link'       => '#44adb5',//+
                        'alter_hover'      => '#192649',//+
                        'alter_link2'      => '#640f76',//+
                        'alter_hover2'     => '#c0c8cb',//
                        'alter_link3'      => '#111111',//+
                        'alter_hover3'     => '#ce1068',//+

                        // Extra blocks (submenu, tabs, color blocks, etc.)
                        'extra_bg_color'   => '#0e1836',//+
                        'extra_bg_hover'   => '#28272e',
                        'extra_bd_color'   => '#192649',//+
                        'extra_bd_hover'   => '#125f16',
                        'extra_text'       => '#979694',//+
                        'extra_light'      => '#adadad',//+
                        'extra_dark'       => '#ffffff',//+
                        'extra_link'       => '#fe9e25',//+
                        'extra_hover'      => '#fe9e25',//
                        'extra_link2'      => '#1a2649',//+
                        'extra_hover2'     => '#404040',//
                        'extra_link3'      => '#192649',//
                        'extra_hover3'     => '#ce1068',//+

                        // Input fields (form's fields and textarea)
                        'input_bg_color'   => '#ffffff',//+
                        'input_bg_hover'   => '#ffffff',//+
                        'input_bd_color'   => '#e1eaf1',//+
                        'input_bd_hover'   => '#111111',//
                        'input_text'       => '#c0c8cb',//+
                        'input_light'      => '#777777',//
                        'input_dark'       => '#0e1736',//+

                        // Inverse blocks (text and links on the 'text_link' background)
                        'inverse_bd_color' => '#67bcc1',
                        'inverse_bd_hover' => '#0e1736',//+
                        'inverse_text'     => '#ffffff',//+
                        'inverse_light'    => '#eeeeee',//+
                        'inverse_dark'     => '#0e1736',//+
                        'inverse_link'     => '#ffffff',//+
                        'inverse_hover'    => '#0e1736',//+
                    ),
                ),

                // Color scheme: 'dark'
                'dark'    => array(
                    'title'    => esc_html__( 'Dark', 'ekoterra' ),
                    'internal' => true,
                    'colors'   => array(

                        // Whole block border and background
                        'bg_color'         => '#0e1736',//+
                        'bd_color'         => '#303d5f',//+

                        // Text and links colors
                        'text'             => '#9499ac',//+
                        'text_light'       => '#747b8e',//+
                        'text_dark'        => '#ffffff',//+
                        'text_link'        => '#fe9e25',//+
                        'text_hover'       => '#ffffff',//+
                        'text_link2'       => '#ce1068',//+
                        'text_hover2'      => '#8be77c',
                        'text_link3'       => '#ddb837',
                        'text_hover3'      => '#eec432',

                        // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                        'alter_bg_color'   => '#192649',//+
                        'alter_bg_hover'   => '#333e5c',//+
                        'alter_bd_color'   => '#303d5f',//+
                        'alter_bd_hover'   => '#125f16',//
                        'alter_text'       => '#9499ac',//+
                        'alter_light'      => '#747b8e',//+
                        'alter_dark'       => '#ffffff',//+
                        'alter_link'       => '#fe9e25',//+
                        'alter_hover'      => '#ffffff',//+
                        'alter_link2'      => '#ffffff',
                        'alter_hover2'     => '#c0c8cb',//
                        'alter_link3'      => '#fe9e25',//
                        'alter_hover3'     => '#ce1068',//++

                        // Extra blocks (submenu, tabs, color blocks, etc.)
                        'extra_bg_color'   => '#f7f6f2',//+
                        'extra_bg_hover'   => '#f4f5f7',//+
                        'extra_bd_color'   => '#e5e5e5',//+
                        'extra_bd_hover'   => '#4a4a4a',
                        'extra_text'       => '#333333',//+
                        'extra_light'      => '#b7b7b7',//+
                        'extra_dark'       => '#2e2d32',//+
                        'extra_link'       => '#640f76',//+
                        'extra_hover'      => '#fe9e25',//
                        'extra_link2'      => '#ffffff',//
                        'extra_hover2'     => '#404040',//
                        'extra_link3'      => '#0e1836',//+
                        'extra_hover3'     => '#ce1068',//+

                        // Input fields (form's fields and textarea)
                        'input_bg_color'   => '#192649',//+
                        'input_bg_hover'   => '#192649',//+
                        'input_bd_color'   => '#303d5f',//+
                        'input_bd_hover'   => '#ffffff',//+
                        'input_text'       => '#7e8699',//+
                        'input_light'      => '#6f6f6f',
                        'input_dark'       => '#ffffff',//+

                        // Inverse blocks (text and links on the 'text_link' background)
                        'inverse_bd_color' => '#e36650',
                        'inverse_bd_hover' => '#cb5b47',
                        'inverse_text'     => '#1d1d1d',//+
                        'inverse_light'    => '#6f6f6f',
                        'inverse_dark'     => '#1d1d1d',//+
                        'inverse_link'     => '#ffffff',//+
                        'inverse_hover'    => '#1d1d1d',//+
                    ),
                ),

            )
        );

        ekoterra_storage_set(
            'scheme_colors_add', array(
                'bg_color_0'        => array(
                    'color' => 'bg_color',
                    'alpha' => 0,
                ),
                'bg_color_02'       => array(
                    'color' => 'bg_color',
                    'alpha' => 0.2,
                ),
                'bg_color_07'       => array(
                    'color' => 'bg_color',
                    'alpha' => 0.7,
                ),
                'bg_color_08'       => array(
                    'color' => 'bg_color',
                    'alpha' => 0.8,
                ),
                'bg_color_09'       => array(
                    'color' => 'bg_color',
                    'alpha' => 0.9,
                ),
                'alter_bg_color_07' => array(
                    'color' => 'alter_bg_color',
                    'alpha' => 0.7,
                ),
                'alter_bg_color_04' => array(
                    'color' => 'alter_bg_color',
                    'alpha' => 0.4,
                ),
                'alter_bg_color_02' => array(
                    'color' => 'alter_bg_color',
                    'alpha' => 0.2,
                ),
                'alter_bd_color_02' => array(
                    'color' => 'alter_bd_hover',
                    'alpha' => 0.2,
                ),
                'alter_link_02'     => array(
                    'color' => 'alter_link',
                    'alpha' => 0.2,
                ),
                'alter_link_07'     => array(
                    'color' => 'alter_link',
                    'alpha' => 0.7,
                ),
                'extra_bg_color_07' => array(
                    'color' => 'extra_bg_color',
                    'alpha' => 0.7,
                ),
                'extra_link_02'     => array(
                    'color' => 'extra_link',
                    'alpha' => 0.2,
                ),
                'extra_link_07'     => array(
                    'color' => 'extra_link',
                    'alpha' => 0.7,
                ),
                'extra_dark_03'     => array(
                    'color' => 'extra_dark',
                    'alpha' => 0.3,
                ),
                'extra_dark_07'     => array(
                    'color' => 'extra_dark',
                    'alpha' => 0.7,
                ),
                'text_dark_07'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.7,
                ),
                'text_link_02'      => array(
                    'color' => 'text_link',
                    'alpha' => 0.2,
                ),
                'text_link_07'      => array(
                    'color' => 'text_link',
                    'alpha' => 0.7,
                ),
                'text_link_blend'   => array(
                    'color'      => 'text_link',
                    'hue'        => 2,
                    'saturation' => -5,
                    'brightness' => 5,
                ),
                'alter_link_blend'  => array(
                    'color'      => 'alter_link',
                    'hue'        => 2,
                    'saturation' => -5,
                    'brightness' => 5,
                ),
            )
        );
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'ekoterra_skin_tgmpa_required_plugins' ) ) {
	add_filter( 'ekoterra_filter_tgmpa_required_plugins', 'ekoterra_skin_tgmpa_required_plugins' );
	function ekoterra_skin_tgmpa_required_plugins( $list = array() ) {
		// ToDo: Check if plugin is in the 'required_plugins' and add his parameters to the TGMPA-list
		//       Replace 'skin-specific-plugin-slug' to the real slug of the plugin
		if ( ekoterra_storage_isset( 'required_plugins', 'skin-specific-plugin-slug' ) ) {
			$list[] = array(
				'name'     => ekoterra_storage_get_array( 'required_plugins', 'skin-specific-plugin-slug' ),
				'slug'     => 'skin-specific-plugin-slug',
				'required' => false,
			);
		}
		return $list;
	}
}


//------------------------------------------------------------------------
// One-click import support
//------------------------------------------------------------------------

// Set theme specific importer options
if ( ! function_exists( 'ekoterra_skin_importer_set_options' ) ) {
    add_filter('trx_addons_filter_importer_options', 'ekoterra_skin_importer_set_options', 9);
    function ekoterra_skin_importer_set_options($options = array()) {
        if (is_array($options)) {
            // Agency News demo
            $options['demo_type'] = 'animal-trafficking';
            $options['files']['animal-trafficking'] = $options['files']['default'];
            $options['files']['animal-trafficking']['title'] = esc_html__('Animal Trafficking Demo', 'ekoterra');
            $options['files']['animal-trafficking']['domain_dev']  = '';
            $options['files']['animal-trafficking']['domain_demo'] = esc_url( ekoterra_get_protocol() . '://animal-trafficking.ekoterra.ancorathemes.com' );   // Demo-site domain
            unset($options['files']['default']);
        }
        return $options;
    }
}


// Enqueue skin-specific styles and scripts
// Priority 1150 - after plugins-specific (1100), but before child theme (1200)
if ( ! function_exists( 'ekoterra_skin_frontend_scripts' ) ) {
	add_action( 'wp_enqueue_scripts', 'ekoterra_skin_frontend_scripts', 1150 );
	function ekoterra_skin_frontend_scripts() {
		$ekoterra_url = ekoterra_get_file_url( EKOTERRA_SKIN_DIR . 'skin.css' );
		if ( '' != $ekoterra_url ) {
			wp_enqueue_style( 'ekoterra-skin-' . esc_attr( EKOTERRA_SKIN_NAME ), $ekoterra_url, array(), null );
		}
	}
}

// Enqueue skin-specific responsive styles
// Priority 2050 - after theme responsive 2000
if ( ! function_exists( 'ekoterra_skin_styles_responsive' ) ) {
	add_action( 'wp_enqueue_scripts', 'ekoterra_skin_styles_responsive', 2050 );
	function ekoterra_skin_styles_responsive() {
		$ekoterra_url = ekoterra_get_file_url( EKOTERRA_SKIN_DIR . 'skin-responsive.css' );
		if ( '' != $ekoterra_url ) {
			wp_enqueue_style( 'ekoterra-skin-' . esc_attr( EKOTERRA_SKIN_NAME ) . '-responsive', $ekoterra_url, array(), null );
		}
	}
}

// Merge custom scripts
if ( ! function_exists( 'ekoterra_skin_merge_scripts' ) ) {
	add_filter( 'ekoterra_filter_merge_scripts', 'ekoterra_skin_merge_scripts' );
	function ekoterra_skin_merge_scripts( $list ) {
		if ( ekoterra_get_file_dir( EKOTERRA_SKIN_DIR . 'skin.js' ) != '' ) {
			$list[] = EKOTERRA_SKIN_DIR . 'skin.js';
		}
		return $list;
	}
}


// Add slin-specific colors and fonts to the custom CSS
require_once EKOTERRA_THEME_DIR . EKOTERRA_SKIN_DIR . 'skin-styles.php';
