<?php
/**
 * Skins support: Main skin file for the skin 'Default'
 *
 * Setup skin-dependent fonts and colors, load scripts and styles,
 * and other operations that affect the appearance and behavior of the theme
 * when the skin is activated
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0.46
 */


// Theme init priorities:
// 3 - add/remove Theme Options elements
if ( ! function_exists( 'ekoterra_skin_theme_setup3' ) ) {
	add_action( 'after_setup_theme', 'ekoterra_skin_theme_setup3', 3 );
	function ekoterra_skin_theme_setup3() {
		// ToDo: Add / Modify theme options, required plugins, etc.
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'ekoterra_skin_tgmpa_required_plugins' ) ) {
	add_filter( 'ekoterra_filter_tgmpa_required_plugins', 'ekoterra_skin_tgmpa_required_plugins' );
	function ekoterra_skin_tgmpa_required_plugins( $list = array() ) {
		// ToDo: Check if plugin is in the 'required_plugins' and add his parameters to the TGMPA-list
		//       Replace 'skin-specific-plugin-slug' to the real slug of the plugin
		if ( ekoterra_storage_isset( 'required_plugins', 'skin-specific-plugin-slug' ) ) {
			$list[] = array(
				'name'     => ekoterra_storage_get_array( 'required_plugins', 'skin-specific-plugin-slug' ),
				'slug'     => 'skin-specific-plugin-slug',
				'required' => false,
			);
		}
		return $list;
	}
}

// Enqueue skin-specific styles and scripts
// Priority 1150 - after plugins-specific (1100), but before child theme (1200)
if ( ! function_exists( 'ekoterra_skin_frontend_scripts' ) ) {
	add_action( 'wp_enqueue_scripts', 'ekoterra_skin_frontend_scripts', 1150 );
	function ekoterra_skin_frontend_scripts() {
		$ekoterra_url = ekoterra_get_file_url( EKOTERRA_SKIN_DIR . 'skin.css' );
		if ( '' != $ekoterra_url ) {
			wp_enqueue_style( 'ekoterra-skin-' . esc_attr( EKOTERRA_SKIN_NAME ), $ekoterra_url, array(), null );
		}
	}
}

// Enqueue skin-specific responsive styles
// Priority 2050 - after theme responsive 2000
if ( ! function_exists( 'ekoterra_skin_styles_responsive' ) ) {
	add_action( 'wp_enqueue_scripts', 'ekoterra_skin_styles_responsive', 2050 );
	function ekoterra_skin_styles_responsive() {
		$ekoterra_url = ekoterra_get_file_url( EKOTERRA_SKIN_DIR . 'skin-responsive.css' );
		if ( '' != $ekoterra_url ) {
			wp_enqueue_style( 'ekoterra-skin-' . esc_attr( EKOTERRA_SKIN_NAME ) . '-responsive', $ekoterra_url, array(), null );
		}
	}
}

// Merge custom scripts
if ( ! function_exists( 'ekoterra_skin_merge_scripts' ) ) {
	add_filter( 'ekoterra_filter_merge_scripts', 'ekoterra_skin_merge_scripts' );
	function ekoterra_skin_merge_scripts( $list ) {
		if ( ekoterra_get_file_dir( EKOTERRA_SKIN_DIR . 'skin.js' ) != '' ) {
			$list[] = EKOTERRA_SKIN_DIR . 'skin.js';
		}
		return $list;
	}
}


// Add slin-specific colors and fonts to the custom CSS
require_once EKOTERRA_THEME_DIR . EKOTERRA_SKIN_DIR . 'skin-styles.php';
