<?php
// Add skin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'ekoterra_skin_get_css' ) ) {
    add_filter( 'ekoterra_filter_get_css', 'ekoterra_skin_get_css', 10, 2 );
    function ekoterra_skin_get_css( $css, $args ) {

        if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
            $fonts         = $args['fonts'];
            $css['fonts'] .= <<<CSS

CSS;
        }

        if ( isset( $css['vars'] ) && isset( $args['vars'] ) ) {
            $vars         = $args['vars'];
            $css['vars'] .= <<<CSS

CSS;
        }

        if ( isset( $css['colors'] ) && isset( $args['colors'] ) ) {
            $colors         = $args['colors'];
            $css['colors'] .= <<<CSS


        /* Normal button */
        .sc_button_default.color_style_link4:hover,
        .sc_button.color_style_link4:not(.sc_button_simple):not(.sc_button_bordered):not(.sc_button_bg_image):hover {
            background-color: {$colors['text_hover3']};
        }

         /* Promo */
        .scheme_dark .sc_promo .sc_button:not(.sc_button_simple):not(.sc_button_bordered):not(.sc_button_bg_image):hover{
            background-color: {$colors['extra_link3']} !important;
        }
        /* Skills (Pie) */
        .sc_skills_pie .sc_skills_item_wrap{
            background-color:{$colors['text_link3']};
        }
        /* Scroll to top */
        .trx_addons_scroll_to_top:hover,
        .trx_addons_cv .trx_addons_scroll_to_top:hover {
             color: {$colors['inverse_link']};
        }
        /* Social link */
        .scheme_dark .post_item_single .post_content .post_meta .post_share .social_item:hover .social_icon{
            background-color: {$colors['text_hover3']};
        }
         /* Give donation */
        .give-progress-bar{
            background-color: {$colors['alter_bg_hover']};
        }
         /* Mail chimp */
        form.mc4wp-form .mc4wp-form-fields input[type="submit"]:hover{
            background-color: {$colors['text_hover3']};
        }
        /* Woocommerce */
        .scheme_dark .sidebar .widget_shopping_cart{
            background-color: {$colors['inverse_bd_color']};
        }

        .woocommerce-page ul.product_list_widget li a:hover {
            color: {$colors['text_hover']} !important;
        }

CSS;
        }

        return $css;
    }
}

