<?php
/**
 * Skins support: Main skin file for the skin 'Honor'
 *
 * Setup skin-dependent fonts and colors, load scripts and styles,
 * and other operations that affect the appearance and behavior of the theme
 * when the skin is activated
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0.46
 */


// Theme init priorities:
// 3 - add/remove Theme Options elements
if ( ! function_exists( 'ekoterra_skin_theme_setup3' ) ) {
	add_action( 'after_setup_theme', 'ekoterra_skin_theme_setup3', 3 );
	function ekoterra_skin_theme_setup3() {
        ekoterra_storage_set(
            'schemes', array(

                // Color scheme: 'default'
                'default' => array(
                    'title'    => esc_html__( 'Default', 'ekoterra' ),
                    'internal' => true,
                    'colors'   => array(

                        // Whole block border and background
                        'bg_color'         => '#ffffff',//
                        'bd_color'         => '#f6f5f1',//

                        // Text and links colors
                        'text'             => '#404040',//
                        'text_light'       => '#777777',//
                        'text_dark'        => '#1a1a1a',//
                        'text_link'        => '#007736',//
                        'text_hover'       => '#111111',//
                        'text_link2'       => '#007736',//
                        'text_hover2'      => '#c60304',//
                        'text_link3'       => '#c60304',//
                        'text_hover3'      => '#007736',//

                        // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                        'alter_bg_color'   => '#f6f6f6',//
                        'alter_bg_hover'   => '#ededed',//
                        'alter_bd_color'   => '#f6f5f1',//
                        'alter_bd_hover'   => '#c4ccd0',//
                        'alter_text'       => '#404040',//
                        'alter_light'      => '#989c9c',//
                        'alter_dark'       => '#111111',//
                        'alter_link'       => '#007736',//
                        'alter_hover'      => '#111111',//
                        'alter_link2'      => '#c60304',//
                        'alter_hover2'     => '#acacac',//
                        'alter_link3'      => '#111111',//
                        'alter_hover3'     => '#007736',//

                        // Extra blocks (submenu, tabs, color blocks, etc.)
                        'extra_bg_color'   => '#111111',//
                        'extra_bg_hover'   => '#28272e',
                        'extra_bd_color'   => '#292929',//
                        'extra_bd_hover'   => '#125f16',
                        'extra_text'       => '#979694',//
                        'extra_light'      => '#adadad',//
                        'extra_dark'       => '#ffffff',//
                        'extra_link'       => '#c60304',//
                        'extra_hover'      => '#c60304',//
                        'extra_link2'      => '#c60304',//
                        'extra_hover2'     => '#404040',//
                        'extra_link3'      => '#111111',//
                        'extra_hover3'     => '#007736',//

                        // Input fields (form's fields and textarea)
                        'input_bg_color'   => '#ffffff',//
                        'input_bg_hover'   => '#ffffff',//
                        'input_bd_color'   => '#e5e5e5',//
                        'input_bd_hover'   => '#111111',//
                        'input_text'       => '#989c9c',//
                        'input_light'      => '#777777',//
                        'input_dark'       => '#111111',//

                        // Inverse blocks (text and links on the 'text_link' background)
                        'inverse_bd_color' => '#67bcc1',
                        'inverse_bd_hover' => '#5aa4a9',
                        'inverse_text'     => '#ffffff',//
                        'inverse_light'    => '#eeeeee',//
                        'inverse_dark'     => '#111111',//
                        'inverse_link'     => '#ffffff',//
                        'inverse_hover'    => '#111111',//
                    ),
                ),

                // Color scheme: 'dark'
                'dark'    => array(
                    'title'    => esc_html__( 'Dark', 'ekoterra' ),
                    'internal' => true,
                    'colors'   => array(

                        // Whole block border and background
                        'bg_color'         => '#000000',//
                        'bd_color'         => '#292929',//

                        // Text and links colors
                        'text'             => '#a6a6a6',//
                        'text_light'       => '#adadad',//
                        'text_dark'        => '#ffffff',//
                        'text_link'        => '#c60304',//
                        'text_hover'       => '#ffffff',//
                        'text_link2'       => '#c60304',
                        'text_hover2'      => '#8be77c',
                        'text_link3'       => '#c60304',
                        'text_hover3'      => '#007736',

                        // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                        'alter_bg_color'   => '#111111',//
                        'alter_bg_hover'   => '#313131',//
                        'alter_bd_color'   => '#313131',//
                        'alter_bd_hover'   => '#125f16',//
                        'alter_text'       => '#a6a6a6',//
                        'alter_light'      => '#adadad',//
                        'alter_dark'       => '#ffffff',//
                        'alter_link'       => '#c60304',//
                        'alter_hover'      => '#ffffff',//
                        'alter_link2'      => '#ffffff',
                        'alter_hover2'     => '#d9e3e9',//
                        'alter_link3'      => '#c60304',//
                        'alter_hover3'     => '#007736',//

                        // Extra blocks (submenu, tabs, color blocks, etc.)
                        'extra_bg_color'   => '#f8f6f2',//
                        'extra_bg_hover'   => '#f3f5f7',//
                        'extra_bd_color'   => '#e5e5e5',//
                        'extra_bd_hover'   => '#4a4a4a',
                        'extra_text'       => '#333333',//
                        'extra_light'      => '#b7b7b7',//
                        'extra_dark'       => '#2e2d32',//
                        'extra_link'       => '#007736',//
                        'extra_hover'      => '#c60304',//
                        'extra_link2'      => '#ffffff',//
                        'extra_hover2'     => '#404040',//
                        'extra_link3'      => '#111111',//
                        'extra_hover3'     => '#007736',//

                        // Input fields (form's fields and textarea)
                        'input_bg_color'   => '#212121',//
                        'input_bg_hover'   => '#212121',//
                        'input_bd_color'   => '#313131',//
                        'input_bd_hover'   => '#353535',
                        'input_text'       => '#6b6966',//
                        'input_light'      => '#6f6f6f',
                        'input_dark'       => '#ffffff',//

                        // Inverse blocks (text and links on the 'text_link' background)
                        'inverse_bd_color' => '#e36650',
                        'inverse_bd_hover' => '#cb5b47',
                        'inverse_text'     => '#1d1d1d',//
                        'inverse_light'    => '#6f6f6f',
                        'inverse_dark'     => '#1d1d1d',//
                        'inverse_link'     => '#ffffff',//
                        'inverse_hover'    => '#1d1d1d',//
                    ),
                ),

            )
        );
        ekoterra_storage_set(
            'scheme_colors_add', array(
                'bg_color_0'        => array(
                    'color' => 'bg_color',
                    'alpha' => 0,
                ),
                'bg_color_02'       => array(
                    'color' => 'bg_color',
                    'alpha' => 0.2,
                ),
                'bg_color_07'       => array(
                    'color' => 'bg_color',
                    'alpha' => 0.7,
                ),
                'bg_color_08'       => array(
                    'color' => 'bg_color',
                    'alpha' => 0.8,
                ),
                'bg_color_09'       => array(
                    'color' => 'bg_color',
                    'alpha' => 0.9,
                ),
                'alter_bg_color_07' => array(
                    'color' => 'alter_bg_color',
                    'alpha' => 0.7,
                ),
                'alter_bg_color_04' => array(
                    'color' => 'alter_bg_color',
                    'alpha' => 0.4,
                ),
                'alter_bg_color_02' => array(
                    'color' => 'alter_bg_color',
                    'alpha' => 0.2,
                ),
                'alter_bd_color_02' => array(
                    'color' => 'alter_bd_hover',
                    'alpha' => 0.2,
                ),
                'alter_link_02'     => array(
                    'color' => 'alter_link',
                    'alpha' => 0.2,
                ),
                'alter_link_07'     => array(
                    'color' => 'alter_link',
                    'alpha' => 0.7,
                ),
                'extra_bg_color_07' => array(
                    'color' => 'extra_bg_color',
                    'alpha' => 0.7,
                ),
                'extra_link_02'     => array(
                    'color' => 'extra_link',
                    'alpha' => 0.2,
                ),
                'extra_link_07'     => array(
                    'color' => 'extra_link',
                    'alpha' => 0.7,
                ),
                'extra_dark_03'     => array(
                    'color' => 'extra_dark',
                    'alpha' => 0.3,
                ),
                'extra_dark_07'     => array(
                    'color' => 'extra_dark',
                    'alpha' => 0.7,
                ),
                'text_dark_07'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.7,
                ),
                'text_link_02'      => array(
                    'color' => 'text_link',
                    'alpha' => 0.2,
                ),
                'text_link_07'      => array(
                    'color' => 'text_link',
                    'alpha' => 0.7,
                ),
                'text_link_blend'   => array(
                    'color'      => 'text_link',
                    'hue'        => 2,
                    'saturation' => -5,
                    'brightness' => 5,
                ),
                'alter_link_blend'  => array(
                    'color'      => 'alter_link',
                    'hue'        => 2,
                    'saturation' => -5,
                    'brightness' => 5,
                ),
            )
        );
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'ekoterra_skin_tgmpa_required_plugins' ) ) {
	add_filter( 'ekoterra_filter_tgmpa_required_plugins', 'ekoterra_skin_tgmpa_required_plugins' );
	function ekoterra_skin_tgmpa_required_plugins( $list = array() ) {
		// ToDo: Check if plugin is in the 'required_plugins' and add his parameters to the TGMPA-list
		//       Replace 'skin-specific-plugin-slug' to the real slug of the plugin
		if ( ekoterra_storage_isset( 'required_plugins', 'skin-specific-plugin-slug' ) ) {
			$list[] = array(
				'name'     => ekoterra_storage_get_array( 'required_plugins', 'skin-specific-plugin-slug' ),
				'slug'     => 'skin-specific-plugin-slug',
				'required' => false,
			);
		}
		return $list;
	}
}
//------------------------------------------------------------------------
// One-click import support
//------------------------------------------------------------------------

// Set theme specific importer options
if ( ! function_exists( 'ekoterra_skin_importer_set_options' ) ) {
    add_filter('trx_addons_filter_importer_options', 'ekoterra_skin_importer_set_options', 9);
    function ekoterra_skin_importer_set_options($options = array()) {
        if (is_array($options)) {
            // Agency News demo
            $options['demo_type'] = 'stop-war';
            $options['files']['stop-war'] = $options['files']['default'];
            $options['files']['stop-war']['title'] = esc_html__('Stop War Demo', 'ekoterra');
            $options['files']['stop-war']['domain_dev']  = '';
            $options['files']['stop-war']['domain_demo'] = esc_url( ekoterra_get_protocol() . '://stop-war.ekoterra.ancorathemes.com' );   // Demo-site domain
            unset($options['files']['default']);
        }
        return $options;
    }
}


// Enqueue skin-specific styles and scripts
// Priority 1150 - after plugins-specific (1100), but before child theme (1200)
if ( ! function_exists( 'ekoterra_skin_frontend_scripts' ) ) {
	add_action( 'wp_enqueue_scripts', 'ekoterra_skin_frontend_scripts', 1150 );
	function ekoterra_skin_frontend_scripts() {
		$ekoterra_url = ekoterra_get_file_url( EKOTERRA_SKIN_DIR . 'skin.css' );
		if ( '' != $ekoterra_url ) {
			wp_enqueue_style( 'ekoterra-skin-' . esc_attr( EKOTERRA_SKIN_NAME ), $ekoterra_url, array(), null );
		}
	}
}

// Enqueue skin-specific responsive styles
// Priority 2050 - after theme responsive 2000
if ( ! function_exists( 'ekoterra_skin_styles_responsive' ) ) {
	add_action( 'wp_enqueue_scripts', 'ekoterra_skin_styles_responsive', 2050 );
	function ekoterra_skin_styles_responsive() {
		$ekoterra_url = ekoterra_get_file_url( EKOTERRA_SKIN_DIR . 'skin-responsive.css' );
		if ( '' != $ekoterra_url ) {
			wp_enqueue_style( 'ekoterra-skin-' . esc_attr( EKOTERRA_SKIN_NAME ) . '-responsive', $ekoterra_url, array(), null );
		}
	}
}

// Merge custom scripts
if ( ! function_exists( 'ekoterra_skin_merge_scripts' ) ) {
	add_filter( 'ekoterra_filter_merge_scripts', 'ekoterra_skin_merge_scripts' );
	function ekoterra_skin_merge_scripts( $list ) {
		if ( ekoterra_get_file_dir( EKOTERRA_SKIN_DIR . 'skin.js' ) != '' ) {
			$list[] = EKOTERRA_SKIN_DIR . 'skin.js';
		}
		return $list;
	}
}


// Add slin-specific colors and fonts to the custom CSS
require_once EKOTERRA_THEME_DIR . EKOTERRA_SKIN_DIR . 'skin-styles.php';
