<?php
/**
 * The template to display Admin notices
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0.1
 */

$ekoterra_theme_obj = wp_get_theme();
?>
<div class="ekoterra_admin_notice ekoterra_welcome_notice update-nag">
	<?php
	// Theme image
	$ekoterra_theme_img = ekoterra_get_file_url( 'screenshot.jpg' );
	if ( '' != $ekoterra_theme_img ) {
		?>
		<div class="ekoterra_notice_image"><img src="<?php echo esc_url( $ekoterra_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'ekoterra' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="ekoterra_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'ekoterra' ),
				$ekoterra_theme_obj->name . ( EKOTERRA_THEME_FREE ? ' ' . __( 'Free', 'ekoterra' ) : '' ),
				$ekoterra_theme_obj->version
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="ekoterra_notice_text">
		<p class="ekoterra_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $ekoterra_theme_obj->description ) );
			?>
		</p>
		<p class="ekoterra_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'ekoterra' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="ekoterra_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=ekoterra_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'ekoterra' );
			?>
		</a>
		<?php		
		// Dismiss this notice
		?>
		<a href="#" class="ekoterra_hide_notice"><i class="dashicons dashicons-dismiss"></i> <span class="ekoterra_hide_notice_text"><?php esc_html_e( 'Dismiss', 'ekoterra' ); ?></span></a>
	</div>
</div>
