<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
if ( ! ekoterra_is_inherit( ekoterra_get_theme_option( 'copyright_scheme' ) ) ) {
	echo ' scheme_' . esc_attr( ekoterra_get_theme_option( 'copyright_scheme' ) );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$ekoterra_copyright = ekoterra_get_theme_option( 'copyright' );
			if ( ! empty( $ekoterra_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$ekoterra_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $ekoterra_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$ekoterra_copyright = ekoterra_prepare_macros( $ekoterra_copyright );
				// Display copyright
				echo wp_kses( nl2br( $ekoterra_copyright ), 'ekoterra_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
