<?php
/**
 * The template to display default site footer
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0.10
 */

$ekoterra_footer_id = ekoterra_get_custom_footer_id();
$ekoterra_footer_meta = get_post_meta( $ekoterra_footer_id, 'trx_addons_options', true );
if ( ! empty( $ekoterra_footer_meta['margin'] ) ) {
	ekoterra_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( ekoterra_prepare_css_value( $ekoterra_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $ekoterra_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $ekoterra_footer_id ) ) ); ?>
						<?php
						if ( ! ekoterra_is_inherit( ekoterra_get_theme_option( 'footer_scheme' ) ) ) {
							echo ' scheme_' . esc_attr( ekoterra_get_theme_option( 'footer_scheme' ) );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'ekoterra_action_show_layout', $ekoterra_footer_id );
	?>
</footer><!-- /.footer_wrap -->
