<?php
/**
 * The template to display the site logo in the footer
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0.10
 */

// Logo
if ( ekoterra_is_on( ekoterra_get_theme_option( 'logo_in_footer' ) ) ) {
	$ekoterra_logo_image = ekoterra_get_logo_image( 'footer' );
	$ekoterra_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $ekoterra_logo_image ) || ! empty( $ekoterra_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $ekoterra_logo_image ) ) {
					$ekoterra_attr = ekoterra_getimagesize( $ekoterra_logo_image );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $ekoterra_logo_image ) . '"'
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'ekoterra' ) . '"'
								. ( ! empty( $ekoterra_attr[3] ) ? ' ' . wp_kses_data( $ekoterra_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $ekoterra_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $ekoterra_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
