<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0.10
 */

// Footer sidebar
$ekoterra_footer_name    = ekoterra_get_theme_option( 'footer_widgets' );
$ekoterra_footer_present = ! ekoterra_is_off( $ekoterra_footer_name ) && is_active_sidebar( $ekoterra_footer_name );
if ( $ekoterra_footer_present ) {
	ekoterra_storage_set( 'current_sidebar', 'footer' );
	$ekoterra_footer_wide = ekoterra_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $ekoterra_footer_name ) ) {
		dynamic_sidebar( $ekoterra_footer_name );
	}
	$ekoterra_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $ekoterra_out ) ) {
		$ekoterra_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $ekoterra_out );
		$ekoterra_need_columns = true;   //or check: strpos($ekoterra_out, 'columns_wrap')===false;
		if ( $ekoterra_need_columns ) {
			$ekoterra_columns = max( 0, (int) ekoterra_get_theme_option( 'footer_columns' ) );
			if ( 0 == $ekoterra_columns ) {
				$ekoterra_columns = min( 4, max( 1, substr_count( $ekoterra_out, '<aside ' ) ) );
			}
			if ( $ekoterra_columns > 1 ) {
				$ekoterra_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $ekoterra_columns ) . ' widget', $ekoterra_out );
			} else {
				$ekoterra_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $ekoterra_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $ekoterra_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $ekoterra_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'ekoterra_action_before_sidebar' );
				ekoterra_show_layout( $ekoterra_out );
				do_action( 'ekoterra_action_after_sidebar' );
				if ( $ekoterra_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $ekoterra_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
