<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0.06
 */

$ekoterra_header_css   = '';
$ekoterra_header_image = get_header_image();
$ekoterra_header_video = ekoterra_get_header_video();
if ( ! empty( $ekoterra_header_image ) && ekoterra_trx_addons_featured_image_override( is_singular() || ekoterra_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$ekoterra_header_image = ekoterra_get_current_mode_image( $ekoterra_header_image );
}

$ekoterra_header_id = ekoterra_get_custom_header_id();
$ekoterra_header_meta = get_post_meta( $ekoterra_header_id, 'trx_addons_options', true );
if ( ! empty( $ekoterra_header_meta['margin'] ) ) {
	ekoterra_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( ekoterra_prepare_css_value( $ekoterra_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $ekoterra_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $ekoterra_header_id ) ) ); ?>
				<?php
				echo ! empty( $ekoterra_header_image ) || ! empty( $ekoterra_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $ekoterra_header_video ) {
					echo ' with_bg_video';
				}
				if ( '' != $ekoterra_header_image ) {
					echo ' ' . esc_attr( ekoterra_add_inline_css_class( 'background-image: url(' . esc_url( $ekoterra_header_image ) . ');' ) );
				}
				if ( is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				if ( ekoterra_is_on( ekoterra_get_theme_option( 'header_fullheight' ) ) ) {
					echo ' header_fullheight ekoterra-full-height';
				}
				if ( ! ekoterra_is_inherit( ekoterra_get_theme_option( 'header_scheme' ) ) ) {
					echo ' scheme_' . esc_attr( ekoterra_get_theme_option( 'header_scheme' ) );
				}
				?>
">
	<?php

	// Background video
	if ( ! empty( $ekoterra_header_video ) ) {
		get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'templates/header-video' ) );
	}

	// Custom header's layout
	do_action( 'ekoterra_action_show_layout', $ekoterra_header_id );

	// Header widgets area
	get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'templates/header-widgets' ) );

	?>
</header>
