<?php
/**
 * The template to display default site header
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0
 */

$ekoterra_header_css   = '';
$ekoterra_header_image = get_header_image();
$ekoterra_header_video = ekoterra_get_header_video();
if ( ! empty( $ekoterra_header_image ) && ekoterra_trx_addons_featured_image_override( is_singular() || ekoterra_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$ekoterra_header_image = ekoterra_get_current_mode_image( $ekoterra_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $ekoterra_header_image ) || ! empty( $ekoterra_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $ekoterra_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $ekoterra_header_image ) {
		echo ' ' . esc_attr( ekoterra_add_inline_css_class( 'background-image: url(' . esc_url( $ekoterra_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( ekoterra_is_on( ekoterra_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight ekoterra-full-height';
	}
	if ( ! ekoterra_is_inherit( ekoterra_get_theme_option( 'header_scheme' ) ) ) {
		echo ' scheme_' . esc_attr( ekoterra_get_theme_option( 'header_scheme' ) );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $ekoterra_header_video ) ) {
		get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	if ( ekoterra_get_theme_option( 'menu_style' ) == 'top' ) {
		get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'templates/header-navi' ) );
	}

	// Mobile header
	if ( ekoterra_is_on( ekoterra_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
    if ( ! is_single() ) {
        get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'templates/header-title' ) );
    }

	// Header widgets area
	get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'templates/header-widgets' ) );

	// Display featured image in the header on the single posts
	// Comment next line to prevent show featured image in the header area
	// and display it in the post's content
	get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'templates/header-single' ) );

	?>
</header>
