<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package ekoterra
 * @since ekoterra 1.0
 */

$ekoterra_args = get_query_var( 'ekoterra_logo_args' );

// Site logo
$ekoterra_logo_type   = isset( $ekoterra_args['type'] ) ? $ekoterra_args['type'] : '';
$ekoterra_logo_image  = ekoterra_get_logo_image( $ekoterra_logo_type );
$ekoterra_logo_text   = ekoterra_is_on( ekoterra_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$ekoterra_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $ekoterra_logo_image['logo'] ) || ! empty( $ekoterra_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $ekoterra_logo_image['logo'] ) ) {
			if ( empty( $ekoterra_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric( $ekoterra_logo_image['logo'] ) && $ekoterra_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$ekoterra_attr = ekoterra_getimagesize( $ekoterra_logo_image['logo'] );
				echo '<img src="' . esc_url( $ekoterra_logo_image['logo'] ) . '"'
						. ( ! empty( $ekoterra_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $ekoterra_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $ekoterra_logo_text ) . '"'
						. ( ! empty( $ekoterra_attr[3] ) ? ' ' . wp_kses_data( $ekoterra_attr[3] ) : '' )
						. '>';
			}
		} else {
			ekoterra_show_layout( ekoterra_prepare_macros( $ekoterra_logo_text ), '<span class="logo_text">', '</span>' );
			ekoterra_show_layout( ekoterra_prepare_macros( $ekoterra_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
