<?php
/**
 * The template to show mobile menu
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0
 */
?>
<div class="menu_mobile_overlay"></div>
<div class="menu_mobile menu_mobile_<?php echo esc_attr( ekoterra_get_theme_option( 'menu_mobile_fullscreen' ) > 0 ? 'fullscreen' : 'narrow' ); ?> scheme_dark">
	<div class="menu_mobile_inner">
		<a class="menu_mobile_close icon-cancel"></a>
		<?php

		// Logo
		set_query_var( 'ekoterra_logo_args', array( 'type' => 'mobile' ) );
		get_template_part( apply_filters( 'ekoterra_filter_get_template_part', 'templates/header-logo' ) );
		set_query_var( 'ekoterra_logo_args', array() );

		// Mobile menu
		$ekoterra_menu_mobile = ekoterra_get_nav_menu( 'menu_mobile' );
		if ( empty( $ekoterra_menu_mobile ) ) {
			$ekoterra_menu_mobile = apply_filters( 'ekoterra_filter_get_mobile_menu', '' );
			if ( empty( $ekoterra_menu_mobile ) ) {
				$ekoterra_menu_mobile = ekoterra_get_nav_menu( 'menu_main' );
			}
			if ( empty( $ekoterra_menu_mobile ) ) {
				$ekoterra_menu_mobile = ekoterra_get_nav_menu();
			}
		}
		if ( ! empty( $ekoterra_menu_mobile ) ) {
			$ekoterra_menu_mobile = str_replace(
				array( 'menu_main',   'id="menu-',        'sc_layouts_menu_nav', 'sc_layouts_menu ', 'sc_layouts_hide_on_mobile', 'hide_on_mobile' ),
				array( 'menu_mobile', 'id="menu_mobile-', '',                    ' ',                '',                          '' ),
				$ekoterra_menu_mobile
			);
			if ( strpos( $ekoterra_menu_mobile, '<nav ' ) === false ) {
				$ekoterra_menu_mobile = sprintf( '<nav class="menu_mobile_nav_area">%s</nav>', $ekoterra_menu_mobile );
			}
			ekoterra_show_layout( apply_filters( 'ekoterra_filter_menu_mobile_layout', $ekoterra_menu_mobile ) );
		}

		// Search field
		do_action(
			'ekoterra_action_search',
			array(
				'style' => 'normal',
				'class' => 'search_mobile',
				'ajax'  => false
			)
		);

		// Social icons
		ekoterra_show_layout( ekoterra_get_socials_links(), '<div class="socials_mobile">', '</div>' );
		?>
	</div>
</div>
