<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0
 */

// Page (category, tag, archive, author) title

if ( ekoterra_need_page_title() ) {
	ekoterra_sc_layouts_showed( 'title', true );
	ekoterra_sc_layouts_showed( 'postmeta', false );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() == false ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								ekoterra_show_post_meta(
									apply_filters(
										'ekoterra_filter_post_meta_args', array(
											'components' => ekoterra_array_get_keys_by_value( ekoterra_get_theme_option( 'meta_parts' ) ),
											'counters'   => ekoterra_array_get_keys_by_value( ekoterra_get_theme_option( 'counters' ) ),
											'seo'        => ekoterra_is_on( ekoterra_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$ekoterra_blog_title           = ekoterra_get_blog_title();
							$ekoterra_blog_title_text      = '';
							$ekoterra_blog_title_class     = '';
							$ekoterra_blog_title_link      = '';
							$ekoterra_blog_title_link_text = '';
							if ( is_array( $ekoterra_blog_title ) ) {
								$ekoterra_blog_title_text      = $ekoterra_blog_title['text'];
								$ekoterra_blog_title_class     = ! empty( $ekoterra_blog_title['class'] ) ? ' ' . $ekoterra_blog_title['class'] : '';
								$ekoterra_blog_title_link      = ! empty( $ekoterra_blog_title['link'] ) ? $ekoterra_blog_title['link'] : '';
								$ekoterra_blog_title_link_text = ! empty( $ekoterra_blog_title['link_text'] ) ? $ekoterra_blog_title['link_text'] : '';
							} else {
								$ekoterra_blog_title_text = $ekoterra_blog_title;
							}
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr( $ekoterra_blog_title_class ); ?>">
								<?php
								$ekoterra_top_icon = ekoterra_get_term_image_small();
								if ( ! empty( $ekoterra_top_icon ) ) {
									$ekoterra_attr = ekoterra_getimagesize( $ekoterra_top_icon );
									?>
									<img src="<?php echo esc_url( $ekoterra_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'ekoterra' ); ?>"
										<?php
										if ( ! empty( $ekoterra_attr[3] ) ) {
											ekoterra_show_layout( $ekoterra_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $ekoterra_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $ekoterra_blog_title_link ) && ! empty( $ekoterra_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $ekoterra_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $ekoterra_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( is_category() || is_tag() || is_tax() ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						?>
						<div class="sc_layouts_title_breadcrumbs">
							<?php
							do_action( 'ekoterra_action_breadcrumbs' );
							?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
?>
