<?php
/**
 * The template to display the widgets area in the header
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0
 */

// Header sidebar
$ekoterra_header_name    = ekoterra_get_theme_option( 'header_widgets' );
$ekoterra_header_present = ! ekoterra_is_off( $ekoterra_header_name ) && is_active_sidebar( $ekoterra_header_name );
if ( $ekoterra_header_present ) {
	ekoterra_storage_set( 'current_sidebar', 'header' );
	$ekoterra_header_wide = ekoterra_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $ekoterra_header_name ) ) {
		dynamic_sidebar( $ekoterra_header_name );
	}
	$ekoterra_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $ekoterra_widgets_output ) ) {
		$ekoterra_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $ekoterra_widgets_output );
		$ekoterra_need_columns   = strpos( $ekoterra_widgets_output, 'columns_wrap' ) === false;
		if ( $ekoterra_need_columns ) {
			$ekoterra_columns = max( 0, (int) ekoterra_get_theme_option( 'header_columns' ) );
			if ( 0 == $ekoterra_columns ) {
				$ekoterra_columns = min( 6, max( 1, substr_count( $ekoterra_widgets_output, '<aside ' ) ) );
			}
			if ( $ekoterra_columns > 1 ) {
				$ekoterra_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $ekoterra_columns ) . ' widget', $ekoterra_widgets_output );
			} else {
				$ekoterra_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $ekoterra_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $ekoterra_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $ekoterra_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'ekoterra_action_before_sidebar' );
				ekoterra_show_layout( $ekoterra_widgets_output );
				do_action( 'ekoterra_action_after_sidebar' );
				if ( $ekoterra_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $ekoterra_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
