<?php
/**
 * The template 'Style 1' to displaying related posts
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0
 */

$ekoterra_link        = get_permalink();
$ekoterra_post_format = get_post_format();
$ekoterra_post_format = empty( $ekoterra_post_format ) ? 'standard' : str_replace( 'post-format-', '', $ekoterra_post_format );

?><div id="post-<?php the_ID(); ?>" <?php post_class( 'related_item related_item_style_1 post_format_' . esc_attr( $ekoterra_post_format ) ); ?>>
    <div class="related_post_wrap">
	<?php
	ekoterra_show_post_featured(
		array(
			'thumb_size'    => apply_filters( 'ekoterra_filter_related_thumb_size', ekoterra_get_thumb_size( (int) ekoterra_get_theme_option( 'related_posts' ) == 1 ? 'big' : 'related-posts' ) ),
			'show_no_image' => ekoterra_get_theme_setting( 'allow_no_image' ),
            'thumb_bg'      => true,
			'singular'      => false,
			'post_info'     => '<div class="post_header entry-header">'
						. '<h6 class="post_title entry-title"><a href="' . esc_url( $ekoterra_link ) . '">' . wp_kses_data( wp_trim_words( get_the_title(), '6', ' ...') ) . '</a></h6>'
						. ( in_array( get_post_type(), array( 'post', 'attachment' ) )
								? '<div class="post_meta">' . '<span class="post_meta_item post_date"><a href="' . esc_url( $ekoterra_link ) . '">' . wp_kses_data( ekoterra_get_date() ) . '</a></span>' . '<span class="post_meta_item post_categories">' . wp_kses( ekoterra_get_post_categories( '' ), 'ekoterra_kses_content' ) . '</span>' . '</div>'
								: '' )
					. '</div>',
		)
	);
	?>
    </div>
</div>
