<?php
/**
 * Setup theme-specific fonts and colors
 *
 * @package WordPress
 * @subpackage EKOTERRA
 * @since EKOTERRA 1.0.22
 */

// If this theme is a free version of premium theme
if ( ! defined( 'EKOTERRA_THEME_FREE' ) ) {
	define( 'EKOTERRA_THEME_FREE', false );
}
if ( ! defined( 'EKOTERRA_THEME_FREE_WP' ) ) {
	define( 'EKOTERRA_THEME_FREE_WP', false );
}

// If this theme uses multiple skins
if ( ! defined( 'EKOTERRA_ALLOW_SKINS' ) ) {
	define( 'EKOTERRA_ALLOW_SKINS', true );
}
if ( ! defined( 'EKOTERRA_DEFAULT_SKIN' ) ) {
	define( 'EKOTERRA_DEFAULT_SKIN', 'default' );
}

// Theme storage
// Attention! Must be in the global namespace to compatibility with WP CLI
$GLOBALS['EKOTERRA_STORAGE'] = array(

	// Theme required plugin's slugs
	'required_plugins'   => array_merge(

		// List of plugins for both - FREE and PREMIUM versions
		//-----------------------------------------------------
		array(
			// Required plugins
			// DON'T COMMENT OR REMOVE NEXT LINES!
			'trx_addons'         => esc_html__( 'ThemeREX Addons', 'ekoterra' ),
			

			// If theme use OCDI instead (or both) ThemeREX Addons Installer
			

			// Recommended (supported) plugins for both (lite and full) versions
			// If plugin not need - comment (or remove) it
			'elementor'         	=> esc_html__( 'Elementor', 'ekoterra' ),
			'contact-form-7'    	=> esc_html__( 'Contact Form 7', 'ekoterra' ),
			'mailchimp-for-wp'  	=> esc_html__( 'MailChimp for WP', 'ekoterra' ),
			'woocommerce'       	=> esc_html__( 'WooCommerce', 'ekoterra' ),
			'elegro-payment'    	=> esc_html__( 'Elegro Payment', 'ekoterra' ),
			'trx_popup'						=> esc_html__( 'ThemeREX Popup', 'ekoterra' ),
			'3r-elementor-timeline-widget'        => esc_html__( 'Elementor Timeline Widget', 'ekoterra' ),
			// GDPR Support: uncomment only one of two following plugins
			
			'wp-gdpr-compliance' => esc_html__( 'Cookie Information', 'ekoterra' ),
			'trx_updater' => esc_html__( 'ThemeREX Updater', 'ekoterra' ),
		),
		// List of plugins for the FREE version only
		//-----------------------------------------------------
		EKOTERRA_THEME_FREE
			? array(
				// Recommended (supported) plugins for the FREE (lite) version
				'siteorigin-panels' => esc_html__( 'SiteOrigin Panels', 'ekoterra' ),
			)

		// List of plugins for the PREMIUM version only
		//-----------------------------------------------------
			: array(
				// Recommended (supported) plugins for the PRO (full) version
				// If plugin not need - comment (or remove) it

				'revslider'                  => esc_html__( 'Revolution Slider', 'ekoterra' ),
				'essential-grid'             => esc_html__( 'Essential Grid', 'ekoterra' ),
				'give'                       => esc_html__( 'Give', 'ekoterra' ),
				'the-events-calendar'        => esc_html__( 'The Events Calendar', 'ekoterra' ),
				'speakout'					 => esc_html__( 'Speakout', 'ekoterra' ),
				'civist'					 => esc_html__( 'Сivist', 'ekoterra' ),
			)
	),

	// Theme-specific blog layouts
	'blog_styles'        => array_merge(
		// Layouts for both - FREE and PREMIUM versions
		//-----------------------------------------------------
		array(
			'excerpt' => array(
				'title'   => esc_html__( 'Standard', 'ekoterra' ),
				'archive' => 'index-excerpt',
				'item'    => 'content-excerpt',
				'styles'  => 'excerpt',
			),
			'classic' => array(
				'title'   => esc_html__( 'Classic', 'ekoterra' ),
				'archive' => 'index-classic',
				'item'    => 'content-classic',
				'columns' => array( 2, 3 ),
				'styles'  => 'classic',
			),
		),
		// Layouts for the FREE version only
		//-----------------------------------------------------
		EKOTERRA_THEME_FREE
		? array()

		// Layouts for the PREMIUM version only
		//-----------------------------------------------------
		: array(
			'masonry'   => array(
				'title'   => esc_html__( 'Masonry', 'ekoterra' ),
				'archive' => 'index-classic',
				'item'    => 'content-classic',
				'columns' => array( 2, 3 ),
				'styles'  => 'masonry',
			),
			'portfolio' => array(
				'title'   => esc_html__( 'Portfolio', 'ekoterra' ),
				'archive' => 'index-portfolio',
				'item'    => 'content-portfolio',
				'columns' => array( 2, 3, 4 ),
				'styles'  => 'portfolio',
			),
			'gallery'   => array(
				'title'   => esc_html__( 'Gallery', 'ekoterra' ),
				'archive' => 'index-portfolio',
				'item'    => 'content-portfolio-gallery',
				'columns' => array( 2, 3, 4 ),
				'styles'  => array( 'portfolio', 'gallery' ),
			),
			'chess'     => array(
				'title'   => esc_html__( 'Chess', 'ekoterra' ),
				'archive' => 'index-chess',
				'item'    => 'content-chess',
				'columns' => array( 1, 2, 3 ),
				'styles'  => 'chess',
			),
		)
	),

	// Key validator: market[env|loc]-vendor[axiom|ancora|themerex]
	'theme_pro_key'      => 'env-ancora',

	// Generate Personal token from Envato to automatic upgrade theme
	'upgrade_token_url'  => '//build.envato.com/create-token/?default=t&purchase:download=t&purchase:list=t',

	// Theme-specific URLs (will be escaped in place of the output)
	'theme_demo_url'     => '//ekoterra.ancorathemes.com',
	'theme_doc_url'      => '//ekoterra.ancorathemes.com/doc',
	
	'theme_rate_url'     => '//themeforest.net/download',

	'theme_download_url' => 'https://themeforest.net/item/ekoterra-nonprofit-ecology-wordpress-theme/26621267',        // Ancora

	'theme_custom_url' => '//themerex.net/offers/?utm_source=offers&utm_medium=click&utm_campaign=themedash',                    // Ancora

	'theme_support_url'  => '//themerex.net/support/',                    // Ancora

	'theme_video_url'    => '//www.youtube.com/channel/UCdIjRh7-lPVHqTTKpaf8PLA',  // Ancora

	'theme_privacy_url'  => '//ancorathemes.com/privacy-policy/',                   // Ancora

	// Comma separated slugs of theme-specific categories (for get relevant news in the dashboard widget)
	// (i.e. 'children,kindergarten')
	'theme_categories'   => '',

	// Responsive resolutions
	// Parameters to create css media query: min, max
	'responsive'         => array(
		// By device
		'wide'       => array(
			'min' => 2160
		),
		'desktop'    => array(
			'min' => 1680,
			'max' => 2159,
		),
		'notebook'   => array(
			'min' => 1280,
			'max' => 1679,
		),
		'tablet'     => array(
			'min' => 768,
			'max' => 1279,
		),
		'not_mobile' => array( 'min' => 768 ),
		'mobile'     => array( 'max' => 767 ),
		// By size
		'xxl'        => array( 'max' => 1679 ),
		'xl'         => array( 'max' => 1439 ),
		'lg'         => array( 'max' => 1279 ),
		'md_over'    => array( 'min' => 1024 ),
		'md'         => array( 'max' => 1023 ),
		'sm'         => array( 'max' => 767 ),
		'sm_wp'      => array( 'max' => 600 ),
		'xs'         => array( 'max' => 479 ),
	),
);

// Theme init priorities:
// Action 'after_setup_theme'
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options. Attention! After this step you can use only basic options (not overriden)
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
// Action 'wp_loaded'
// 1 - detect override mode. Attention! Only after this step you can use overriden options (separate values for the shop, courses, etc.)

if ( ! function_exists( 'ekoterra_customizer_theme_setup1' ) ) {
	add_action( 'after_setup_theme', 'ekoterra_customizer_theme_setup1', 1 );
	function ekoterra_customizer_theme_setup1() {

		// -----------------------------------------------------------------
		// -- ONLY FOR PROGRAMMERS, NOT FOR CUSTOMER
		// -- Internal theme settings
		// -----------------------------------------------------------------
		ekoterra_storage_set(
			'settings', array(

				'duplicate_options'      => 'child',            // none  - use separate options for the main and the child-theme
																// child - duplicate theme options from the main theme to the child-theme only
																// both  - sinchronize changes in the theme options between main and child themes

				'customize_refresh'      => 'auto',             // Refresh method for preview area in the Appearance - Customize:
																// auto - refresh preview area on change each field with Theme Options
																// manual - refresh only obn press button 'Refresh' at the top of Customize frame

				'max_load_fonts'         => 5,                  // Max fonts number to load from Google fonts or from uploaded fonts

				'comment_after_name'     => true,               // Place 'comment' field after the 'name' and 'email'

				'show_author_avatar'     => true,               // Display author's avatar in the post meta

				'icons_selector'         => 'internal',         // Icons selector in the shortcodes:
																// vc (default) - standard VC (very slow) or Elementor's icons selector (not support images and svg)
																// internal - internal popup with plugin's or theme's icons list (fast and support images and svg)

				'icons_type'             => 'icons',            // Type of icons (if 'icons_selector' is 'internal'):
																// icons  - use font icons to present icons
																// images - use images from theme's folder trx_addons/css/icons.png
																// svg    - use svg from theme's folder trx_addons/css/icons.svg

				'socials_type'           => 'icons',            // Type of socials icons (if 'icons_selector' is 'internal'):
																// icons  - use font icons to present social networks
																// images - use images from theme's folder trx_addons/css/icons.png
																// svg    - use svg from theme's folder trx_addons/css/icons.svg

				'check_min_version'      => true,               // Check if exists a .min version of .css and .js and return path to it
																// instead the path to the original file
																// (if debug_mode is off and modification time of the original file < time of the .min file)

				'autoselect_menu'        => false,              // Show any menu if no menu selected in the location 'main_menu'
																// (for example, the theme is just activated)

				'disable_jquery_ui'      => false,              // Prevent loading custom jQuery UI libraries in the third-party plugins

				'use_mediaelements'      => true,               // Load script "Media Elements" to play video and audio

				'tgmpa_upload'           => false,              // Allow upload not pre-packaged plugins via TGMPA

				'allow_no_image'         => false,              // Allow use image placeholder if no image present in the blog, related posts, post navigation, etc.

				'separate_schemes'       => true,               // Save color schemes to the separate files __color_xxx.css (true) or append its to the __custom.css (false)

				'allow_fullscreen'       => false,              // Allow cases 'fullscreen' and 'fullwide' for the body style in the Theme Options
																// In the Page Options this styles are present always
																// (can be removed if filter 'ekoterra_filter_allow_fullscreen' return false)

				'attachments_navigation' => false,              // Add arrows on the single attachment page to navigate to the prev/next attachment
				
				'gutenberg_safe_mode'    => array(),            // 'vc', 'elementor' - Prevent simultaneous editing of posts for Gutenberg and other PageBuilders (VC, Elementor)

				'allow_gutenberg_blocks' => true,               // Allow our shortcodes and widgets as blocks in the Gutenberg (not ready yet - in the development now)

				'subtitle_above_title'   => true,               // Put subtitle above the title in the shortcodes

				'add_hide_on_xxx'        => 'replace',          // Add our breakpoints to the Responsive section of each element
																// 'add' - add our breakpoints after Elementor's
																// 'replace' - add our breakpoints instead Elementor's
																// 'none' - don't add our breakpoints (using only Elementor's)

                'override_option_single' => 'post',			    // Who can override option with value specified for the single post:
                                                                // 'all'  - any CPT
                                                                // 'post' - only 'post' type
			)
		);

		// -----------------------------------------------------------------
		// -- Theme fonts (Google and/or custom fonts)
		// -----------------------------------------------------------------

		// Fonts to load when theme start
		// It can be Google fonts or uploaded fonts, placed in the folder /css/font-face/font-name inside the theme folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		
		ekoterra_storage_set(
			'load_fonts', array(
				// Google font
				array(
					'name'   => 'Roboto',
					'family' => 'sans-serif',
					'styles' => '300,300italic,400,400italic,700,700italic',     // Parameter 'style' used only for the Google fonts
				),
				// Font-face packed with theme
				array(
					'name'   => 'd-din_exp',
					'family' => 'sans-serif',
				),
				// Font-face packed with theme
				array(
					'name'   => 'd-din_condensed',
					'family' => 'sans-serif',
				),

			)
		);

		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		ekoterra_storage_set( 'load_fonts_subset', 'latin,latin-ext' );

		// Settings of the main tags
		// Attention! Font name in the parameter 'font-family' will be enclosed in the quotes and no spaces after comma!
		
		
		

		ekoterra_storage_set(
			'theme_fonts', array(
				'p'       => array(
					'title'           => esc_html__( 'Main text', 'ekoterra' ),
					'description'     => esc_html__( 'Font settings of the main text of the site. Attention! For correct display of the site on mobile devices, use only units "rem", "em" or "ex"', 'ekoterra' ),
					'font-family'     => '"d-din_exp",sans-serif',
					'font-size'       => '1rem',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.778em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '',
					'margin-top'      => '0em',
					'margin-bottom'   => '1.1em',
				),
				'h1'      => array(
					'title'           => esc_html__( 'Heading 1', 'ekoterra' ),
					'font-family'     => '"d-din_exp",sans-serif',
					'font-size'       => '3.889em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.22em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0',
					'margin-top'      => '1.0417em',
					'margin-bottom'   => '0.72em',
				),
				'h2'      => array(
					'title'           => esc_html__( 'Heading 2', 'ekoterra' ),
                    'font-family'     => '"d-din_exp",sans-serif',
					'font-size'       => '2.889em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.2em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0',
					'margin-top'      => '1.0952em',
					'margin-bottom'   => '0.9em',
				),
				'h3'      => array(
					'title'           => esc_html__( 'Heading 3', 'ekoterra' ),
                    'font-family'     => '"d-din_exp",sans-serif',
					'font-size'       => '2.556em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.2em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '-0.3px',
					'margin-top'      => '1.4545em',
					'margin-bottom'   => '0.7879em',
				),
				'h4'      => array(
					'title'           => esc_html__( 'Heading 4', 'ekoterra' ),
                    'font-family'     => '"d-din_exp",sans-serif',
					'font-size'       => '2.111em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.3077em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0',
					'margin-top'      => '1.5em',
					'margin-bottom'   => '1em',
				),
				'h5'      => array(
					'title'           => esc_html__( 'Heading 5', 'ekoterra' ),
                    'font-family'     => '"d-din_exp",sans-serif',
					'font-size'       => '1.667em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.35em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.7em',
					'margin-bottom'   => '1em',
				),
				'h6'      => array(
					'title'           => esc_html__( 'Heading 6', 'ekoterra' ),
                    'font-family'     => '"d-din_exp",sans-serif',
					'font-size'       => '1.333em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.4em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.8em',
					'margin-bottom'   => '0.9412em',
				),
				'logo'    => array(
					'title'           => esc_html__( 'Logo text', 'ekoterra' ),
					'description'     => esc_html__( 'Font settings of the text case of the logo', 'ekoterra' ),
					'font-family'     => '"d-din_exp",sans-serif',
					'font-size'       => '1.8em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.25em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '1px',
				),
				'button'  => array(
					'title'           => esc_html__( 'Buttons', 'ekoterra' ),
					'font-family'     => '"d-din_condensed",sans-serif',
					'font-size'       => '16px',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '16px',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '2px',
				),
				'input'   => array(
					'title'           => esc_html__( 'Input fields', 'ekoterra' ),
					'description'     => esc_html__( 'Font settings of the input fields, dropdowns and textareas', 'ekoterra' ),
					'font-family'     => 'inherit',
					'font-size'       => '1.112em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em', // Attention! Firefox don't allow line-height less then 1.5em in the select
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0',
				),
				'info'    => array(
					'title'           => esc_html__( 'Post meta', 'ekoterra' ),
					'description'     => esc_html__( 'Font settings of the post meta: date, counters, share, etc.', 'ekoterra' ),
                    'font-family'     => '"d-din_condensed",sans-serif',
					'font-size'       => '0.835em',  // Old value '13px' don't allow using 'font zoom' in the custom blog items
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '1.2px',
					'margin-top'      => '0.3em',
					'margin-bottom'   => '0.3em',
				),
				'menu'    => array(
					'title'           => esc_html__( 'Main menu', 'ekoterra' ),
					'description'     => esc_html__( 'Font settings of the main menu items', 'ekoterra' ),
                    'font-family'     => '"d-din_exp",sans-serif',
					'font-size'       => '0.889rem',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'submenu' => array(
					'title'           => esc_html__( 'Dropdown menu', 'ekoterra' ),
					'description'     => esc_html__( 'Font settings of the dropdown menu items', 'ekoterra' ),
                    'font-family'     => '"d-din_exp",sans-serif',
					'font-size'       => '0.8667rem',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
			)
		);

		// -----------------------------------------------------------------
		// -- Theme colors for customizer
		// -- Attention! Inner scheme must be last in the array below
		// -----------------------------------------------------------------
		ekoterra_storage_set(
			'scheme_color_groups', array(
				'main'    => array(
					'title'       => esc_html__( 'Main', 'ekoterra' ),
					'description' => esc_html__( 'Colors of the main content area', 'ekoterra' ),
				),
				'alter'   => array(
					'title'       => esc_html__( 'Alter', 'ekoterra' ),
					'description' => esc_html__( 'Colors of the alternative blocks (sidebars, etc.)', 'ekoterra' ),
				),
				'extra'   => array(
					'title'       => esc_html__( 'Extra', 'ekoterra' ),
					'description' => esc_html__( 'Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'ekoterra' ),
				),
				'inverse' => array(
					'title'       => esc_html__( 'Inverse', 'ekoterra' ),
					'description' => esc_html__( 'Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'ekoterra' ),
				),
				'input'   => array(
					'title'       => esc_html__( 'Input', 'ekoterra' ),
					'description' => esc_html__( 'Colors of the form fields (text field, textarea, select, etc.)', 'ekoterra' ),
				),
			)
		);
		ekoterra_storage_set(
			'scheme_color_names', array(
				'bg_color'    => array(
					'title'       => esc_html__( 'Background color', 'ekoterra' ),
					'description' => esc_html__( 'Background color of this block in the normal state', 'ekoterra' ),
				),
				'bg_hover'    => array(
					'title'       => esc_html__( 'Background hover', 'ekoterra' ),
					'description' => esc_html__( 'Background color of this block in the hovered state', 'ekoterra' ),
				),
				'bd_color'    => array(
					'title'       => esc_html__( 'Border color', 'ekoterra' ),
					'description' => esc_html__( 'Border color of this block in the normal state', 'ekoterra' ),
				),
				'bd_hover'    => array(
					'title'       => esc_html__( 'Border hover', 'ekoterra' ),
					'description' => esc_html__( 'Border color of this block in the hovered state', 'ekoterra' ),
				),
				'text'        => array(
					'title'       => esc_html__( 'Text', 'ekoterra' ),
					'description' => esc_html__( 'Color of the plain text inside this block', 'ekoterra' ),
				),
				'text_dark'   => array(
					'title'       => esc_html__( 'Text dark', 'ekoterra' ),
					'description' => esc_html__( 'Color of the dark text (bold, header, etc.) inside this block', 'ekoterra' ),
				),
				'text_light'  => array(
					'title'       => esc_html__( 'Text light', 'ekoterra' ),
					'description' => esc_html__( 'Color of the light text (post meta, etc.) inside this block', 'ekoterra' ),
				),
				'text_link'   => array(
					'title'       => esc_html__( 'Link', 'ekoterra' ),
					'description' => esc_html__( 'Color of the links inside this block', 'ekoterra' ),
				),
				'text_hover'  => array(
					'title'       => esc_html__( 'Link hover', 'ekoterra' ),
					'description' => esc_html__( 'Color of the hovered state of links inside this block', 'ekoterra' ),
				),
				'text_link2'  => array(
					'title'       => esc_html__( 'Link 2', 'ekoterra' ),
					'description' => esc_html__( 'Color of the accented texts (areas) inside this block', 'ekoterra' ),
				),
				'text_hover2' => array(
					'title'       => esc_html__( 'Link 2 hover', 'ekoterra' ),
					'description' => esc_html__( 'Color of the hovered state of accented texts (areas) inside this block', 'ekoterra' ),
				),
				'text_link3'  => array(
					'title'       => esc_html__( 'Link 3', 'ekoterra' ),
					'description' => esc_html__( 'Color of the other accented texts (buttons) inside this block', 'ekoterra' ),
				),
				'text_hover3' => array(
					'title'       => esc_html__( 'Link 3 hover', 'ekoterra' ),
					'description' => esc_html__( 'Color of the hovered state of other accented texts (buttons) inside this block', 'ekoterra' ),
				),
			)
		);
		ekoterra_storage_set(
			'schemes', array(

				// Color scheme: 'default'
				'default' => array(
					'title'    => esc_html__( 'Default', 'ekoterra' ),
					'internal' => true,
					'colors'   => array(

						// Whole block border and background
						'bg_color'         => '#ffffff',//
						'bd_color'         => '#f6f5f1',//

						// Text and links colors
						'text'             => '#404040',//
						'text_light'       => '#777777',//
						'text_dark'        => '#1a1a1a',//
						'text_link'        => '#5280f4',//
						'text_hover'       => '#111111',//
						'text_link2'       => '#4ba750',//
						'text_hover2'      => '#fece3b',//
						'text_link3'       => '#fd5634',//
						'text_hover3'      => '#f3f3f3',//

						// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
						'alter_bg_color'   => '#f1f9ff',//
						'alter_bg_hover'   => '#e6eff5',//
						'alter_bd_color'   => '#f6f5f1',//
						'alter_bd_hover'   => '#c4ccd0',//
						'alter_text'       => '#404040',//
						'alter_light'      => '#989c9c',//
						'alter_dark'       => '#111111',//
						'alter_link'       => '#5280f4',//
						'alter_hover'      => '#111111',//
						'alter_link2'      => '#fd5634',//
						'alter_hover2'     => '#acacac',//
						'alter_link3'      => '#111111',//
						'alter_hover3'     => '#5280f4',//

						// Extra blocks (submenu, tabs, color blocks, etc.)
						'extra_bg_color'   => '#111111',//
						'extra_bg_hover'   => '#28272e',
						'extra_bd_color'   => '#292929',//
						'extra_bd_hover'   => '#125f16',
						'extra_text'       => '#979694',//
						'extra_light'      => '#adadad',//
						'extra_dark'       => '#ffffff',//
						'extra_link'       => '#fece3b',//
						'extra_hover'      => '#fece3b',//
						'extra_link2'      => '#fece3b',//
						'extra_hover2'     => '#404040',//
						'extra_link3'      => '#111111',//
						'extra_hover3'     => '#4ba750',//

						// Input fields (form's fields and textarea)
						'input_bg_color'   => '#ffffff',//
						'input_bg_hover'   => '#ffffff',//
						'input_bd_color'   => '#e1eaf0',//
						'input_bd_hover'   => '#111111',//
						'input_text'       => '#989c9c',//
						'input_light'      => '#777777',//
						'input_dark'       => '#111111',//

						// Inverse blocks (text and links on the 'text_link' background)
						'inverse_bd_color' => '#67bcc1',
						'inverse_bd_hover' => '#5aa4a9',
						'inverse_text'     => '#ffffff',//
						'inverse_light'    => '#eeeeee',//
						'inverse_dark'     => '#111111',//
						'inverse_link'     => '#ffffff',//
						'inverse_hover'    => '#111111',//
					),
				),

				// Color scheme: 'dark'
				'dark'    => array(
					'title'    => esc_html__( 'Dark', 'ekoterra' ),
					'internal' => true,
					'colors'   => array(

						// Whole block border and background
						'bg_color'         => '#000000',//
						'bd_color'         => '#292929',//

						// Text and links colors
						'text'             => '#a6a6a6',//
						'text_light'       => '#adadad',//
						'text_dark'        => '#ffffff',//
						'text_link'        => '#fece3b',//
						'text_hover'       => '#ffffff',//
						'text_link2'       => '#fd5634',
						'text_hover2'      => '#8be77c',
						'text_link3'       => '#ddb837',
						'text_hover3'      => '#eec432',

						// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
						'alter_bg_color'   => '#111111',//
						'alter_bg_hover'   => '#313131',//
						'alter_bd_color'   => '#313131',//
						'alter_bd_hover'   => '#125f16',//
						'alter_text'       => '#a6a6a6',//
						'alter_light'      => '#adadad',//
						'alter_dark'       => '#ffffff',//
						'alter_link'       => '#fece3b',//
						'alter_hover'      => '#ffffff',//
						'alter_link2'      => '#ffffff',
						'alter_hover2'     => '#d9e3e9',//
						'alter_link3'      => '#fece3b',//
						'alter_hover3'     => '#5280f4',//

						// Extra blocks (submenu, tabs, color blocks, etc.)
						'extra_bg_color'   => '#f8f6f2',//
						'extra_bg_hover'   => '#f3f5f7',//
						'extra_bd_color'   => '#e5e5e5',//
						'extra_bd_hover'   => '#4a4a4a',
						'extra_text'       => '#333333',//
						'extra_light'      => '#b7b7b7',//
						'extra_dark'       => '#2e2d32',//
						'extra_link'       => '#fd5634',//
						'extra_hover'      => '#fece3b',//
						'extra_link2'      => '#ffffff',//
						'extra_hover2'     => '#404040',//
						'extra_link3'      => '#111111',//
						'extra_hover3'     => '#4ba750',//

						// Input fields (form's fields and textarea)
						'input_bg_color'   => '#212121',//
						'input_bg_hover'   => '#212121',//
						'input_bd_color'   => '#313131',//
						'input_bd_hover'   => '#353535',
						'input_text'       => '#6b6966',//
						'input_light'      => '#6f6f6f',
						'input_dark'       => '#ffffff',//

						// Inverse blocks (text and links on the 'text_link' background)
						'inverse_bd_color' => '#e36650',
						'inverse_bd_hover' => '#cb5b47',
						'inverse_text'     => '#1d1d1d',//
						'inverse_light'    => '#6f6f6f',
						'inverse_dark'     => '#1d1d1d',//
						'inverse_link'     => '#ffffff',//
						'inverse_hover'    => '#1d1d1d',//
					),
				),

				// Color scheme: 'modern'
				'modern' => array(
					'title'    => esc_html__( 'Modern', 'ekoterra' ),
					'internal' => true,
					'colors'   => array(

						// Whole block border and background
						'bg_color'         => '#ffffff',//
						'bd_color'         => '#f6f5f1',//

						// Text and links colors
						'text'             => '#404040',//
						'text_light'       => '#777777',//
						'text_dark'        => '#1a1a1a',//
						'text_link'        => '#5280f4',//
						'text_hover'       => '#111111',//
						'text_link2'       => '#4ba750',//
						'text_hover2'      => '#fece3b',//
						'text_link3'       => '#101115',//
						'text_hover3'      => '#f3f3f3',//

						// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
						'alter_bg_color'   => '#f1f9ff',//
						'alter_bg_hover'   => '#e6eff5',//
						'alter_bd_color'   => '#f6f5f1',//
						'alter_bd_hover'   => '#c4ccd0',//
						'alter_text'       => '#404040',//
						'alter_light'      => '#989c9c',//
						'alter_dark'       => '#111111',//
						'alter_link'       => '#5280f4',//
						'alter_hover'      => '#111111',//
						'alter_link2'      => '#4BA750',//
						'alter_hover2'     => '#acacac',//
						'alter_link3'      => '#5280f4',//
						'alter_hover3'     => '#5280f4',//

						// Extra blocks (submenu, tabs, color blocks, etc.)
						'extra_bg_color'   => '#111111',//
						'extra_bg_hover'   => '#28272e',
						'extra_bd_color'   => '#292929',//
						'extra_bd_hover'   => '#125f16',
						'extra_text'       => '#979694',//
						'extra_light'      => '#adadad',//
						'extra_dark'       => '#ffffff',//
						'extra_link'       => '#fece3b',//
						'extra_hover'      => '#fece3b',//
						'extra_link2'      => '#fece3b',//
						'extra_hover2'     => '#404040',//
						'extra_link3'      => '#111111',//
						'extra_hover3'     => '#4ba750',//

						// Input fields (form's fields and textarea)
						'input_bg_color'   => '#ffffff',//
						'input_bg_hover'   => '#ffffff',//
						'input_bd_color'   => '#e1eaf0',//
						'input_bd_hover'   => '#111111',//
						'input_text'       => '#989c9c',//
						'input_light'      => '#777777',//
						'input_dark'       => '#111111',//

						// Inverse blocks (text and links on the 'text_link' background)
						'inverse_bd_color' => '#67bcc1',
						'inverse_bd_hover' => '#5aa4a9',
						'inverse_text'     => '#ffffff',//
						'inverse_light'    => '#eeeeee',//
						'inverse_dark'     => '#111111',//
						'inverse_link'     => '#ffffff',//
						'inverse_hover'    => '#111111',//
					),
				),

				// Color scheme: 'modern dark'
				'modern_dark' => array(
					'title'    => esc_html__( 'Modern dark', 'ekoterra' ),
					'internal' => true,
					'colors'   => array(

						// Whole block border and background
						'bg_color'         => '#000000',//
						'bd_color'         => '#292929',//

						// Text and links colors
						'text'             => '#a6a6a6',//
						'text_light'       => '#adadad',//
						'text_dark'        => '#ffffff',//
						'text_link'        => '#5280f4',//
						'text_hover'       => '#ffffff',//
						'text_link2'       => '#fd5634',
						'text_hover2'      => '#8be77c',
						'text_link3'       => '#ddb837',
						'text_hover3'      => '#eec432',

						// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
						'alter_bg_color'   => '#111111',//
						'alter_bg_hover'   => '#313131',//
						'alter_bd_color'   => '#313131',//
						'alter_bd_hover'   => '#125f16',//
						'alter_text'       => '#a6a6a6',//
						'alter_light'      => '#adadad',//
						'alter_dark'       => '#ffffff',//
						'alter_link'       => '#5280f4',//
						'alter_hover'      => '#ffffff',//
						'alter_link2'      => '#ffffff',
						'alter_hover2'     => '#d9e3e9',//
						'alter_link3'      => '#fece3b',//
						'alter_hover3'     => '#fece3b',//

						// Extra blocks (submenu, tabs, color blocks, etc.)
						'extra_bg_color'   => '#f8f6f2',//
						'extra_bg_hover'   => '#f3f5f7',//
						'extra_bd_color'   => '#e5e5e5',//
						'extra_bd_hover'   => '#4a4a4a',
						'extra_text'       => '#333333',//
						'extra_light'      => '#b7b7b7',//
						'extra_dark'       => '#2e2d32',//
						'extra_link'       => '#fd5634',//
						'extra_hover'      => '#fece3b',//
						'extra_link2'      => '#ffffff',//
						'extra_hover2'     => '#404040',//
						'extra_link3'      => '#111111',//
						'extra_hover3'     => '#4ba750',//

						// Input fields (form's fields and textarea)
						'input_bg_color'   => '#212121',//
						'input_bg_hover'   => '#212121',//
						'input_bd_color'   => '#313131',//
						'input_bd_hover'   => '#353535',
						'input_text'       => '#6b6966',//
						'input_light'      => '#6f6f6f',
						'input_dark'       => '#ffffff',//

						// Inverse blocks (text and links on the 'text_link' background)
						'inverse_bd_color' => '#e36650',
						'inverse_bd_hover' => '#cb5b47',
						'inverse_text'     => '#1d1d1d',//
						'inverse_light'    => '#6f6f6f',
						'inverse_dark'     => '#1d1d1d',//
						'inverse_link'     => '#ffffff',//
						'inverse_hover'    => '#1d1d1d',//
					),
				),

				// Color scheme: 'fresh'
				'fresh' => array(
					'title'    => esc_html__( 'Fresh', 'ekoterra' ),
					'internal' => true,
					'colors'   => array(

						// Whole block border and background
						'bg_color'         => '#ffffff',//
						'bd_color'         => '#f6f5f1',//

						// Text and links colors
						'text'             => '#404040',//
						'text_light'       => '#777777',//
						'text_dark'        => '#1a1a1a',//
						'text_link'        => '#762ED8',//
						'text_hover'       => '#1D0938',//
						'text_link2'       => '#FE8017',//
						'text_hover2'      => '#fece3b',//
						'text_link3'       => '#762ED8',//
						'text_hover3'      => '#f3f3f3',//

						// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
						'alter_bg_color'   => '#f1f9ff',//
						'alter_bg_hover'   => '#e6eff5',//
						'alter_bd_color'   => '#f6f5f1',//
						'alter_bd_hover'   => '#c4ccd0',//
						'alter_text'       => '#404040',//
						'alter_light'      => '#989c9c',//
						'alter_dark'       => '#1D0938',//
						'alter_link'       => '#762ED8',//
						'alter_hover'      => '#111111',//
						'alter_link2'      => '#4BA750',//
						'alter_hover2'     => '#acacac',//
						'alter_link3'      => '#1D0938',//
						'alter_hover3'     => '#5280f4',//

						// Extra blocks (submenu, tabs, color blocks, etc.)
						'extra_bg_color'   => '#111111',//
						'extra_bg_hover'   => '#28272e',
						'extra_bd_color'   => '#292929',//
						'extra_bd_hover'   => '#125f16',
						'extra_text'       => '#979694',//
						'extra_light'      => '#adadad',//
						'extra_dark'       => '#ffffff',//
						'extra_link'       => '#fece3b',//
						'extra_hover'      => '#fece3b',//
						'extra_link2'      => '#fece3b',//
						'extra_hover2'     => '#404040',//
						'extra_link3'      => '#111111',//
						'extra_hover3'     => '#4ba750',//

						// Input fields (form's fields and textarea)
						'input_bg_color'   => '#ffffff',//
						'input_bg_hover'   => '#ffffff',//
						'input_bd_color'   => '#e1eaf0',//
						'input_bd_hover'   => '#111111',//
						'input_text'       => '#989c9c',//
						'input_light'      => '#777777',//
						'input_dark'       => '#111111',//

						// Inverse blocks (text and links on the 'text_link' background)
						'inverse_bd_color' => '#67bcc1',
						'inverse_bd_hover' => '#5aa4a9',
						'inverse_text'     => '#ffffff',//
						'inverse_light'    => '#eeeeee',//
						'inverse_dark'     => '#111111',//
						'inverse_link'     => '#ffffff',//
						'inverse_hover'    => '#111111',//
					),
				),

				// Color scheme: 'fresh dark'
				'fresh_dark' => array(
					'title'    => esc_html__( 'Fresh dark', 'ekoterra' ),
					'internal' => true,
					'colors'   => array(

						// Whole block border and background
						'bg_color'         => '#000000',//
						'bd_color'         => '#292929',//

						// Text and links colors
						'text'             => '#a6a6a6',//
						'text_light'       => '#adadad',//
						'text_dark'        => '#ffffff',//
						'text_link'        => '#762ED8',//
						'text_hover'       => '#ffffff',//
						'text_link2'       => '#fd5634',
						'text_hover2'      => '#8be77c',
						'text_link3'       => '#ddb837',
						'text_hover3'      => '#eec432',

						// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
						'alter_bg_color'   => '#111111',//
						'alter_bg_hover'   => '#313131',//
						'alter_bd_color'   => '#313131',//
						'alter_bd_hover'   => '#125f16',//
						'alter_text'       => '#a6a6a6',//
						'alter_light'      => '#adadad',//
						'alter_dark'       => '#ffffff',//
						'alter_link'       => '#762ED8',//
						'alter_hover'      => '#ffffff',//
						'alter_link2'      => '#ffffff',
						'alter_hover2'     => '#d9e3e9',//
						'alter_link3'      => '#762ED8',//
						'alter_hover3'     => '#762ED8',//

						// Extra blocks (submenu, tabs, color blocks, etc.)
						'extra_bg_color'   => '#f8f6f2',//
						'extra_bg_hover'   => '#f3f5f7',//
						'extra_bd_color'   => '#e5e5e5',//
						'extra_bd_hover'   => '#4a4a4a',
						'extra_text'       => '#333333',//
						'extra_light'      => '#b7b7b7',//
						'extra_dark'       => '#2e2d32',//
						'extra_link'       => '#fd5634',//
						'extra_hover'      => '#fece3b',//
						'extra_link2'      => '#ffffff',//
						'extra_hover2'     => '#404040',//
						'extra_link3'      => '#1D0938',//
						'extra_hover3'     => '#4ba750',//

						// Input fields (form's fields and textarea)
						'input_bg_color'   => '#212121',//
						'input_bg_hover'   => '#212121',//
						'input_bd_color'   => '#313131',//
						'input_bd_hover'   => '#353535',
						'input_text'       => '#6b6966',//
						'input_light'      => '#6f6f6f',
						'input_dark'       => '#ffffff',//

						// Inverse blocks (text and links on the 'text_link' background)
						'inverse_bd_color' => '#e36650',
						'inverse_bd_hover' => '#cb5b47',
						'inverse_text'     => '#1d1d1d',//
						'inverse_light'    => '#6f6f6f',
						'inverse_dark'     => '#1d1d1d',//
						'inverse_link'     => '#ffffff',//
						'inverse_hover'    => '#1d1d1d',//
					),
				),
			)
		);
        ekoterra_storage_set( 'schemes_original', ekoterra_storage_get( 'schemes' ) );


        // Simple scheme editor: lists the colors to edit in the "Simple" mode.
		// For each color you can set the array of 'slave' colors and brightness factors that are used to generate new values,
		// when 'main' color is changed
		// Leave 'slave' arrays empty if your scheme does not have a color dependency
		ekoterra_storage_set(
            'schemes_simple', array(
                // Main color => List the slave elements and it's brightness factors
                'text_link'   => array(
                    
                    
                    
                    
                ),
                'text_hover'  => array(
                    
                    
                ),
                'text_link2'  => array(
                    
                    
                ),
                'text_hover2' => array(
                    
                    
                ),
                'text_link3'  => array(
                    
                    
                ),
                'text_hover3' => array(
                    
                    
                ),
                'alter_link'       => array(),
                'alter_hover'      => array(),
                'alter_link2'      => array(),
                'alter_hover2'     => array(),
                'alter_link3'      => array(),
                'alter_hover3'     => array(),
                'extra_link'       => array(),
                'extra_hover'      => array(),
                'extra_link2'      => array(),
                'extra_hover2'     => array(),
                'extra_link3'      => array(),
                'extra_hover3'     => array(),
                'inverse_bd_color' => array(),
                'inverse_bd_hover' => array(),
            )
		);

		// Additional colors for each scheme
		// Parameters:	'color' - name of the color from the scheme that should be used as source for the transformation
		//				'alpha' - to make color transparent (0.0 - 1.0)
		//				'hue', 'saturation', 'brightness' - inc/dec value for each color's component
		ekoterra_storage_set(
			'scheme_colors_add', array(
				'bg_color_0'        => array(
					'color' => 'bg_color',
					'alpha' => 0,
				),
				'bg_color_02'       => array(
					'color' => 'bg_color',
					'alpha' => 0.2,
				),
				'bg_color_07'       => array(
					'color' => 'bg_color',
					'alpha' => 0.7,
				),
				'bg_color_08'       => array(
					'color' => 'bg_color',
					'alpha' => 0.8,
				),
				'bg_color_09'       => array(
					'color' => 'bg_color',
					'alpha' => 0.9,
				),
				'alter_bg_color_07' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.7,
				),
				'alter_bg_color_04' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.4,
				),
				'alter_bg_color_02' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.2,
				),
				'alter_bd_color_02' => array(
					'color' => 'alter_bd_hover',
					'alpha' => 0.2,
				),
				'alter_link_02'     => array(
					'color' => 'alter_link',
					'alpha' => 0.2,
				),
				'alter_link_07'     => array(
					'color' => 'alter_link',
					'alpha' => 0.7,
				),
				'extra_bg_color_07' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.7,
				),
				'extra_link_02'     => array(
					'color' => 'extra_link',
					'alpha' => 0.2,
				),
				'extra_link_07'     => array(
					'color' => 'extra_link',
					'alpha' => 0.7,
				),
				'extra_dark_03'     => array(
					'color' => 'extra_dark',
					'alpha' => 0.3,
				),
				'extra_dark_07'     => array(
					'color' => 'extra_dark',
					'alpha' => 0.7,
				),
				'text_dark_07'      => array(
					'color' => 'text_dark',
					'alpha' => 0.7,
				),
				'text_link_02'      => array(
					'color' => 'text_link',
					'alpha' => 0.2,
				),
				'text_link_07'      => array(
					'color' => 'text_link',
					'alpha' => 0.7,
				),
				'text_link_blend'   => array(
					'color'      => 'text_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'alter_link_blend'  => array(
					'color'      => 'alter_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
			)
		);

		// Parameters to set order of schemes in the css
		ekoterra_storage_set(
			'schemes_sorted', array(
				'color_scheme',
				'header_scheme',
				'menu_scheme',
				'sidebar_scheme',
				'footer_scheme',
			)
		);

		// -----------------------------------------------------------------
		// -- Theme specific thumb sizes
		// -----------------------------------------------------------------
		ekoterra_storage_set(
			'theme_thumbs', apply_filters(
				'ekoterra_filter_add_thumb_sizes', array(
					// Width of the image is equal to the content area width (without sidebar)
					// Height is fixed
					'ekoterra-thumb-huge'        => array(
						'size'  => array( 1230, 767, true ),
						'title' => esc_html__( 'Huge image', 'ekoterra' ),
						'subst' => 'trx_addons-thumb-huge',
					),
					// Width of the image is equal to the content area width (with sidebar)
					// Height is fixed
					'ekoterra-thumb-big'         => array(
						'size'  => array( 790, 518, true ),
						'title' => esc_html__( 'Large image', 'ekoterra' ),
						'subst' => 'trx_addons-thumb-big',
					),
                    // services
                    'ekoterra-thumb-services-square'     => array(
                        'size'  => array( 285, 285, true ),
                        'title' => esc_html__( 'Services Square Thumbs', 'ekoterra' ),
                        'subst' => 'trx_addons-thumb-services-square',
                    ),

					// Width of the image is equal to the 1/3 of the content area width (without sidebar)
					// Height is fixed
					'ekoterra-thumb-med'         => array(
						'size'  => array( 390, 255, true ),
						'title' => esc_html__( 'Medium image', 'ekoterra' ),
						'subst' => 'trx_addons-thumb-medium',
					),

					// Small square image (for avatars in comments, etc.)
					'ekoterra-thumb-tiny'        => array(
						'size'  => array( 90, 90, true ),
						'title' => esc_html__( 'Small square avatar', 'ekoterra' ),
						'subst' => 'trx_addons-thumb-tiny',
					),

					// Width of the image is equal to the content area width (with sidebar)
					// Height is proportional (only downscale, not crop)
					'ekoterra-thumb-masonry-big' => array(
						'size'  => array( 760, 0, false ),     // Only downscale, not crop
						'title' => esc_html__( 'Masonry Large (scaled)', 'ekoterra' ),
						'subst' => 'trx_addons-thumb-masonry-big',
					),

					// Width of the image is equal to the 1/3 of the full content area width (without sidebar)
					// Height is proportional (only downscale, not crop)
					'ekoterra-thumb-masonry'     => array(
						'size'  => array( 387, 0, false ),     // Only downscale, not crop
						'title' => esc_html__( 'Masonry (scaled)', 'ekoterra' ),
						'subst' => 'trx_addons-thumb-masonry',
					),
                    // Width of the image is equal to the 1/3 of the full content area width (without sidebar)
                    // Height is proportional (only downscale, not crop)
                    'ekoterra-thumb-cats'     => array(
                        'size'  => array( 250, 95, true ),     // Only downscale, not crop
                        'title' => esc_html__( 'Categories Sidebar', 'ekoterra' ),
                        'subst' => 'trx_addons-thumb-cats',
                    ),
                    // related posts
                    'ekoterra-thumb-related-posts'     => array(
                        'size'  => array( 379, 213, true ),     // Only downscale, not crop
                        'title' => esc_html__( 'Related Posts', 'ekoterra' ),
                        'subst' => 'trx_addons-thumb-related-posts',
                    ),
                    // related posts
                    'ekoterra-thumb-gallery-thumb'     => array(
                        'size'  => array( 195, 128, true ),     // Only downscale, not crop
                        'title' => esc_html__( 'Gallery Thumbs', 'ekoterra' ),
                        'subst' => 'trx_addons-thumb-gallery-thumb',
                    ),
                    'ekoterra-thumb-icon-hovered'     => array(
                        'size'  => array( 500, 450, true ),     // Only downscale, not crop
                        'title' => esc_html__( 'Icon Hovered Thumbs', 'ekoterra' ),
                        'subst' => 'trx_addons-thumb-icon-hovered',
                    ),
                    'ekoterra-thumb-rnews-announce'     => array(
                        'size'  => array( 706, 464, true ),     // Only downscale, not crop
                        'title' => esc_html__( 'Recent news Announce', 'ekoterra' ),
                        'subst' => 'trx_addons-thumb-rnews-announce',
                    ),
                    'ekoterra-thumb-blogger-sm'     => array(
                        'size'  => array( 387, 150, true ),     // Only downscale, not crop
                        'title' => esc_html__( 'Blogger Small', 'ekoterra' ),
                        'subst' => 'trx_addons-thumb-blogger-sm',
                    ),
                    'ekoterra-thumb-team-square'     => array(
                        'size'  => array( 500, 500, false ),     // Only downscale, not crop
                        'title' => esc_html__( 'Team Square', 'ekoterra' ),
                        'subst' => 'trx_addons-thumb-team-square',
                    ),

				)
			)
		);
	}
}




//------------------------------------------------------------------------
// One-click import support
//------------------------------------------------------------------------

// Set theme specific importer options
if ( ! function_exists( 'ekoterra_importer_set_options' ) ) {
	add_filter( 'trx_addons_filter_importer_options', 'ekoterra_importer_set_options', 9 );
	function ekoterra_importer_set_options( $options = array() ) {
		if ( is_array( $options ) ) {
			// Save or not installer's messages to the log-file
			$options['debug'] = false;
			// Allow import/export functionality
			$options['allow_import'] = true;
			$options['allow_export'] = false;
			// Prepare demo data
			$options['demo_url'] =  esc_url( ekoterra_get_protocol().'://demofiles.ancorathemes.com/ekoterra/');
			// Required plugins
			$options['required_plugins'] = array_keys( ekoterra_storage_get( 'required_plugins' ) );
			// Set number of thumbnails (usually 3 - 5) to regenerate at once when its imported (if demo data was zipped without cropped images)
			// Set 0 to prevent regenerate thumbnails (if demo data archive is already contain cropped images)
			$options['regenerate_thumbnails'] = 0;
			// Default demo
			$options['files']['default']['title']       = esc_html__( 'Ekoterra Demo', 'ekoterra' );
			$options['files']['default']['domain_dev']  ='';       // Developers domain
			$options['files']['default']['domain_demo'] = esc_url( ekoterra_get_protocol().'://ekoterra.ancorathemes.com' );       // Demo-site domain
			// If theme need more demo - just copy 'default' and change required parameter
		}
		return $options;
	}
}


//------------------------------------------------------------------------
// OCDI support
//------------------------------------------------------------------------

// Set theme specific OCDI options
if ( ! function_exists( 'ekoterra_ocdi_set_options' ) ) {
	add_filter( 'trx_addons_filter_ocdi_options', 'ekoterra_ocdi_set_options', 9 );
	function ekoterra_ocdi_set_options( $options = array() ) {
		if ( is_array( $options ) ) {
			// Prepare demo data
			$options['demo_url'] = esc_url( ekoterra_get_protocol() . '://demofiles.ancorathemes.com/ekoterra/' );
			// Required plugins
			$options['required_plugins'] = array_keys( ekoterra_storage_get( 'required_plugins' ) );
			// Demo-site domain
			$options['files']['ocdi']['title']       = esc_html__( 'Ekoterra OCDI Demo', 'ekoterra' );
			$options['files']['ocdi']['domain_demo'] = esc_url( ekoterra_get_protocol() . '://ekoterra.ancorathemes.com' );
			// If theme need more demo - just copy 'default' and change required parameter
			
			
			
		}
		return $options;
	}
}


// -----------------------------------------------------------------
// -- Theme options for customizer
// -----------------------------------------------------------------
if ( ! function_exists( 'ekoterra_create_theme_options' ) ) {

	function ekoterra_create_theme_options() {

		// Message about options override.
		// Attention! Not need esc_html() here, because this message put in wp_kses_data() below
		$msg_override = __( 'Attention! Some of these options can be overridden in the following sections (Blog, Plugins settings, etc.) or in the settings of individual pages. If you changed such parameter and nothing happened on the page, this option may be overridden in the corresponding section or in the Page Options of this page. These options are marked with an asterisk (*) in the title.', 'ekoterra' );

		// Color schemes number: if < 2 - hide fields with selectors
		$hide_schemes = count( ekoterra_storage_get( 'schemes' ) ) < 2;

		ekoterra_storage_set(
			'options', array(

				// 'Logo & Site Identity'
				'title_tagline'                 => array(
					'title'    => esc_html__( 'Logo & Site Identity', 'ekoterra' ),
					'desc'     => '',
					'priority' => 10,
					'type'     => 'section',
				),
				'logo_info'                     => array(
					'title'    => esc_html__( 'Logo Settings', 'ekoterra' ),
					'desc'     => '',
					'priority' => 20,
					'qsetup'   => esc_html__( 'General', 'ekoterra' ),
					'type'     => 'info',
				),
				'logo_text'                     => array(
					'title'    => esc_html__( 'Use Site Name as Logo', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Use the site title and tagline as a text logo if no image is selected', 'ekoterra' ) ),
					'class'    => 'ekoterra_column-1_2 ekoterra_new_row',
					'priority' => 30,
					'std'      => 1,
					'qsetup'   => esc_html__( 'General', 'ekoterra' ),
					'type'     => EKOTERRA_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'logo_retina_enabled'           => array(
					'title'    => esc_html__( 'Allow retina display logo', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Show fields to select logo images for Retina display', 'ekoterra' ) ),
					'class'    => 'ekoterra_column-1_2',
					'priority' => 40,
					'refresh'  => false,
					'std'      => 0,
					'type'     => EKOTERRA_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'logo_zoom'                     => array(
					'title'   => esc_html__( 'Logo zoom', 'ekoterra' ),
					'desc'    => wp_kses(
									__( 'Zoom the logo (set 1 to leave original size).', 'ekoterra' )
									. ' <br>'
									. __( 'Attention! For this parameter to affect images, their max-height should be specified in "em" instead of "px" when creating a header.', 'ekoterra' )
									. ' <br>'
									. __( 'In this case maximum size of logo depends on the actual size of the picture.', 'ekoterra' ), 'ekoterra_kses_content'
								),
					'std'     => 1,
					'min'     => 0.2,
					'max'     => 2,
					'step'    => 0.1,
					'refresh' => false,
					'type'    => EKOTERRA_THEME_FREE ? 'hidden' : 'slider',
				),
				// Parameter 'logo' was replaced with standard WordPress 'custom_logo'
				'logo_retina'                   => array(
					'title'      => esc_html__( 'Logo for Retina', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'ekoterra' ) ),
					'class'      => 'ekoterra_column-1_2',
					'priority'   => 70,
					'dependency' => array(
						'logo_retina_enabled' => array( 1 ),
					),
					'std'        => '',
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'image',
				),
				'logo_mobile_header'            => array(
					'title' => esc_html__( 'Logo for the mobile header', 'ekoterra' ),
					'desc'  => wp_kses_data( __( 'Select or upload site logo to display it in the mobile header (if enabled in the section "Header - Header mobile"', 'ekoterra' ) ),
					'class' => 'ekoterra_column-1_2 ekoterra_new_row',
					'std'   => '',
					'type'  => 'image',
				),
				'logo_mobile_header_retina'     => array(
					'title'      => esc_html__( 'Logo for the mobile header on Retina', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'ekoterra' ) ),
					'class'      => 'ekoterra_column-1_2',
					'dependency' => array(
						'logo_retina_enabled' => array( 1 ),
					),
					'std'        => '',
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'image',
				),
				'logo_mobile'                   => array(
					'title' => esc_html__( 'Logo for the mobile menu', 'ekoterra' ),
					'desc'  => wp_kses_data( __( 'Select or upload site logo to display it in the mobile menu', 'ekoterra' ) ),
					'class' => 'ekoterra_column-1_2 ekoterra_new_row',
					'std'   => '',
					'type'  => 'image',
				),
				'logo_mobile_retina'            => array(
					'title'      => esc_html__( 'Logo mobile on Retina', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'ekoterra' ) ),
					'class'      => 'ekoterra_column-1_2',
					'dependency' => array(
						'logo_retina_enabled' => array( 1 ),
					),
					'std'        => '',
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'image',
				),
				'logo_side'                     => array(
					'title' => esc_html__( 'Logo for the side menu', 'ekoterra' ),
					'desc'  => wp_kses_data( __( 'Select or upload site logo (with vertical orientation) to display it in the side menu', 'ekoterra' ) ),
					'class' => 'ekoterra_column-1_2 ekoterra_new_row',
					'std'   => '',
					'type'  => 'image',
				),
				'logo_side_retina'              => array(
					'title'      => esc_html__( 'Logo for the side menu on Retina', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Select or upload site logo (with vertical orientation) to display it in the side menu on Retina displays (if empty - use default logo from the field above)', 'ekoterra' ) ),
					'class'      => 'ekoterra_column-1_2',
					'dependency' => array(
						'logo_retina_enabled' => array( 1 ),
					),
					'std'        => '',
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'image',
				),

				// 'General settings'
				'general'                       => array(
					'title'    => esc_html__( 'General Settings', 'ekoterra' ),
					'desc'     => wp_kses_data( $msg_override ),
					'priority' => 20,
					'type'     => 'section',
				),

				'general_layout_info'           => array(
					'title'  => esc_html__( 'Layout', 'ekoterra' ),
					'desc'   => '',
					'qsetup' => esc_html__( 'General', 'ekoterra' ),
					'type'   => 'info',
				),
				'body_style'                    => array(
					'title'    => esc_html__( 'Body style', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Select width of the body content', 'ekoterra' ) ),
					'override' => array(
						'mode'    => 'page,post,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Content', 'ekoterra' ),
					),
					'qsetup'   => esc_html__( 'General', 'ekoterra' ),
					'refresh'  => false,
					'std'      => 'boxed',
					'options'  => ekoterra_get_list_body_styles( false ),
					'type'     => 'select',
				),
				'page_width'                    => array(
					'title'      => esc_html__( 'Page width', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Total width of the site content and sidebar (in pixels). If empty - use default width', 'ekoterra' ) ),
					'dependency' => array(
						'body_style' => array( 'boxed', 'wide' ),
					),
					'std'        => 1230,
					'min'        => 1000,
					'max'        => 1630,
					'step'       => 10,
					'refresh'    => false,
					'customizer' => 'page',         // SASS variable's name to preview changes 'on fly'
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'slider',
				),
				'boxed_bg_image'                => array(
					'title'      => esc_html__( 'Boxed bg image', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Select or upload image, used as background in the boxed body', 'ekoterra' ) ),
					'dependency' => array(
						'body_style' => array( 'boxed' ),
					),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Content', 'ekoterra' ),
					),
					'std'        => '',
					'qsetup'     => esc_html__( 'General', 'ekoterra' ),
					
					'type'       => 'image',
				),
				'remove_margins'                => array(
					'title'    => esc_html__( 'Remove margins', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Remove margins above and below the content area', 'ekoterra' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Content', 'ekoterra' ),
					),
					'refresh'  => false,
					'std'      => 0,
					'type'     => 'checkbox',
				),

				'general_sidebar_info'          => array(
					'title' => esc_html__( 'Sidebar', 'ekoterra' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'sidebar_position'              => array(
					'title'    => esc_html__( 'Sidebar position', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Select position to show sidebar', 'ekoterra' ) ),
					'override' => array(
						'mode'    => 'page',		// Override parameters for single posts moved to the 'sidebar_position_single'
						'section' => esc_html__( 'Widgets', 'ekoterra' ),
					),
					'std'      => 'right',
					'qsetup'   => esc_html__( 'General', 'ekoterra' ),
					'options'  => array(),
					'type'     => 'switch',
				),
				'sidebar_position_mobile'       => array(
					'title'    => esc_html__( 'Sidebar position on mobile', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Select position to show sidebar on mobile devices - above or below the content', 'ekoterra' ) ),
					'override' => array(
						'mode'    => 'page',		// Override parameters for single posts moved to the 'sidebar_position_mobile_single'
						'section' => esc_html__( 'Widgets', 'ekoterra' ),
					),
					'dependency' => array(
						'sidebar_position' => array( '^hide' ),
					),
					'std'      => 'below',
					'qsetup'   => esc_html__( 'General', 'ekoterra' ),
					'options'  => array(),
					'type'     => 'switch',
				),
				'sidebar_widgets'               => array(
					'title'      => esc_html__( 'Sidebar widgets', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Select default widgets to show in the sidebar', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'page',		// Override parameters for single posts moved to the 'sidebar_widgets_single'
						'section' => esc_html__( 'Widgets', 'ekoterra' ),
					),
					'dependency' => array(
						'sidebar_position' => array( 'left', 'right' ),
					),
					'std'        => 'sidebar_widgets',
					'options'    => array(),
					'qsetup'     => esc_html__( 'General', 'ekoterra' ),
					'type'       => 'select',
				),
				'sidebar_width'                 => array(
					'title'      => esc_html__( 'Sidebar width', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Width of the sidebar (in pixels). If empty - use default width', 'ekoterra' ) ),
					'std'        => 388,
					'min'        => 150,
					'max'        => 500,
					'step'       => 10,
					'refresh'    => false,
					'customizer' => 'sidebar',      // SASS variable's name to preview changes 'on fly'
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'slider',
				),
				'sidebar_gap'                   => array(
					'title'      => esc_html__( 'Sidebar gap', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Gap between content and sidebar (in pixels). If empty - use default gap', 'ekoterra' ) ),
					'std'        => 50,
					'min'        => 0,
					'max'        => 100,
					'step'       => 1,
					'refresh'    => false,
					'customizer' => 'gap',          // SASS variable's name to preview changes 'on fly'
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'slider',
				),
				'expand_content'                => array(
					'title'   => esc_html__( 'Expand content', 'ekoterra' ),
					'desc'    => wp_kses_data( __( 'Expand the content width if the sidebar is hidden', 'ekoterra' ) ),
					'refresh' => false,
					'override'   => array(
						'mode'    => 'page,post,product,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'ekoterra' ),
					),
					'std'     => 1,
					'type'    => 'checkbox',
				),

				'general_widgets_info'          => array(
					'title' => esc_html__( 'Additional widgets', 'ekoterra' ),
					'desc'  => '',
					'type'  => EKOTERRA_THEME_FREE ? 'hidden' : 'hidden',
				),
				'widgets_above_page'            => array(
					'title'    => esc_html__( 'Widgets at the top of the page', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Select widgets to show at the top of the page (above content and sidebar)', 'ekoterra' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'ekoterra' ),
					),
					'std'      => 'hide',
					'options'  => array(),
					'type'     => EKOTERRA_THEME_FREE ? 'hidden' : 'hidden',
				),
				'widgets_above_content'         => array(
					'title'    => esc_html__( 'Widgets above the content', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Select widgets to show at the beginning of the content area', 'ekoterra' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'ekoterra' ),
					),
					'std'      => 'hide',
					'options'  => array(),
					'type'     => EKOTERRA_THEME_FREE ? 'hidden' : 'hidden',
				),
				'widgets_below_content'         => array(
					'title'    => esc_html__( 'Widgets below the content', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Select widgets to show at the ending of the content area', 'ekoterra' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'ekoterra' ),
					),
					'std'      => 'hide',
					'options'  => array(),
					'type'     => EKOTERRA_THEME_FREE ? 'hidden' : 'hidden',
				),
				'widgets_below_page'            => array(
					'title'    => esc_html__( 'Widgets at the bottom of the page', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Select widgets to show at the bottom of the page (below content and sidebar)', 'ekoterra' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'ekoterra' ),
					),
					'std'      => 'hide',
					'options'  => array(),
					'type'     => EKOTERRA_THEME_FREE ? 'hidden' : 'hidden',
				),

				'general_effects_info'          => array(
					'title' => esc_html__( 'Design & Effects', 'ekoterra' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'border_radius'                 => array(
					'title'      => esc_html__( 'Border radius', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Specify the border radius of the form fields and buttons in pixels', 'ekoterra' ) ),
					'std'        => 0,
					'min'        => 0,
					'max'        => 20,
					'step'       => 1,
					'refresh'    => false,
					'customizer' => 'rad',      // SASS name to preview changes 'on fly'
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'slider',
				),

				'general_misc_info'             => array(
					'title' => esc_html__( 'Miscellaneous', 'ekoterra' ),
					'desc'  => '',
					'type'  => EKOTERRA_THEME_FREE ? 'hidden' : 'info',
				),
				'seo_snippets'                  => array(
					'title' => esc_html__( 'SEO snippets', 'ekoterra' ),
					'desc'  => wp_kses_data( __( 'Add structured data markup to the single posts and pages', 'ekoterra' ) ),
					'std'   => 0,
					'type'  => EKOTERRA_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'privacy_text' => array(
					"title" => esc_html__("Text with Privacy Policy link", 'ekoterra'),
					"desc"  => wp_kses_data( __("Specify text with Privacy Policy link for the checkbox 'I agree ...'", 'ekoterra') ),
					"std"   => wp_kses_data( __( 'I agree that my submitted data is being collected and stored.', 'ekoterra') ),
					"type"  => "text"
				),

				// 'Header'
				'header'                        => array(
					'title'    => esc_html__( 'Header', 'ekoterra' ),
					'desc'     => wp_kses_data( $msg_override ),
					'priority' => 30,
					'type'     => 'section',
				),

				'header_style_info'             => array(
					'title' => esc_html__( 'Header style', 'ekoterra' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'header_type'                   => array(
					'title'    => esc_html__( 'Header style', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'ekoterra' ) ),
					'override' => array(
						'mode'    => 'page,post,product,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'ekoterra' ),
					),
					'std'      => 'default',
					'options'  => ekoterra_get_list_header_footer_types(),
					'type'     => EKOTERRA_THEME_FREE || ! ekoterra_exists_trx_addons() ? 'hidden' : 'switch',
				),
				'header_style'                  => array(
					'title'      => esc_html__( 'Select custom layout', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Select custom header from Layouts Builder', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'page,post,product,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'ekoterra' ),
					),
					'dependency' => array(
						'header_type' => array( 'custom' ),
					),
					'std'        => EKOTERRA_THEME_FREE ? 'header-custom-elementor-header-default' : 'header-custom-header-default',
					'options'    => array(),
					'type'       => 'select',
				),
				'header_position'               => array(
					'title'    => esc_html__( 'Header position', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Select position to display the site header', 'ekoterra' ) ),
					'override' => array(
						'mode'    => 'page,post,product,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'ekoterra' ),
					),
					'std'      => 'default',
					'options'  => array(),
					'type'     => EKOTERRA_THEME_FREE ? 'hidden' : 'switch',
				),
				'header_fullheight'             => array(
					'title'    => esc_html__( 'Header fullheight', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Enlarge header area to fill whole screen. Used only if header have a background image', 'ekoterra' ) ),
					'override' => array(
						'mode'    => 'page,post,product,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'ekoterra' ),
					),
					'std'      => 0,
					'type'     => EKOTERRA_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_wide'                   => array(
					'title'      => esc_html__( 'Header fullwidth', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Do you want to stretch the header widgets area to the entire window width?', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'page,post,product,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'ekoterra' ),
					),
					'dependency' => array(
						'header_type' => array( 'default' ),
					),
					'std'        => 1,
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'hidden',
				),
				'header_zoom'                   => array(
					'title'   => esc_html__( 'Header zoom', 'ekoterra' ),
					'desc'    => wp_kses_data( __( 'Zoom the header title. 1 - original size', 'ekoterra' ) ),
					'std'     => 1,
					'min'     => 0.3,
					'max'     => 2,
					'step'    => 0.1,
					'refresh' => false,
					'type'    => EKOTERRA_THEME_FREE ? 'hidden' : 'slider',
				),

				'header_widgets_info'           => array(
					'title' => esc_html__( 'Header widgets', 'ekoterra' ),
					'desc'  => wp_kses_data( __( 'Here you can place a widget slider, advertising banners, etc.', 'ekoterra' ) ),
					'type'  => 'hidden',
				),
				'header_widgets'                => array(
					'title'    => esc_html__( 'Header widgets', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Select set of widgets to show in the header on each page', 'ekoterra' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'ekoterra' ),
						'desc'    => wp_kses_data( __( 'Select set of widgets to show in the header on this page', 'ekoterra' ) ),
					),
					'std'      => 'hide',
					'options'  => array(),
					'type'     => 'hidden',
				),
				'header_columns'                => array(
					'title'      => esc_html__( 'Header columns', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Select number columns to show widgets in the Header. If 0 - autodetect by the widgets count', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'ekoterra' ),
					),
					'dependency' => array(
						'header_type'    => array( 'default' ),
						'header_widgets' => array( '^hide' ),
					),
					'std'        => 0,
					'options'    => ekoterra_get_list_range( 0, 6 ),
					'type'       => 'hidden',
				),

				'menu_info'                     => array(
					'title' => esc_html__( 'Main menu', 'ekoterra' ),
					'desc'  => wp_kses_data( __( 'Select main menu style, position and other parameters', 'ekoterra' ) ),
					'type'  => EKOTERRA_THEME_FREE ? 'hidden' : 'info',
				),
				'menu_style'                    => array(
					'title'    => esc_html__( 'Menu position', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Select position of the main menu', 'ekoterra' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'ekoterra' ),
					),
					'std'      => 'top',
					'options'  => array(
						'top'   => esc_html__( 'Top', 'ekoterra' ),
						'left'  => esc_html__( 'Left', 'ekoterra' ),
						'right' => esc_html__( 'Right', 'ekoterra' ),
					),
					'type'     => EKOTERRA_THEME_FREE || ! ekoterra_exists_trx_addons() ? 'hidden' : 'switch',
				),
				'menu_side_stretch'             => array(
					'title'      => esc_html__( 'Stretch sidemenu', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Stretch sidemenu to window height (if menu items number >= 5)', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'ekoterra' ),
					),
					'dependency' => array(
						'menu_style' => array( 'left', 'right' ),
					),
					'std'        => 0,
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'menu_side_icons'               => array(
					'title'      => esc_html__( 'Iconed sidemenu', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Get icons from anchors and display it in the sidemenu or mark sidemenu items with simple dots', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'ekoterra' ),
					),
					'dependency' => array(
						'menu_style' => array( 'left', 'right' ),
					),
					'std'        => 1,
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'menu_mobile_fullscreen'        => array(
					'title' => esc_html__( 'Mobile menu fullscreen', 'ekoterra' ),
					'desc'  => wp_kses_data( __( 'Display mobile and side menus on full screen (if checked) or slide narrow menu from the left or from the right side (if not checked)', 'ekoterra' ) ),
					'std'   => 1,
					'type'  => EKOTERRA_THEME_FREE ? 'hidden' : 'checkbox',
				),

				'header_image_info'             => array(
					'title' => esc_html__( 'Header image', 'ekoterra' ),
					'desc'  => '',
					'type'  => EKOTERRA_THEME_FREE ? 'hidden' : 'info',
				),
				'header_image_override'         => array(
					'title'    => esc_html__( 'Header image override', 'ekoterra' ),
					'desc'     => wp_kses_data( __( "Allow override the header image with the page's/post's/product's/etc. featured image", 'ekoterra' ) ),
					'override' => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Header', 'ekoterra' ),
					),
					'std'      => 0,
					'type'     => EKOTERRA_THEME_FREE ? 'hidden' : 'checkbox',
				),

				'header_mobile_info'            => array(
					'title'      => esc_html__( 'Mobile header', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Configure the mobile version of the header', 'ekoterra' ) ),
					'priority'   => 500,
					'dependency' => array(
						'header_type' => array( 'default' ),
					),
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'info',
				),
				'header_mobile_enabled'         => array(
					'title'      => esc_html__( 'Enable the mobile header', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Use the mobile version of the header (if checked) or relayout the current header on mobile devices', 'ekoterra' ) ),
					'dependency' => array(
						'header_type' => array( 'default' ),
					),
					'std'        => 0,
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_additional_info' => array(
					'title'      => esc_html__( 'Additional info', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Additional info to show at the top of the mobile header', 'ekoterra' ) ),
					'std'        => '',
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'refresh'    => false,
					'teeny'      => false,
					'rows'       => 20,
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'text_editor',
				),
				'header_mobile_hide_info'       => array(
					'title'      => esc_html__( 'Hide additional info', 'ekoterra' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_hide_logo'       => array(
					'title'      => esc_html__( 'Hide logo', 'ekoterra' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_hide_login'      => array(
					'title'      => esc_html__( 'Hide login/logout', 'ekoterra' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_hide_search'     => array(
					'title'      => esc_html__( 'Hide search', 'ekoterra' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_hide_cart'       => array(
					'title'      => esc_html__( 'Hide cart', 'ekoterra' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'checkbox',
				),

				// 'Footer'
				'footer'                        => array(
					'title'    => esc_html__( 'Footer', 'ekoterra' ),
					'desc'     => wp_kses_data( $msg_override ),
					'priority' => 50,
					'type'     => 'section',
				),
				'footer_type'                   => array(
					'title'    => esc_html__( 'Footer style', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Choose whether to use the default footer or footer Layouts (available only if the ThemeREX Addons is activated)', 'ekoterra' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Footer', 'ekoterra' ),
					),
					'std'      => 'default',
					'options'  => ekoterra_get_list_header_footer_types(),
					'type'     => EKOTERRA_THEME_FREE || ! ekoterra_exists_trx_addons() ? 'hidden' : 'switch',
				),
				'footer_style'                  => array(
					'title'      => esc_html__( 'Select custom layout', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Select custom footer from Layouts Builder', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio,post',
						'section' => esc_html__( 'Footer', 'ekoterra' ),
					),
					'dependency' => array(
						'footer_type' => array( 'custom' ),
					),
					'std'        => EKOTERRA_THEME_FREE ? 'footer-custom-elementor-footer-default' : 'footer-custom-footer-default',
					'options'    => array(),
					'type'       => 'select',
				),
				'footer_widgets'                => array(
					'title'      => esc_html__( 'Footer widgets', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Select set of widgets to show in the footer', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Footer', 'ekoterra' ),
					),
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'std'        => 'footer_widgets',
					'options'    => array(),
					'type'       => 'select',
				),
				'footer_columns'                => array(
					'title'      => esc_html__( 'Footer columns', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Footer', 'ekoterra' ),
					),
					'dependency' => array(
						'footer_type'    => array( 'default' ),
						'footer_widgets' => array( '^hide' ),
					),
					'std'        => 0,
					'options'    => ekoterra_get_list_range( 0, 6 ),
					'type'       => 'select',
				),
				'footer_wide'                   => array(
					'title'      => esc_html__( 'Footer fullwidth', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Do you want to stretch the footer to the entire window width?', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Footer', 'ekoterra' ),
					),
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'std'        => 0,
					'type'       => 'checkbox',
				),
				'logo_in_footer'                => array(
					'title'      => esc_html__( 'Show logo', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Show logo in the footer', 'ekoterra' ) ),
					'refresh'    => false,
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'std'        => 0,
					'type'       => 'checkbox',
				),
				'logo_footer'                   => array(
					'title'      => esc_html__( 'Logo for footer', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Select or upload site logo to display it in the footer', 'ekoterra' ) ),
					'dependency' => array(
						'footer_type'    => array( 'default' ),
						'logo_in_footer' => array( 1 ),
					),
					'std'        => '',
					'type'       => 'image',
				),
				'logo_footer_retina'            => array(
					'title'      => esc_html__( 'Logo for footer (Retina)', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Select or upload logo for the footer area used on Retina displays (if empty - use default logo from the field above)', 'ekoterra' ) ),
					'dependency' => array(
						'footer_type'         => array( 'default' ),
						'logo_in_footer'      => array( 1 ),
						'logo_retina_enabled' => array( 1 ),
					),
					'std'        => '',
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'image',
				),
				'socials_in_footer'             => array(
					'title'      => esc_html__( 'Show social icons', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Show social icons in the footer (under logo or footer widgets)', 'ekoterra' ) ),
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'std'        => 0,
					'type'       => ! ekoterra_exists_trx_addons() ? 'hidden' : 'checkbox',
				),
				'copyright'                     => array(
					'title'      => esc_html__( 'Copyright', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Copyright text in the footer. Use {Y} to insert current year and press "Enter" to create a new line', 'ekoterra' ) ),
					'translate'  => true,
					'std'        => esc_html__( 'Copyright &copy; {Y} by AncoraThemes. All rights reserved.', 'ekoterra' ),
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'refresh'    => false,
					'type'       => 'textarea',
				),

				// 'Blog'
				'blog'                          => array(
					'title'    => esc_html__( 'Blog', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Options of the the blog archive', 'ekoterra' ) ),
					'priority' => 70,
					'type'     => 'panel',
				),

				// Blog - Posts page
				'blog_general'                  => array(
					'title' => esc_html__( 'Posts page', 'ekoterra' ),
					'desc'  => wp_kses_data( __( 'Style and components of the blog archive', 'ekoterra' ) ),
					'type'  => 'section',
				),
				'blog_general_info'             => array(
					'title'  => esc_html__( 'Posts page settings', 'ekoterra' ),
					'desc'   => '',
					'qsetup' => esc_html__( 'General', 'ekoterra' ),
					'type'   => 'info',
				),
				'blog_style'                    => array(
					'title'      => esc_html__( 'Blog style', 'ekoterra' ),
					'desc'       => '',
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'ekoterra' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					'std'        => 'excerpt',
					'qsetup'     => esc_html__( 'General', 'ekoterra' ),
					'options'    => array(),
					'type'       => 'select',
				),
				'first_post_large'              => array(
					'title'      => esc_html__( 'First post large', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Make your first post stand out by making it bigger', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'ekoterra' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
						'blog_style' => array( 'classic', 'masonry' ),
					),
					'std'        => 0,
					'type'       => 'checkbox',
				),
				'blog_content'                  => array(
					'title'      => esc_html__( 'Posts content', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Display either post excerpts or the full post content', 'ekoterra' ) ),
					'std'        => 'excerpt',
					'dependency' => array(
						'blog_style' => array( 'excerpt' ),
					),
					'options'    => array(
						'excerpt'  => esc_html__( 'Excerpt', 'ekoterra' ),
						'fullpost' => esc_html__( 'Full post', 'ekoterra' ),
					),
					'type'       => 'switch',
				),
				'excerpt_length'                => array(
					'title'      => esc_html__( 'Excerpt length', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Length (in words) to generate excerpt from the post content. Attention! If the post excerpt is explicitly specified - it appears unchanged', 'ekoterra' ) ),
					'dependency' => array(
						'blog_style'   => array( 'excerpt' ),
						'blog_content' => array( 'excerpt' ),
					),
					'std'        => 60,
					'type'       => 'text',
				),
				'blog_columns'                  => array(
					'title'   => esc_html__( 'Blog columns', 'ekoterra' ),
					'desc'    => wp_kses_data( __( 'How many columns should be used in the blog archive (from 2 to 4)?', 'ekoterra' ) ),
					'std'     => 2,
					'options' => ekoterra_get_list_range( 2, 4 ),
					'type'    => 'hidden',      // This options is available and must be overriden only for some modes (for example, 'shop')
				),
				'post_type'                     => array(
					'title'      => esc_html__( 'Post type', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Select post type to show in the blog archive', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'ekoterra' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					'linked'     => 'parent_cat',
					'refresh'    => false,
					'hidden'     => true,
					'std'        => 'post',
					'options'    => array(),
					'type'       => 'select',
				),
				'parent_cat'                    => array(
					'title'      => esc_html__( 'Category to show', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Select category to show in the blog archive', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'ekoterra' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					'refresh'    => false,
					'hidden'     => true,
					'std'        => '0',
					'options'    => array(),
					'type'       => 'select',
				),
				'posts_per_page'                => array(
					'title'      => esc_html__( 'Posts per page', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'How many posts will be displayed on this page', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'ekoterra' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					'hidden'     => true,
					'std'        => '',
					'type'       => 'text',
				),
				'blog_pagination'               => array(
					'title'      => esc_html__( 'Pagination style', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Show Older/Newest posts or Page numbers below the posts list', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'ekoterra' ),
					),
					'std'        => 'pages',
					'qsetup'     => esc_html__( 'General', 'ekoterra' ),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					'options'    => array(
						'pages'    => esc_html__( 'Page numbers', 'ekoterra' ),
						'more'     => esc_html__( 'Load more', 'ekoterra' ),
						'infinite' => esc_html__( 'Infinite scroll', 'ekoterra' ),

					),
					'type'       => 'select',
				),
				'blog_animation'                => array(
					'title'      => esc_html__( 'Animation for the posts', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Select animation to show posts in the blog. Attention! Do not use any animation on pages with the "wheel to the anchor" behaviour (like a "Chess 2 columns")!', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'ekoterra' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					'std'        => 'fadeIn',
					'options'    => array(),
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'select',
				),
				'disable_animation_on_mobile'   => array(
					'title'      => esc_html__( 'Disable animation on mobile', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Disable any posts animation on mobile devices', 'ekoterra' ) ),
					'std'        => 1,
					'type'     => EKOTERRA_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'show_filters'                  => array(
					'title'      => esc_html__( 'Show filters', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Show categories as tabs to filter posts', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'ekoterra' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
						'blog_style'     => array( 'portfolio', 'gallery' ),
					),
					'hidden'     => true,
					'std'        => 0,
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'checkbox',
				),

				'blog_header_info'              => array(
					'title' => esc_html__( 'Header', 'ekoterra' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'header_type_blog'              => array(
					'title'    => esc_html__( 'Header style', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'ekoterra' ) ),
					'std'      => 'inherit',
					'options'  => ekoterra_get_list_header_footer_types( true ),
					'type'     => EKOTERRA_THEME_FREE || ! ekoterra_exists_trx_addons() ? 'hidden' : 'switch',
				),
				'header_style_blog'             => array(
					'title'      => esc_html__( 'Select custom layout', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Select custom header from Layouts Builder', 'ekoterra' ) ),
					'dependency' => array(
						'header_type_blog' => array( 'custom' ),
					),
					'std'        => EKOTERRA_THEME_FREE ? 'header-custom-elementor-header-default' : 'header-custom-header-default',
					'options'    => array(),
					'type'       => 'select',
				),
				'header_position_blog'          => array(
					'title'    => esc_html__( 'Header position', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Select position to display the site header', 'ekoterra' ) ),
					'std'      => 'inherit',
					'options'  => array(),
					'type'     => EKOTERRA_THEME_FREE ? 'hidden' : 'switch',
				),
				'header_fullheight_blog'        => array(
					'title'    => esc_html__( 'Header fullheight', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Enlarge header area to fill whole screen. Used only if header have a background image', 'ekoterra' ) ),
					'std'      => 0,
					'type'     => EKOTERRA_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_wide_blog'              => array(
					'title'      => esc_html__( 'Header fullwidth', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Do you want to stretch the header widgets area to the entire window width?', 'ekoterra' ) ),
					'dependency' => array(
						'header_type_blog' => array( 'default' ),
					),
					'std'        => 1,
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'checkbox',
				),

				'blog_sidebar_info'             => array(
					'title' => esc_html__( 'Sidebar', 'ekoterra' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'sidebar_position_blog'         => array(
					'title'   => esc_html__( 'Sidebar position', 'ekoterra' ),
					'desc'    => wp_kses_data( __( 'Select position to show sidebar', 'ekoterra' ) ),
					'std'     => 'inherit',
					'options' => array(),
					'qsetup'     => esc_html__( 'General', 'ekoterra' ),
					'type'    => 'switch',
				),
				'sidebar_position_mobile_blog'  => array(
					'title'    => esc_html__( 'Sidebar position on mobile', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Select position to show sidebar on mobile devices - above or below the content', 'ekoterra' ) ),
					'dependency' => array(
						'sidebar_position_blog' => array( '^hide' ),
					),
					'std'      => 'inherit',
					'qsetup'   => esc_html__( 'General', 'ekoterra' ),
					'options'  => array(),
					'type'     => 'switch',
				),
				'sidebar_widgets_blog'          => array(
					'title'      => esc_html__( 'Sidebar widgets', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Select default widgets to show in the sidebar', 'ekoterra' ) ),
					'dependency' => array(
						'sidebar_position_blog' => array( '^hide' ),
					),
					'std'        => 'sidebar_widgets',
					'options'    => array(),
					'qsetup'     => esc_html__( 'General', 'ekoterra' ),
					'type'       => 'select',
				),
				'expand_content_blog'           => array(
					'title'   => esc_html__( 'Expand content', 'ekoterra' ),
					'desc'    => wp_kses_data( __( 'Expand the content width if the sidebar is hidden', 'ekoterra' ) ),
					'refresh' => false,
					'std'     => 1,
					'type'    => 'checkbox',
				),

				'blog_widgets_info'             => array(
					'title' => esc_html__( 'Additional widgets', 'ekoterra' ),
					'desc'  => '',
					'type'  => EKOTERRA_THEME_FREE ? 'hidden' : 'hidden',
				),
				'widgets_above_page_blog'       => array(
					'title'   => esc_html__( 'Widgets at the top of the page', 'ekoterra' ),
					'desc'    => wp_kses_data( __( 'Select widgets to show at the top of the page (above content and sidebar)', 'ekoterra' ) ),
					'std'     => 'hide',
					'options' => array(),
					'type'    => EKOTERRA_THEME_FREE ? 'hidden' : 'hidden',
				),
				'widgets_above_content_blog'    => array(
					'title'   => esc_html__( 'Widgets above the content', 'ekoterra' ),
					'desc'    => wp_kses_data( __( 'Select widgets to show at the beginning of the content area', 'ekoterra' ) ),
					'std'     => 'hide',
					'options' => array(),
					'type'    => EKOTERRA_THEME_FREE ? 'hidden' : 'hidden',
				),
				'widgets_below_content_blog'    => array(
					'title'   => esc_html__( 'Widgets below the content', 'ekoterra' ),
					'desc'    => wp_kses_data( __( 'Select widgets to show at the ending of the content area', 'ekoterra' ) ),
					'std'     => 'hide',
					'options' => array(),
					'type'    => EKOTERRA_THEME_FREE ? 'hidden' : 'hidden',
				),
				'widgets_below_page_blog'       => array(
					'title'   => esc_html__( 'Widgets at the bottom of the page', 'ekoterra' ),
					'desc'    => wp_kses_data( __( 'Select widgets to show at the bottom of the page (below content and sidebar)', 'ekoterra' ) ),
					'std'     => 'hide',
					'options' => array(),
					'type'    => EKOTERRA_THEME_FREE ? 'hidden' : 'hidden',
				),

				'blog_advanced_info'            => array(
					'title' => esc_html__( 'Advanced settings', 'ekoterra' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'no_image'                      => array(
					'title' => esc_html__( 'Image placeholder', 'ekoterra' ),
					'desc'  => wp_kses_data( __( 'Select or upload an image used as placeholder for posts without a featured image', 'ekoterra' ) ),
					'std'   => '',
					'type'  => 'image',
				),
				'time_diff_before'              => array(
					'title' => esc_html__( 'Easy Readable Date Format', 'ekoterra' ),
					'desc'  => wp_kses_data( __( "For how many days to show the easy-readable date format (e.g. '3 days ago') instead of the standard publication date", 'ekoterra' ) ),
					'std'   => 5,
					'type'  => 'text',
				),
				'sticky_style'                  => array(
					'title'   => esc_html__( 'Sticky posts style', 'ekoterra' ),
					'desc'    => wp_kses_data( __( 'Select style of the sticky posts output', 'ekoterra' ) ),
					'std'     => 'inherit',
					'options' => array(
						'inherit' => esc_html__( 'Decorated posts', 'ekoterra' ),
					),
					'type'    => EKOTERRA_THEME_FREE ? 'hidden' : 'select',
				),
				'meta_parts'                    => array(
					'title'      => esc_html__( 'Post meta', 'ekoterra' ),
					'desc'       => wp_kses_data( __( "If your blog page is created using the 'Blog archive' page template, set up the 'Post Meta' settings in the 'Theme Options' section of that page. Post counters and Share Links are available only if plugin ThemeREX Addons is active", 'ekoterra' ) )
								. '<br>'
								. wp_kses_data( __( '<b>Tip:</b> Drag items to change their order.', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'ekoterra' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					'dir'        => 'vertical',
					'sortable'   => true,
					'std'        => 'date=1|categories=1|counters=0|author=0|share=0|edit=0',
					'options'    => ekoterra_get_list_meta_parts(),
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'checklist',
				),
				'counters'                      => array(
					'title'      => esc_html__( 'Post counters', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Show only selected counters. Attention! Likes and Views are available only if ThemeREX Addons is active', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'ekoterra' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					'dir'        => 'vertical',
					'sortable'   => true,
					'std'        => 'views=1|likes=1|comments=1',
					'options'    => ekoterra_get_list_counters(),
					'type'       => EKOTERRA_THEME_FREE || ! ekoterra_exists_trx_addons() ? 'hidden' : 'checklist',
				),

				// Blog - Single posts
				'blog_single'                   => array(
					'title' => esc_html__( 'Single posts', 'ekoterra' ),
					'desc'  => wp_kses_data( __( 'Settings of the single post', 'ekoterra' ) ),
					'type'  => 'section',
				),

				'blog_single_header_info'       => array(
					'title' => esc_html__( 'Header', 'ekoterra' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'header_type_post'              => array(
					'title'    => esc_html__( 'Header style', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'ekoterra' ) ),
					'std'      => 'inherit',
					'options'  => ekoterra_get_list_header_footer_types( true ),
					'type'     => EKOTERRA_THEME_FREE || ! ekoterra_exists_trx_addons() ? 'hidden' : 'switch',
				),
				'header_style_post'             => array(
					'title'      => esc_html__( 'Select custom layout', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Select custom header from Layouts Builder', 'ekoterra' ) ),
					'dependency' => array(
						'header_type_post' => array( 'custom' ),
					),
					'std'        => EKOTERRA_THEME_FREE ? 'header-custom-elementor-header-default' : 'header-custom-header-default',
					'options'    => array(),
					'type'       => 'select',
				),
				'header_position_post'          => array(
					'title'    => esc_html__( 'Header position', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Select position to display the site header', 'ekoterra' ) ),
					'std'      => 'inherit',
					'options'  => array(),
					'type'     => EKOTERRA_THEME_FREE ? 'hidden' : 'switch',
				),
				'header_fullheight_post'        => array(
					'title'    => esc_html__( 'Header fullheight', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Enlarge header area to fill whole screen. Used only if header have a background image', 'ekoterra' ) ),
					'std'      => 0,
					'type'     => EKOTERRA_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_wide_post'              => array(
					'title'      => esc_html__( 'Header fullwidth', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Do you want to stretch the header widgets area to the entire window width?', 'ekoterra' ) ),
					'dependency' => array(
						'header_type_post' => array( 'default' ),
					),
					'std'        => 1,
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'checkbox',
				),

				'blog_single_sidebar_info'      => array(
					'title' => esc_html__( 'Sidebar', 'ekoterra' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'sidebar_position_single'       => array(
					'title'   => esc_html__( 'Sidebar position', 'ekoterra' ),
					'desc'    => wp_kses_data( __( 'Select position to show sidebar on the single posts', 'ekoterra' ) ),
					'std'     => 'right',
					'override'   => array(
						'mode'    => 'post,product,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'ekoterra' ),
					),
					'options' => array(),
					'type'    => 'switch',
				),
				'sidebar_position_mobile_single'=> array(
					'title'    => esc_html__( 'Sidebar position on mobile', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Select position to show sidebar on the single posts on mobile devices - above or below the content', 'ekoterra' ) ),
					'override' => array(
						'mode'    => 'post,product,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'ekoterra' ),
					),
					'dependency' => array(
						'sidebar_position_single' => array( '^hide' ),
					),
					'std'      => 'below',
					'options'  => array(),
					'type'     => 'switch',
				),
				'sidebar_widgets_single'        => array(
					'title'      => esc_html__( 'Sidebar widgets', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Select default widgets to show in the sidebar on the single posts', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'post,product,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'ekoterra' ),
					),
					'dependency' => array(
						'sidebar_position_single' => array( '^hide' ),
					),
					'std'        => 'sidebar_widgets',
					'options'    => array(),
					'type'       => 'select',
				),
				'expand_content_post'           => array(
					'title'   => esc_html__( 'Expand content', 'ekoterra' ),
					'desc'    => wp_kses_data( __( 'Expand the content width on the single posts if the sidebar is hidden', 'ekoterra' ) ),
					'refresh' => false,
					'std'     => 1,
					'type'    => 'checkbox',
				),

				'blog_single_title_info'      => array(
					'title' => esc_html__( 'Featured image and title', 'ekoterra' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'hide_featured_on_single'       => array(
					'title'    => esc_html__( 'Hide featured image on the single post', 'ekoterra' ),
					'desc'     => wp_kses_data( __( "Hide featured image on the single post's pages", 'ekoterra' ) ),
					'override' => array(
						'mode'    => 'page,post',
						'section' => esc_html__( 'Content', 'ekoterra' ),
					),
					'std'      => 0,
					'type'     => 'checkbox',
				),
				'post_thumbnail_type'      => array(
					'title'      => esc_html__( 'Type of post thumbnail', 'ekoterra' ),
					'desc'       => wp_kses_data( __( "Select type of post thumbnail on the single post's pages", 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Content', 'ekoterra' ),
					),
					'dependency' => array(
						'hide_featured_on_single' => array( 'is_empty', 0 ),
					),
					'std'        => 'default',
					'options'    => array(
						'fullwidth'   => esc_html__( 'Fullwidth', 'ekoterra' ),

						'default'     => esc_html__( 'Default', 'ekoterra' ),
					),
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'select',
				),
				'post_header_position'          => array(
					'title'      => esc_html__( 'Post header position', 'ekoterra' ),
					'desc'       => wp_kses_data( __( "Select post header position on the single post's pages", 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Content', 'ekoterra' ),
					),
					'dependency' => array(
						'hide_featured_on_single' => array( 'is_empty', 0 ),
					),
					'std'        => 'under',
					'options'    => array(
						'above'      => esc_html__( 'Above the post thumbnail', 'ekoterra' ),
						'under'      => esc_html__( 'Under the post thumbnail', 'ekoterra' ),
						'default'    => esc_html__( 'Default', 'ekoterra' ),
					),
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'select',
				),
				'post_header_align'             => array(
					'title'      => esc_html__( 'Align of the post header', 'ekoterra' ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Content', 'ekoterra' ),
					),
					'dependency' => array(
						'post_header_position' => array( 'on_thumb' ),
					),
					'std'        => 'mc',
					'options'    => array(
						'ts' => esc_html__('Top Stick Out', 'ekoterra'),
						'tl' => esc_html__('Top Left', 'ekoterra'),
						'tc' => esc_html__('Top Center', 'ekoterra'),
						'tr' => esc_html__('Top Right', 'ekoterra'),
						'ml' => esc_html__('Middle Left', 'ekoterra'),
						'mc' => esc_html__('Middle Center', 'ekoterra'),
						'mr' => esc_html__('Middle Right', 'ekoterra'),
						'bl' => esc_html__('Bottom Left', 'ekoterra'),
						'bc' => esc_html__('Bottom Center', 'ekoterra'),
						'br' => esc_html__('Bottom Right', 'ekoterra'),
						'bs' => esc_html__('Bottom Stick Out', 'ekoterra'),
					),
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'select',
				),
				'post_subtitle'                 => array(
					'title' => esc_html__( 'Post subtitle', 'ekoterra' ),
					'desc'  => wp_kses_data( __( "Specify post subtitle to display it under the post title.", 'ekoterra' ) ),
					'override' => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Content', 'ekoterra' ),
					),
					'std'   => '',
					'hidden' => true,
					'type'  => 'text',
				),
				'show_post_meta'                => array(
					'title' => esc_html__( 'Show post meta', 'ekoterra' ),
					'desc'  => wp_kses_data( __( "Display block with post's meta: date, categories, counters, etc.", 'ekoterra' ) ),
					'std'   => 1,
					'type'  => 'checkbox',
				),
				'meta_parts_post'               => array(
					'title'      => esc_html__( 'Post meta', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Meta parts for single posts. Post counters and Share Links are available only if plugin ThemeREX Addons is active', 'ekoterra' ) )
								. '<br>'
								. wp_kses_data( __( '<b>Tip:</b> Drag items to change their order.', 'ekoterra' ) ),
					'dependency' => array(
						'show_post_meta' => array( 1 ),
					),
					'dir'        => 'vertical',
					'sortable'   => true,
					'std'        => 'date=1|categories=1|counters=0|author=0|share=0|edit=0',
					'options'    => ekoterra_get_list_meta_parts(),
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'checklist',
				),
				'counters_post'                 => array(
					'title'      => esc_html__( 'Post counters', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Show only selected counters. Attention! Likes and Views are available only if plugin ThemeREX Addons is active', 'ekoterra' ) ),
					'dependency' => array(
						'show_post_meta' => array( 1 ),
					),
					'dir'        => 'vertical',
					'sortable'   => true,
					'std'        => 'views=1|likes=1|comments=1',
					'options'    => ekoterra_get_list_counters(),
					'type'       => EKOTERRA_THEME_FREE || ! ekoterra_exists_trx_addons() ? 'hidden' : 'checklist',
				),
				'show_share_links'              => array(
					'title' => esc_html__( 'Show share links', 'ekoterra' ),
					'desc'  => wp_kses_data( __( 'Display share links on the single post', 'ekoterra' ) ),
					'std'   => 1,
					'type'  => ! ekoterra_exists_trx_addons() ? 'hidden' : 'checkbox',
				),
				'show_author_info'              => array(
					'title' => esc_html__( 'Show author info', 'ekoterra' ),
					'desc'  => wp_kses_data( __( "Display block with information about post's author", 'ekoterra' ) ),
					'std'   => 1,
					'type'  => 'checkbox',
				),

				'blog_single_related_info'      => array(
					'title' => esc_html__( 'Related posts', 'ekoterra' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'show_related_posts'            => array(
					'title'    => esc_html__( 'Show related posts', 'ekoterra' ),
					'desc'     => wp_kses_data( __( "Show section 'Related posts' on the single post's pages", 'ekoterra' ) ),
					'override' => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'ekoterra' ),
					),
					'std'      => 0,
					'type'     => 'checkbox',
				),
				'related_posts'                 => array(
					'title'      => esc_html__( 'Related posts', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'How many related posts should be displayed in the single post? If 0 - no related posts are shown.', 'ekoterra' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
					),
					'std'        => 2,
					'options'    => ekoterra_get_list_range( 1, 9 ),
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'select',
				),
				'related_columns'               => array(
					'title'      => esc_html__( 'Related columns', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'How many columns should be used to output related posts in the single page (from 2 to 4)?', 'ekoterra' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
					),
					'std'        => 2,
					'options'    => ekoterra_get_list_range( 1, 4 ),
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'switch',
				),
				'related_style'                 => array(
					'title'      => esc_html__( 'Related posts style', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Select style of the related posts output', 'ekoterra' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
					),
					'std'        => 1,
					'options'    => ekoterra_get_list_styles(1, 1),
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'hidden',
				),
				'related_slider'                => array(
					'title'      => esc_html__( 'Use slider layout', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Use slider layout in case related posts count is more than columns count', 'ekoterra' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
					),
					'std'        => 0,
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'hidden',
				),
				'related_slider_controls'       => array(
					'title'      => esc_html__( 'Slider controls', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Show arrows in the slider', 'ekoterra' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
						'related_slider' => array( 1 ),
					),
					'std'        => 'none',
					'options'    => array(
						'none'    => esc_html__('None', 'ekoterra'),
						'side'    => esc_html__('Side', 'ekoterra'),
						'outside' => esc_html__('Outside', 'ekoterra'),
						'top'     => esc_html__('Top', 'ekoterra'),
						'bottom'  => esc_html__('Bottom', 'ekoterra')
					),
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'select',
				),
				'related_slider_pagination'       => array(
					'title'      => esc_html__( 'Slider pagination', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Show bullets after the slider', 'ekoterra' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
						'related_slider' => array( 1 ),
					),
					'std'        => 'bottom',
					'options'    => array(
						'none'    => esc_html__('None', 'ekoterra'),
						'bottom'  => esc_html__('Bottom', 'ekoterra')
					),
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'switch',
				),
				'related_slider_space'          => array(
					'title'      => esc_html__( 'Space', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Space between slides', 'ekoterra' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
						'related_slider' => array( 1 ),
					),
					'std'        => 30,
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'text',
				),
				'related_position'              => array(
					'title'      => esc_html__( 'Related posts position', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Select position to display the related posts', 'ekoterra' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
					),
					'std'        => 'below_content',
					'options'    => array (
						'below_content' => esc_html__( 'After content', 'ekoterra' ),
						'below_page'    => esc_html__( 'After content & sidebar', 'ekoterra' ),
					),
					'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'switch',
				),
				'posts_navigation_info'      => array(
					'title' => esc_html__( 'Posts navigation', 'ekoterra' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'show_posts_navigation'		=> array(
					'title'    => esc_html__( 'Show posts navigation', 'ekoterra' ),
					'desc'     => wp_kses_data( __( "Show posts navigation on the single post's pages", 'ekoterra' ) ),
					'std'      => 0,
					'type'     => 'checkbox',
				),
				'fixed_posts_navigation'		=> array(
					'title'    => esc_html__( 'Fixed posts navigation', 'ekoterra' ),
					'desc'     => wp_kses_data( __( "Make posts navigation fixed position. Display it when the content of the article is inside the window.", 'ekoterra' ) ),
					'dependency' => array(
						'show_posts_navigation' => array( 1 ),
					),
					'std'      => 0,
					'type'     => 'hidden',
				),
				'posts_banners_info'      => array(
					'title' => esc_html__( 'Posts banners', 'ekoterra' ),
					'desc'  => '',
					'type'  => 'hidden',
				),
				'header_banner_link'     => array(
					'title' => esc_html__( 'Header banner link', 'ekoterra' ),
					'desc'  => wp_kses_data( __( 'Insert URL of the banner', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'ekoterra' ),
					),
					'std'   => '',
					'type'  => 'hidden',
				),
				'header_banner_img'     => array(
					'title' => esc_html__( 'Header banner image', 'ekoterra' ),
					'desc'  => wp_kses_data( __( 'Select image to display at the backgound', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'ekoterra' ),
					),
					'std'        => '',
					'type'       => 'hidden',
				),
				'header_banner_code'     => array(
					'title'      => esc_html__( 'Header banner code', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Embed html code', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'ekoterra' ),
					),
					'std'        => '',
					'allow_html' => true,
					'type'       => 'hidden',
				),
				'footer_banner_link'     => array(
					'title' => esc_html__( 'Footer banner link', 'ekoterra' ),
					'desc'  => wp_kses_data( __( 'Insert URL of the banner', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'ekoterra' ),
					),
					'std'   => '',
					'type'  => 'hidden',
				),
				'footer_banner_img'     => array(
					'title' => esc_html__( 'Footer banner image', 'ekoterra' ),
					'desc'  => wp_kses_data( __( 'Select image to display at the backgound', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'ekoterra' ),
					),
					'std'        => '',
					'type'       => 'hidden',
				),
				'footer_banner_code'     => array(
					'title'      => esc_html__( 'Footer banner code', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Embed html code', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'ekoterra' ),
					),
					'std'        => '',
					'allow_html' => true,
					'type'       => 'hidden',
				),
				'sidebar_banner_link'     => array(
					'title' => esc_html__( 'Sidebar banner link', 'ekoterra' ),
					'desc'  => wp_kses_data( __( 'Insert URL of the banner', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'ekoterra' ),
					),
					'std'   => '',
					'type'  => 'hidden',
				),
				'sidebar_banner_img'     => array(
					'title' => esc_html__( 'Sidebar banner image', 'ekoterra' ),
					'desc'  => wp_kses_data( __( 'Select image to display at the backgound', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'ekoterra' ),
					),
					'std'        => '',
					'type'       => 'hidden',
				),
				'sidebar_banner_code'     => array(
					'title'      => esc_html__( 'Sidebar banner code', 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Embed html code', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'ekoterra' ),
					),
					'std'        => '',
					'allow_html' => true,
					'type'       => 'hidden',
				),
				'background_banner_link'     => array(
					'title' => esc_html__( "Post's background banner link", 'ekoterra' ),
					'desc'  => wp_kses_data( __( 'Insert URL of the banner', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'ekoterra' ),
					),
					'std'   => '',
					'type'  => 'hidden',
				),
				'background_banner_img'     => array(
					'title' => esc_html__( "Post's background banner image", 'ekoterra' ),
					'desc'  => wp_kses_data( __( 'Select image to display at the backgound', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'ekoterra' ),
					),
					'std'        => '',
					'type'       => 'hidden',
				),
				'background_banner_code'     => array(
					'title'      => esc_html__( "Post's background banner code", 'ekoterra' ),
					'desc'       => wp_kses_data( __( 'Embed html code', 'ekoterra' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'ekoterra' ),
					),
					'std'        => '',
					'allow_html' => true,
					'type'       => 'hidden',
				),
				'blog_end'                      => array(
					'type' => 'panel_end',
				),

				// 'Colors'
				'panel_colors'                  => array(
					'title'    => esc_html__( 'Colors', 'ekoterra' ),
					'desc'     => '',
					'priority' => 300,
					'type'     => 'section',
				),

				'color_schemes_info'            => array(
					'title'  => esc_html__( 'Color schemes', 'ekoterra' ),
					'desc'   => wp_kses_data( __( 'Color schemes for various parts of the site. "Inherit" means that this block is used the Site color scheme (the first parameter)', 'ekoterra' ) ),
					'hidden' => $hide_schemes,
					'type'   => 'info',
				),
				'color_scheme'                  => array(
					'title'    => esc_html__( 'Site Color Scheme', 'ekoterra' ),
					'desc'     => '',
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Colors', 'ekoterra' ),
					),
					'std'      => 'default',
					'options'  => array(),
					'refresh'  => false,
					'type'     => $hide_schemes ? 'hidden' : 'switch',
				),
				'header_scheme'                 => array(
					'title'    => esc_html__( 'Header Color Scheme', 'ekoterra' ),
					'desc'     => '',
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Colors', 'ekoterra' ),
					),
					'std'      => 'inherit',
					'options'  => array(),
					'refresh'  => false,
					'type'     => $hide_schemes ? 'hidden' : 'switch',
				),
				'menu_scheme'                   => array(
					'title'    => esc_html__( 'Sidemenu Color Scheme', 'ekoterra' ),
					'desc'     => '',
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Colors', 'ekoterra' ),
					),
					'std'      => 'inherit',
					'options'  => array(),
					'refresh'  => false,
					'type'     => $hide_schemes || EKOTERRA_THEME_FREE ? 'hidden' : 'switch',
				),
				'sidebar_scheme'                => array(
					'title'    => esc_html__( 'Sidebar Color Scheme', 'ekoterra' ),
					'desc'     => '',
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Colors', 'ekoterra' ),
					),
					'std'      => 'inherit',
					'options'  => array(),
					'refresh'  => false,
					'type'     => $hide_schemes ? 'hidden' : 'switch',
				),
				'footer_scheme'                 => array(
					'title'    => esc_html__( 'Footer Color Scheme', 'ekoterra' ),
					'desc'     => '',
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Colors', 'ekoterra' ),
					),
					'std'      => 'inherit',
					'options'  => array(),
					'refresh'  => false,
					'type'     => $hide_schemes ? 'hidden' : 'switch',
				),

				'color_scheme_editor_info'      => array(
					'title' => esc_html__( 'Color scheme editor', 'ekoterra' ),
					'desc'  => wp_kses_data( __( 'Select color scheme to modify. Attention! Only those sections in the site will be changed which this scheme was assigned to', 'ekoterra' ) ),
					'type'  => 'info',
				),
				'scheme_storage'                => array(
					'title'       => esc_html__( 'Color scheme editor', 'ekoterra' ),
					'desc'        => '',
					'std'         => '$ekoterra_get_scheme_storage',
					'refresh'     => false,
					'colorpicker' => 'tiny',
					'type'        => 'scheme_editor',
				),

				// Internal options.
				// Attention! Don't change any options in the section below!
				// Use huge priority to call render this elements after all options!
				'reset_options'                 => array(
					'title'    => '',
					'desc'     => '',
					'std'      => '0',
					'priority' => 10000,
					'type'     => 'hidden',
				),

				'last_option'                   => array(     // Need to manually call action to include Tiny MCE scripts
					'title' => '',
					'desc'  => '',
					'std'   => 1,
					'type'  => 'hidden',
				),

			)
		);

		// Prepare panel 'Fonts'
		// -------------------------------------------------------------
		$fonts = array(

			// 'Fonts'
			'fonts'             => array(
				'title'    => esc_html__( 'Typography', 'ekoterra' ),
				'desc'     => '',
				'priority' => 200,
				'type'     => 'panel',
			),

			// Fonts - Load_fonts
			'load_fonts'        => array(
				'title' => esc_html__( 'Load fonts', 'ekoterra' ),
				'desc'  => wp_kses_data( __( 'Specify fonts to load when theme start. You can use them in the base theme elements: headers, text, menu, links, input fields, etc.', 'ekoterra' ) )
						. '<br>'
						. wp_kses_data( __( 'Attention! Press "Refresh" button to reload preview area after the all fonts are changed', 'ekoterra' ) ),
				'type'  => 'section',
			),
			'load_fonts_subset' => array(
				'title'   => esc_html__( 'Google fonts subsets', 'ekoterra' ),
				'desc'    => wp_kses_data( __( 'Specify comma separated list of the subsets which will be load from Google fonts', 'ekoterra' ) )
						. '<br>'
						. wp_kses_data( __( 'Available subsets are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese', 'ekoterra' ) ),
				'class'   => 'ekoterra_column-1_3 ekoterra_new_row',
				'refresh' => false,
				'std'     => '$ekoterra_get_load_fonts_subset',
				'type'    => 'text',
			),
		);

		for ( $i = 1; $i <= ekoterra_get_theme_setting( 'max_load_fonts' ); $i++ ) {
			if ( ekoterra_get_value_gp( 'page' ) != 'theme_options' ) {
				$fonts[ "load_fonts-{$i}-info" ] = array(
					// Translators: Add font's number - 'Font 1', 'Font 2', etc
					'title' => esc_html( sprintf( __( 'Font %s', 'ekoterra' ), $i ) ),
					'desc'  => '',
					'type'  => 'info',
				);
			}
			$fonts[ "load_fonts-{$i}-name" ]   = array(
				'title'   => esc_html__( 'Font name', 'ekoterra' ),
				'desc'    => '',
				'class'   => 'ekoterra_column-1_3 ekoterra_new_row',
				'refresh' => false,
				'std'     => '$ekoterra_get_load_fonts_option',
				'type'    => 'text',
			);
			$fonts[ "load_fonts-{$i}-family" ] = array(
				'title'   => esc_html__( 'Font family', 'ekoterra' ),
				'desc'    => 1 == $i
							? wp_kses_data( __( 'Select font family to use it if font above is not available', 'ekoterra' ) )
							: '',
				'class'   => 'ekoterra_column-1_3',
				'refresh' => false,
				'std'     => '$ekoterra_get_load_fonts_option',
				'options' => array(
					'inherit'    => esc_html__( 'Inherit', 'ekoterra' ),
					'serif'      => esc_html__( 'serif', 'ekoterra' ),
					'sans-serif' => esc_html__( 'sans-serif', 'ekoterra' ),
					'monospace'  => esc_html__( 'monospace', 'ekoterra' ),
					'cursive'    => esc_html__( 'cursive', 'ekoterra' ),
					'fantasy'    => esc_html__( 'fantasy', 'ekoterra' ),
				),
				'type'    => 'select',
			);
			$fonts[ "load_fonts-{$i}-styles" ] = array(
				'title'   => esc_html__( 'Font styles', 'ekoterra' ),
				'desc'    => 1 == $i
							? wp_kses_data( __( 'Font styles used only for the Google fonts. This is a comma separated list of the font weight and styles. For example: 400,400italic,700', 'ekoterra' ) )
								. '<br>'
								. wp_kses_data( __( 'Attention! Each weight and style increase download size! Specify only used weights and styles.', 'ekoterra' ) )
							: '',
				'class'   => 'ekoterra_column-1_3',
				'refresh' => false,
				'std'     => '$ekoterra_get_load_fonts_option',
				'type'    => 'text',
			);
		}
		$fonts['load_fonts_end'] = array(
			'type' => 'section_end',
		);

		// Fonts - H1..6, P, Info, Menu, etc.
		$theme_fonts = ekoterra_get_theme_fonts();
		foreach ( $theme_fonts as $tag => $v ) {
			$fonts[ "{$tag}_section" ] = array(
				'title' => ! empty( $v['title'] )
								? $v['title']
								// Translators: Add tag's name to make title 'H1 settings', 'P settings', etc.
								: esc_html( sprintf( __( '%s settings', 'ekoterra' ), $tag ) ),
				'desc'  => ! empty( $v['description'] )
								? $v['description']
								// Translators: Add tag's name to make description
								: wp_kses( sprintf( __( 'Font settings of the "%s" tag.', 'ekoterra' ), $tag ), 'ekoterra_kses_content' ),
				'type'  => 'section',
			);

			foreach ( $v as $css_prop => $css_value ) {
				if ( in_array( $css_prop, array( 'title', 'description' ) ) ) {
					continue;
				}
				$options    = '';
				$type       = 'text';
				$load_order = 1;
				$title      = ucfirst( str_replace( '-', ' ', $css_prop ) );
				if ( 'font-family' == $css_prop ) {
					$type       = 'select';
					$options    = array();
					$load_order = 2;        // Load this option's value after all options are loaded (use option 'load_fonts' to build fonts list)
				} elseif ( 'font-weight' == $css_prop ) {
					$type    = 'select';
					$options = array(
						'inherit' => esc_html__( 'Inherit', 'ekoterra' ),
						'100'     => esc_html__( '100 (Light)', 'ekoterra' ),
						'200'     => esc_html__( '200 (Light)', 'ekoterra' ),
						'300'     => esc_html__( '300 (Thin)', 'ekoterra' ),
						'400'     => esc_html__( '400 (Normal)', 'ekoterra' ),
						'500'     => esc_html__( '500 (Semibold)', 'ekoterra' ),
						'600'     => esc_html__( '600 (Semibold)', 'ekoterra' ),
						'700'     => esc_html__( '700 (Bold)', 'ekoterra' ),
						'800'     => esc_html__( '800 (Black)', 'ekoterra' ),
						'900'     => esc_html__( '900 (Black)', 'ekoterra' ),
					);
				} elseif ( 'font-style' == $css_prop ) {
					$type    = 'select';
					$options = array(
						'inherit' => esc_html__( 'Inherit', 'ekoterra' ),
						'normal'  => esc_html__( 'Normal', 'ekoterra' ),
						'italic'  => esc_html__( 'Italic', 'ekoterra' ),
					);
				} elseif ( 'text-decoration' == $css_prop ) {
					$type    = 'select';
					$options = array(
						'inherit'      => esc_html__( 'Inherit', 'ekoterra' ),
						'none'         => esc_html__( 'None', 'ekoterra' ),
						'underline'    => esc_html__( 'Underline', 'ekoterra' ),
						'overline'     => esc_html__( 'Overline', 'ekoterra' ),
						'line-through' => esc_html__( 'Line-through', 'ekoterra' ),
					);
				} elseif ( 'text-transform' == $css_prop ) {
					$type    = 'select';
					$options = array(
						'inherit'    => esc_html__( 'Inherit', 'ekoterra' ),
						'none'       => esc_html__( 'None', 'ekoterra' ),
						'uppercase'  => esc_html__( 'Uppercase', 'ekoterra' ),
						'lowercase'  => esc_html__( 'Lowercase', 'ekoterra' ),
						'capitalize' => esc_html__( 'Capitalize', 'ekoterra' ),
					);
				}
				$fonts[ "{$tag}_{$css_prop}" ] = array(
					'title'      => $title,
					'desc'       => '',
					'class'      => 'ekoterra_column-1_5',
					'refresh'    => false,
					'load_order' => $load_order,
					'std'        => '$ekoterra_get_theme_fonts_option',
					'options'    => $options,
					'type'       => $type,
				);
			}

			$fonts[ "{$tag}_section_end" ] = array(
				'type' => 'section_end',
			);
		}

		$fonts['fonts_end'] = array(
			'type' => 'panel_end',
		);

		// Add fonts parameters to Theme Options
		ekoterra_storage_set_array_before( 'options', 'panel_colors', $fonts );

		// Add Header Video if WP version < 4.7
		// -----------------------------------------------------
		if ( ! function_exists( 'get_header_video_url' ) ) {
			ekoterra_storage_set_array_after(
				'options', 'header_image_override', 'header_video', array(
					'title'    => esc_html__( 'Header video', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Select video to use it as background for the header', 'ekoterra' ) ),
					'override' => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Header', 'ekoterra' ),
					),
					'std'      => '',
					'type'     => 'video',
				)
			);
		}

		// Add option 'logo' if WP version < 4.5
		// or 'custom_logo' if current page is not 'Customize'
		// ------------------------------------------------------
		if ( ! function_exists( 'the_custom_logo' ) || ! ekoterra_check_current_url( 'customize.php' ) ) {
			ekoterra_storage_set_array_before(
				'options', 'logo_retina', function_exists( 'the_custom_logo' ) ? 'custom_logo' : 'logo', array(
					'title'    => esc_html__( 'Logo', 'ekoterra' ),
					'desc'     => wp_kses_data( __( 'Select or upload the site logo', 'ekoterra' ) ),
					'class'    => 'ekoterra_column-1_2 ekoterra_new_row',
					'priority' => 60,
					'std'      => '',
					'qsetup'   => esc_html__( 'General', 'ekoterra' ),
					'type'     => 'image',
				)
			);
		}

	}
}


// Returns a list of options that can be overridden for CPT
if ( ! function_exists( 'ekoterra_options_get_list_cpt_options' ) ) {
	function ekoterra_options_get_list_cpt_options( $cpt, $title = '' ) {
		if ( empty( $title ) ) {
			$title = ucfirst( $cpt );
		}
		return array(
			"content_info_{$cpt}"           => array(
				'title' => esc_html__( 'Content', 'ekoterra' ),
				'desc'  => '',
				'type'  => 'info',
			),
			"body_style_{$cpt}"             => array(
				'title'    => esc_html__( 'Body style', 'ekoterra' ),
				'desc'     => wp_kses_data( __( 'Select width of the body content', 'ekoterra' ) ),
				'std'      => 'inherit',
				'options'  => ekoterra_get_list_body_styles( true ),
				'type'     => 'select',
			),
			"boxed_bg_image_{$cpt}"         => array(
				'title'      => esc_html__( 'Boxed bg image', 'ekoterra' ),
				'desc'       => wp_kses_data( __( 'Select or upload image, used as background in the boxed body', 'ekoterra' ) ),
				'dependency' => array(
					"body_style_{$cpt}" => array( 'boxed' ),
				),
				'std'        => 'inherit',
				'type'       => 'image',
			),
			"header_info_{$cpt}"            => array(
				'title' => esc_html__( 'Header', 'ekoterra' ),
				'desc'  => '',
				'type'  => 'info',
			),
			"header_type_{$cpt}"            => array(
				'title'   => esc_html__( 'Header style', 'ekoterra' ),
				'desc'    => wp_kses_data( __( 'Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'ekoterra' ) ),
				'std'     => 'inherit',
				'options' => ekoterra_get_list_header_footer_types( true ),
				'type'    => EKOTERRA_THEME_FREE ? 'hidden' : 'switch',
			),
			"header_style_{$cpt}"           => array(
				'title'      => esc_html__( 'Select custom layout', 'ekoterra' ),
				// Translators: Add CPT name to the description
				'desc'       => wp_kses_data( sprintf( __( 'Select custom layout to display the site header on the %s pages', 'ekoterra' ), $title ) ),
				'dependency' => array(
					"header_type_{$cpt}" => array( 'custom' ),
				),
				'std'        => 'inherit',
				'options'    => array(),
				'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'select',
			),
			"header_position_{$cpt}"        => array(
				'title'   => esc_html__( 'Header position', 'ekoterra' ),
				// Translators: Add CPT name to the description
				'desc'    => wp_kses_data( sprintf( __( 'Select position to display the site header on the %s pages', 'ekoterra' ), $title ) ),
				'std'     => 'inherit',
				'options' => array(),
				'type'    => EKOTERRA_THEME_FREE ? 'hidden' : 'switch',
			),
			"header_image_override_{$cpt}"  => array(
				'title'   => esc_html__( 'Header image override', 'ekoterra' ),
				'desc'    => wp_kses_data( __( "Allow override the header image with the post's featured image", 'ekoterra' ) ),
				'std'     => 'inherit',
				'options' => array(
					'inherit' => esc_html__( 'Inherit', 'ekoterra' ),
					1         => esc_html__( 'Yes', 'ekoterra' ),
					0         => esc_html__( 'No', 'ekoterra' ),
				),
				'type'    => EKOTERRA_THEME_FREE ? 'hidden' : 'switch',
			),
			"header_widgets_{$cpt}"         => array(
				'title'   => esc_html__( 'Header widgets', 'ekoterra' ),
				// Translators: Add CPT name to the description
				'desc'    => wp_kses_data( sprintf( __( 'Select set of widgets to show in the header on the %s pages', 'ekoterra' ), $title ) ),
				'std'     => 'hide',
				'options' => array(),
				'type'    => 'hidden',
			),

			"sidebar_info_{$cpt}"           => array(
				'title' => esc_html__( 'Sidebar', 'ekoterra' ),
				'desc'  => '',
				'type'  => 'info',
			),
			"sidebar_position_{$cpt}"       => array(
				'title'   => sprintf( __( 'Sidebar position on the %s list', 'ekoterra' ), $title ),
				// Translators: Add CPT name to the description
				'desc'    => wp_kses_data( sprintf( __( 'Select position to show sidebar on the %s list', 'ekoterra' ), $title ) ),
				'std'     => 'left',
				'options' => array(),
				'type'    => 'switch',
			),
			"sidebar_position_mobile_{$cpt}"=> array(
				'title'    => sprintf( __( 'Sidebar position on the %s list on mobile', 'ekoterra' ), $title ),
				'desc'     => wp_kses_data( __( 'Select position to show sidebar on mobile devices - above or below the content', 'ekoterra' ) ),
				'std'      => 'below',
				'dependency' => array(
					"sidebar_position_{$cpt}" => array( '^hide' ),
				),
				'options'  => array(),
				'type'     => 'switch',
			),
			"sidebar_widgets_{$cpt}"        => array(
				'title'      => sprintf( __( 'Sidebar widgets on the %s list', 'ekoterra' ), $title ),
				// Translators: Add CPT name to the description
				'desc'       => wp_kses_data( sprintf( __( 'Select sidebar to show on the %s list', 'ekoterra' ), $title ) ),
				'dependency' => array(
					"sidebar_position_{$cpt}" => array( '^hide' ),
				),
				'std'        => 'hide',
				'options'    => array(),
				'type'       => 'select',
			),
			"sidebar_position_single_{$cpt}"       => array(
				'title'   => sprintf( __( 'Sidebar position on the single post', 'ekoterra' ), $title ),
				// Translators: Add CPT name to the description
				'desc'    => wp_kses_data( sprintf( __( 'Select position to show sidebar on the single posts of the %s', 'ekoterra' ), $title ) ),
				'std'     => 'left',
				'options' => array(),
				'type'    => 'switch',
			),
			"sidebar_position_mobile_single_{$cpt}"=> array(
				'title'    => esc_html__( 'Sidebar position on the single post on mobile', 'ekoterra' ),
				'desc'     => wp_kses_data( __( 'Select position to show sidebar on mobile devices - above or below the content', 'ekoterra' ) ),
				'dependency' => array(
					"sidebar_position_single_{$cpt}" => array( '^hide' ),
				),
				'std'      => 'below',
				'options'  => array(),
				'type'     => 'switch',
			),
			"sidebar_widgets_single_{$cpt}"        => array(
				'title'      => sprintf( __( 'Sidebar widgets on the single post', 'ekoterra' ), $title ),
				// Translators: Add CPT name to the description
				'desc'       => wp_kses_data( sprintf( __( 'Select widgets to show in the sidebar on the single posts of the %s', 'ekoterra' ), $title ) ),
				'dependency' => array(
					"sidebar_position_single_{$cpt}" => array( '^hide' ),
				),
				'std'        => 'hide',
				'options'    => array(),
				'type'       => 'select',
			),
			"expand_content_{$cpt}"         => array(
				'title'   => esc_html__( 'Expand content', 'ekoterra' ),
				'desc'    => wp_kses_data( __( 'Expand the content width if the sidebar is hidden', 'ekoterra' ) ),
				'refresh' => false,
				'std'     => 1,
				'options' => array(
					'inherit' => esc_html__( 'Inherit', 'ekoterra' ),
					1         => esc_html__( 'Expand', 'ekoterra' ),
					0         => esc_html__( 'No', 'ekoterra' ),
				),
				'type'    => 'switch',
			),

			"footer_info_{$cpt}"            => array(
				'title' => esc_html__( 'Footer', 'ekoterra' ),
				'desc'  => '',
				'type'  => 'info',
			),
			"footer_type_{$cpt}"            => array(
				'title'   => esc_html__( 'Footer style', 'ekoterra' ),
				'desc'    => wp_kses_data( __( 'Choose whether to use the default footer or footer Layouts (available only if the ThemeREX Addons is activated)', 'ekoterra' ) ),
				'std'     => 'inherit',
				'options' => ekoterra_get_list_header_footer_types( true ),
				'type'    => EKOTERRA_THEME_FREE ? 'hidden' : 'switch',
			),
			"footer_style_{$cpt}"           => array(
				'title'      => esc_html__( 'Select custom layout', 'ekoterra' ),
				'desc'       => wp_kses_data( __( 'Select custom layout to display the site footer', 'ekoterra' ) ),
				'std'        => 'inherit',
				'dependency' => array(
					"footer_type_{$cpt}" => array( 'custom' ),
				),
				'options'    => array(),
				'type'       => EKOTERRA_THEME_FREE ? 'hidden' : 'select',
			),
			"footer_widgets_{$cpt}"         => array(
				'title'      => esc_html__( 'Footer widgets', 'ekoterra' ),
				'desc'       => wp_kses_data( __( 'Select set of widgets to show in the footer', 'ekoterra' ) ),
				'dependency' => array(
					"footer_type_{$cpt}" => array( 'default' ),
				),
				'std'        => 'footer_widgets',
				'options'    => array(),
				'type'       => 'select',
			),
			"footer_columns_{$cpt}"         => array(
				'title'      => esc_html__( 'Footer columns', 'ekoterra' ),
				'desc'       => wp_kses_data( __( 'Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'ekoterra' ) ),
				'dependency' => array(
					"footer_type_{$cpt}"    => array( 'default' ),
					"footer_widgets_{$cpt}" => array( '^hide' ),
				),
				'std'        => 0,
				'options'    => ekoterra_get_list_range( 0, 6 ),
				'type'       => 'select',
			),
			"footer_wide_{$cpt}"            => array(
				'title'      => esc_html__( 'Footer fullwidth', 'ekoterra' ),
				'desc'       => wp_kses_data( __( 'Do you want to stretch the footer to the entire window width?', 'ekoterra' ) ),
				'dependency' => array(
					"footer_type_{$cpt}" => array( 'default' ),
				),
				'std'        => 0,
				'type'       => 'checkbox',
			),

			"widgets_info_{$cpt}"           => array(
				'title' => esc_html__( 'Additional panels', 'ekoterra' ),
				'desc'  => '',
				'type'  => EKOTERRA_THEME_FREE ? 'hidden' : 'hidden',
			),
			"widgets_above_page_{$cpt}"     => array(
				'title'   => esc_html__( 'Widgets at the top of the page', 'ekoterra' ),
				'desc'    => wp_kses_data( __( 'Select widgets to show at the top of the page (above content and sidebar)', 'ekoterra' ) ),
				'std'     => 'hide',
				'options' => array(),
				'type'    => EKOTERRA_THEME_FREE ? 'hidden' : 'hidden',
			),
			"widgets_above_content_{$cpt}"  => array(
				'title'   => esc_html__( 'Widgets above the content', 'ekoterra' ),
				'desc'    => wp_kses_data( __( 'Select widgets to show at the beginning of the content area', 'ekoterra' ) ),
				'std'     => 'hide',
				'options' => array(),
				'type'    => EKOTERRA_THEME_FREE ? 'hidden' : 'hidden',
			),
			"widgets_below_content_{$cpt}"  => array(
				'title'   => esc_html__( 'Widgets below the content', 'ekoterra' ),
				'desc'    => wp_kses_data( __( 'Select widgets to show at the ending of the content area', 'ekoterra' ) ),
				'std'     => 'hide',
				'options' => array(),
				'type'    => EKOTERRA_THEME_FREE ? 'hidden' : 'hidden',
			),
			"widgets_below_page_{$cpt}"     => array(
				'title'   => esc_html__( 'Widgets at the bottom of the page', 'ekoterra' ),
				'desc'    => wp_kses_data( __( 'Select widgets to show at the bottom of the page (below content and sidebar)', 'ekoterra' ) ),
				'std'     => 'hide',
				'options' => array(),
				'type'    => EKOTERRA_THEME_FREE ? 'hidden' : 'hidden',
			),
		);
	}
}


// Return lists with choises when its need in the admin mode
if ( ! function_exists( 'ekoterra_options_get_list_choises' ) ) {
	add_filter( 'ekoterra_filter_options_get_list_choises', 'ekoterra_options_get_list_choises', 10, 2 );
	function ekoterra_options_get_list_choises( $list, $id ) {
		if ( is_array( $list ) && count( $list ) == 0 ) {
			if ( strpos( $id, 'header_style' ) === 0 ) {
				$list = ekoterra_get_list_header_styles( strpos( $id, 'header_style_' ) === 0 );
			} elseif ( strpos( $id, 'header_position' ) === 0 ) {
				$list = ekoterra_get_list_header_positions( strpos( $id, 'header_position_' ) === 0 );
			} elseif ( strpos( $id, 'header_widgets' ) === 0 ) {
				$list = ekoterra_get_list_sidebars( strpos( $id, 'header_widgets_' ) === 0, true );
			} elseif ( strpos( $id, '_scheme' ) > 0 ) {
				$list = ekoterra_get_list_schemes( 'color_scheme' != $id );
			} elseif ( strpos( $id, 'sidebar_widgets' ) === 0 ) {
				$list = ekoterra_get_list_sidebars( 'sidebar_widgets_single' != $id && ( strpos( $id, 'sidebar_widgets_' ) === 0 || strpos( $id, 'sidebar_widgets_single_' ) === 0 ), true );
			} elseif ( strpos( $id, 'sidebar_position_mobile' ) === 0 ) {
				$list = ekoterra_get_list_sidebars_positions_mobile( strpos( $id, 'sidebar_position_mobile_' ) === 0 );
			} elseif ( strpos( $id, 'sidebar_position' ) === 0 ) {
				$list = ekoterra_get_list_sidebars_positions( strpos( $id, 'sidebar_position_' ) === 0 );
			} elseif ( strpos( $id, 'widgets_above_page' ) === 0 ) {
				$list = ekoterra_get_list_sidebars( strpos( $id, 'widgets_above_page_' ) === 0, true );
			} elseif ( strpos( $id, 'widgets_above_content' ) === 0 ) {
				$list = ekoterra_get_list_sidebars( strpos( $id, 'widgets_above_content_' ) === 0, true );
			} elseif ( strpos( $id, 'widgets_below_page' ) === 0 ) {
				$list = ekoterra_get_list_sidebars( strpos( $id, 'widgets_below_page_' ) === 0, true );
			} elseif ( strpos( $id, 'widgets_below_content' ) === 0 ) {
				$list = ekoterra_get_list_sidebars( strpos( $id, 'widgets_below_content_' ) === 0, true );
			} elseif ( strpos( $id, 'footer_style' ) === 0 ) {
				$list = ekoterra_get_list_footer_styles( strpos( $id, 'footer_style_' ) === 0 );
			} elseif ( strpos( $id, 'footer_widgets' ) === 0 ) {
				$list = ekoterra_get_list_sidebars( strpos( $id, 'footer_widgets_' ) === 0, true );
			} elseif ( strpos( $id, 'blog_style' ) === 0 ) {
				$list = ekoterra_get_list_blog_styles( strpos( $id, 'blog_style_' ) === 0 );
			} elseif ( strpos( $id, 'post_type' ) === 0 ) {
				$list = ekoterra_get_list_posts_types();
			} elseif ( strpos( $id, 'parent_cat' ) === 0 ) {
				$list = ekoterra_array_merge( array( 0 => esc_html__( '- Select category -', 'ekoterra' ) ), ekoterra_get_list_categories() );
			} elseif ( strpos( $id, 'blog_animation' ) === 0 ) {
				$list = ekoterra_get_list_animations_in();
			} elseif ( 'color_scheme_editor' == $id ) {
				$list = ekoterra_get_list_schemes();
			} elseif ( strpos( $id, '_font-family' ) > 0 ) {
				$list = ekoterra_get_list_load_fonts( true );
			}
		}
		return $list;
	}
}
