<?php
/**
 * The "Announce" template to show post's content
 *
 * Used in the widget Recent News.
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.0
 */
 
$widget_args = get_query_var('trx_addons_args_recent_news');
$style = $widget_args['style'];
$number = min(8, $widget_args['number']);
$count = min(8, $widget_args['count']);
$post_format = get_post_format();
$post_format = empty($post_format) ? 'standard' : str_replace('post-format-', '', $post_format);
$animation = apply_filters('trx_addons_blog_animation', '');
$post_link = empty($args['no_links']) ? get_permalink() : '';
$grid = array(
	array('full'),
	array('big', 'big'),
	array('big', 'medium', 'medium'),
	array('big', 'medium', 'small', 'small'),
	array('big', 'small', 'small', 'small', 'small'),
	array('medium', 'medium', 'small', 'small', 'small', 'small'),
	array('medium', 'small', 'small', 'small', 'small', 'small', 'small'),
	array('small', 'small', 'small', 'small', 'small', 'small', 'small', 'small')
);
$thumb_size = $grid[$count-$number >= 8 ? 8 : ($count-1)%8][($number-1)%8];

$post_meta = trx_addons_sc_show_post_meta('sc_blogger', apply_filters('trx_addons_filter_show_post_meta', array(
        'components' => 'date,counters',
        'counters' => 'likes',
        'echo' => false
    ), 'sc_blogger_plain', $args['columns'])
);
?><article 
	<?php post_class( 'post_item post_layout_'.esc_attr($style)
					.' post_format_'.esc_attr($post_format)
					.' post_size_'.esc_attr($thumb_size)
					); ?>
	<?php echo (!empty($animation) ? ' data-animation="'.esc_attr($animation).'"' : ''); ?>
	>

	<?php
	if ( is_sticky() && is_home() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}
	
	trx_addons_get_template_part('templates/tpl.featured.php',
								'trx_addons_args_featured',
								apply_filters('trx_addons_filter_args_featured', array(
										'post_info' => '<div class="post_info"> <div class="rn_content_wrap">'
                                                        . '<h5 class="post_title entry-title"><a href="'.esc_url(get_permalink()).'" rel="bookmark">' . wp_kses( get_the_title(), 'ekoterra_kses_content' ) . '</a></h5>'
                                                        .  $post_meta
                                                        . '<div class="post-link">'
                                                        . '<a href="'.esc_url($post_link).'" rel="bookmark">' . '</a>'
                                                        .'</div>'

                                                        . '</div></div>'
                                                        ,
                                        'hover' => '',
                                        'no_links' => empty($link),
                                        'link' => $post_link,
										'thumb_bg' => false,
                                        'thumb_size' => apply_filters('trx_addons_filter_thumb_size', ekoterra_get_thumb_size('rnews-announce' ))
										),
										'recent_news-announce')
								);
	?>
</article>